/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UniversalChineseGrammaticalRelations {
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    private static final String COMMA_PATTERN = "/^,|\uff0c$/";
    private static final String MODAL_PATTERN = "/^(\u53ef(\u4ee5|\u80fd)?)|\u80fd\u591f?|\u5e94\u8be5?|\u5c06\u8981?|\u5fc5\u987b|\u4f1a$/";
    private static final String LOCATION_NOUNS = "/^((\u4e1c|\u897f|\u5357|\u5317)(\u8fb9|\u4fa7|\u90e8|\u5cb8|\u9e93|\u7554))|\u9644\u8fd1|\u8fd1?\u65c1|\u65c1?\u8fb9$/";
    private static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(Language.UniversalChinese, "arg", "argument", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(Language.UniversalChinese, "subj", "subject", ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.UniversalChinese, "nsubj", "nominal subject", SUBJECT, "IP|NP", tregexCompiler, "IP <( ( NP|QP=target!< NT ) $+ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB !<:NP !<:PP )) !$- BA", "IP <( ( NP|QP=target!< NT ) $+ (PU (<: /^,|\uff0c$/ $+ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB !<:NP !<:PP )))) !$- BA", "IP <( ( NP|QP=target!< NT ) $+ (LCP ($+ ( /^VP|VCD|IP/  !< VE !<VC !<SB !<LB !<:NP !<:PP )))) !$- BA", "NP !$+ VP < ( (  NP|DP|QP=target !< NT ) $+ ( /^VP|VCD/ !<VE !< VC !<SB !<LB))", "IP < (/^NP/=target $+ (VP < VC))");
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.UniversalChinese, "nsubjpass", "nominal passive subject", NOMINAL_SUBJECT, "IP", tregexCompiler, "IP < (NP=target $+ (VP|IP < SB|LB))");
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(Language.UniversalChinese, "csubj", "clausal subject", SUBJECT, "IP|VP", tregexCompiler, "IP|VP < ( /^IP(-SBJ)?/ < NP|QP|LCP $+ VP=target )", "IP|VP < ( /^IP(-SBJ)?/ < NP|QP|LCP $+ (PU $+ VP=target ))");
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "comp", "complement", ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(Language.UniversalChinese, "obj", "object", COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.UniversalChinese, "dobj", "direct object", OBJECT, "CP|VP", tregexCompiler, "VP < ( /^V*/ $+ NP|DP=target ) !< VC ", "VP < ( /^V*/ $+ (AS $+ NP|DP=target) ) !< VC ", " VP < ( /^V*/ $+ NP|DP=target ! $+ NP|DP) !< VC ", "CP < (IP $++ NP=target ) !<< VC");
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(Language.UniversalChinese, "iobj", "indirect object", OBJECT, "VP", tregexCompiler, " CP !> VP < ( VV $+ ( NP|DP|QP|CLP=target . NP|DP ) )");
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "ccomp", "clausal complement", COMPLEMENT, "VP|ADJP|IP", tregexCompiler, "  VP  < (VV|VC|VRD|VCD|VSB|VE $++ IP|VP|VRD|VCD|VSB|CP=target)  !< NP|QP|LCP  > IP|VP ", "VP < (VV $+ NP $++ IP=target)");
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "xcomp", "xclausal complement", COMPLEMENT, "VP", tregexCompiler, "VP < (VV=target $+ VP !< /^(\u53ef(\u4ee5|\u80fd)?)|\u80fd\u591f?|\u5e94\u8be5?|\u5c06\u8981?|\u5fc5\u987b|\u4f1a$/)");
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "mod", "modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nummod", "numeric modifier", MODIFIER, "QP|NP|DP", tregexCompiler, "NP|QP < ( QP  =target << M $++ NN|NP|QP)", "NP|QP < ( DNP=target < (QP < CD !< OD) !< JJ|ADJP $++ NP|QP )");
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "appos", "appositional modifier", MODIFIER, "NP", tregexCompiler, "NP < (/^NP(-APP)?$/=target !<<- /^((\u4e1c|\u897f|\u5357|\u5317)(\u8fb9|\u4fa7|\u90e8|\u5cb8|\u9e93|\u7554))|\u9644\u8fd1|\u8fd1?\u65c1|\u65c1?\u8fb9$/ !< NT !<: NR $+ (NP <: NR !$+ __))");
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(Language.UniversalChinese, "parataxis", "parataxis", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation PARENTHETICAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "parataxis:prnmod", "parenthetical modifier", PARATAXIS, "NP", tregexCompiler, "NP < PRN=target ");
    public static final GrammaticalRelation NOUN_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod", "noun modifier", MODIFIER, "NP", tregexCompiler, "NP < (NP=target < NR !$+ PU|CC|NP|NN $++ NP|PRN)", "NP < (NP=target $+ (NP <: NR)) [$- P|LC | $+ P|LC]", "NP|QP < ( DNP =target < (NP < NT) $++ NP|QP )", "NP|QP < ( DNP =target < LCP|PP $++ NP|QP )");
    public static final GrammaticalRelation RANGE = new GrammaticalRelation(Language.UniversalChinese, "nmod:range", "range", NOUN_MODIFIER, "VP", tregexCompiler, "VP < ( NP|DP|QP $+ DP|QP=target)", "VP < ( VV $+ QP=target )");
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod:poss", "possessive modifier", NOUN_MODIFIER, "NP", tregexCompiler, "NP < (PN=target $+ NN)");
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod:tmod", "temporal modifier", NOUN_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < (NP=target < NT $++ VP)");
    public static final GrammaticalRelation CLAUSAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "acl", "clausal modifier of noun", MODIFIER, "NP", tregexCompiler, "NP  < ( CP=target $++ NP << VV)", "NP < IP=target ");
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "amod", "adjectival modifier", MODIFIER, "NP|CLP|QP", tregexCompiler, "NP|CLP|QP < (ADJP=target $++ NP|CLP|QP ) ", "NP  $++ (CP=target << VA !<< VV) > NP ", "NP  < ( CP=target $++ NP << VA !<< VV)", "NP|QP < ( DNP=target < JJ|ADJP !< NP|QP $++ NP|QP )");
    public static final GrammaticalRelation ORDINAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "amod:ordmod", "ordinal numeric modifier", ADJECTIVAL_MODIFIER, "NP|QP", tregexCompiler, "NP < (QP=target < OD !< CLP)", "NP|QP < ( DNP=target < (QP < OD !< CD) !< JJ|ADJP $++ NP|QP )");
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.UniversalChinese, "det", "determiner", MODIFIER, "^NP|DP", tregexCompiler, "/^NP/ < (DP=target $++ NP )");
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "neg", "negation modifier", MODIFIER, "VP|ADJP|IP", tregexCompiler, "VP|ADJP|IP < (AD|VV=target < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/)", "VP|ADJP|IP < (ADVP|VV=target < (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))");
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "advmod", "adverbial modifier", MODIFIER, "VP|ADJP|IP|CP|PP|NP|QP", tregexCompiler, "VP|ADJP|IP|CP|PP|NP < (ADVP=target !< (AD < /^(\\u4e0d|\\u6CA1|\\u6CA1\\u6709)$/))", "VP|ADJP < AD|CS=target", "QP < (ADVP=target $+ QP)", "QP < ( QP $+ ADVP=target)");
    public static final GrammaticalRelation ADV_CLAUSAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "advcl", "clausal adverb", ADVERBIAL_MODIFIER);
    public static final GrammaticalRelation DVPM_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "advmod:dvp", "dvp modifier", ADVERBIAL_MODIFIER, "VP", tregexCompiler, " VP < ( DVP=target $+ VP) ");
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "aux", "auxiliary (example: should[modifier] leave[head])", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, new String[0]);
    public static final GrammaticalRelation MODAL_VERB = new GrammaticalRelation(Language.UniversalChinese, "aux:modal", "modal verb", AUX_MODIFIER, "VP", tregexCompiler, "VP < ( VV=target < /^(\u53ef(\u4ee5|\u80fd)?)|\u80fd\u591f?|\u5e94\u8be5?|\u5c06\u8981?|\u5fc5\u987b|\u4f1a$/ !< /^\u6ca1\u6709$/ $+ VP|VRD )");
    public static final GrammaticalRelation ASPECT_MARKER = new GrammaticalRelation(Language.UniversalChinese, "aux:asp", "aspect", AUX_MODIFIER, "VP", tregexCompiler, "VP < ( /^V*/ $+ AS=target)");
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "auxpass", "auxiliary passive", MODIFIER, "VP", tregexCompiler, "VP < SB|LB=target");
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(Language.UniversalChinese, "cop", "copula", GrammaticalRelation.DEPENDENT, "VP", tregexCompiler, " VP < VC=target");
    public static final GrammaticalRelation MARK = new GrammaticalRelation(Language.UniversalChinese, "mark", "marker (examples: that[modifier] expanded[head]; \u5f00\u53d1/expand[head] \u6d66\u4e1c/Pudong \u7684[modifier])", GrammaticalRelation.DEPENDENT, "^PP|^LCP|^CP|^DVP", tregexCompiler, "/^PP/ < (P=target $+ VP)", "/^LCP/ < (P=target $+ VP)", "/^CP/ < (__  $++ DEC=target)", "DVP < (__ $+ DEV=target)");
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.UniversalChinese, "punct", "punctuation", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ < PU=target");
    public static final GrammaticalRelation COMPOUND = new GrammaticalRelation(Language.UniversalChinese, "compound", "compound (examples: phone book, three thousand)", ARGUMENT);
    public static final GrammaticalRelation NOUN_COMPOUND = new GrammaticalRelation(Language.UniversalChinese, "compound:nn", "noun compound", COMPOUND, "^NP", tregexCompiler, "NP < (NN|NR|NT=target [$+ NN|NT $- NN|NP | $+ (NN|NT $+ NN|NP|NR)])", "NP < (NN|NR|NT=target !$+ PU|CC|DNP $++ NN|NT)", "NP < (NN|NR|NT $+ FW=target)", "NP < (NP=target !< NR !$+ PU|CC|DNP $++ (NP|PRN !< NR|QP))", "NP < (NP=target < NR $+ (NP [<<# NR | $+ NR|NN | $+ (__ <<# NR) | $+ /^[^N]/]))", "NP < (NP=target < NN !< NR $+ (NP < NN|NT))");
    public static final GrammaticalRelation NAME = new GrammaticalRelation(Language.UniversalChinese, "name", "name", COMPOUND, "^NP", tregexCompiler, "NP < (NR=target $+ NR)");
    public static final GrammaticalRelation VERB_COMPOUND = new GrammaticalRelation(Language.UniversalChinese, "compound:vc", "coordinated verb compound", COMPOUND, "VCD|VSB", tregexCompiler, "VCD < ( VV|VA $+  VV|VA=target)", "VSB < ( VV|VA=target $+  VV|VA)");
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.UniversalChinese, "conj", "conjunct", GrammaticalRelation.DEPENDENT, "FRAG|INC|IP|VP|NP|ADJP|PP|ADVP|UCP", tregexCompiler, "NP|ADJP|PP|ADVP|UCP < (!PU|CC=target $+ CC)", "VP < (!PU|CC=target !$- VP $+ CC)", "VP|NP|ADJP|PP|ADVP|UCP < ( __=target $+ PU $+ CC)", "VP   < ( /^V/=target  $+ ((PU < \u3001) $+ /^V/))", "NP   < ( /^N/=target  $+ ((PU < \u3001) $+ /^N/))", "ADJP < ( JJ|ADJP=target  $+ ((PU < \u3001) $+ JJ|ADJP))", "PP   < ( /^P/=target  $+ ((PU < \u3001) $+ /^P/))", "ADVP < ( /^AD/ $+ ((PU < \u3001) $+ /^AD/=target))", "UCP  < ( !PU|CC=target    $+ (PU < \u3001) )", "PP < (PP $+ PP=target )", "NP <( NP=target $+ ((PU < \u3001) $+ NP) )", "NP <( NN|NR|NT|PN=target $+ ((PU < \uff0c|\u3001) $+ NN|NR|NT|PN) )", "VP < (CC $+ VV=target)", "FRAG|INC|IP|VP < (VP  < VV|VC|VRD|VCD|VE|VA < NP|QP|LCP  $ IP|VP|VRD|VCD|VE|VC|VA=target)  ", "IP|VP < ( IP < NP|QP|LCP $ IP=target )", "IP|VP < ( VP $ VP=target )");
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.UniversalChinese, "cc", "coordination", GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP", tregexCompiler, "VP|NP|ADJP|PP|ADVP|UCP|IP|QP < (CC=target)");
    public static final GrammaticalRelation CASE = new GrammaticalRelation(Language.UniversalChinese, "case", "case marking (examples: Chair[head] 's[modifier], \u6839\u636e/according[modifier] ... \u89c4\u5b9a/rule[head]; \u8fd1\u5e74/this year[head] \u6765[modifier])", GrammaticalRelation.DEPENDENT, "^PP|^LCP|^DNP", tregexCompiler, "/^PP/ < P=target", "/^LCP/ < LC=target", "/^DNP/ < DEG=target", "PP < ( P=target $++ LCP )");
    public static final GrammaticalRelation ASSOCIATIVE_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod:assmod", "associative modifier (examples: \u4e0a\u6d77\u5e02/Shanghai[modifier] \u7684 \u89c4\u5b9a/law[head])", NOUN_MODIFIER, "NP|QP|DNP", tregexCompiler, "NP|QP < ( DNP =target < (NP !< NT) $++ NP|QP ) ", "NP|DNP < (/^NP(-PN)?$/=target < NR $+ (NP !<<# NR !$+ NR|NN !$+ (__ <<# NR) !$+ /^[^N]/) !$- NP|NN)", "NP < (NP=target !< NR !$+ PU|CC $++ (NP|PRN < QP))");
    public static final GrammaticalRelation NOMINAL_TOPIC_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod:topic", "nominal topic", NOUN_MODIFIER, "IP", tregexCompiler, "IP < (/^NP.*(-TPC)?/=target $++ (NP $+ VP) !< NT)");
    public static final GrammaticalRelation LOCALIZER_COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "advmod:loc", "localizer complement", ADVERBIAL_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < (LCP=target !< IP) ");
    public static final GrammaticalRelation CLAUSAL_LOCALIZER_COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "advcl:loc", "localizer complement", ADV_CLAUSAL_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < (LCP=target < IP) ");
    public static final GrammaticalRelation RESULTATIVE_COMPLEMENT = new GrammaticalRelation(Language.UniversalChinese, "advmod:rcomp", "result verb", ADVERBIAL_MODIFIER, "VRD", tregexCompiler, "VRD < ( /V*/ $+ /V*/=target )");
    public static final GrammaticalRelation BA = new GrammaticalRelation(Language.UniversalChinese, "aux:ba", "ba", AUX_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < BA=target ");
    public static final GrammaticalRelation CLASSIFIER_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "mark:clf", "classifier marker", MARK, "QP|DP", tregexCompiler, "QP < M=target", "QP < CLP=target", "DP < ( DT $+ CLP=target )");
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.UniversalChinese, "nmod:prep", "prepositional modifier", NOUN_MODIFIER, "^NP|VP|IP", tregexCompiler, "/^NP/ < /^PP/=target", "VP < /^PP/=target", "IP < /^PP/=target ");
    public static final GrammaticalRelation PART_VERB = new GrammaticalRelation(Language.UniversalChinese, "aux:prtmod", "particle verb", AUX_MODIFIER, "VP|IP", tregexCompiler, "VP|IP < ( MSP=target )");
    public static final GrammaticalRelation ETC = new GrammaticalRelation(Language.UniversalChinese, "etc", "ETC", MODIFIER, "^NP", tregexCompiler, "/^NP/ < (NN|NR . ETC=target)");
    public static final GrammaticalRelation CONTROLLED_SUBJECT = new GrammaticalRelation(Language.UniversalChinese, "nsubj:xsubj", "controlled subject", NOMINAL_SUBJECT, "VP", tregexCompiler, "VP !< NP < VP > (IP !$- NP !< NP !>> (VP < VC ) >+(VP) (VP $-- NP=target))");
    public static final GrammaticalRelation DISCOURSE = new GrammaticalRelation(Language.UniversalChinese, "discourse", "discourse", ARGUMENT, "CP", tregexCompiler, "CP < SP=target");
    private static final GrammaticalRelation chineseOnly = null;
    private static final GrammaticalRelation[] rawValues = new GrammaticalRelation[]{GrammaticalRelation.DEPENDENT, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, MODIFIER, NUMERIC_MODIFIER, ORDINAL_MODIFIER, chineseOnly, APPOSITIONAL_MODIFIER, PARENTHETICAL_MODIFIER, chineseOnly, NOUN_MODIFIER, RANGE, chineseOnly, ASSOCIATIVE_MODIFIER, chineseOnly, TEMPORAL_MODIFIER, chineseOnly, POSSESSIVE_MODIFIER, NOMINAL_TOPIC_MODIFIER, chineseOnly, ADJECTIVAL_MODIFIER, DETERMINER, NEGATION_MODIFIER, CLAUSAL_MODIFIER, ADVERBIAL_MODIFIER, DVPM_MODIFIER, chineseOnly, ADV_CLAUSAL_MODIFIER, CLAUSAL_LOCALIZER_COMPLEMENT, chineseOnly, AUX_MODIFIER, MODAL_VERB, chineseOnly, ASPECT_MARKER, chineseOnly, AUX_PASSIVE_MODIFIER, COPULA, MARK, CLASSIFIER_MODIFIER, chineseOnly, PUNCTUATION, COMPOUND, NOUN_COMPOUND, chineseOnly, VERB_COMPOUND, chineseOnly, NAME, CONJUNCT, COORDINATION, CASE, DISCOURSE, LOCALIZER_COMPLEMENT, chineseOnly, RESULTATIVE_COMPLEMENT, chineseOnly, BA, chineseOnly, PREPOSITIONAL_MODIFIER, chineseOnly, PART_VERB, chineseOnly, ETC, chineseOnly, CONTROLLED_SUBJECT, chineseOnly};
    private static final List<GrammaticalRelation> values = new ArrayList<GrammaticalRelation>();
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    public static final Set<GrammaticalRelation> universalValues = new HashSet<GrammaticalRelation>();
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();

    private UniversalChineseGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return Collections.unmodifiableList(values);
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, UniversalChineseGrammaticalRelations.values(), UniversalChineseGrammaticalRelations.valuesLock());
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    static {
        for (int i = 0; i < rawValues.length; ++i) {
            GrammaticalRelation gr = rawValues[i];
            if (gr == chineseOnly) continue;
            synchronizedValues.add(gr);
            if (i + 1 != rawValues.length && rawValues[i + 1] == chineseOnly) continue;
            universalValues.add(gr);
        }
        UniversalChineseGrammaticalRelations.valuesLock().lock();
        try {
            for (GrammaticalRelation gr : UniversalChineseGrammaticalRelations.values()) {
                shortNameToGRel.put(gr.getShortName(), gr);
            }
        }
        finally {
            UniversalChineseGrammaticalRelations.valuesLock().unlock();
        }
    }
}

