/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Util {
    private static final Redwood.RedwoodChannels log = Redwood.channels(Util.class);
    private static Random random;

    private Util() {
    }

    public static double[][] scaling(double[][] A, double rMean, double rStd) {
        int count = 0;
        double mean = 0.0;
        double std = 0.0;
        double[][] dArray = A;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] aA;
            for (double v : aA = dArray[i]) {
                ++count;
                mean += v;
                std += v * v;
            }
        }
        std = Math.sqrt(std / (double)count - (mean /= (double)count) * mean);
        log.info("Scaling word embeddings:");
        log.info(String.format("(mean = %.2f, std = %.2f) -> (mean = %.2f, std = %.2f)", mean, std, rMean, rStd));
        double[][] rA = new double[A.length][A[0].length];
        for (int i = 0; i < rA.length; ++i) {
            for (int j = 0; j < rA[i].length; ++j) {
                rA[i][j] = (A[i][j] - mean) * rStd / std + rMean;
            }
        }
        return rA;
    }

    public static double[][] scaling(double[][] A) {
        return Util.scaling(A, 0.0, 1.0);
    }

    public static List<String> generateDict(List<String> str, int cutOff) {
        IntCounter<String> freq = new IntCounter<String>();
        for (String aStr : str) {
            freq.incrementCount(aStr);
        }
        List<String> keys = Counters.toSortedList(freq, false);
        ArrayList<String> dict = new ArrayList<String>();
        for (String word : keys) {
            if (!(freq.getCount(word) >= (double)cutOff)) continue;
            dict.add(word);
        }
        return dict;
    }

    public static List<String> generateDict(List<String> str) {
        return Util.generateDict(str, 1);
    }

    static Random getRandom() {
        if (random != null) {
            return random;
        }
        return Util.getRandom(System.currentTimeMillis());
    }

    private static Random getRandom(long seed) {
        random = new Random(seed);
        log.info(String.format("Random generator initialized with seed %d%n", seed));
        return random;
    }

    public static <T> List<T> getRandomSubList(List<T> input, int subsetSize) {
        int inputSize = input.size();
        if (subsetSize > inputSize) {
            subsetSize = inputSize;
        }
        Random random = Util.getRandom();
        for (int i = 0; i < subsetSize; ++i) {
            int indexToSwap = i + random.nextInt(inputSize - i);
            T temp = input.get(i);
            input.set(i, input.get(indexToSwap));
            input.set(indexToSwap, temp);
        }
        return input.subList(0, subsetSize);
    }

    public static void loadConllFile(String inFile, List<CoreMap> sents, List<DependencyTree> trees, boolean unlabeled, boolean cPOS) {
        CoreLabelTokenFactory tf = new CoreLabelTokenFactory(false);
        try (BufferedReader reader = IOUtils.readerFromString(inFile);){
            ArrayList<CoreLabel> sentenceTokens = new ArrayList<CoreLabel>();
            DependencyTree tree = new DependencyTree();
            for (String line : IOUtils.getLineIterable(reader, false)) {
                String[] splits = line.split("\t");
                if (splits.length < 10) {
                    if (sentenceTokens.size() <= 0) continue;
                    trees.add(tree);
                    CoreLabel sentence = new CoreLabel();
                    sentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
                    sents.add(sentence);
                    tree = new DependencyTree();
                    sentenceTokens = new ArrayList();
                    continue;
                }
                String word = splits[1];
                String pos = cPOS ? splits[3] : splits[4];
                String depType = splits[7];
                int head = -1;
                try {
                    head = Integer.parseInt(splits[6]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                CoreLabel token = tf.makeToken(word, 0, 0);
                token.setTag(pos);
                token.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, head);
                token.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, depType);
                sentenceTokens.add(token);
                if (!unlabeled) {
                    tree.add(head, depType);
                    continue;
                }
                tree.add(head, "-UNKNOWN-");
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void loadConllFile(String inFile, List<CoreMap> sents, List<DependencyTree> trees) {
        Util.loadConllFile(inFile, sents, trees, false, false);
    }

    public static void writeConllFile(String outFile, List<CoreMap> sentences, List<DependencyTree> trees) {
        try {
            PrintWriter output = IOUtils.getPrintWriter(outFile);
            for (int i = 0; i < sentences.size(); ++i) {
                CoreMap sentence = sentences.get(i);
                DependencyTree tree = trees.get(i);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                int size = tokens.size();
                for (int j = 1; j <= size; ++j) {
                    CoreLabel token = (CoreLabel)tokens.get(j - 1);
                    output.printf("%d\t%s\t_\t%s\t%s\t_\t%d\t%s\t_\t_%n", j, token.word(), token.tag(), token.tag(), tree.getHead(j), tree.getLabel(j));
                }
                output.println();
            }
            output.close();
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void printTreeStats(String str, List<DependencyTree> trees) {
        log.info("################### " + str);
        int nTrees = trees.size();
        int nonTree = 0;
        int multiRoot = 0;
        int nonProjective = 0;
        for (DependencyTree tree : trees) {
            if (!tree.isTree()) {
                ++nonTree;
                continue;
            }
            if (!tree.isProjective()) {
                ++nonProjective;
            }
            if (tree.isSingleRoot()) continue;
            ++multiRoot;
        }
        log.info(String.format("#Trees: %d%n", nTrees));
        log.info(String.format("%d tree(s) are illegal (%.2f%%).%n", nonTree, (double)nonTree * 100.0 / (double)nTrees));
        log.info(String.format("%d tree(s) are legal but have multiple roots (%.2f%%).%n", multiRoot, (double)multiRoot * 100.0 / (double)nTrees));
        log.info(String.format("%d tree(s) are legal but not projective (%.2f%%).%n", nonProjective, (double)nonProjective * 100.0 / (double)nTrees));
    }

    public static void printTreeStats(List<DependencyTree> trees) {
        Util.printTreeStats("", trees);
    }
}

