/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.demo;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.util.Triple;
import java.util.List;

public class NERDemo {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        String serializedClassifier = "classifiers/english.all.3class.distsim.crf.ser.gz";
        if (args.length > 0) {
            serializedClassifier = args[0];
        }
        CRFClassifier<CoreLabel> classifier = CRFClassifier.getClassifier(serializedClassifier);
        if (args.length > 1) {
            String fileContents = IOUtils.slurpFile(args[1]);
            List out2 = classifier.classify(fileContents);
            for (List list : out2) {
                for (CoreLabel word : list) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
            System.out.println("---");
            out2 = classifier.classifyFile(args[1]);
            for (List list : out2) {
                for (CoreLabel word : list) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
            System.out.println("---");
            List<Triple<String, Integer, Integer>> list22 = classifier.classifyToCharacterOffsets(fileContents);
            for (Triple<String, Integer, Integer> triple : list22) {
                System.out.println(triple.first() + ": " + fileContents.substring(triple.second(), triple.third()));
            }
            System.out.println("---");
            System.out.println("Ten best entity labelings");
            DocumentReaderAndWriter documentReaderAndWriter = classifier.makePlainTextReaderAndWriter();
            classifier.classifyAndWriteAnswersKBest(args[1], 10, documentReaderAndWriter);
            System.out.println("---");
            System.out.println("Per-token marginalized probabilities");
            classifier.printProbs(args[1], documentReaderAndWriter);
        } else {
            void var7_48;
            void var6_28;
            void var6_26;
            void var6_24;
            void var6_22;
            void var6_20;
            void var6_18;
            String[] example;
            String[] out2 = example = new String[]{"Good afternoon Rajat Raina, how are you today?", "I go to school at Stanford University, which is located in California."};
            int list22 = out2.length;
            boolean bl = false;
            while (var6_18 < list22) {
                String string = out2[var6_18];
                System.out.println(classifier.classifyToString(string));
                ++var6_18;
            }
            System.out.println("---");
            out2 = example;
            list22 = out2.length;
            boolean bl2 = false;
            while (var6_20 < list22) {
                String string = out2[var6_20];
                System.out.print(classifier.classifyToString(string, "slashTags", false));
                ++var6_20;
            }
            System.out.println("---");
            out2 = example;
            list22 = out2.length;
            boolean bl3 = false;
            while (var6_22 < list22) {
                String string = out2[var6_22];
                System.out.print(classifier.classifyToString(string, "tabbedEntities", false));
                ++var6_22;
            }
            System.out.println("---");
            out2 = example;
            list22 = out2.length;
            boolean bl4 = false;
            while (var6_24 < list22) {
                String string = out2[var6_24];
                System.out.println(classifier.classifyWithInlineXML(string));
                ++var6_24;
            }
            System.out.println("---");
            out2 = example;
            list22 = out2.length;
            boolean bl5 = false;
            while (var6_26 < list22) {
                String string = out2[var6_26];
                System.out.println(classifier.classifyToString(string, "xml", true));
                ++var6_26;
            }
            System.out.println("---");
            out2 = example;
            list22 = out2.length;
            boolean bl6 = false;
            while (var6_28 < list22) {
                String string = out2[var6_28];
                System.out.print(classifier.classifyToString(string, "tsv", false));
                ++var6_28;
            }
            System.out.println("---");
            int j = 0;
            String[] list22 = example;
            int n = list22.length;
            boolean bl7 = false;
            while (var7_48 < n) {
                String str = list22[var7_48];
                ++j;
                List<Triple<String, Integer, Integer>> triples = classifier.classifyToCharacterOffsets(str);
                for (Triple<String, Integer, Integer> triple : triples) {
                    System.out.printf("%s over character offsets [%d, %d) in sentence %d.%n", triple.first(), triple.second(), triple.third, j);
                }
                ++var7_48;
            }
            System.out.println("---");
            int i = 0;
            for (String str : example) {
                for (List list : classifier.classify(str)) {
                    for (CoreLabel cl : list) {
                        System.out.print(i++ + ": ");
                        System.out.println(cl.toShorterString(new String[0]));
                    }
                }
            }
            System.out.println("---");
        }
    }
}

