/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.impl;

import de.jollyday.CalendarHierarchy;
import de.jollyday.Holiday;
import de.jollyday.HolidayManager;
import de.jollyday.config.Configuration;
import de.jollyday.config.Holidays;
import de.jollyday.parser.HolidayParser;
import de.jollyday.util.ClassLoadingUtil;
import de.jollyday.util.XMLUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLManager
extends HolidayManager {
    private static final Logger LOG = Logger.getLogger(XMLManager.class.getName());
    private static final String PARSER_IMPL_PREFIX = "parser.impl.";
    private static final String FILE_PREFIX = "holidays/Holidays";
    private static final String FILE_SUFFIX = ".xml";
    private final Map<String, HolidayParser> parserCache = new HashMap<String, HolidayParser>();
    protected Configuration configuration;
    private ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();
    private XMLUtil xmlUtil = new XMLUtil();

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        Set<Holiday> holidaySet = Collections.synchronizedSet(new HashSet());
        this.getHolidays(year, this.configuration, holidaySet, args);
        return holidaySet;
    }

    @Override
    public Set<Holiday> getHolidays(ReadableInterval interval, String ... args) {
        if (interval == null) {
            throw new IllegalArgumentException("Interval is NULL.");
        }
        HashSet<Holiday> holidays = new HashSet<Holiday>();
        for (int year = interval.getStart().getYear(); year <= interval.getEnd().getYear(); ++year) {
            Set<Holiday> yearHolidays = this.getHolidays(year, args);
            for (Holiday h : yearHolidays) {
                if (!interval.contains((ReadableInstant)h.getDate().toDateTimeAtStartOfDay())) continue;
                holidays.add(h);
            }
        }
        return holidays;
    }

    private void getHolidays(int year, Configuration c, Set<Holiday> holidaySet, String ... args) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Adding holidays for " + c.getDescription());
        }
        this.parseHolidays(year, holidaySet, c.getHolidays());
        if (args != null && args.length > 0) {
            String hierarchy = args[0];
            for (Configuration config : c.getSubConfigurations()) {
                if (!hierarchy.equalsIgnoreCase(config.getHierarchy())) continue;
                this.getHolidays(year, config, holidaySet, this.copyOfRange(args, 1, args.length));
                break;
            }
        }
    }

    private String[] copyOfRange(String[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        String[] copy = new String[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private void parseHolidays(int year, Set<Holiday> holidays, Holidays config) {
        Collection<HolidayParser> parsers = this.getParsers(config);
        for (HolidayParser p : parsers) {
            HolidayParserRunner holidayParserRunner = new HolidayParserRunner(year, holidays, config, p);
            holidayParserRunner.run();
        }
    }

    private Collection<HolidayParser> getParsers(Holidays config) {
        HashSet<HolidayParser> parsers = new HashSet<HolidayParser>();
        try {
            PropertyDescriptor[] propertiesDescs;
            for (PropertyDescriptor propertyDescriptor : propertiesDescs = Introspector.getBeanInfo(config.getClass()).getPropertyDescriptors()) {
                List l;
                if (!List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || (l = (List)propertyDescriptor.getReadMethod().invoke((Object)config, new Object[0])).isEmpty()) continue;
                String className = l.get(0).getClass().getName();
                if (!this.parserCache.containsKey(className)) {
                    String propName = PARSER_IMPL_PREFIX + className;
                    Properties configProps = this.getProperties();
                    if (configProps.containsKey(propName)) {
                        String parserClassName = configProps.getProperty(propName);
                        Class<?> parserClass = this.classLoadingUtil.loadClass(parserClassName);
                        Object parserObject = parserClass.newInstance();
                        HolidayParser hp = (HolidayParser)HolidayParser.class.cast(parserObject);
                        this.parserCache.put(className, hp);
                    }
                }
                if (!this.parserCache.containsKey(className)) continue;
                parsers.add(this.parserCache.get(className));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parsers.", e);
        }
        return parsers;
    }

    @Override
    public void init(String calendar) {
        String configurationFileName = XMLManager.getConfigurationFileName(calendar);
        URL urlDestination = null;
        try {
            urlDestination = this.getClass().getClassLoader().getResource(configurationFileName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate configuration.", e);
        }
        this.init(urlDestination);
    }

    @Override
    public void init(URL url) {
        try {
            InputStream inputStream = url.openStream();
            this.configuration = this.xmlUtil.unmarshallConfiguration(inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate configuration.", e);
        }
        XMLManager.validateConfigurationHierarchy(this.configuration);
        XMLManager.logHierarchy(this.configuration, 0);
    }

    protected static void logHierarchy(Configuration c, int level) {
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder space = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                space.append("-");
            }
            LOG.finer(space + " " + c.getDescription() + "(" + c.getHierarchy() + ").");
            for (Configuration sub : c.getSubConfigurations()) {
                XMLManager.logHierarchy(sub, level + 1);
            }
        }
    }

    public static String getConfigurationFileName(String country) {
        return "holidays/Holidays_" + country + FILE_SUFFIX;
    }

    protected static void validateConfigurationHierarchy(Configuration c) {
        HashMap<String, Integer> hierarchyMap = new HashMap<String, Integer>();
        HashSet<String> multipleHierarchies = new HashSet<String>();
        for (Configuration subConfig : c.getSubConfigurations()) {
            String hierarchy = subConfig.getHierarchy();
            if (!hierarchyMap.containsKey(hierarchy)) {
                hierarchyMap.put(hierarchy, 1);
                continue;
            }
            int count = (Integer)hierarchyMap.get(hierarchy);
            hierarchyMap.put(hierarchy, ++count);
            multipleHierarchies.add(hierarchy);
        }
        if (multipleHierarchies.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Configuration for " + c.getHierarchy() + " contains  multiple SubConfigurations with the same hierarchy id. ");
            for (String hierarchy : multipleHierarchies) {
                msg.append(hierarchy + " " + ((Integer)hierarchyMap.get(hierarchy)).toString() + " times ");
            }
            throw new IllegalArgumentException(msg.toString().trim());
        }
        for (Configuration subConfig : c.getSubConfigurations()) {
            XMLManager.validateConfigurationHierarchy(subConfig);
        }
    }

    @Override
    public CalendarHierarchy getCalendarHierarchy() {
        return XMLManager.createConfigurationHierarchy(this.configuration, null);
    }

    private static CalendarHierarchy createConfigurationHierarchy(Configuration c, CalendarHierarchy h) {
        h = new CalendarHierarchy(h, c.getHierarchy());
        h.setFallbackDescription(c.getDescription());
        for (Configuration sub : c.getSubConfigurations()) {
            CalendarHierarchy subHierarchy = XMLManager.createConfigurationHierarchy(sub, h);
            h.getChildren().put(subHierarchy.getId(), subHierarchy);
        }
        return h;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HolidayParserRunner
    implements Runnable {
        private final int year;
        private final Set<Holiday> holidays;
        private final Holidays config;
        private final HolidayParser parser;

        public HolidayParserRunner(int year, Set<Holiday> holidays, Holidays config, HolidayParser parser) {
            this.year = year;
            this.holidays = holidays;
            this.config = config;
            this.parser = parser;
        }

        @Override
        public void run() {
            this.parser.parse(this.year, this.holidays, this.config);
        }
    }
}

