/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration.internal;

import de.jollyday.configuration.ConfigurationProvider;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public class URLConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(URLConfigurationProvider.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConfiguration(Properties properties) {
        String[] strConfigURLs;
        Properties systemProps = System.getProperties();
        String configURLs = systemProps.getProperty("de.jollyday.config.urls");
        if (configURLs != null && (strConfigURLs = configURLs.split(",")) != null) {
            for (String strURL : strConfigURLs) {
                if (strURL == null || "".equals(strURL)) continue;
                InputStream inputStream = null;
                try {
                    URL configURL = new URL(strURL.trim());
                    inputStream = configURL.openStream();
                    properties.load(inputStream);
                }
                catch (Exception e) {
                    LOG.warning("Cannot read configuration from '" + strURL + "'. " + e.getClass().getSimpleName() + " (" + e.getMessage() + ").");
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            LOG.warning("Cannot close stream for configuration URL " + strURL + ".");
                        }
                    }
                }
            }
        }
    }
}

