/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import java.util.Map;

class TsurgeonPatternRoot
extends TsurgeonPattern {
    boolean coindexes = false;

    public TsurgeonPatternRoot(TsurgeonPattern child) {
        this(new TsurgeonPattern[]{child});
    }

    public TsurgeonPatternRoot(TsurgeonPattern[] children) {
        super("operations: ", children);
        this.setRoot(this);
    }

    void setCoindexes() {
        this.coindexes = true;
    }

    @Override
    public TsurgeonMatcher matcher() {
        CoindexationGenerator coindexer = null;
        if (this.coindexes) {
            coindexer = new CoindexationGenerator();
        }
        return this.matcher(Generics.newHashMap(), coindexer);
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(TsurgeonPatternRoot.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            if (this.coindexer != null) {
                this.coindexer.setLastIndex(tree);
            }
            for (TsurgeonMatcher child : this.childMatcher) {
                if ((tree = child.evaluate(tree, tregex)) != null) continue;
                return null;
            }
            return tree;
        }
    }
}

