data {
  int unb_d;
  int<lower=0, upper=1> bin_d;
  int<lower=0> pos_d;
  array[1] int unb_d_vec;
  array[1] int<lower=0, upper=1> bin_d_vec;
  array[1] int<lower=0> pos_d_vec;
}
parameters {
  real x;
  real<lower=0> x_pos;
  real<lower=0,upper=1> x_unit;
  real unb_p;
  real<lower=0> pos_p;
  real<lower=0, upper=1> unit_p;
  vector[1] vec;
  vector<lower=0>[1] pos_vec;
  matrix[1,1] mat;
  simplex[1] sim;
  ordered[1] ord;
  cov_matrix[1] cov;
  cholesky_factor_cov[1] chol_cov;
  corr_matrix[1] corr;
  cholesky_factor_corr[1] chol_corr;
}
model {
  unb_d ~ bernoulli(unb_p);
  bin_d ~ bernoulli(unit_p);
  unb_d ~ bernoulli_logit(unb_p);
  bin_d ~ bernoulli_logit(unb_p); // can't catch anything yet
  unb_d_vec ~ bernoulli_logit_glm(mat, vec, vec);
  bin_d_vec ~ bernoulli_logit_glm(mat, vec, vec); // can't catch anything yet
  unb_d ~ binomial(unb_d, unb_p);
  bin_d ~ binomial(pos_d, unit_p);
  unb_d ~ binomial_logit(unb_d, unb_p);
  bin_d ~ binomial_logit(pos_d, unb_p);
  unb_d ~ beta_binomial(unb_d, unb_p, unb_p);
  pos_d ~ beta_binomial(pos_d, pos_p, pos_p);
  unb_d ~ hypergeometric(unb_d, unb_d, unb_d);
  pos_d ~ hypergeometric(pos_d, pos_d, pos_d);
  unb_d ~ categorical(vec);
  pos_d ~ categorical(sim);
  unb_d ~ ordered_logistic(unb_p, vec);
  pos_d ~ ordered_logistic(unb_p, ord);
  unb_d ~ ordered_probit(unb_p, vec);
  pos_d ~ ordered_probit(unb_p, ord);
  unb_d ~ neg_binomial(unb_p, unb_p);
  pos_d ~ neg_binomial(pos_p, pos_p);
  unb_d ~ neg_binomial_2(unb_p, unb_p);
  pos_d ~ neg_binomial_2(pos_p, pos_p);
  unb_d ~ neg_binomial_2_log(unb_p, unb_p);
  pos_d ~ neg_binomial_2_log(unb_p, pos_p);
  unb_d_vec ~ neg_binomial_2_log_glm(mat, vec, vec, unb_p);
  unb_d_vec ~ neg_binomial_2_log_glm(mat, vec, vec, pos_p);
  unb_d ~ poisson(unb_p);
  pos_d ~ poisson(pos_p);
  unb_d ~ poisson_log(unb_p);
  pos_d ~ poisson_log(unb_p);
  unb_d_vec ~ poisson_log_glm(mat, vec, vec);
  pos_d_vec ~ poisson_log_glm(mat, vec, vec);
  unb_d_vec ~ multinomial(vec);
  pos_d_vec ~ multinomial(sim);
  x ~ normal(0, unb_p);
  x ~ normal(0, pos_p);
  vec ~ normal_id_glm(mat, vec, vec, unb_p); // missing b.c. lpdf suffix
  vec ~ normal_id_glm(mat, vec, vec, pos_p);
  x ~ exp_mod_normal(0, unb_p, unb_p);
  x ~ exp_mod_normal(0, pos_p, pos_p);
  x ~ skew_normal(0, unb_p, 0);
  x ~ skew_normal(0, pos_p, 0);
  x ~ student_t(unb_p, 0, unb_p);
  x ~ student_t(pos_p, 0, pos_p);
  x ~ cauchy(0, unb_p); // missing
  x ~ cauchy(0, pos_p);
  x ~ double_exponential(0, unb_p);
  x ~ double_exponential(0, pos_p);
  x ~ logistic(0, unb_p);
  x ~ logistic(0, pos_p);
  x ~ gumbel(0, unb_p);
  x ~ gumbel(0, pos_p);
  x ~ lognormal(0, unb_p);
  x_pos ~ lognormal(0, pos_p);
  x ~ chi_square(unb_p);
  x_pos ~ chi_square(pos_p);
  x ~ inv_chi_square(unb_p);
  x_pos ~ inv_chi_square(pos_p);
  x ~ scaled_inv_chi_square(unb_p, unb_p);
  x_pos ~ scaled_inv_chi_square(pos_p, pos_p);
  x ~ exponential(unb_p);
  x_pos ~ exponential(pos_p);
  x ~ gamma(unb_p, unb_p);
  x_pos ~ gamma(pos_p, pos_p);
  x ~ inv_gamma(unb_p, unb_p);
  x_pos ~ inv_gamma(pos_p, pos_p);
  x ~ weibull(unb_p, unb_p);
  x_pos ~ weibull(pos_p, pos_p);
  x ~ frechet(unb_p, unb_p);
  x_pos ~ frechet(pos_p, pos_p);
  x ~ rayleigh(unb_p);
  x_pos ~ rayleigh(pos_p);
  x ~ wiener(unb_p, unb_p, pos_p, 0);
  x_pos ~ wiener(pos_p, pos_p, unit_p, 0);
  x ~ pareto(unb_p, unb_p);
  x_pos ~ pareto(pos_p, pos_p);
  x ~ pareto_type_2(0, unb_p, unb_p);
  x ~ pareto_type_2(0, pos_p, pos_p);
  x ~ beta(unb_p, unb_p);
  x_unit ~ beta(pos_p, pos_p);
  x ~ beta_proportion(unb_p, unb_p);
  x_unit ~ beta_proportion(unit_p, pos_p);
  x ~ von_mises(0, unb_p);
  x ~ von_mises(0, pos_p);
  vec ~ multi_normal(vec, mat);
  vec ~ multi_normal(vec, cov);
  vec ~ multi_normal_prec(vec, mat);
  vec ~ multi_normal_prec(vec, cov);
  vec ~ multi_normal_cholesky(vec, cov);
  vec ~ multi_normal_cholesky(vec, chol_cov);
  mat ~ multi_gp(mat, vec);
  mat ~ multi_gp(cov, vec);
  mat ~ multi_gp_cholesky(cov, vec);
  mat ~ multi_gp_cholesky(chol_cov, vec);
  vec ~ multi_student_t(unb_p, vec, mat);
  vec ~ multi_student_t(pos_p, vec, cov);
  vec ~ multi_student_t_cholesky(unb_p, vec, cov);
  vec ~ multi_student_t_cholesky(pos_p, vec, chol_cov);
  mat ~ gaussian_dlm_obs(mat, mat, mat, mat, vec, mat);
  mat ~ gaussian_dlm_obs(mat, mat, cov, cov, vec, mat);
  vec ~ dirichlet(vec);
  sim ~ dirichlet(pos_vec);
  mat ~ lkj_corr(unb_p);
  corr ~ lkj_corr(pos_p);
  corr ~ lkj_corr_cholesky(unb_p);
  chol_corr ~ lkj_corr_cholesky(pos_p);
  mat ~ wishart(unb_p, mat);
  cov ~ wishart(pos_p, cov);
  mat ~ wishart_cholesky(unb_p, cov);
  chol_cov ~ wishart_cholesky(pos_p, chol_cov);
  mat ~ inv_wishart(unb_p, mat);
  cov ~ inv_wishart(pos_p, cov);
  mat ~ inv_wishart_cholesky(unb_p, cov);
  chol_cov ~ inv_wishart_cholesky(pos_p, chol_cov);
}
