# SELECT *

## Inefficiency in moving data to the consumer:   
When you SELECT *, you're often retrieving more columns from the database than
your application really needs to function. This causes more data to move from
the database server to the client, slowing access and increasing load on your
machines, as well as taking more time to travel across the network. This is
especially true when someone adds new columns to underlying tables that didn't
exist and weren't needed when the original consumers coded their data access.   

## Indexing issues:   
Consider a scenario where you want to tune a query to a high level of performance.
If you were to use *, and it returned more columns than you actually needed,
the server would often have to perform more expensive methods to retrieve your
data than it otherwise might. For example, you wouldn't be able to create an index
which simply covered the columns in your SELECT list, and even if you did
(including all columns [shudder]), the next developer who came around and added a column
to the underlying table would cause the optimizer to ignore your optimized covering
index, and you'd likely find that the performance of your query would drop
substantially for no readily apparent reason.   

## Binding Problems:   
When you SELECT *, it's possible to retrieve two columns of the same name from two
different tables. This can often crash your data consumer. Imagine a query that joins
two tables, both of which contain a column called \ID\. How would a consumer know
which was which? SELECT * can also confuse views (at least in some versions SQL Server)
when underlying table structures change -- the view is not rebuilt, and the data which
comes back can be nonsense. And the worst part of it is that you can take care to name
your columns whatever you want, but the next developer who comes along might have no way of
knowing that he has to worry about adding a column which will collide with your
already-developed names.   
