# Multi-Valued Attribute

## **Store each value in its own column and row:**     
Storing a list of IDs as a VARCHAR/TEXT column can cause performance and data integrity
problems. Querying against such a column would require using pattern-matching
expressions. It is awkward and costly to join a comma-separated list to matching rows.
This will make it harder to validate IDs. Think about what is the greatest number of
entries this list must support? Instead of using a multi-valued attribute,
consider storing it in a separate table, so that each individual value of that attribute
occupies a separate row. Such an intersection table implements a many-to-many relationship
between the two referenced tables. This will greatly simplify querying and validating
the IDs.