/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.inheritance;

import java.lang.annotation.Annotation;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.MetadataHelper;

public class InheritanceMetadata
extends ORMetadata {
    private Enum m_strategy;

    public InheritanceMetadata() {
        super("<inheritance>");
    }

    public InheritanceMetadata(Annotation inheritance, MetadataAccessibleObject accessibleObject) {
        super(inheritance, accessibleObject);
        if (inheritance != null) {
            this.m_strategy = (Enum)MetadataHelper.invokeMethod("strategy", inheritance);
        }
    }

    public Enum getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor descriptor) {
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_strategy == null || this.m_strategy.equals(InheritanceType.SINGLE_TABLE)) {
            classDescriptor.getInheritancePolicy().setSingleTableStrategy();
        } else if (this.m_strategy.name().equals(InheritanceType.JOINED.name())) {
            classDescriptor.getInheritancePolicy().setJoinedStrategy();
        } else if (this.m_strategy.name().equals(InheritanceType.TABLE_PER_CLASS.name())) {
            throw ValidationException.tablePerClassInheritanceNotSupported(this.getLocation());
        }
    }

    public void setStrategy(Enum strategy) {
        this.m_strategy = strategy;
    }
}

