/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NotCompilableException;

public class AssignmentCompiler {
    public static void assign(Node node, int index, Compiler context) {
        switch (node.nodeId) {
            case 25: {
                AssignmentCompiler.dasgnArgCompile(node, index, context);
                break;
            }
            case 43: {
                AssignmentCompiler.globalAsgnArgCompile(node, index, context);
                break;
            }
            case 47: {
                AssignmentCompiler.instAsgnArgCompile(node, index, context);
                break;
            }
            case 52: {
                AssignmentCompiler.localAsgnArgCompile(node, index, context);
                break;
            }
            default: {
                throw new NotCompilableException("Can't compile node: " + node);
            }
        }
    }

    private static void dasgnArgCompile(Node node, int argIndex, Compiler context) {
        DAsgnNode dasgnNode = (DAsgnNode)node;
        context.assignLocalVariableBlockArg(argIndex, dasgnNode.getIndex(), dasgnNode.getDepth());
    }

    private static void localAsgnArgCompile(Node node, int argIndex, Compiler context) {
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        context.assignLocalVariableBlockArg(argIndex, localAsgnNode.getIndex(), localAsgnNode.getDepth());
    }

    private static void instAsgnArgCompile(Node node, int argIndex, Compiler context) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        context.assignInstanceVariableBlockArg(argIndex, instAsgnNode.getName());
    }

    private static void globalAsgnArgCompile(Node node, int argIndex, Compiler context) {
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        context.assignGlobalVariableBlockArg(argIndex, globalAsgnNode.getName());
    }
}

