/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.test;

import java.util.Arrays;
import org.springframework.boot.cli.command.test.TestFailedException;
import org.springframework.boot.cli.command.test.TestRunner;
import org.springframework.boot.cli.command.test.TestRunnerConfiguration;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class TestRunner {
    private static final String JUNIT_TEST_ANNOTATION = "org.junit.Test";
    private final String[] sources;
    private final GroovyCompiler compiler;
    private volatile Throwable threadException;

    TestRunner(TestRunnerConfiguration configuration, String[] sources, String[] args) {
        this.sources = (String[])sources.clone();
        this.compiler = new GroovyCompiler((GroovyCompilerConfiguration)configuration);
    }

    public void compileAndRunTests() throws Exception {
        Object[] sources = this.compiler.compile(this.sources);
        if (sources.length == 0) {
            throw new RuntimeException("No classes found in '" + Arrays.toString(this.sources) + "'");
        }
        RunThread runThread = new RunThread(this, sources);
        runThread.start();
        runThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        runThread.join();
        if (this.threadException != null) {
            TestFailedException ex = new TestFailedException(this.threadException);
            this.threadException = null;
            throw ex;
        }
    }

    static /* synthetic */ Throwable access$002(TestRunner x0, Throwable x1) {
        x0.threadException = x1;
        return x0.threadException;
    }
}

