/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class SpringTestCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"SpringApplicationConfiguration"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.http.HttpHeaders"}).add(new String[]{"spring-boot-starter-web"});
    }

    public void apply(GroovyClassLoader loader, GroovyCompilerConfiguration configuration, GeneratorContext generatorContext, SourceUnit source, ClassNode classNode) throws CompilationFailedException {
        if (!AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"RunWith"})) {
            AnnotationNode runWith = new AnnotationNode(ClassHelper.make((String)"RunWith"));
            runWith.addMember("value", (Expression)new ClassExpression(ClassHelper.make((String)"SpringRunner")));
            classNode.addAnnotation(runWith);
        }
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addStarImports(new String[]{"org.junit.runner", "org.springframework.boot.test", "org.springframework.http", "org.springframework.test.context.junit4", "org.springframework.test.annotation"}).addImports(new String[]{"org.springframework.test.context.web.WebAppConfiguration"});
    }
}

