/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.boot.cli.command.test.TestFailedException;
import org.springframework.boot.cli.command.test.TestRunnerConfiguration;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.groovy.DelegateTestRunner;
import org.springframework.util.ReflectionUtils;

public class TestRunner {
    private static final String JUNIT_TEST_ANNOTATION = "org.junit.Test";
    private final String[] sources;
    private final GroovyCompiler compiler;
    private volatile Throwable threadException;

    TestRunner(TestRunnerConfiguration configuration, String[] sources, String[] args) {
        this.sources = (String[])sources.clone();
        this.compiler = new GroovyCompiler(configuration);
    }

    public void compileAndRunTests() throws Exception {
        Object[] sources = this.compiler.compile(this.sources);
        if (sources.length == 0) {
            throw new RuntimeException("No classes found in '" + this.sources + "'");
        }
        RunThread runThread = new RunThread(sources);
        runThread.start();
        runThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable ex) {
                TestRunner.this.threadException = ex;
            }
        });
        runThread.join();
        if (this.threadException != null) {
            TestFailedException ex = new TestFailedException(this.threadException);
            this.threadException = null;
            throw ex;
        }
    }

    private class RunThread
    extends Thread {
        private final Class<?>[] testClasses;
        private final Class<?> spockSpecificationClass;

        RunThread(Object ... sources) {
            super("testrunner");
            this.setDaemon(true);
            if (sources.length != 0 && sources[0] instanceof Class) {
                this.setContextClassLoader(((Class)sources[0]).getClassLoader());
            }
            this.spockSpecificationClass = this.loadSpockSpecificationClass(this.getContextClassLoader());
            this.testClasses = this.getTestClasses(sources);
        }

        private Class<?> loadSpockSpecificationClass(ClassLoader contextClassLoader) {
            try {
                return this.getContextClassLoader().loadClass("spock.lang.Specification");
            }
            catch (Exception ex) {
                return null;
            }
        }

        private Class<?>[] getTestClasses(Object[] sources) {
            ArrayList<Class> testClasses = new ArrayList<Class>();
            for (Object source : sources) {
                if (!(source instanceof Class) || !this.isTestable((Class)source)) continue;
                testClasses.add((Class)source);
            }
            return testClasses.toArray(new Class[testClasses.size()]);
        }

        private boolean isTestable(Class<?> sourceClass) {
            return this.isJunitTest(sourceClass) || this.isSpockTest(sourceClass);
        }

        private boolean isJunitTest(Class<?> sourceClass) {
            for (Method method : sourceClass.getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals(TestRunner.JUNIT_TEST_ANNOTATION)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSpockTest(Class<?> sourceClass) {
            return this.spockSpecificationClass != null && this.spockSpecificationClass.isAssignableFrom(sourceClass);
        }

        @Override
        public void run() {
            try {
                if (this.testClasses.length == 0) {
                    System.out.println("No tests found");
                } else {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> delegateClass = contextClassLoader.loadClass(DelegateTestRunner.class.getName());
                    Class<?> resultClass = contextClassLoader.loadClass("org.junit.runner.Result");
                    Method runMethod = delegateClass.getMethod("run", Class[].class, resultClass);
                    Object result = resultClass.newInstance();
                    runMethod.invoke(null, this.testClasses, result);
                    boolean wasSuccessful = (Boolean)resultClass.getMethod("wasSuccessful", new Class[0]).invoke(result, new Object[0]);
                    if (!wasSuccessful) {
                        throw new RuntimeException("Tests Failed.");
                    }
                }
            }
            catch (Exception ex) {
                ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            }
        }
    }
}

