/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.run;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.springframework.boot.cli.app.SpringApplicationLauncher;
import org.springframework.boot.cli.command.run.SpringApplicationRunnerConfiguration;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.util.ResourceUtils;

public class SpringApplicationRunner {
    private static int watcherCounter = 0;
    private static int runnerCounter = 0;
    private final SpringApplicationRunnerConfiguration configuration;
    private final String[] sources;
    private final String[] args;
    private final GroovyCompiler compiler;
    private RunThread runThread;
    private FileWatchThread fileWatchThread;

    SpringApplicationRunner(SpringApplicationRunnerConfiguration configuration, String[] sources, String ... args) {
        this.configuration = configuration;
        this.sources = (String[])sources.clone();
        this.args = (String[])args.clone();
        this.compiler = new GroovyCompiler(configuration);
        int level = configuration.getLogLevel().intValue();
        if (level <= Level.FINER.intValue()) {
            System.setProperty("groovy.grape.report.downloads", "true");
            System.setProperty("trace", "true");
        } else if (level <= Level.FINE.intValue()) {
            System.setProperty("debug", "true");
        } else if (level == Level.OFF.intValue()) {
            System.setProperty("spring.main.showBanner", "false");
            System.setProperty("logging.level.ROOT", "OFF");
        }
    }

    public synchronized void compileAndRun() throws Exception {
        try {
            this.stop();
            Object[] compiledSources = this.compile();
            this.monitorForChanges();
            this.runThread = new RunThread(compiledSources);
            this.runThread.start();
            this.runThread.join();
        }
        catch (Exception ex) {
            if (this.fileWatchThread == null) {
                throw ex;
            }
            ex.printStackTrace();
        }
    }

    public void stop() {
        if (this.runThread != null) {
            this.runThread.shutdown();
            this.runThread = null;
        }
    }

    private Object[] compile() throws IOException {
        Object[] compiledSources = this.compiler.compile(this.sources);
        if (compiledSources.length == 0) {
            throw new RuntimeException("No classes found in '" + this.sources + "'");
        }
        return compiledSources;
    }

    private void monitorForChanges() {
        if (this.fileWatchThread == null && this.configuration.isWatchForFileChanges()) {
            this.fileWatchThread = new FileWatchThread();
            this.fileWatchThread.start();
        }
    }

    private class FileWatchThread
    extends Thread {
        private long previous;
        private List<File> sources;

        FileWatchThread() {
            super("filewatcher-" + watcherCounter++);
            this.previous = 0L;
            this.sources = this.getSourceFiles();
            for (File file : this.sources) {
                long current;
                if (!file.exists() || (current = file.lastModified()) <= this.previous) continue;
                this.previous = current;
            }
            this.setDaemon(false);
        }

        private List<File> getSourceFiles() {
            ArrayList<File> sources = new ArrayList<File>();
            for (String source : SpringApplicationRunner.this.sources) {
                List<String> paths = ResourceUtils.getUrls(source, (ClassLoader)((Object)SpringApplicationRunner.this.compiler.getLoader()));
                for (String path : paths) {
                    try {
                        URL url = new URL(path);
                        if (!"file".equals(url.getProtocol())) continue;
                        sources.add(new File(url.getFile()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            return sources;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                        Iterator<File> iterator = this.sources.iterator();
                        while (true) {
                            long current;
                            if (!iterator.hasNext()) continue block4;
                            File file = iterator.next();
                            if (!file.exists() || this.previous >= (current = file.lastModified())) continue;
                            this.previous = current;
                            SpringApplicationRunner.this.compileAndRun();
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class RunThread
    extends Thread {
        private final Object[] compiledSources;
        private Object applicationContext;

        RunThread(Object ... compiledSources) {
            super("runner-" + runnerCounter++);
            this.compiledSources = compiledSources;
            if (compiledSources.length != 0 && compiledSources[0] instanceof Class) {
                this.setContextClassLoader(((Class)compiledSources[0]).getClassLoader());
            }
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.applicationContext = new SpringApplicationLauncher(this.getContextClassLoader()).launch(this.compiledSources, SpringApplicationRunner.this.args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public synchronized void shutdown() {
            if (this.applicationContext != null) {
                try {
                    Method method = this.applicationContext.getClass().getMethod("close", new Class[0]);
                    method.invoke(this.applicationContext, new Object[0]);
                }
                catch (NoSuchMethodException method) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.applicationContext = null;
                }
            }
        }
    }
}

