/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.boot.cli.command.init.Dependency;
import org.springframework.boot.cli.command.init.ProjectType;

class InitializrServiceMetadata {
    private static final String DEPENDENCIES_EL = "dependencies";
    private static final String TYPE_EL = "type";
    private static final String VALUES_EL = "values";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private final Map<String, Dependency> dependencies;
    private final MetadataHolder<String, ProjectType> projectTypes;
    private final Map<String, String> defaults;

    public InitializrServiceMetadata(JSONObject root) {
        this.dependencies = this.parseDependencies(root);
        this.projectTypes = this.parseProjectTypes(root);
        this.defaults = Collections.unmodifiableMap(this.parseDefaults(root));
    }

    public InitializrServiceMetadata(ProjectType defaultProjectType) {
        this.dependencies = new HashMap<String, Dependency>();
        this.projectTypes = new MetadataHolder();
        this.projectTypes.getContent().put(defaultProjectType.getId(), defaultProjectType);
        this.projectTypes.setDefaultItem(defaultProjectType);
        this.defaults = new HashMap<String, String>();
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies.values();
    }

    public Dependency getDependency(String id) {
        return this.dependencies.get(id);
    }

    public Map<String, ProjectType> getProjectTypes() {
        return this.projectTypes.getContent();
    }

    public ProjectType getDefaultType() {
        if (this.projectTypes.getDefaultItem() != null) {
            return this.projectTypes.getDefaultItem();
        }
        String defaultTypeId = this.getDefaults().get(TYPE_EL);
        if (defaultTypeId != null) {
            return this.projectTypes.getContent().get(defaultTypeId);
        }
        return null;
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    private Map<String, Dependency> parseDependencies(JSONObject root) {
        HashMap<String, Dependency> result = new HashMap<String, Dependency>();
        if (!root.has(DEPENDENCIES_EL)) {
            return result;
        }
        JSONObject dependencies = root.getJSONObject(DEPENDENCIES_EL);
        JSONArray array = dependencies.getJSONArray(VALUES_EL);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject group = array.getJSONObject(i);
            this.parseGroup(group, result);
        }
        return result;
    }

    private MetadataHolder<String, ProjectType> parseProjectTypes(JSONObject root) {
        MetadataHolder<String, ProjectType> result = new MetadataHolder<String, ProjectType>();
        if (!root.has(TYPE_EL)) {
            return result;
        }
        JSONObject type = root.getJSONObject(TYPE_EL);
        JSONArray array = type.getJSONArray(VALUES_EL);
        String defaultType = type.has(DEFAULT_ATTRIBUTE) ? type.getString(DEFAULT_ATTRIBUTE) : null;
        for (int i = 0; i < array.length(); ++i) {
            JSONObject typeJson = array.getJSONObject(i);
            ProjectType projectType = this.parseType(typeJson, defaultType);
            result.getContent().put(projectType.getId(), projectType);
            if (!projectType.isDefaultType()) continue;
            result.setDefaultItem(projectType);
        }
        return result;
    }

    private Map<String, String> parseDefaults(JSONObject root) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator keys = root.keys();
        while (keys.hasNext()) {
            JSONObject child;
            String key = (String)keys.next();
            Object o = root.get(key);
            if (!(o instanceof JSONObject) || !(child = (JSONObject)o).has(DEFAULT_ATTRIBUTE)) continue;
            result.put(key, child.getString(DEFAULT_ATTRIBUTE));
        }
        return result;
    }

    private void parseGroup(JSONObject group, Map<String, Dependency> dependencies) {
        if (group.has(VALUES_EL)) {
            JSONArray content = group.getJSONArray(VALUES_EL);
            for (int i = 0; i < content.length(); ++i) {
                Dependency dependency = this.parseDependency(content.getJSONObject(i));
                dependencies.put(dependency.getId(), dependency);
            }
        }
    }

    private Dependency parseDependency(JSONObject object) {
        String id = this.getStringValue(object, ID_ATTRIBUTE, null);
        String name = this.getStringValue(object, NAME_ATTRIBUTE, null);
        String description = this.getStringValue(object, DESCRIPTION_ATTRIBUTE, null);
        return new Dependency(id, name, description);
    }

    private ProjectType parseType(JSONObject object, String defaultId) {
        String id = this.getStringValue(object, ID_ATTRIBUTE, null);
        String name = this.getStringValue(object, NAME_ATTRIBUTE, null);
        String action = this.getStringValue(object, ACTION_ATTRIBUTE, null);
        boolean defaultType = id.equals(defaultId);
        HashMap<String, String> tags = new HashMap<String, String>();
        if (object.has("tags")) {
            JSONObject jsonTags = object.getJSONObject("tags");
            tags.putAll(this.parseStringItems(jsonTags));
        }
        return new ProjectType(id, name, action, defaultType, tags);
    }

    private String getStringValue(JSONObject object, String name, String defaultValue) {
        return object.has(name) ? object.getString(name) : defaultValue;
    }

    private Map<String, String> parseStringItems(JSONObject json) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object k : json.keySet()) {
            String key = (String)k;
            Object value = json.get(key);
            if (!(value instanceof String)) continue;
            result.put(key, (String)value);
        }
        return result;
    }

    private static class MetadataHolder<K, T> {
        private final Map<K, T> content = new HashMap<K, T>();
        private T defaultItem;

        private MetadataHolder() {
        }

        public Map<K, T> getContent() {
            return this.content;
        }

        public T getDefaultItem() {
            return this.defaultItem;
        }

        public void setDefaultItem(T defaultItem) {
            this.defaultItem = defaultItem;
        }
    }
}

