/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.util.StringUtils;

public final class RepositoryConfigurationFactory {
    private static final RepositoryConfiguration MAVEN_CENTRAL = new RepositoryConfiguration("central", URI.create("http://repo1.maven.org/maven2/"), false);
    private static final RepositoryConfiguration SPRING_MILESTONE = new RepositoryConfiguration("spring-milestone", URI.create("http://repo.spring.io/milestone"), false);
    private static final RepositoryConfiguration SPRING_SNAPSHOT = new RepositoryConfiguration("spring-snapshot", URI.create("http://repo.spring.io/snapshot"), true);

    public static List<RepositoryConfiguration> createDefaultRepositoryConfiguration() {
        ArrayList<RepositoryConfiguration> repositoryConfiguration = new ArrayList<RepositoryConfiguration>();
        repositoryConfiguration.add(MAVEN_CENTRAL);
        if (!Boolean.getBoolean("disableSpringSnapshotRepos")) {
            repositoryConfiguration.add(SPRING_MILESTONE);
            repositoryConfiguration.add(SPRING_SNAPSHOT);
        }
        RepositoryConfigurationFactory.addDefaultCacheAsRespository(repositoryConfiguration);
        return repositoryConfiguration;
    }

    public static void addDefaultCacheAsRespository(List<RepositoryConfiguration> repositoryConfiguration) {
        RepositoryConfiguration repository = new RepositoryConfiguration("local", new File(RepositoryConfigurationFactory.getM2HomeDirectory(), "repository").toURI(), true);
        if (!repositoryConfiguration.contains(repository)) {
            repositoryConfiguration.add(0, repository);
        }
    }

    private static File getM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength((String)mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }
}

