/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.jar;

import groovy.lang.Grab;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.springframework.boot.cli.app.SpringApplicationLauncher;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.jar.ResourceMatcher;
import org.springframework.boot.cli.command.options.CompilerOptionHandler;
import org.springframework.boot.cli.command.options.OptionSetGroovyCompilerConfiguration;
import org.springframework.boot.cli.command.options.SourceOptions;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.RepositoryConfigurationFactory;
import org.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.boot.cli.jar.PackagedSpringApplicationLauncher;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class JarCommand
extends OptionParsingCommand {
    private static final Layout LAYOUT = new Layouts.Jar();
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};

    public JarCommand() {
        super("jar", "Create a self-contained executable jar file from a Spring Groovy script", new JarOptionHandler());
    }

    @Override
    public String getUsageHelp() {
        return "[options] <jar-name> <files>";
    }

    private static class GrabAnnotationTransform
    implements ASTTransformation {
        private GrabAnnotationTransform() {
        }

        public void visit(ASTNode[] nodes, SourceUnit source) {
            for (ASTNode node : nodes) {
                if (!(node instanceof ModuleNode)) continue;
                this.visitModule((ModuleNode)node);
            }
        }

        private void visitModule(ModuleNode module) {
            Iterator i$ = module.getClasses().iterator();
            if (i$.hasNext()) {
                ClassNode classNode = (ClassNode)i$.next();
                AnnotationNode annotation = new AnnotationNode(new ClassNode(Grab.class));
                annotation.addMember("value", (Expression)new ConstantExpression((Object)"groovy"));
                classNode.addAnnotation(annotation);
            }
            this.removeGrabResolver(module.getClasses());
            this.removeGrabResolver(module.getImports());
        }

        private void removeGrabResolver(List<? extends AnnotatedNode> nodes) {
            for (AnnotatedNode annotatedNode : nodes) {
                List annotations = annotatedNode.getAnnotations();
                for (AnnotationNode node : new ArrayList(annotations)) {
                    if (!node.getClassNode().getNameWithoutPackage().equals("GrabResolver")) continue;
                    annotations.remove(node);
                }
            }
        }
    }

    private static final class JarOptionHandler
    extends CompilerOptionHandler {
        private OptionSpec<String> includeOption;
        private OptionSpec<String> excludeOption;

        private JarOptionHandler() {
        }

        @Override
        protected void doOptions() {
            this.includeOption = this.option("include", "Pattern applied to directories on the classpath to find files to include in the resulting jar").withRequiredArg().withValuesSeparatedBy(",").defaultsTo((Object)"", (Object[])new String[0]);
            this.excludeOption = this.option("exclude", "Pattern applied to directories on the claspath to find files to exclude from the resulting jar").withRequiredArg().withValuesSeparatedBy(",").defaultsTo((Object)"", (Object[])new String[0]);
        }

        @Override
        protected ExitStatus run(OptionSet options) throws Exception {
            ArrayList nonOptionArguments = new ArrayList(options.nonOptionArguments());
            Assert.isTrue((nonOptionArguments.size() >= 2 ? 1 : 0) != 0, (String)"The name of the resulting jar and at least one source file must be specified");
            File output = new File((String)nonOptionArguments.remove(0));
            Assert.isTrue((boolean)output.getName().toLowerCase().endsWith(".jar"), (String)("The output '" + output + "' is not a JAR file."));
            this.deleteIfExists(output);
            GroovyCompiler compiler = this.createCompiler(options);
            List<URL> classpath = this.getClassPathUrls(compiler);
            List<ResourceMatcher.MatchedResource> classpathEntries = this.findMatchingClasspathEntries(classpath, options);
            String[] sources = new SourceOptions(nonOptionArguments).getSourcesArray();
            Class<?>[] compiledClasses = compiler.compile(sources);
            List<URL> dependencies = this.getClassPathUrls(compiler);
            dependencies.removeAll(classpath);
            this.writeJar(output, compiledClasses, classpathEntries, dependencies);
            return ExitStatus.OK;
        }

        private void deleteIfExists(File file) {
            if (file.exists() && !file.delete()) {
                throw new IllegalStateException("Failed to delete existing file " + file.getPath());
            }
        }

        private GroovyCompiler createCompiler(OptionSet options) {
            List<RepositoryConfiguration> repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
            OptionSetGroovyCompilerConfiguration configuration = new OptionSetGroovyCompilerConfiguration(options, this, repositoryConfiguration);
            GroovyCompiler groovyCompiler = new GroovyCompiler(configuration);
            groovyCompiler.getAstTransformations().add(0, new GrabAnnotationTransform());
            return groovyCompiler;
        }

        private List<URL> getClassPathUrls(GroovyCompiler compiler) {
            return new ArrayList<URL>(Arrays.asList(compiler.getLoader().getURLs()));
        }

        private List<ResourceMatcher.MatchedResource> findMatchingClasspathEntries(List<URL> classpath, OptionSet options) throws IOException {
            ResourceMatcher matcher = new ResourceMatcher(options.valuesOf(this.includeOption), options.valuesOf(this.excludeOption));
            ArrayList<File> roots = new ArrayList<File>();
            for (URL classpathEntry : classpath) {
                roots.add(new File(URI.create(classpathEntry.toString())));
            }
            return matcher.find(roots);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeJar(File file, Class<?>[] compiledClasses, List<ResourceMatcher.MatchedResource> classpathEntries, List<URL> dependencies) throws FileNotFoundException, IOException, URISyntaxException {
            JarWriter writer = new JarWriter(file);
            try {
                this.addManifest(writer, compiledClasses);
                this.addCliClasses(writer);
                for (Class<?> compiledClass : compiledClasses) {
                    this.addClass(writer, compiledClass);
                }
                this.addClasspathEntries(writer, classpathEntries);
                this.addDependencies(writer, dependencies);
                writer.writeLoaderClasses();
            }
            finally {
                writer.close();
            }
        }

        private void addManifest(JarWriter writer, Class<?>[] compiledClasses) throws IOException {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            manifest.getMainAttributes().putValue("Main-Class", LAYOUT.getLauncherClassName());
            manifest.getMainAttributes().putValue("Start-Class", PackagedSpringApplicationLauncher.class.getName());
            manifest.getMainAttributes().putValue("Spring-Application-Source-Classes", this.commaDelimitedClassNames(compiledClasses));
            writer.writeManifest(manifest);
        }

        private String commaDelimitedClassNames(Class<?>[] classes) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < classes.length; ++i) {
                builder.append(i == 0 ? "" : ",");
                builder.append(classes[i].getName());
            }
            return builder.toString();
        }

        private void addCliClasses(JarWriter writer) throws IOException {
            Resource[] resources;
            this.addClass(writer, PackagedSpringApplicationLauncher.class);
            this.addClass(writer, SpringApplicationLauncher.class);
            for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("org/springframework/boot/groovy/**")) {
                String url = resource.getURL().toString();
                this.addResource(writer, resource, url.substring(url.indexOf("org/springframework/boot/groovy/")));
            }
        }

        private void addClass(JarWriter writer, Class<?> sourceClass) throws IOException {
            String name = sourceClass.getName().replace(".", "/") + ".class";
            InputStream stream = sourceClass.getResourceAsStream("/" + name);
            writer.writeEntry(name, stream);
        }

        private void addResource(JarWriter writer, Resource resource, String name) throws IOException {
            InputStream stream = resource.getInputStream();
            writer.writeEntry(name, stream);
        }

        private void addClasspathEntries(JarWriter writer, List<ResourceMatcher.MatchedResource> entries) throws IOException {
            for (ResourceMatcher.MatchedResource entry : entries) {
                if (entry.isRoot()) {
                    this.addDependency(writer, entry.getFile());
                    continue;
                }
                writer.writeEntry(entry.getName(), (InputStream)new FileInputStream(entry.getFile()));
            }
        }

        private void addDependencies(JarWriter writer, List<URL> urls) throws IOException, URISyntaxException, FileNotFoundException {
            for (URL url : urls) {
                this.addDependency(writer, new File(url.toURI()));
            }
        }

        private void addDependency(JarWriter writer, File dependency) throws FileNotFoundException, IOException {
            if (dependency.isFile() && this.isZip(dependency)) {
                writer.writeNestedLibrary("lib/", new Library(dependency, LibraryScope.COMPILE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isZip(File file) {
            boolean bl;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                bl = this.isZip(fileInputStream);
            }
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            fileInputStream.close();
            return bl;
        }

        private boolean isZip(InputStream inputStream) throws IOException {
            for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
                if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
                return false;
            }
            return true;
        }
    }
}

