// A Bison parser, made by GNU Bison 3.0.4.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// Take the name prefix into account.
#define yylex   tlyylex

// First part of user declarations.

#line 39 "parsetl.cc" // lalr1.cc:404

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

#include "parsetl.hh"

// User implementation prologue.

#line 53 "parsetl.cc" // lalr1.cc:412
// Unqualified %code blocks.
#line 58 "parsetl.yy" // lalr1.cc:413

/* parsetl.hh and parsedecl.hh include each other recursively.
   We mut ensure that YYSTYPE is declared (by the above %union)
   before parsedecl.hh uses it. */
#include <spot/parsetl/parsedecl.hh>
using namespace spot;

#define missing_right_op_msg(op, str)		\
  error_list.emplace_back(op,			\
    "missing right operand for \"" str "\"");

#define missing_right_op(res, op, str)		\
  do						\
    {						\
      missing_right_op_msg(op, str);		\
      res = fnode::ff();		\
    }						\
  while (0);

// right is missing, so complain and use left.
#define missing_right_binop(res, left, op, str)	\
  do						\
    {						\
      missing_right_op_msg(op, str);		\
      res = left;				\
    }						\
  while (0);

// right is missing, so complain and use false.
#define missing_right_binop_hard(res, left, op, str)	\
  do							\
    {							\
      left->destroy();					\
      missing_right_op(res, op, str);			\
    }							\
  while (0);

  static bool
  sere_ensure_bool(const fnode* f, const spot::location& loc,
                   const char* oper, spot::parse_error_list& error_list)
  {
    if (f->is_boolean())
      return true;
    std::string s;
    s.reserve(80);
    s = "not a Boolean expression: in a SERE ";
    s += oper;
    s += " can only be applied to a Boolean expression";
    error_list.emplace_back(loc, s);
    return false;
  }

  static const fnode*
  error_false_block(const spot::location& loc,
                    spot::parse_error_list& error_list)
  {
    error_list.emplace_back(loc, "treating this block as false");
    return fnode::ff();
  }

  static const fnode*
  parse_ap(const std::string& str,
           const spot::location& location,
           spot::environment& env,
           spot::parse_error_list& error_list)
  {
    auto res = env.require(str);
    if (!res)
      {
        std::string s;
        s.reserve(64);
        s = "unknown atomic proposition `";
        s += str;
        s += "' in ";
        s += env.name();
        error_list.emplace_back(location, s);
      }
    return res.to_node_();
  }

  enum parser_type { parser_ltl, parser_bool, parser_sere };

  static const fnode*
  try_recursive_parse(const std::string& str,
		      const spot::location& location,
		      spot::environment& env,
		      bool debug,
		      parser_type type,
		      spot::parse_error_list& error_list)
    {
      // We want to parse a U (b U c) as two until operators applied
      // to the atomic propositions a, b, and c.  We also want to
      // parse a U (b == c) as one until operator applied to the
      // atomic propositions "a" and "b == c".  The only problem is
      // that we do not know anything about "==" or in general about
      // the syntax of atomic proposition of our users.
      //
      // To support that, the lexer will return "b U c" and "b == c"
      // as PAR_BLOCK tokens.  We then try to parse such tokens
      // recursively.  If, as in the case of "b U c", the block is
      // successfully parsed as a formula, we return this formula.
      // Otherwise, we convert the string into an atomic proposition
      // (it's up to the environment to check the syntax of this
      // proposition, and maybe reject it).

      if (str.empty())
	{
	  error_list.emplace_back(location, "unexpected empty block");
	  return nullptr;
	}

      spot::parsed_formula pf;
      switch (type)
	{
	case parser_sere:
	  pf = spot::parse_infix_sere(str, env, debug, true);
	  break;
	case parser_bool:
	  pf = spot::parse_infix_boolean(str, env, debug, true);
	  break;
	case parser_ltl:
	  pf = spot::parse_infix_psl(str, env, debug, true);
	  break;
	}

      if (pf.errors.empty())
	return pf.f.to_node_();
      return parse_ap(str, location, env, error_list);
    }


#line 187 "parsetl.cc" // lalr1.cc:413


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (/*CONSTCOND*/ false)
# endif


// Suppress unused-variable warnings by "using" E.
#define YYUSE(E) ((void) (E))

// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << std::endl;                  \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yystack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE(Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void>(0)
# define YY_STACK_PRINT()                static_cast<void>(0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)


namespace tlyy {
#line 273 "parsetl.cc" // lalr1.cc:479

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              // Fall through.
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }


  /// Build a parser object.
  parser::parser (spot::parse_error_list &error_list_yyarg, spot::environment &parse_environment_yyarg, spot::formula &result_yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      error_list (error_list_yyarg),
      parse_environment (parse_environment_yyarg),
      result (result_yyarg)
  {}

  parser::~parser ()
  {}


  /*---------------.
  | Symbol types.  |
  `---------------*/

  inline
  parser::syntax_error::syntax_error (const location_type& l, const std::string& m)
    : std::runtime_error (m)
    , location (l)
  {}

  // basic_symbol.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol ()
    : value ()
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& other)
    : Base (other)
    , value ()
    , location (other.location)
  {
    value = other.value;
  }


  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const semantic_type& v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}


  /// Constructor for valueless symbols.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const location_type& l)
    : Base (t)
    , value ()
    , location (l)
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::~basic_symbol ()
  {
    clear ();
  }

  template <typename Base>
  inline
  void
  parser::basic_symbol<Base>::clear ()
  {
    Base::clear ();
  }

  template <typename Base>
  inline
  bool
  parser::basic_symbol<Base>::empty () const
  {
    return Base::type_get () == empty_symbol;
  }

  template <typename Base>
  inline
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move(s);
    value = s.value;
    location = s.location;
  }

  // by_type.
  inline
  parser::by_type::by_type ()
    : type (empty_symbol)
  {}

  inline
  parser::by_type::by_type (const by_type& other)
    : type (other.type)
  {}

  inline
  parser::by_type::by_type (token_type t)
    : type (yytranslate_ (t))
  {}

  inline
  void
  parser::by_type::clear ()
  {
    type = empty_symbol;
  }

  inline
  void
  parser::by_type::move (by_type& that)
  {
    type = that.type;
    that.clear ();
  }

  inline
  int
  parser::by_type::type_get () const
  {
    return type;
  }


  // by_state.
  inline
  parser::by_state::by_state ()
    : state (empty_state)
  {}

  inline
  parser::by_state::by_state (const by_state& other)
    : state (other.state)
  {}

  inline
  void
  parser::by_state::clear ()
  {
    state = empty_state;
  }

  inline
  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  inline
  parser::by_state::by_state (state_type s)
    : state (s)
  {}

  inline
  parser::symbol_number_type
  parser::by_state::type_get () const
  {
    if (state == empty_state)
      return empty_symbol;
    else
      return yystos_[state];
  }

  inline
  parser::stack_symbol_type::stack_symbol_type ()
  {}


  inline
  parser::stack_symbol_type::stack_symbol_type (state_type s, symbol_type& that)
    : super_type (s, that.location)
  {
    value = that.value;
    // that is emptied.
    that.type = empty_symbol;
  }

  inline
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    value = that.value;
    location = that.location;
    return *this;
  }


  template <typename Base>
  inline
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);

    // User destructor.
    switch (yysym.type_get ())
    {
            case 9: // "(...) block"

#line 272 "parsetl.yy" // lalr1.cc:614
        { delete (yysym.value.str); }
#line 528 "parsetl.cc" // lalr1.cc:614
        break;

      case 10: // "{...} block"

#line 272 "parsetl.yy" // lalr1.cc:614
        { delete (yysym.value.str); }
#line 535 "parsetl.cc" // lalr1.cc:614
        break;

      case 11: // "{...}! block"

#line 272 "parsetl.yy" // lalr1.cc:614
        { delete (yysym.value.str); }
#line 542 "parsetl.cc" // lalr1.cc:614
        break;

      case 49: // "atomic proposition"

#line 272 "parsetl.yy" // lalr1.cc:614
        { delete (yysym.value.str); }
#line 549 "parsetl.cc" // lalr1.cc:614
        break;

      case 86: // atomprop

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 556 "parsetl.cc" // lalr1.cc:614
        break;

      case 87: // booleanatom

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 563 "parsetl.cc" // lalr1.cc:614
        break;

      case 88: // sere

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 570 "parsetl.cc" // lalr1.cc:614
        break;

      case 89: // bracedsere

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 577 "parsetl.cc" // lalr1.cc:614
        break;

      case 90: // parenthesedsubformula

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 584 "parsetl.cc" // lalr1.cc:614
        break;

      case 91: // boolformula

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 591 "parsetl.cc" // lalr1.cc:614
        break;

      case 92: // subformula

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 598 "parsetl.cc" // lalr1.cc:614
        break;

      case 93: // lbtformula

#line 273 "parsetl.yy" // lalr1.cc:614
        { (yysym.value.ltl)->destroy(); }
#line 605 "parsetl.cc" // lalr1.cc:614
        break;


      default:
        break;
    }
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo,
                                     const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    symbol_number_type yytype = yysym.type_get ();
    // Avoid a (spurious) G++ 4.8 warning about "array subscript is
    // below array bounds".
    if (yysym.empty ())
      std::abort ();
    yyo << (yytype < yyntokens_ ? "token" : "nterm")
        << ' ' << yytname_[yytype] << " ("
        << yysym.location << ": ";
    switch (yytype)
    {
            case 9: // "(...) block"

#line 275 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.str); }
#line 636 "parsetl.cc" // lalr1.cc:636
        break;

      case 10: // "{...} block"

#line 275 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.str); }
#line 643 "parsetl.cc" // lalr1.cc:636
        break;

      case 11: // "{...}! block"

#line 275 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.str); }
#line 650 "parsetl.cc" // lalr1.cc:636
        break;

      case 42: // "number for square bracket operator"

#line 278 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.num); }
#line 657 "parsetl.cc" // lalr1.cc:636
        break;

      case 49: // "atomic proposition"

#line 275 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.str); }
#line 664 "parsetl.cc" // lalr1.cc:636
        break;

      case 80: // sqbracketargs

#line 279 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 671 "parsetl.cc" // lalr1.cc:636
        break;

      case 81: // gotoargs

#line 279 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 678 "parsetl.cc" // lalr1.cc:636
        break;

      case 83: // starargs

#line 279 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 685 "parsetl.cc" // lalr1.cc:636
        break;

      case 84: // fstarargs

#line 279 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 692 "parsetl.cc" // lalr1.cc:636
        break;

      case 85: // equalargs

#line 279 "parsetl.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 699 "parsetl.cc" // lalr1.cc:636
        break;

      case 86: // atomprop

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 706 "parsetl.cc" // lalr1.cc:636
        break;

      case 87: // booleanatom

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 713 "parsetl.cc" // lalr1.cc:636
        break;

      case 88: // sere

#line 277 "parsetl.yy" // lalr1.cc:636
        { print_sere(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 720 "parsetl.cc" // lalr1.cc:636
        break;

      case 89: // bracedsere

#line 277 "parsetl.yy" // lalr1.cc:636
        { print_sere(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 727 "parsetl.cc" // lalr1.cc:636
        break;

      case 90: // parenthesedsubformula

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 734 "parsetl.cc" // lalr1.cc:636
        break;

      case 91: // boolformula

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 741 "parsetl.cc" // lalr1.cc:636
        break;

      case 92: // subformula

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 748 "parsetl.cc" // lalr1.cc:636
        break;

      case 93: // lbtformula

#line 276 "parsetl.yy" // lalr1.cc:636
        { print_psl(debug_stream(), formula((yysym.value.ltl)->clone())); }
#line 755 "parsetl.cc" // lalr1.cc:636
        break;


      default:
        break;
    }
    yyo << ')';
  }
#endif

  inline
  void
  parser::yypush_ (const char* m, state_type s, symbol_type& sym)
  {
    stack_symbol_type t (s, sym);
    yypush_ (m, t);
  }

  inline
  void
  parser::yypush_ (const char* m, stack_symbol_type& s)
  {
    if (m)
      YY_SYMBOL_PRINT (m, s);
    yystack_.push (s);
  }

  inline
  void
  parser::yypop_ (unsigned int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  inline parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - yyntokens_] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - yyntokens_];
  }

  inline bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  inline bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::parse ()
  {
    // State.
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

    // FIXME: This shoud be completely indented.  It is not yet to
    // avoid gratuitous conflicts when merging into the master branch.
    try
      {
    YYCDEBUG << "Starting parse" << std::endl;


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, yyla);

    // A new symbol was pushed on the stack.
  yynewstate:
    YYCDEBUG << "Entering state " << yystack_[0].state << std::endl;

    // Accept?
    if (yystack_[0].state == yyfinal_)
      goto yyacceptlab;

    goto yybackup;

    // Backup.
  yybackup:

    // Try to take a decision without lookahead.
    yyn = yypact_[yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token: ";
        try
          {
            yyla.type = yytranslate_ (yylex (&yyla.value, &yyla.location, error_list));
          }
        catch (const syntax_error& yyexc)
          {
            error (yyexc);
            goto yyerrlab1;
          }
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.type_get ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.type_get ())
      goto yydefault;

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", yyn, yyla);
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_(yystack_[yylen].state, yyr1_[yyn]);
      /* If YYLEN is nonzero, implement the default value of the
         action: '$$ = $1'.  Otherwise, use the top of the stack.

         Otherwise, the following line sets YYLHS.VALUE to garbage.
         This behavior is undocumented and Bison users should not rely
         upon it.  */
      if (yylen)
        yylhs.value = yystack_[yylen - 1].value;
      else
        yylhs.value = yystack_[0].value;

      // Compute the default @$.
      {
        slice<stack_symbol_type, stack_type> slice (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, slice, yylen);
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
      try
        {
          switch (yyn)
            {
  case 2:
#line 283 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 978 "parsetl.cc" // lalr1.cc:859
    break;

  case 3:
#line 288 "parsetl.yy" // lalr1.cc:859
    {
		result = nullptr;
		YYABORT;
	      }
#line 987 "parsetl.cc" // lalr1.cc:859
    break;

  case 4:
#line 293 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 996 "parsetl.cc" // lalr1.cc:859
    break;

  case 5:
#line 298 "parsetl.yy" // lalr1.cc:859
    { YYABORT; }
#line 1002 "parsetl.cc" // lalr1.cc:859
    break;

  case 6:
#line 300 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1011 "parsetl.cc" // lalr1.cc:859
    break;

  case 7:
#line 305 "parsetl.yy" // lalr1.cc:859
    {
		result = nullptr;
		YYABORT;
	      }
#line 1020 "parsetl.cc" // lalr1.cc:859
    break;

  case 8:
#line 310 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1029 "parsetl.cc" // lalr1.cc:859
    break;

  case 9:
#line 315 "parsetl.yy" // lalr1.cc:859
    { YYABORT; }
#line 1035 "parsetl.cc" // lalr1.cc:859
    break;

  case 10:
#line 317 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1044 "parsetl.cc" // lalr1.cc:859
    break;

  case 11:
#line 322 "parsetl.yy" // lalr1.cc:859
    {
		result = nullptr;
		YYABORT;
	      }
#line 1053 "parsetl.cc" // lalr1.cc:859
    break;

  case 12:
#line 327 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1062 "parsetl.cc" // lalr1.cc:859
    break;

  case 13:
#line 332 "parsetl.yy" // lalr1.cc:859
    { YYABORT; }
#line 1068 "parsetl.cc" // lalr1.cc:859
    break;

  case 14:
#line 334 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1077 "parsetl.cc" // lalr1.cc:859
    break;

  case 15:
#line 339 "parsetl.yy" // lalr1.cc:859
    {
		result = nullptr;
		YYABORT;
	      }
#line 1086 "parsetl.cc" // lalr1.cc:859
    break;

  case 16:
#line 344 "parsetl.yy" // lalr1.cc:859
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1095 "parsetl.cc" // lalr1.cc:859
    break;

  case 17:
#line 349 "parsetl.yy" // lalr1.cc:859
    { YYABORT; }
#line 1101 "parsetl.cc" // lalr1.cc:859
    break;

  case 18:
#line 352 "parsetl.yy" // lalr1.cc:859
    {
		error_list.emplace_back(yylhs.location, "empty input");
		result = nullptr;
	      }
#line 1110 "parsetl.cc" // lalr1.cc:859
    break;

  case 19:
#line 358 "parsetl.yy" // lalr1.cc:859
    {
		error_list.emplace_back(yystack_[1].location, "ignoring trailing garbage");
	      }
#line 1118 "parsetl.cc" // lalr1.cc:859
    break;

  case 26:
#line 369 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yystack_[3].value.num); (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1124 "parsetl.cc" // lalr1.cc:859
    break;

  case 27:
#line 371 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yystack_[2].value.num); (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1130 "parsetl.cc" // lalr1.cc:859
    break;

  case 28:
#line 373 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1136 "parsetl.cc" // lalr1.cc:859
    break;

  case 29:
#line 375 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1142 "parsetl.cc" // lalr1.cc:859
    break;

  case 30:
#line 377 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1148 "parsetl.cc" // lalr1.cc:859
    break;

  case 31:
#line 381 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yystack_[3].value.num); (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1154 "parsetl.cc" // lalr1.cc:859
    break;

  case 32:
#line 383 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yystack_[2].value.num); (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1160 "parsetl.cc" // lalr1.cc:859
    break;

  case 33:
#line 385 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1166 "parsetl.cc" // lalr1.cc:859
    break;

  case 34:
#line 387 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1172 "parsetl.cc" // lalr1.cc:859
    break;

  case 35:
#line 389 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = 1U; }
#line 1178 "parsetl.cc" // lalr1.cc:859
    break;

  case 36:
#line 391 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1184 "parsetl.cc" // lalr1.cc:859
    break;

  case 37:
#line 393 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "treating this goto block as [->]");
             (yylhs.value.minmax).min = (yylhs.value.minmax).max = 1U; }
#line 1191 "parsetl.cc" // lalr1.cc:859
    break;

  case 38:
#line 396 "parsetl.yy" // lalr1.cc:859
    { error_list.
	       emplace_back(yylhs.location, "missing closing bracket for goto operator");
	     (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1199 "parsetl.cc" // lalr1.cc:859
    break;

  case 41:
#line 403 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1205 "parsetl.cc" // lalr1.cc:859
    break;

  case 42:
#line 405 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1211 "parsetl.cc" // lalr1.cc:859
    break;

  case 43:
#line 407 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1217 "parsetl.cc" // lalr1.cc:859
    break;

  case 44:
#line 409 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "treating this star block as [*]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1224 "parsetl.cc" // lalr1.cc:859
    break;

  case 45:
#line 412 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "missing closing bracket for star");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1231 "parsetl.cc" // lalr1.cc:859
    break;

  case 46:
#line 416 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1237 "parsetl.cc" // lalr1.cc:859
    break;

  case 47:
#line 418 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1243 "parsetl.cc" // lalr1.cc:859
    break;

  case 48:
#line 420 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1249 "parsetl.cc" // lalr1.cc:859
    break;

  case 49:
#line 422 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back
		(yylhs.location, "treating this fusion-star block as [:*]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1257 "parsetl.cc" // lalr1.cc:859
    break;

  case 50:
#line 426 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back
		(yylhs.location, "missing closing bracket for fusion-star");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1265 "parsetl.cc" // lalr1.cc:859
    break;

  case 51:
#line 431 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1271 "parsetl.cc" // lalr1.cc:859
    break;

  case 52:
#line 433 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "treating this equal block as [=]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1278 "parsetl.cc" // lalr1.cc:859
    break;

  case 53:
#line 436 "parsetl.yy" // lalr1.cc:859
    { error_list.
		emplace_back(yylhs.location, "missing closing bracket for equal operator");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1286 "parsetl.cc" // lalr1.cc:859
    break;

  case 54:
#line 442 "parsetl.yy" // lalr1.cc:859
    {
            (yylhs.value.ltl) = parse_ap(*(yystack_[0].value.str), yystack_[0].location, parse_environment, error_list);
            delete (yystack_[0].value.str);
            if (!(yylhs.value.ltl))
              YYERROR;
          }
#line 1297 "parsetl.cc" // lalr1.cc:859
    break;

  case 57:
#line 452 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[1].value.ltl));
	      }
#line 1305 "parsetl.cc" // lalr1.cc:859
    break;

  case 58:
#line 456 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::tt(); }
#line 1311 "parsetl.cc" // lalr1.cc:859
    break;

  case 59:
#line 458 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::ff(); }
#line 1317 "parsetl.cc" // lalr1.cc:859
    break;

  case 61:
#line 462 "parsetl.yy" // lalr1.cc:859
    {
		if (sere_ensure_bool((yystack_[0].value.ltl), yystack_[0].location, "`!'", error_list))
		  {
		    (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl));
		  }
		else
		  {
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1333 "parsetl.cc" // lalr1.cc:859
    break;

  case 63:
#line 475 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) =
		  try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
				      debug_level(), parser_sere, error_list);
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1346 "parsetl.cc" // lalr1.cc:859
    break;

  case 64:
#line 484 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1352 "parsetl.cc" // lalr1.cc:859
    break;

  case 65:
#line 486 "parsetl.yy" // lalr1.cc:859
    { error_list.
		  emplace_back(yylhs.location,
			       "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1362 "parsetl.cc" // lalr1.cc:859
    break;

  case 66:
#line 492 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location, "missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1370 "parsetl.cc" // lalr1.cc:859
    break;

  case 67:
#line 496 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1380 "parsetl.cc" // lalr1.cc:859
    break;

  case 68:
#line 502 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::AndRat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1386 "parsetl.cc" // lalr1.cc:859
    break;

  case 69:
#line 504 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "length-matching and operator"); }
#line 1393 "parsetl.cc" // lalr1.cc:859
    break;

  case 70:
#line 507 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::AndNLM, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1399 "parsetl.cc" // lalr1.cc:859
    break;

  case 71:
#line 509 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
                                    "non-length-matching and operator"); }
#line 1406 "parsetl.cc" // lalr1.cc:859
    break;

  case 72:
#line 512 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::OrRat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1412 "parsetl.cc" // lalr1.cc:859
    break;

  case 73:
#line 514 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1418 "parsetl.cc" // lalr1.cc:859
    break;

  case 74:
#line 516 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::Concat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1424 "parsetl.cc" // lalr1.cc:859
    break;

  case 75:
#line 518 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "concat operator"); }
#line 1430 "parsetl.cc" // lalr1.cc:859
    break;

  case 76:
#line 520 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::Fusion, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1436 "parsetl.cc" // lalr1.cc:859
    break;

  case 77:
#line 522 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "fusion operator"); }
#line 1442 "parsetl.cc" // lalr1.cc:859
    break;

  case 78:
#line 524 "parsetl.yy" // lalr1.cc:859
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::Star, fnode::tt(), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1455 "parsetl.cc" // lalr1.cc:859
    break;

  case 79:
#line 533 "parsetl.yy" // lalr1.cc:859
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::Star, (yystack_[1].value.ltl), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1468 "parsetl.cc" // lalr1.cc:859
    break;

  case 80:
#line 542 "parsetl.yy" // lalr1.cc:859
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::FStar, (yystack_[1].value.ltl), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1481 "parsetl.cc" // lalr1.cc:859
    break;

  case 81:
#line 551 "parsetl.yy" // lalr1.cc:859
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		if (sere_ensure_bool((yystack_[1].value.ltl), yystack_[1].location, "[=...]", error_list))
		  {
		    (yylhs.value.ltl) = formula::sugar_equal(formula((yystack_[1].value.ltl)),
					      (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max).to_node_();
		  }
		else
		  {
		    (yystack_[1].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1503 "parsetl.cc" // lalr1.cc:859
    break;

  case 82:
#line 569 "parsetl.yy" // lalr1.cc:859
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		if (sere_ensure_bool((yystack_[1].value.ltl), yystack_[1].location, "[->...]", error_list))
		  {
		    (yylhs.value.ltl) = formula::sugar_goto(formula((yystack_[1].value.ltl)),
					     (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max).to_node_();
		  }
		else
		  {
		    (yystack_[1].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1525 "parsetl.cc" // lalr1.cc:859
    break;

  case 83:
#line 587 "parsetl.yy" // lalr1.cc:859
    {
		if (sere_ensure_bool((yystack_[2].value.ltl), yystack_[2].location, "`^'", error_list)
                    && sere_ensure_bool((yystack_[0].value.ltl), yystack_[0].location, "`^'", error_list))
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1543 "parsetl.cc" // lalr1.cc:859
    break;

  case 84:
#line 601 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1549 "parsetl.cc" // lalr1.cc:859
    break;

  case 85:
#line 603 "parsetl.yy" // lalr1.cc:859
    {
		if (sere_ensure_bool((yystack_[2].value.ltl), yystack_[2].location, "`->'", error_list))
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1566 "parsetl.cc" // lalr1.cc:859
    break;

  case 86:
#line 616 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1572 "parsetl.cc" // lalr1.cc:859
    break;

  case 87:
#line 618 "parsetl.yy" // lalr1.cc:859
    {
		if (sere_ensure_bool((yystack_[2].value.ltl), yystack_[2].location, "`<->'", error_list)
                    && sere_ensure_bool((yystack_[0].value.ltl), yystack_[0].location, "`<->'", error_list))
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = error_false_block(yylhs.location, error_list);
		  }
	      }
#line 1590 "parsetl.cc" // lalr1.cc:859
    break;

  case 88:
#line 632 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1596 "parsetl.cc" // lalr1.cc:859
    break;

  case 89:
#line 635 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1602 "parsetl.cc" // lalr1.cc:859
    break;

  case 90:
#line 637 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1610 "parsetl.cc" // lalr1.cc:859
    break;

  case 91:
#line 641 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
					"treating this brace block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1619 "parsetl.cc" // lalr1.cc:859
    break;

  case 92:
#line 646 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location,
					"missing closing brace");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1628 "parsetl.cc" // lalr1.cc:859
    break;

  case 93:
#line 651 "parsetl.yy" // lalr1.cc:859
    { error_list. emplace_back(yystack_[1].location,
                  "ignoring trailing garbage and missing closing brace");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1637 "parsetl.cc" // lalr1.cc:859
    break;

  case 94:
#line 656 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
                    "missing closing brace, "
		    "treating this brace block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1647 "parsetl.cc" // lalr1.cc:859
    break;

  case 95:
#line 662 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(),
                                         parser_sere, error_list);
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1660 "parsetl.cc" // lalr1.cc:859
    break;

  case 96:
#line 672 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(), parser_ltl, error_list);
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1672 "parsetl.cc" // lalr1.cc:859
    break;

  case 97:
#line 680 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1678 "parsetl.cc" // lalr1.cc:859
    break;

  case 98:
#line 682 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1686 "parsetl.cc" // lalr1.cc:859
    break;

  case 99:
#line 686 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
		 "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1695 "parsetl.cc" // lalr1.cc:859
    break;

  case 100:
#line 691 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location, "missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1703 "parsetl.cc" // lalr1.cc:859
    break;

  case 101:
#line 695 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[1].location,
                "ignoring trailing garbage and missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1712 "parsetl.cc" // lalr1.cc:859
    break;

  case 102:
#line 700 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1722 "parsetl.cc" // lalr1.cc:859
    break;

  case 104:
#line 709 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(),
                                         parser_bool, error_list);
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1735 "parsetl.cc" // lalr1.cc:859
    break;

  case 105:
#line 718 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1741 "parsetl.cc" // lalr1.cc:859
    break;

  case 106:
#line 720 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1749 "parsetl.cc" // lalr1.cc:859
    break;

  case 107:
#line 724 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
		 "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1758 "parsetl.cc" // lalr1.cc:859
    break;

  case 108:
#line 729 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location,
					"missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1767 "parsetl.cc" // lalr1.cc:859
    break;

  case 109:
#line 734 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[1].location,
                "ignoring trailing garbage and missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1776 "parsetl.cc" // lalr1.cc:859
    break;

  case 110:
#line 739 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1786 "parsetl.cc" // lalr1.cc:859
    break;

  case 111:
#line 745 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1792 "parsetl.cc" // lalr1.cc:859
    break;

  case 112:
#line 747 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1798 "parsetl.cc" // lalr1.cc:859
    break;

  case 113:
#line 749 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1804 "parsetl.cc" // lalr1.cc:859
    break;

  case 114:
#line 751 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1810 "parsetl.cc" // lalr1.cc:859
    break;

  case 115:
#line 753 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1816 "parsetl.cc" // lalr1.cc:859
    break;

  case 116:
#line 755 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1822 "parsetl.cc" // lalr1.cc:859
    break;

  case 117:
#line 757 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1828 "parsetl.cc" // lalr1.cc:859
    break;

  case 118:
#line 759 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1834 "parsetl.cc" // lalr1.cc:859
    break;

  case 119:
#line 761 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1840 "parsetl.cc" // lalr1.cc:859
    break;

  case 120:
#line 763 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1846 "parsetl.cc" // lalr1.cc:859
    break;

  case 121:
#line 765 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1852 "parsetl.cc" // lalr1.cc:859
    break;

  case 122:
#line 767 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1858 "parsetl.cc" // lalr1.cc:859
    break;

  case 123:
#line 769 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1864 "parsetl.cc" // lalr1.cc:859
    break;

  case 124:
#line 771 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1870 "parsetl.cc" // lalr1.cc:859
    break;

  case 125:
#line 773 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 1876 "parsetl.cc" // lalr1.cc:859
    break;

  case 126:
#line 775 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "not operator"); }
#line 1882 "parsetl.cc" // lalr1.cc:859
    break;

  case 129:
#line 780 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1888 "parsetl.cc" // lalr1.cc:859
    break;

  case 130:
#line 782 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1894 "parsetl.cc" // lalr1.cc:859
    break;

  case 131:
#line 784 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1900 "parsetl.cc" // lalr1.cc:859
    break;

  case 132:
#line 786 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1906 "parsetl.cc" // lalr1.cc:859
    break;

  case 133:
#line 788 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1912 "parsetl.cc" // lalr1.cc:859
    break;

  case 134:
#line 790 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1918 "parsetl.cc" // lalr1.cc:859
    break;

  case 135:
#line 792 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1924 "parsetl.cc" // lalr1.cc:859
    break;

  case 136:
#line 794 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1930 "parsetl.cc" // lalr1.cc:859
    break;

  case 137:
#line 796 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1936 "parsetl.cc" // lalr1.cc:859
    break;

  case 138:
#line 798 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1942 "parsetl.cc" // lalr1.cc:859
    break;

  case 139:
#line 800 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1948 "parsetl.cc" // lalr1.cc:859
    break;

  case 140:
#line 802 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1954 "parsetl.cc" // lalr1.cc:859
    break;

  case 141:
#line 804 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1960 "parsetl.cc" // lalr1.cc:859
    break;

  case 142:
#line 806 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1966 "parsetl.cc" // lalr1.cc:859
    break;

  case 143:
#line 808 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::U, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1972 "parsetl.cc" // lalr1.cc:859
    break;

  case 144:
#line 810 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "until operator"); }
#line 1978 "parsetl.cc" // lalr1.cc:859
    break;

  case 145:
#line 812 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1984 "parsetl.cc" // lalr1.cc:859
    break;

  case 146:
#line 814 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "release operator"); }
#line 1990 "parsetl.cc" // lalr1.cc:859
    break;

  case 147:
#line 816 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::W, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1996 "parsetl.cc" // lalr1.cc:859
    break;

  case 148:
#line 818 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "weak until operator"); }
#line 2002 "parsetl.cc" // lalr1.cc:859
    break;

  case 149:
#line 820 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::M, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2008 "parsetl.cc" // lalr1.cc:859
    break;

  case 150:
#line 822 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "strong release operator"); }
#line 2014 "parsetl.cc" // lalr1.cc:859
    break;

  case 151:
#line 824 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2020 "parsetl.cc" // lalr1.cc:859
    break;

  case 152:
#line 826 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "sometimes operator"); }
#line 2026 "parsetl.cc" // lalr1.cc:859
    break;

  case 153:
#line 828 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::nested_unop_range(op::X, op::Or, (yystack_[2].value.num), (yystack_[2].value.num), (yystack_[0].value.ltl));
                error_list.emplace_back(yystack_[3].location + yystack_[1].location,
                                        "F[n:m] expects two parameters");
              }
#line 2035 "parsetl.cc" // lalr1.cc:859
    break;

  case 154:
#line 834 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::nested_unop_range(op::X, op::Or, (yystack_[4].value.num), (yystack_[2].value.num), (yystack_[0].value.ltl)); }
#line 2041 "parsetl.cc" // lalr1.cc:859
    break;

  case 155:
#line 837 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[5].location + yystack_[1].location, "F[.] operator"); }
#line 2047 "parsetl.cc" // lalr1.cc:859
    break;

  case 156:
#line 839 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "missing closing bracket for F[.]");
                (yylhs.value.ltl) = fnode::ff(); }
#line 2054 "parsetl.cc" // lalr1.cc:859
    break;

  case 157:
#line 842 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[3].location + yystack_[1].location,
                                        "treating this F[.] as a simple F");
                (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2062 "parsetl.cc" // lalr1.cc:859
    break;

  case 158:
#line 846 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::G, (yystack_[0].value.ltl)); }
#line 2068 "parsetl.cc" // lalr1.cc:859
    break;

  case 159:
#line 848 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "always operator"); }
#line 2074 "parsetl.cc" // lalr1.cc:859
    break;

  case 160:
#line 851 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::nested_unop_range(op::X, op::And, (yystack_[4].value.num), (yystack_[2].value.num), (yystack_[0].value.ltl)); }
#line 2080 "parsetl.cc" // lalr1.cc:859
    break;

  case 161:
#line 853 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::nested_unop_range(op::X, op::And, (yystack_[2].value.num), (yystack_[2].value.num), (yystack_[0].value.ltl));
                error_list.emplace_back(yystack_[3].location + yystack_[1].location,
                                        "G[n:m] expects two parameters");
              }
#line 2089 "parsetl.cc" // lalr1.cc:859
    break;

  case 162:
#line 859 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[5].location + yystack_[1].location, "G[.] operator"); }
#line 2095 "parsetl.cc" // lalr1.cc:859
    break;

  case 163:
#line 861 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "missing closing bracket for G[.]");
                (yylhs.value.ltl) = fnode::ff(); }
#line 2102 "parsetl.cc" // lalr1.cc:859
    break;

  case 164:
#line 864 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yystack_[3].location + yystack_[1].location,
                                        "treating this G[.] as a simple G");
                (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2110 "parsetl.cc" // lalr1.cc:859
    break;

  case 165:
#line 868 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::X, (yystack_[0].value.ltl)); }
#line 2116 "parsetl.cc" // lalr1.cc:859
    break;

  case 166:
#line 870 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "next operator"); }
#line 2122 "parsetl.cc" // lalr1.cc:859
    break;

  case 167:
#line 872 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::nested_unop_range(op::X, op::Or, (yystack_[2].value.num), (yystack_[2].value.num), (yystack_[0].value.ltl)); }
#line 2128 "parsetl.cc" // lalr1.cc:859
    break;

  case 168:
#line 874 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[3].location + yystack_[1].location, "X[.] operator"); }
#line 2134 "parsetl.cc" // lalr1.cc:859
    break;

  case 169:
#line 876 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "treating this X[.] as a simple X");
                (yylhs.value.ltl) = fnode::unop(op::X, (yystack_[0].value.ltl)); }
#line 2141 "parsetl.cc" // lalr1.cc:859
    break;

  case 170:
#line 879 "parsetl.yy" // lalr1.cc:859
    { error_list.emplace_back(yylhs.location, "missing closing bracket for X[.]");
                (yylhs.value.ltl) = fnode::ff(); }
#line 2148 "parsetl.cc" // lalr1.cc:859
    break;

  case 171:
#line 882 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 2154 "parsetl.cc" // lalr1.cc:859
    break;

  case 172:
#line 884 "parsetl.yy" // lalr1.cc:859
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "not operator"); }
#line 2160 "parsetl.cc" // lalr1.cc:859
    break;

  case 173:
#line 886 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::Closure, (yystack_[0].value.ltl)); }
#line 2166 "parsetl.cc" // lalr1.cc:859
    break;

  case 174:
#line 888 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::UConcat, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2172 "parsetl.cc" // lalr1.cc:859
    break;

  case 175:
#line 890 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::UConcat, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2178 "parsetl.cc" // lalr1.cc:859
    break;

  case 176:
#line 892 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "universal overlapping concat operator"); }
#line 2185 "parsetl.cc" // lalr1.cc:859
    break;

  case 177:
#line 895 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::EConcat, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2191 "parsetl.cc" // lalr1.cc:859
    break;

  case 178:
#line 897 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "existential overlapping concat operator");
	      }
#line 2199 "parsetl.cc" // lalr1.cc:859
    break;

  case 179:
#line 902 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::UConcat,
				  fnode::multop(op::Concat, {(yystack_[2].value.ltl), fnode::tt()}),
				  (yystack_[0].value.ltl)); }
#line 2207 "parsetl.cc" // lalr1.cc:859
    break;

  case 180:
#line 906 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				  "universal non-overlapping concat operator");
	      }
#line 2215 "parsetl.cc" // lalr1.cc:859
    break;

  case 181:
#line 911 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::EConcat,
				  fnode::multop(op::Concat, {(yystack_[2].value.ltl), fnode::tt()}),
				  (yystack_[0].value.ltl)); }
#line 2223 "parsetl.cc" // lalr1.cc:859
    break;

  case 182:
#line 915 "parsetl.yy" // lalr1.cc:859
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				"existential non-overlapping concat operator");
	      }
#line 2231 "parsetl.cc" // lalr1.cc:859
    break;

  case 183:
#line 920 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::EConcat, (yystack_[1].value.ltl), fnode::tt()); }
#line 2237 "parsetl.cc" // lalr1.cc:859
    break;

  case 184:
#line 922 "parsetl.yy" // lalr1.cc:859
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(),
                                         parser_sere, error_list);
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
		(yylhs.value.ltl) = fnode::binop(op::EConcat, (yylhs.value.ltl), fnode::tt());
	      }
#line 2251 "parsetl.cc" // lalr1.cc:859
    break;

  case 186:
#line 934 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 2257 "parsetl.cc" // lalr1.cc:859
    break;

  case 187:
#line 936 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[1].value.ltl), (yystack_[0].value.ltl)}); }
#line 2263 "parsetl.cc" // lalr1.cc:859
    break;

  case 188:
#line 938 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[1].value.ltl), (yystack_[0].value.ltl)}); }
#line 2269 "parsetl.cc" // lalr1.cc:859
    break;

  case 189:
#line 940 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2275 "parsetl.cc" // lalr1.cc:859
    break;

  case 190:
#line 942 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2281 "parsetl.cc" // lalr1.cc:859
    break;

  case 191:
#line 944 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2287 "parsetl.cc" // lalr1.cc:859
    break;

  case 192:
#line 946 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::X, (yystack_[0].value.ltl)); }
#line 2293 "parsetl.cc" // lalr1.cc:859
    break;

  case 193:
#line 948 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2299 "parsetl.cc" // lalr1.cc:859
    break;

  case 194:
#line 950 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::unop(op::G, (yystack_[0].value.ltl)); }
#line 2305 "parsetl.cc" // lalr1.cc:859
    break;

  case 195:
#line 952 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::U, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2311 "parsetl.cc" // lalr1.cc:859
    break;

  case 196:
#line 954 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2317 "parsetl.cc" // lalr1.cc:859
    break;

  case 197:
#line 956 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2323 "parsetl.cc" // lalr1.cc:859
    break;

  case 198:
#line 958 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::W, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2329 "parsetl.cc" // lalr1.cc:859
    break;

  case 199:
#line 960 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::binop(op::M, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2335 "parsetl.cc" // lalr1.cc:859
    break;

  case 200:
#line 962 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::tt(); }
#line 2341 "parsetl.cc" // lalr1.cc:859
    break;

  case 201:
#line 964 "parsetl.yy" // lalr1.cc:859
    { (yylhs.value.ltl) = fnode::ff(); }
#line 2347 "parsetl.cc" // lalr1.cc:859
    break;


#line 2351 "parsetl.cc" // lalr1.cc:859
            default:
              break;
            }
        }
      catch (const syntax_error& yyexc)
        {
          error (yyexc);
          YYERROR;
        }
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;
      YY_STACK_PRINT ();

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, yylhs);
    }
    goto yynewstate;

  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        error (yyla.location, yysyntax_error_ (yystack_[0].state, yyla));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.type_get () == yyeof_)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;
    yyerror_range[1].location = yystack_[yylen - 1].location;
    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    {
      stack_symbol_type error_token;
      for (;;)
        {
          yyn = yypact_[yystack_[0].state];
          if (!yy_pact_value_is_default_ (yyn))
            {
              yyn += yyterror_;
              if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
                {
                  yyn = yytable_[yyn];
                  if (0 < yyn)
                    break;
                }
            }

          // Pop the current state because it cannot handle the error token.
          if (yystack_.size () == 1)
            YYABORT;

          yyerror_range[1].location = yystack_[0].location;
          yy_destroy_ ("Error: popping", yystack_[0]);
          yypop_ ();
          YY_STACK_PRINT ();
        }

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = yyn;
      yypush_ ("Shifting", error_token);
    }
    goto yynewstate;

    // Accept.
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    // Abort.
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack"
                 << std::endl;
        // Do not try to display the values of the reclaimed symbols,
        // as their printer might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what());
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (state_type yystate, const symbol_type& yyla) const
  {
    // Number of reported tokens (one for the "unexpected", one per
    // "expected").
    size_t yycount = 0;
    // Its maximum.
    enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
    // Arguments of yyformat.
    char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];

    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state
         merging (from LALR or IELR) and default reductions corrupt the
         expected token list.  However, the list is correct for
         canonical LR with one exception: it will still contain any
         token that will not be accepted due to an error action in a
         later state.
    */
    if (!yyla.empty ())
      {
        int yytoken = yyla.type_get ();
        yyarg[yycount++] = yytname_[yytoken];
        int yyn = yypact_[yystate];
        if (!yy_pact_value_is_default_ (yyn))
          {
            /* Start YYX at -YYN if negative to avoid negative indexes in
               YYCHECK.  In other words, skip the first -YYN actions for
               this state because they are default actions.  */
            int yyxbegin = yyn < 0 ? -yyn : 0;
            // Stay within bounds of both yycheck and yytname.
            int yychecklim = yylast_ - yyn + 1;
            int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
            for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
              if (yycheck_[yyx + yyn] == yyx && yyx != yyterror_
                  && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
                {
                  if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                    {
                      yycount = 1;
                      break;
                    }
                  else
                    yyarg[yycount++] = yytname_[yyx];
                }
          }
      }

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
        YYCASE_(0, YY_("syntax error"));
        YYCASE_(1, YY_("syntax error, unexpected %s"));
        YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    size_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += yytnamerr_ (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short int parser::yypact_ninf_ = -133;

  const signed char parser::yytable_ninf_ = -25;

  const short int
  parser::yypact_[] =
  {
      53,   420,   204,   451,   520,    19,   -20,   530,  -133,  -133,
    -133,  1155,   577,   584,   631,   638,    11,    78,   109,  -133,
    -133,  -133,  -133,  -133,  -133,   -18,  -133,   240,  -133,     8,
    1559,  1559,  1559,  1559,  1559,  1559,  1559,  1559,  1559,  1559,
    1559,  1559,  1559,  1559,  -133,  -133,  -133,  -133,  -133,    35,
    1184,  -133,  1155,  1518,  -133,  -133,  -133,    34,  -133,  -133,
    -133,  -133,  -133,   374,  -133,  1177,  -133,  1233,  -133,  -133,
    -133,   106,  -133,  -133,     6,   474,    32,   323,  -133,  -133,
    -133,  -133,  -133,  -133,  -133,  -133,     5,     7,    -4,    27,
      -2,    20,    88,     3,    77,  -133,  -133,   685,   692,   739,
     746,  -133,   793,   800,   847,   854,   901,   908,   955,   962,
    1009,  1016,  1063,  -133,  -133,  -133,  1559,  1559,  1559,  1559,
    1559,  -133,  -133,  -133,  1559,  1559,  1559,  1559,  1559,  -133,
    -133,    65,  1458,   332,  -133,    92,    40,   172,  -133,   108,
     103,  -133,  1213,  1242,  1271,  1300,  1329,  1358,  -133,  -133,
      86,    93,   117,  1387,  1416,  -133,  -133,  -133,  -133,  -133,
    -133,   140,   500,  -133,  -133,  1262,  1291,  1320,  1349,  1378,
    1407,  1436,  -133,  -133,  -133,  -133,   142,  -133,  -133,  -133,
    -133,   126,  -133,  -133,  -133,  1492,  1070,  -133,  1492,  1492,
     148,  -133,  1492,  1492,   150,  -133,  -133,  1516,  -133,  1516,
    -133,  1516,  -133,  1516,  -133,  1616,  -133,   599,  -133,   259,
    -133,   259,  -133,  1516,  -133,  1516,  -133,   233,  -133,   233,
    -133,   233,  -133,   233,  -133,   233,  -133,  -133,  -133,  -133,
    -133,  -133,  -133,  -133,  -133,  -133,  -133,  -133,  -133,  -133,
    -133,  -133,   208,   165,   171,  -133,  -133,  -133,  -133,   261,
    -133,   363,  -133,   639,  -133,   639,  -133,  1567,  -133,  1567,
     207,   198,  -133,   243,   238,  -133,   268,  -133,   163,   217,
     274,   262,  -133,  1541,  -133,  1567,  -133,  -133,   154,  -133,
    -133,  -133,   401,  -133,    37,  -133,   293,  -133,   293,  -133,
     421,  -133,   421,  -133,  -133,  -133,  -133,  -133,  -133,  -133,
    -133,  -133,  -133,  -133,   285,  -133,  -133,   291,   294,  -133,
    -133,  -133,  -133,  -133,  -133,  -133,  -133,   247,   303,   305,
    -133,  -133,  -133,  -133,  1117,  1124,  -133,   312,  -133,  -133,
    -133,  -133,  -133,  -133,  -133
  };

  const unsigned char
  parser::yydefact_[] =
  {
       0,     0,     0,     0,     0,     0,     0,     0,    96,    95,
     184,     0,     0,     0,     0,     0,     0,     0,     0,    54,
      58,    59,    18,     5,     3,    55,   127,   173,   128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,   201,    17,    15,   185,     0,
       0,    63,     0,     0,    39,    40,    42,     0,    13,    11,
      41,    78,    60,     0,    62,     0,   104,     0,     9,     7,
     103,     0,     1,    19,     0,     0,     0,     0,   152,   151,
     159,   158,   166,   165,   172,   171,    25,     0,     0,    25,
       0,     0,    25,     0,     0,    57,    56,     0,     0,     0,
       0,   175,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     2,     4,   186,     0,     0,     0,     0,
       0,   192,   193,   194,     0,     0,     0,     0,     0,    14,
      16,     0,     0,     0,    61,    25,     0,    20,    23,     0,
       0,    43,     0,     0,     0,     0,     0,     0,    46,    47,
       0,     0,     0,     0,     0,    10,    12,    82,    79,    80,
      81,     0,     0,   126,   125,     0,     0,     0,     0,     0,
       0,     0,     6,     8,    99,   102,     0,    97,   100,    91,
      94,     0,    89,   183,    92,     0,     0,   170,     0,     0,
       0,   156,     0,     0,     0,   163,   176,   174,   178,   177,
     180,   179,   182,   181,   136,   135,   138,   137,   130,   129,
     132,   131,   140,   139,   142,   141,   144,   143,   146,   145,
     148,   147,   150,   149,   134,   133,   187,   188,   189,   190,
     191,   195,   196,   197,   198,   199,    65,    67,    64,    66,
      44,    30,    20,     0,     0,    21,    29,    45,    73,    72,
      84,    83,    69,    68,    71,    70,    86,    85,    88,    87,
      25,     0,    48,    25,     0,    51,    25,    35,     0,    20,
       0,     0,    75,    74,    77,    76,   107,   110,     0,   105,
     108,   118,   117,   120,   119,   112,   111,   114,   113,   122,
     121,   124,   123,   116,   115,    98,   101,    90,    93,   169,
     168,   167,   157,   153,     0,   164,   161,     0,     0,    27,
      28,    49,    50,    52,    53,    37,    36,    20,     0,     0,
      34,    38,   106,   109,     0,     0,    26,     0,    32,    33,
     155,   154,   162,   160,    31
  };

  const short int
  parser::yypgoto_[] =
  {
    -133,  -133,   228,    14,  -132,  -133,     4,   157,  -133,  -133,
     -62,  -133,  -133,   186,    -1,    56,    30,   307,   -54,    -7,
     203
  };

  const short int
  parser::yydefgoto_[] =
  {
      -1,     5,    23,    24,   138,   139,    88,   141,   157,    60,
      61,   159,   160,    25,    26,    63,    27,    28,    71,    29,
      49
  };

  const short int
  parser::yytable_[] =
  {
      75,   158,    62,    70,   243,    79,    81,    83,    85,     6,
      62,   162,    86,   164,   174,   158,    47,    59,    69,    72,
     270,    91,    94,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,    64,    73,   135,     6,    95,    96,   189,
     112,    64,   190,   114,   193,   179,   185,   194,   186,    62,
     187,    62,    62,    87,   167,   168,     1,     2,     3,     4,
     175,   140,   113,   130,    70,   -24,    70,    77,   188,   171,
     158,   158,   158,   236,   191,   -22,   136,   156,   137,    89,
      64,   241,    64,    64,   242,   173,   180,   260,   -24,   129,
     197,   199,   201,   203,   263,   205,   207,   209,   211,   213,
     215,   217,   219,   221,   223,   225,   132,     6,   133,   134,
      92,   282,   284,   286,   288,   290,   292,   294,   266,   237,
      90,   165,   166,   167,   168,   169,   170,   -22,   136,   192,
     137,   195,   -24,   240,   -22,   136,   318,   137,   171,   297,
     -24,    62,    62,    62,    62,    62,    62,   -24,   276,   246,
     295,    93,    62,    62,   261,   264,   271,   247,   267,   268,
     172,   269,   322,   -24,    70,    70,    70,    70,    70,    70,
      70,   -24,    64,    64,    64,    64,    64,    64,   299,   301,
     298,   302,   303,    64,    64,   305,   306,   158,    48,   158,
     304,   158,   307,   158,   277,   158,   296,   158,   249,   251,
     253,   255,   257,   259,   316,     6,   309,   317,   323,   273,
     275,   158,   310,   158,   244,   245,    48,    48,    48,    48,
      48,    48,    48,    48,    48,    48,    48,    48,    48,    48,
      46,    58,    68,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,     7,   311,     8,
     308,   245,   312,    19,   108,   109,   110,   111,    22,   319,
     245,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,   143,   144,   145,
     108,   109,   110,   111,   313,    97,    98,    99,   100,   327,
     245,   112,   314,    54,    55,   148,    56,   149,    57,   150,
     151,   152,    48,    48,    48,    48,    48,   262,   265,   315,
      48,    48,    48,    48,    48,   320,   321,   331,   333,   226,
     227,   228,   229,   230,   181,   171,   324,   231,   232,   233,
     234,   235,   325,   181,   101,   326,   182,   183,   142,   143,
     144,   145,   146,   147,   328,   182,   329,   142,   143,   144,
     145,   146,   147,   334,     0,    54,    55,   148,    56,   149,
      57,   150,   151,   152,    54,    55,   148,    56,   149,    57,
     150,   151,   152,   153,   154,     6,     0,   184,     0,     0,
     144,   145,   153,   154,     0,     0,   184,     0,     0,   142,
     143,   144,   145,   146,   147,    54,    55,   148,    56,   149,
      57,   150,   151,   152,     0,     0,    54,    55,   148,    56,
     149,    57,   150,   151,   152,     0,     0,   166,   167,   168,
       0,     6,     0,     0,   153,   154,     0,     7,   155,     8,
       9,    10,    11,   171,     0,     0,   165,   166,   167,   168,
     169,   170,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,     6,   171,     0,     0,     0,     0,    50,     0,
      51,     9,     0,    52,     0,     0,     0,     0,     0,    19,
       0,     0,    20,    21,    22,   176,     0,     0,     0,    53,
       0,     0,   177,    54,    55,     0,    56,     0,    57,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,     0,
      19,   278,     0,    20,    21,    22,   112,     0,   279,     0,
       0,     0,     0,     0,     0,   165,   166,   167,   168,   169,
     170,     6,     0,     0,     0,     0,     0,    65,   178,    66,
       0,    74,   171,     0,     0,     0,     0,     7,     0,     8,
       9,    10,    11,     0,     0,     0,     0,     0,    67,     0,
       0,     0,     0,     0,   280,    12,    13,    14,    15,    16,
      17,    18,     0,     0,     0,     0,     0,     0,     0,    19,
       0,     0,    20,    21,    22,     0,     0,     0,    78,    19,
       0,     0,    20,    21,     7,    80,     8,     9,    10,    11,
       0,     7,     0,     8,     9,    10,    11,     0,     0,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    12,
      13,    14,    15,    16,    17,    18,   104,   105,     0,     0,
     108,   109,   110,   111,     0,     0,    19,     0,     0,    20,
      21,   112,    82,    19,     0,     0,    20,    21,     7,    84,
       8,     9,    10,    11,     0,     7,     0,     8,     9,    10,
      11,     0,     0,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    12,    13,    14,    15,    16,    17,    18,
       0,    54,    55,   148,    56,   149,    57,   150,   151,   152,
      19,     0,     0,    20,    21,     0,   196,    19,     0,     0,
      20,    21,     7,   198,     8,     9,    10,    11,     0,     7,
       0,     8,     9,    10,    11,     0,     0,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,    20,    21,     0,
     200,    19,     0,     0,    20,    21,     7,   202,     8,     9,
      10,    11,     0,     7,     0,     8,     9,    10,    11,     0,
       0,     0,     0,     0,    12,    13,    14,    15,    16,    17,
      18,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,    20,    21,     0,   204,    19,     0,     0,    20,    21,
       7,   206,     8,     9,    10,    11,     0,     7,     0,     8,
       9,    10,    11,     0,     0,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    12,    13,    14,    15,    16,
      17,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    19,     0,     0,    20,    21,     0,   208,    19,
       0,     0,    20,    21,     7,   210,     8,     9,    10,    11,
       0,     7,     0,     8,     9,    10,    11,     0,     0,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    19,     0,     0,    20,
      21,     0,   212,    19,     0,     0,    20,    21,     7,   214,
       8,     9,    10,    11,     0,     7,     0,     8,     9,    10,
      11,     0,     0,     0,     0,     0,    12,    13,    14,    15,
      16,    17,    18,    12,    13,    14,    15,    16,    17,    18,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      19,     0,     0,    20,    21,     0,   216,    19,     0,     0,
      20,    21,     7,   218,     8,     9,    10,    11,     0,     7,
       0,     8,     9,    10,    11,     0,     0,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,    20,    21,     0,
     220,    19,     0,     0,    20,    21,     7,   222,     8,     9,
      10,    11,     0,     7,     0,     8,     9,    10,    11,     0,
       0,     0,     0,     0,    12,    13,    14,    15,    16,    17,
      18,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,    20,    21,     0,   224,    19,     0,     0,    20,    21,
       7,   300,     8,     9,    10,    11,     0,     7,     0,     8,
       9,    10,    11,     0,     0,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    12,    13,    14,    15,    16,
      17,    18,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    19,     0,     0,    20,    21,     0,   330,    19,
       0,     0,    20,    21,     7,   332,     8,     9,    10,    11,
       0,     7,     0,     8,     9,    10,    11,     0,     0,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    12,
      13,    14,    15,    16,    17,    18,    76,     0,     0,     0,
       0,     0,    50,     0,    51,     9,    19,    52,     0,    20,
      21,     0,     0,    19,     0,     0,    20,    21,   161,     0,
       0,     0,     0,    53,    65,   131,    66,    54,    55,     0,
      56,    50,    57,    51,     9,     0,    52,     0,     0,     0,
       0,     0,     0,     0,    19,    67,     0,    20,    21,     0,
       0,     0,    53,     0,   248,     0,    54,    55,     0,    56,
      50,    57,    51,     9,     0,    52,    19,     0,     0,    20,
      21,     0,     0,    19,   163,     0,    20,    21,     0,     0,
      65,    53,    66,   250,     0,    54,    55,     0,    56,    50,
      57,    51,     9,     0,    52,     0,     0,     0,     0,     0,
       0,    67,    19,   281,     0,    20,    21,     0,     0,    65,
      53,    66,   252,     0,    54,    55,     0,    56,    50,    57,
      51,     9,    19,    52,     0,    20,    21,     0,     0,     0,
      67,    19,   283,     0,    20,    21,     0,     0,    65,    53,
      66,   254,     0,    54,    55,     0,    56,    50,    57,    51,
       9,    19,    52,     0,    20,    21,     0,     0,     0,    67,
      19,   285,     0,    20,    21,     0,     0,    65,    53,    66,
     256,     0,    54,    55,     0,    56,    50,    57,    51,     9,
      19,    52,     0,    20,    21,     0,     0,     0,    67,    19,
     287,     0,    20,    21,     0,     0,    65,    53,    66,   258,
       0,    54,    55,     0,    56,    50,    57,    51,     9,    19,
      52,     0,    20,    21,     0,     0,     0,    67,    19,   289,
       0,    20,    21,     0,     0,    65,    53,    66,   272,     0,
      54,    55,     0,    56,    50,    57,    51,     9,    19,    52,
       0,    20,    21,     0,     0,     0,    67,    19,   291,     0,
      20,    21,     0,     0,    65,    53,    66,   274,     0,    54,
      55,     0,    56,    50,    57,    51,     9,    19,    52,     0,
      20,    21,     0,     0,     0,    67,    19,   293,     0,    20,
      21,     0,     0,    65,    53,    66,     0,     0,    54,    55,
       0,    56,     0,    57,     0,     0,    19,     0,     0,    20,
      21,     0,     0,     0,    67,    19,   238,     0,    20,    21,
       0,     0,     0,   142,   143,   144,   145,   146,   147,     0,
       0,     0,     0,     0,     0,    19,     0,     0,    20,    21,
      54,    55,   148,    56,   149,    57,   150,   151,   152,     7,
       0,     8,     9,    10,    11,     0,     0,     0,   153,   154,
       0,     0,   239,     0,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,     0,    50,     0,    51,     9,     0,
      52,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,    19,     0,     0,    20,    21,    53,     0,   112,     0,
      54,    55,     0,    56,     0,    57,   142,   143,   144,   145,
     146,   147,     0,     0,     0,     0,     0,    19,     0,     0,
      20,    21,     0,    54,    55,   148,    56,   149,    57,   150,
     151,   152,   142,   143,   144,   145,   146,   147,     0,     0,
       0,     0,   154,     0,     0,     0,     0,     0,     0,    54,
      55,   148,    56,   149,    57,   150,   151,   152,    19,     0,
       0,     0,     0,     0,     0,     0,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,   103,   104,   105,     0,     0,   108,   109,   110,
     111,     0,     0,     0,     0,     0,     0,     0,   112
  };

  const short int
  parser::yycheck_[] =
  {
       7,    63,     3,     4,   136,    12,    13,    14,    15,     1,
      11,    65,     1,    67,     8,    77,     2,     3,     4,     0,
     152,    17,    18,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,     3,    54,     1,     1,    55,    56,    41,
      32,    11,    44,    29,    41,    13,    41,    44,    41,    50,
      54,    52,    53,    42,    17,    18,     3,     4,     5,     6,
      54,    57,    54,    49,    65,    54,    67,    11,    41,    32,
     132,   133,   134,     8,    54,    41,    42,    63,    44,     1,
      50,    41,    52,    53,    44,    71,    54,     1,    54,    54,
      97,    98,    99,   100,     1,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,    50,     1,    52,    53,
       1,   165,   166,   167,   168,   169,   170,   171,     1,    54,
      42,    15,    16,    17,    18,    19,    20,    41,    42,    41,
      44,    54,    54,    41,    41,    42,   268,    44,    32,    13,
      54,   142,   143,   144,   145,   146,   147,    54,     8,    41,
       8,    42,   153,   154,   150,   151,   152,    54,    41,    42,
      54,    44,     8,    54,   165,   166,   167,   168,   169,   170,
     171,    54,   142,   143,   144,   145,   146,   147,   185,   186,
      54,   188,   189,   153,   154,   192,   193,   249,     2,   251,
      42,   253,    42,   255,    54,   257,    54,   259,   142,   143,
     144,   145,   146,   147,    41,     1,    41,    44,    54,   153,
     154,   273,    41,   275,    42,    43,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
       2,     3,     4,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,     7,    41,     9,
      42,    43,    54,    49,    21,    22,    23,    24,    54,    42,
      43,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    16,    17,    18,
      21,    22,    23,    24,    41,    45,    46,    47,    48,    42,
      43,    32,    54,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   116,   117,   118,   119,   120,   150,   151,    41,
     124,   125,   126,   127,   128,    41,    54,   324,   325,   116,
     117,   118,   119,   120,     1,    32,    41,   124,   125,   126,
     127,   128,    41,     1,    27,    41,    13,    14,    15,    16,
      17,    18,    19,    20,    41,    13,    41,    15,    16,    17,
      18,    19,    20,    41,    -1,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    50,    51,     1,    -1,    54,    -1,    -1,
      17,    18,    50,    51,    -1,    -1,    54,    -1,    -1,    15,
      16,    17,    18,    19,    20,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    -1,    -1,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    -1,    -1,    16,    17,    18,
      -1,     1,    -1,    -1,    50,    51,    -1,     7,    54,     9,
      10,    11,    12,    32,    -1,    -1,    15,    16,    17,    18,
      19,    20,    -1,    -1,    -1,    25,    26,    27,    28,    29,
      30,    31,     1,    32,    -1,    -1,    -1,    -1,     7,    -1,
       9,    10,    -1,    12,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    -1,    52,    53,    54,     1,    -1,    -1,    -1,    28,
      -1,    -1,     8,    32,    33,    -1,    35,    -1,    37,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    -1,
      49,     1,    -1,    52,    53,    54,    32,    -1,     8,    -1,
      -1,    -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,
      20,     1,    -1,    -1,    -1,    -1,    -1,     7,    54,     9,
      -1,     1,    32,    -1,    -1,    -1,    -1,     7,    -1,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    54,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    -1,    52,    53,    54,    -1,    -1,    -1,     1,    49,
      -1,    -1,    52,    53,     7,     1,     9,    10,    11,    12,
      -1,     7,    -1,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    25,
      26,    27,    28,    29,    30,    31,    17,    18,    -1,    -1,
      21,    22,    23,    24,    -1,    -1,    49,    -1,    -1,    52,
      53,    32,     1,    49,    -1,    -1,    52,    53,     7,     1,
       9,    10,    11,    12,    -1,     7,    -1,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    25,    26,    27,    28,    29,    30,    31,
      -1,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      49,    -1,    -1,    52,    53,    -1,     1,    49,    -1,    -1,
      52,    53,     7,     1,     9,    10,    11,    12,    -1,     7,
      -1,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    29,    30,    31,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    -1,    52,    53,    -1,
       1,    49,    -1,    -1,    52,    53,     7,     1,     9,    10,
      11,    12,    -1,     7,    -1,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      -1,    52,    53,    -1,     1,    49,    -1,    -1,    52,    53,
       7,     1,     9,    10,    11,    12,    -1,     7,    -1,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    -1,    52,    53,    -1,     1,    49,
      -1,    -1,    52,    53,     7,     1,     9,    10,    11,    12,
      -1,     7,    -1,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    25,
      26,    27,    28,    29,    30,    31,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,    52,
      53,    -1,     1,    49,    -1,    -1,    52,    53,     7,     1,
       9,    10,    11,    12,    -1,     7,    -1,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    25,    26,    27,    28,    29,    30,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    -1,    52,    53,    -1,     1,    49,    -1,    -1,
      52,    53,     7,     1,     9,    10,    11,    12,    -1,     7,
      -1,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    29,    30,    31,    25,    26,    27,
      28,    29,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    -1,    52,    53,    -1,
       1,    49,    -1,    -1,    52,    53,     7,     1,     9,    10,
      11,    12,    -1,     7,    -1,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      -1,    52,    53,    -1,     1,    49,    -1,    -1,    52,    53,
       7,     1,     9,    10,    11,    12,    -1,     7,    -1,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    25,    26,    27,    28,    29,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    -1,    52,    53,    -1,     1,    49,
      -1,    -1,    52,    53,     7,     1,     9,    10,    11,    12,
      -1,     7,    -1,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    25,
      26,    27,    28,    29,    30,    31,     1,    -1,    -1,    -1,
      -1,    -1,     7,    -1,     9,    10,    49,    12,    -1,    52,
      53,    -1,    -1,    49,    -1,    -1,    52,    53,     1,    -1,
      -1,    -1,    -1,    28,     7,     1,     9,    32,    33,    -1,
      35,     7,    37,     9,    10,    -1,    12,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    49,    28,    -1,    52,    53,    -1,
      -1,    -1,    28,    -1,     1,    -1,    32,    33,    -1,    35,
       7,    37,     9,    10,    -1,    12,    49,    -1,    -1,    52,
      53,    -1,    -1,    49,     1,    -1,    52,    53,    -1,    -1,
       7,    28,     9,     1,    -1,    32,    33,    -1,    35,     7,
      37,     9,    10,    -1,    12,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    49,     1,    -1,    52,    53,    -1,    -1,     7,
      28,     9,     1,    -1,    32,    33,    -1,    35,     7,    37,
       9,    10,    49,    12,    -1,    52,    53,    -1,    -1,    -1,
      28,    49,     1,    -1,    52,    53,    -1,    -1,     7,    28,
       9,     1,    -1,    32,    33,    -1,    35,     7,    37,     9,
      10,    49,    12,    -1,    52,    53,    -1,    -1,    -1,    28,
      49,     1,    -1,    52,    53,    -1,    -1,     7,    28,     9,
       1,    -1,    32,    33,    -1,    35,     7,    37,     9,    10,
      49,    12,    -1,    52,    53,    -1,    -1,    -1,    28,    49,
       1,    -1,    52,    53,    -1,    -1,     7,    28,     9,     1,
      -1,    32,    33,    -1,    35,     7,    37,     9,    10,    49,
      12,    -1,    52,    53,    -1,    -1,    -1,    28,    49,     1,
      -1,    52,    53,    -1,    -1,     7,    28,     9,     1,    -1,
      32,    33,    -1,    35,     7,    37,     9,    10,    49,    12,
      -1,    52,    53,    -1,    -1,    -1,    28,    49,     1,    -1,
      52,    53,    -1,    -1,     7,    28,     9,     1,    -1,    32,
      33,    -1,    35,     7,    37,     9,    10,    49,    12,    -1,
      52,    53,    -1,    -1,    -1,    28,    49,     1,    -1,    52,
      53,    -1,    -1,     7,    28,     9,    -1,    -1,    32,    33,
      -1,    35,    -1,    37,    -1,    -1,    49,    -1,    -1,    52,
      53,    -1,    -1,    -1,    28,    49,     8,    -1,    52,    53,
      -1,    -1,    -1,    15,    16,    17,    18,    19,    20,    -1,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,    52,    53,
      32,    33,    34,    35,    36,    37,    38,    39,    40,     7,
      -1,     9,    10,    11,    12,    -1,    -1,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    -1,    -1,    25,    26,    27,
      28,    29,    30,    31,    -1,     7,    -1,     9,    10,    -1,
      12,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    49,    -1,    -1,    52,    53,    28,    -1,    32,    -1,
      32,    33,    -1,    35,    -1,    37,    15,    16,    17,    18,
      19,    20,    -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,
      52,    53,    -1,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    15,    16,    17,    18,    19,    20,    -1,    -1,
      -1,    -1,    51,    -1,    -1,    -1,    -1,    -1,    -1,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    16,    17,    18,    -1,    -1,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     3,     4,     5,     6,    74,     1,     7,     9,    10,
      11,    12,    25,    26,    27,    28,    29,    30,    31,    49,
      52,    53,    54,    75,    76,    86,    87,    89,    90,    92,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    75,    76,    86,    93,
       7,     9,    12,    28,    32,    33,    35,    37,    75,    76,
      82,    83,    87,    88,    89,     7,     9,    28,    75,    76,
      87,    91,     0,    54,     1,    92,     1,    88,     1,    92,
       1,    92,     1,    92,     1,    92,     1,    42,    79,     1,
      42,    79,     1,    42,    79,    55,    56,    45,    46,    47,
      48,    90,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    32,    54,    76,    93,    93,    93,    93,    93,
      93,    93,    93,    93,    93,    93,    93,    93,    93,    54,
      76,     1,    88,    88,    88,     1,    42,    44,    77,    78,
      79,    80,    15,    16,    17,    18,    19,    20,    34,    36,
      38,    39,    40,    50,    51,    54,    76,    81,    83,    84,
      85,     1,    91,     1,    91,    15,    16,    17,    18,    19,
      20,    32,    54,    76,     8,    54,     1,     8,    54,    13,
      54,     1,    13,    14,    54,    41,    41,    54,    41,    41,
      44,    54,    41,    41,    44,    54,     1,    92,     1,    92,
       1,    92,     1,    92,     1,    92,     1,    92,     1,    92,
       1,    92,     1,    92,     1,    92,     1,    92,     1,    92,
       1,    92,     1,    92,     1,    92,    93,    93,    93,    93,
      93,    93,    93,    93,    93,    93,     8,    54,     8,    54,
      41,    41,    44,    77,    42,    43,    41,    54,     1,    88,
       1,    88,     1,    88,     1,    88,     1,    88,     1,    88,
       1,    79,    80,     1,    79,    80,     1,    41,    42,    44,
      77,    79,     1,    88,     1,    88,     8,    54,     1,     8,
      54,     1,    91,     1,    91,     1,    91,     1,    91,     1,
      91,     1,    91,     1,    91,     8,    54,    13,    54,    92,
       1,    92,    92,    92,    42,    92,    92,    42,    42,    41,
      41,    41,    54,    41,    54,    41,    41,    44,    77,    42,
      41,    54,     8,    54,    41,    41,    41,    42,    41,    41,
       1,    92,     1,    92,    41
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    73,    74,    74,    74,    74,    74,    74,    74,    74,
      74,    74,    74,    74,    74,    74,    74,    74,    75,    76,
      77,    77,    78,    78,    79,    79,    80,    80,    80,    80,
      80,    81,    81,    81,    81,    81,    81,    81,    81,    82,
      82,    83,    83,    83,    83,    83,    84,    84,    84,    84,
      84,    85,    85,    85,    86,    87,    87,    87,    87,    87,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    89,
      89,    89,    89,    89,    89,    89,    90,    90,    90,    90,
      90,    90,    90,    91,    91,    91,    91,    91,    91,    91,
      91,    91,    91,    91,    91,    91,    91,    91,    91,    91,
      91,    91,    91,    91,    91,    91,    91,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    93,    93,    93,    93,    93,
      93,    93,    93,    93,    93,    93,    93,    93,    93,    93,
      93,    93
  };

  const unsigned char
  parser::yyr2_[] =
  {
       0,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     3,     2,     3,     2,     3,     2,     1,     2,
       1,     2,     0,     1,     0,     1,     4,     3,     3,     2,
       2,     5,     4,     4,     3,     2,     3,     3,     3,     1,
       1,     1,     1,     2,     3,     3,     1,     1,     2,     3,
       3,     2,     3,     3,     1,     1,     2,     2,     1,     1,
       1,     2,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     2,
       2,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       4,     3,     3,     4,     3,     1,     1,     3,     4,     3,
       3,     4,     3,     1,     1,     3,     4,     3,     3,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     4,     6,     6,     3,     4,     2,     2,
       6,     4,     6,     3,     4,     2,     2,     4,     4,     4,
       3,     2,     2,     1,     3,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     1,     2,     3,     3,     3,
       3,     3,     2,     2,     2,     3,     3,     3,     3,     3,
       1,     1
  };



  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a yyntokens_, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "$end", "error", "$undefined", "\"LTL start marker\"",
  "\"LBT start marker\"", "\"SERE start marker\"",
  "\"BOOLEAN start marker\"", "\"opening parenthesis\"",
  "\"closing parenthesis\"", "\"(...) block\"", "\"{...} block\"",
  "\"{...}! block\"", "\"opening brace\"", "\"closing brace\"",
  "\"closing brace-bang\"", "\"or operator\"", "\"xor operator\"",
  "\"and operator\"", "\"short and operator\"", "\"implication operator\"",
  "\"equivalent operator\"", "\"until operator\"", "\"release operator\"",
  "\"weak until operator\"", "\"strong release operator\"",
  "\"sometimes operator\"", "\"always operator\"", "\"next operator\"",
  "\"not operator\"", "\"X[.] operator\"", "\"F[.] operator\"",
  "\"G[.] operator\"", "\"star operator\"", "\"bracket star operator\"",
  "\"bracket fusion-star operator\"", "\"plus operator\"",
  "\"fusion-plus operator\"", "\"opening bracket for star operator\"",
  "\"opening bracket for fusion-star operator\"",
  "\"opening bracket for equal operator\"",
  "\"opening bracket for goto operator\"", "\"closing bracket\"",
  "\"number for square bracket operator\"", "\"unbounded mark\"",
  "\"separator for square bracket operator\"",
  "\"universal concat operator\"", "\"existential concat operator\"",
  "\"universal non-overlapping concat operator\"",
  "\"existential non-overlapping concat operator\"",
  "\"atomic proposition\"", "\"concat operator\"", "\"fusion operator\"",
  "\"constant true\"", "\"constant false\"", "\"end of formula\"",
  "\"negative suffix\"", "\"positive suffix\"", "'!'", "'&'", "'|'", "'^'",
  "'i'", "'e'", "'X'", "'F'", "'G'", "'U'", "'V'", "'R'", "'W'", "'M'",
  "'t'", "'f'", "$accept", "result", "emptyinput", "enderror",
  "OP_SQBKT_SEP_unbounded", "OP_SQBKT_SEP_opt", "error_opt",
  "sqbracketargs", "gotoargs", "kleen_star", "starargs", "fstarargs",
  "equalargs", "atomprop", "booleanatom", "sere", "bracedsere",
  "parenthesedsubformula", "boolformula", "subformula", "lbtformula", YY_NULLPTR
  };

#if YYDEBUG
  const unsigned short int
  parser::yyrline_[] =
  {
       0,   282,   282,   287,   292,   297,   299,   304,   309,   314,
     316,   321,   326,   331,   333,   338,   343,   348,   351,   357,
     363,   363,   364,   364,   365,   365,   368,   370,   372,   374,
     376,   380,   382,   384,   386,   388,   390,   392,   395,   400,
     400,   402,   404,   406,   408,   411,   415,   417,   419,   421,
     425,   430,   432,   435,   441,   449,   450,   451,   455,   457,
     460,   461,   473,   474,   483,   485,   491,   495,   501,   503,
     506,   508,   511,   513,   515,   517,   519,   521,   523,   532,
     541,   550,   568,   586,   600,   602,   615,   617,   631,   634,
     636,   640,   645,   650,   655,   661,   671,   679,   681,   685,
     690,   694,   699,   707,   708,   717,   719,   723,   728,   733,
     738,   744,   746,   748,   750,   752,   754,   756,   758,   760,
     762,   764,   766,   768,   770,   772,   774,   777,   778,   779,
     781,   783,   785,   787,   789,   791,   793,   795,   797,   799,
     801,   803,   805,   807,   809,   811,   813,   815,   817,   819,
     821,   823,   825,   827,   832,   835,   838,   841,   845,   847,
     849,   852,   857,   860,   863,   867,   869,   871,   873,   875,
     878,   881,   883,   885,   887,   889,   891,   894,   896,   900,
     905,   909,   914,   918,   921,   932,   933,   935,   937,   939,
     941,   943,   945,   947,   949,   951,   953,   955,   957,   959,
     961,   963
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << i->state;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):" << std::endl;
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  // Symbol number corresponding to token number t.
  inline
  parser::token_number_type
  parser::yytranslate_ (int t)
  {
    static
    const token_number_type
    translate_table[] =
    {
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    57,     2,     2,     2,     2,    58,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      64,    65,     2,     2,     2,     2,     2,    70,     2,     2,
       2,     2,    68,     2,     2,    66,    67,    69,    63,     2,
       2,     2,     2,     2,    60,     2,     2,     2,     2,     2,
       2,    62,    72,     2,     2,    61,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    71,     2,     2,     2,
       2,     2,     2,     2,    59,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56
    };
    const unsigned int user_token_number_max_ = 311;
    const token_number_type undef_token_ = 2;

    if (static_cast<int>(t) <= yyeof_)
      return yyeof_;
    else if (static_cast<unsigned int> (t) <= user_token_number_max_)
      return translate_table[t];
    else
      return undef_token_;
  }


} // tlyy
#line 3286 "parsetl.cc" // lalr1.cc:1167
#line 967 "parsetl.yy" // lalr1.cc:1168


void
tlyy::parser::error(const location_type& location, const std::string& message)
{
  error_list.emplace_back(location, message);
}

namespace spot
{
  parsed_formula
  parse_infix_psl(const std::string& ltl_string,
		  environment& env,
		  bool debug, bool lenient)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_LTL,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_infix_boolean(const std::string& ltl_string,
		      environment& env,
		      bool debug, bool lenient)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_BOOL,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_prefix_ltl(const std::string& ltl_string,
		   environment& env,
		   bool debug)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_LBT,
		    false);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_infix_sere(const std::string& sere_string,
		   environment& env,
		   bool debug,
		   bool lenient)
  {
    parsed_formula result(sere_string);
    flex_set_buffer(sere_string,
		    tlyy::parser::token::START_SERE,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  formula
  parse_formula(const std::string& ltl_string, environment& env)
  {
    parsed_formula pf = parse_infix_psl(ltl_string, env);
    std::ostringstream s;
    if (pf.format_errors(s))
      {
	parsed_formula pg = parse_prefix_ltl(ltl_string, env);
	if (pg.errors.empty())
	  return pg.f;
	else
	  throw parse_error(s.str());
      }
    return pf.f;
  }
}

// Local Variables:
// mode: c++
// End:
