// Copyright (C) 2008, 2012 Laboratoire de Recherche et Dveloppement
// de l'Epita (LRDE).
// Copyright (C) 2003, 2004 Laboratoire d'Informatique de Paris
// 6 (LIP6), dpartement Systmes Rpartis Coopratifs (SRC),
// Universit Pierre et Marie Curie.
//
// This file is part of Spot, a model checking library.
//
// Spot is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// Spot is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
// License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SPOT_LTLENV_ENVIRONMENT_HH
# define SPOT_LTLENV_ENVIRONMENT_HH

# include "ltlast/formula.hh"
# include <string>

namespace spot
{
  namespace ltl
  {
    /// \ingroup ltl_essential
    /// \brief An environment that describes atomic propositions.
    class environment
    {
    public:
      /// \brief Obtain the formula associated to \a prop_str
      ///
      /// Usually \a prop_str, is the name of an atomic proposition,
      /// and spot::ltl::require simply returns the associated
      /// spot::ltl::atomic_prop.
      ///
      /// Note this is not a \c const method.  Some environments will
      /// "create" the atomic proposition when requested.
      ///
      /// We return a spot::ltl::formula instead of an
      /// spot::ltl::atomic_prop, because this
      /// will allow nifty tricks (e.g., we could name formulae in an
      /// environment, and let the parser build a larger tree from
      /// these).
      ///
      /// \return 0 iff \a prop_str is not part of the environment,
      ///   or the associated spot::ltl::formula otherwise.
      virtual const formula* require(const std::string& prop_str) = 0;

      /// Get the name of the environment.
      virtual const std::string& name() = 0;

      virtual
      ~environment()
      {
      }
    };

  }
}

#endif // SPOT_LTLENV_ENVIRONMENT_HH
