#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );

use SpidyTest;
use Test::More tests => $SpidyTest::TEST_URL ? 136 : 86; #'no_plan';

SpidyTest::skipping( 136 - 86 ) unless $SpidyTest::TEST_URL;
                        
use Cwd;
my $path = cwd();

SpidyTest::cleanup( files(), dirs() );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/test.xml \
#                                 --filePath t/fixed \
#                                 --inputImagePath ./Spidy/Icons \
#                                 --sizes small

is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/test.xml \\
                             --filePath t/fixed \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes small` ], output(), "creating test \"fixed\" gallery");

SpidyTest::count("$path/t/fixed", 31 );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/fixed/index.html" ) if $SpidyTest::TEST_URL;

SpidyTest::cleanup( files(), dirs() );

is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/test_fixed.xml --sizes small` ], output(), "creating test \"fixed in xml\" gallery");

SpidyTest::count("$path/t/fixed", 31 );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/fixed/index.html" ) if $SpidyTest::TEST_URL;

SpidyTest::cleanup( files(), dirs() );

sub files {
  return [ qw( 
    t/fixed/images/thumb/000000/nothing.gif
    t/fixed/images/thumb/000000/line_000000.gif
    t/fixed/images/thumb/000000/up_one_000000.gif
    t/fixed/images/thumb/000000/up_one_FFFFFF.gif
    t/fixed/images/thumb/000000/line_FFFFFF.gif
    t/fixed/images/small/nothing.gif
    t/fixed/images/small/line_000000.gif
    t/fixed/images/small/up_one_000000.gif
    t/fixed/images/small/up_one_FFFFFF.gif
    t/fixed/images/small/line_FFFFFF.gif
    t/fixed/small_index.html
    t/fixed/index.html
    t/fixed/set1/small_index.html
    t/fixed/set1/index.html
    t/fixed/set1/subset1/small_index.html
    t/fixed/set1/subset1/index.html
    t/fixed/set1/subset1/small_nothing.html
    t/fixed/set1/subset1/small_line_000000.html
    t/fixed/set1/subset2/small_index.html
    t/fixed/set1/subset2/index.html
    t/fixed/set1/subset2/small_up_one_000000.html
    t/fixed/set1/subset2/small_up_one_FFFFFF.html
    t/fixed/set2/small_index.html
    t/fixed/set2/index.html
    t/fixed/set2/small_line_FFFFFF.html
    t/fixed/set2/small_up_one_FFFFFF.html
    t/fixed/icons/line_000000.gif
    t/fixed/icons/line_FFFFFF.gif
    t/fixed/icons/nothing.gif
    t/fixed/icons/up_one_000000.gif
    t/fixed/icons/up_one_FFFFFF.gif
  ) ];
}

sub dirs {
  return [ reverse qw(
    t/fixed
    t/fixed/images
    t/fixed/images/thumb
    t/fixed/images/thumb/000000
    t/fixed/images/small
    t/fixed/set1
    t/fixed/set1/subset1
    t/fixed/set1/subset2
    t/fixed/set2
    t/fixed/icons
  ) ];
}

sub output {
  my $convert = SpidyTest::which('convert');
  return [ split /\n/, <<EOF ];
mkdir t/fixed
mkdir t/fixed/images
mkdir t/fixed/images/thumb
mkdir t/fixed/images/thumb/000000
creating temporary file t/fixed/images/thumb/nothing.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/nothing.gif t/fixed/images/thumb/nothing.gif
$convert -bordercolor #000000 -border 01x01 t/fixed/images/thumb/nothing.gif t/fixed/images/thumb/000000/nothing.gif
deleting temporary file t/fixed/images/thumb/nothing.gif
mkdir t/fixed/images/small
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/nothing.gif t/fixed/images/small/nothing.gif
creating temporary file t/fixed/images/thumb/line_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_000000.gif t/fixed/images/thumb/line_000000.gif
$convert -bordercolor #000000 -border 01x29 t/fixed/images/thumb/line_000000.gif t/fixed/images/thumb/000000/line_000000.gif
deleting temporary file t/fixed/images/thumb/line_000000.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_000000.gif t/fixed/images/small/line_000000.gif
creating temporary file t/fixed/images/thumb/up_one_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_000000.gif t/fixed/images/thumb/up_one_000000.gif
$convert -bordercolor #000000 -border 01x01 t/fixed/images/thumb/up_one_000000.gif t/fixed/images/thumb/000000/up_one_000000.gif
deleting temporary file t/fixed/images/thumb/up_one_000000.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_000000.gif t/fixed/images/small/up_one_000000.gif
creating temporary file t/fixed/images/thumb/up_one_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/fixed/images/thumb/up_one_FFFFFF.gif
$convert -bordercolor #000000 -border 01x01 t/fixed/images/thumb/up_one_FFFFFF.gif t/fixed/images/thumb/000000/up_one_FFFFFF.gif
deleting temporary file t/fixed/images/thumb/up_one_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/fixed/images/small/up_one_FFFFFF.gif
creating temporary file t/fixed/images/thumb/line_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/fixed/images/thumb/line_FFFFFF.gif
$convert -bordercolor #000000 -border 01x29 t/fixed/images/thumb/line_FFFFFF.gif t/fixed/images/thumb/000000/line_FFFFFF.gif
deleting temporary file t/fixed/images/thumb/line_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/fixed/images/small/line_FFFFFF.gif
Creating t/fixed/small_index.html
Loading template $path/Spidy/Templates/group.tmpl
Creating t/fixed/index.html
mkdir t/fixed/set1
Creating t/fixed/set1/small_index.html
Creating t/fixed/set1/index.html
mkdir t/fixed/set1/subset1
Creating t/fixed/set1/subset1/small_index.html
Creating t/fixed/set1/subset1/index.html
Creating t/fixed/set1/subset1/small_nothing.html
Loading template $path/Spidy/Templates/image.tmpl
Creating t/fixed/set1/subset1/small_line_000000.html
mkdir t/fixed/set1/subset2
Creating t/fixed/set1/subset2/small_index.html
Creating t/fixed/set1/subset2/index.html
Creating t/fixed/set1/subset2/small_up_one_000000.html
Creating t/fixed/set1/subset2/small_up_one_FFFFFF.html
mkdir t/fixed/set2
Creating t/fixed/set2/small_index.html
Creating t/fixed/set2/index.html
Creating t/fixed/set2/small_line_FFFFFF.html
Creating t/fixed/set2/small_up_one_FFFFFF.html
mkdir t/fixed/icons
Creating t/fixed/icons/line_000000.gif
Creating t/fixed/icons/line_FFFFFF.gif
Creating t/fixed/icons/nothing.gif
Creating t/fixed/icons/up_one_000000.gif
Creating t/fixed/icons/up_one_FFFFFF.gif
EOF
}
