#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );

use constant MIN => 66;
use constant MAX => 105;
use SpidyTest;

use Test::More tests => $SpidyTest::TEST_URL ? MAX : MIN;

SpidyTest::skipping( MAX - MIN ) unless $SpidyTest::TEST_URL;
                        
use Cwd;
my $path = cwd();

SpidyTest::cleanup( files(), dirs() );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/quick.xml \
#                                 --filePath t/quick \
#                                 --inputImagePath ./Spidy/Icons \
#                                 --outputImagePathType relative \
#                                 --sizes teeny \
#                                 --parentUrl 'http://www.corybennett.org' \
#                                 --defaultSize teeny \
#                                 --bundleDownload \
#                                 --outputImageType jpg \
#                                 --watermark `pwd`/Spidy/Icons/line_FFFFFF.gif \
#                                 --gravity 'south' \
#                                 --inputFilePath t/

is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/quick.xml \\
                             --filePath t/quick \\
                             --inputImagePath ./Spidy/Icons \\
                             --outputImagePathType relative \\
                             --sizes teeny \\
                             --parentUrl 'http://www.corybennett.org' \\
                             --defaultSize teeny \\
                             --bundleDownload \\
                             --outputImageType jpg \\
                             --watermark $path/Spidy/Icons/line_FFFFFF.gif \\
                             --gravity 'south' \\
                             --inputFilePath t/` ], output(), "creating test \"quick\" gallery");

SpidyTest::count("$path/t/quick", 44 );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/quick/index.html" ) if $SpidyTest::TEST_URL;

# find parent url at top page
open( TOP, "$path/t/quick/index.html" ) or warn "Could not open $path/t/quick/index.html: $!";
ok( (grep { m|http://www.corybennett.org| } <TOP>), "testing --parentUrl option" );
close TOP;

# dont find parent url at lower page
open( BOTTOM, "$path/t/quick/set1/teeny_line_000000.html" ) or warn "Could not open $path/t/quick/teeny_line_000000.html: $!";
ok( (!grep { m|http://www.corybennett.org| } <BOTTOM>), "testing --parentUrl option" );

seek BOTTOM, 0, 0;
ok( ( grep { /FOO/ } <BOTTOM> ), "testing <var> tag" );
seek BOTTOM, 0, 0;
ok( ( grep { /BAR/ } <BOTTOM> ), "testing <var> tag" );
seek BOTTOM, 0, 0;
ok( ( grep { /QUICK COMMENT/ } <BOTTOM> ), "testing --inputFilePath and <comment file='...'>" );
close BOTTOM;

is( -s "$path/t/quick/teeny_index.html", -s "$path/t/quick/index.html", "testing --defaultSize option");

SpidyTest::cleanup( files(), dirs() );

sub files {
  return [ qw( 
    t/quick/set1/thumb/000000/line_000000.jpg
    t/quick/set1/thumb/000000/line_FFFFFF.jpg
    t/quick/set2/thumb/000000/nothing.jpg
    t/quick/set2/thumb/000000/up_one_000000.jpg
    t/quick/set3/thumb/000000/up_one_FFFFFF.jpg
    t/quick/set1/teeny/line_000000.jpg
    t/quick/set1/teeny/line_FFFFFF.jpg
    t/quick/set2/teeny/nothing.jpg
    t/quick/set2/teeny/up_one_000000.jpg
    t/quick/set3/teeny/up_one_FFFFFF.jpg
    t/quick/set1/set1.tar.gz
    t/quick/set1/set1.zip
    t/quick/set1/teeny_index.html
    t/quick/set1/index.html
    t/quick/set1/line_000000.tar.gz
    t/quick/set1/line_000000.zip
    t/quick/set1/teeny_line_000000.html
    t/quick/set1/line_FFFFFF.tar.gz
    t/quick/set1/line_FFFFFF.zip
    t/quick/set1/teeny_line_FFFFFF.html
    t/quick/set2/set2.tar.gz
    t/quick/set2/set2.zip
    t/quick/set2/teeny_index.html
    t/quick/set2/index.html
    t/quick/set2/nothing.tar.gz
    t/quick/set2/nothing.zip
    t/quick/set2/teeny_nothing.html
    t/quick/set2/up_one_000000.tar.gz
    t/quick/set2/up_one_000000.zip
    t/quick/set2/teeny_up_one_000000.html
    t/quick/set3/set3.tar.gz
    t/quick/set3/set3.zip
    t/quick/set3/teeny_index.html
    t/quick/set3/index.html
    t/quick/set3/up_one_FFFFFF.tar.gz
    t/quick/set3/up_one_FFFFFF.zip
    t/quick/set3/teeny_up_one_FFFFFF.html
    t/quick/icons/line_000000.gif
    t/quick/icons/line_FFFFFF.gif
    t/quick/icons/nothing.gif
    t/quick/icons/up_one_000000.gif
    t/quick/icons/up_one_FFFFFF.gif
    t/quick/index.html
    t/quick/teeny_index.html
  ) ];
}

sub dirs {
  return [ reverse qw(
    t/quick
    t/quick/set1
    t/quick/set1/thumb
    t/quick/set1/thumb/000000
    t/quick/set1/teeny
    t/quick/set2
    t/quick/set2/thumb
    t/quick/set2/thumb/000000
    t/quick/set2/teeny
    t/quick/set3
    t/quick/set3/thumb
    t/quick/set3/thumb/000000
    t/quick/set3/teeny
    t/quick/icons
  ) ];
}

sub output {
  my $convert = SpidyTest::which('convert');
  my $composite = SpidyTest::which('composite');
  return [ split /\n/, <<EOF ];
mkdir t/quick
mkdir t/quick/set1
mkdir t/quick/set1/thumb
mkdir t/quick/set1/thumb/000000
creating temporary file t/quick/set1/thumb/line_000000.jpg
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_000000.gif t/quick/set1/thumb/line_000000.jpg
$convert -bordercolor #000000 -border 01x29 t/quick/set1/thumb/line_000000.jpg t/quick/set1/thumb/000000/line_000000.jpg
deleting temporary file t/quick/set1/thumb/line_000000.jpg
mkdir t/quick/set1/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/line_000000.gif t/quick/set1/teeny/line_000000.jpg
$composite -gravity south -compose over $path/Spidy/Icons/line_FFFFFF.gif t/quick/set1/teeny/line_000000.jpg t/quick/set1/teeny/line_000000.jpg
creating temporary file t/quick/set1/thumb/line_FFFFFF.jpg
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/quick/set1/thumb/line_FFFFFF.jpg
$convert -bordercolor #000000 -border 01x29 t/quick/set1/thumb/line_FFFFFF.jpg t/quick/set1/thumb/000000/line_FFFFFF.jpg
deleting temporary file t/quick/set1/thumb/line_FFFFFF.jpg
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/quick/set1/teeny/line_FFFFFF.jpg
$composite -gravity south -compose over $path/Spidy/Icons/line_FFFFFF.gif t/quick/set1/teeny/line_FFFFFF.jpg t/quick/set1/teeny/line_FFFFFF.jpg
mkdir t/quick/set2
mkdir t/quick/set2/thumb
mkdir t/quick/set2/thumb/000000
creating temporary file t/quick/set2/thumb/nothing.jpg
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/nothing.gif t/quick/set2/thumb/nothing.jpg
$convert -bordercolor #000000 -border 01x01 t/quick/set2/thumb/nothing.jpg t/quick/set2/thumb/000000/nothing.jpg
deleting temporary file t/quick/set2/thumb/nothing.jpg
mkdir t/quick/set2/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/nothing.gif t/quick/set2/teeny/nothing.jpg
$composite -gravity south -compose over $path/Spidy/Icons/line_FFFFFF.gif t/quick/set2/teeny/nothing.jpg t/quick/set2/teeny/nothing.jpg
creating temporary file t/quick/set2/thumb/up_one_000000.jpg
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_000000.gif t/quick/set2/thumb/up_one_000000.jpg
$convert -bordercolor #000000 -border 01x01 t/quick/set2/thumb/up_one_000000.jpg t/quick/set2/thumb/000000/up_one_000000.jpg
deleting temporary file t/quick/set2/thumb/up_one_000000.jpg
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/up_one_000000.gif t/quick/set2/teeny/up_one_000000.jpg
$composite -gravity south -compose over $path/Spidy/Icons/line_FFFFFF.gif t/quick/set2/teeny/up_one_000000.jpg t/quick/set2/teeny/up_one_000000.jpg
mkdir t/quick/set3
mkdir t/quick/set3/thumb
mkdir t/quick/set3/thumb/000000
creating temporary file t/quick/set3/thumb/up_one_FFFFFF.jpg
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/quick/set3/thumb/up_one_FFFFFF.jpg
$convert -bordercolor #000000 -border 01x01 t/quick/set3/thumb/up_one_FFFFFF.jpg t/quick/set3/thumb/000000/up_one_FFFFFF.jpg
deleting temporary file t/quick/set3/thumb/up_one_FFFFFF.jpg
mkdir t/quick/set3/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/quick/set3/teeny/up_one_FFFFFF.jpg
$composite -gravity south -compose over $path/Spidy/Icons/line_FFFFFF.gif t/quick/set3/teeny/up_one_FFFFFF.jpg t/quick/set3/teeny/up_one_FFFFFF.jpg
Creating t/quick/teeny_index.html
Loading template $path/Spidy/Templates/group.tmpl
Creating t/quick/index.html
Creating t/quick/set1/set1.tar.gz
Creating t/quick/set1/set1.zip
Creating t/quick/set1/teeny_index.html
Creating t/quick/set1/index.html
Creating t/quick/set1/line_000000.tar.gz
Creating t/quick/set1/line_000000.zip
Creating t/quick/set1/teeny_line_000000.html
Loading template $path/Spidy/Templates/image.tmpl
Creating t/quick/set1/line_FFFFFF.tar.gz
Creating t/quick/set1/line_FFFFFF.zip
Creating t/quick/set1/teeny_line_FFFFFF.html
Creating t/quick/set2/set2.tar.gz
Creating t/quick/set2/set2.zip
Creating t/quick/set2/teeny_index.html
Creating t/quick/set2/index.html
Creating t/quick/set2/nothing.tar.gz
Creating t/quick/set2/nothing.zip
Creating t/quick/set2/teeny_nothing.html
Creating t/quick/set2/up_one_000000.tar.gz
Creating t/quick/set2/up_one_000000.zip
Creating t/quick/set2/teeny_up_one_000000.html
Creating t/quick/set3/set3.tar.gz
Creating t/quick/set3/set3.zip
Creating t/quick/set3/teeny_index.html
Creating t/quick/set3/index.html
Creating t/quick/set3/up_one_FFFFFF.tar.gz
Creating t/quick/set3/up_one_FFFFFF.zip
Creating t/quick/set3/teeny_up_one_FFFFFF.html
mkdir t/quick/icons
Creating t/quick/icons/line_000000.gif
Creating t/quick/icons/line_FFFFFF.gif
Creating t/quick/icons/nothing.gif
Creating t/quick/icons/up_one_000000.gif
Creating t/quick/icons/up_one_FFFFFF.gif
EOF
}
