package Spidy::CGI::Group;

use Spidy::Group;
@ISA = qw( Spidy::Group );
use Spidy::GraphicsBuilder;
use CGI;

use strict;

sub autoload_members {
    my $self = shift;
    return {
        %{$self->SUPER::autoload_members()},
        # just for cgi mode
        'script_name'              => 'scalar',
        'cgi'                      => 'scalar',
    };
}

sub new {
  my $self = shift->SUPER::new(@_);
  $self->{'cgi'} = CGI->new();
  return $self;
}

sub set_defaults { 
  my $self = shift;
  my %defaults;
  if( ref($_[0]) ) {
    %defaults = %{$_[0]};
  } else {
    %defaults = @_;
  }
  
  for my $key ( keys %defaults ) {
    $self->{$key} = $defaults{$key}
      unless defined $self->{$key};
  }
  
  #
  # Data here is for html file generation
  # of image generation.  Also html data
  # that is recursive in nature (directory paths)
  # is set here for efficiency's sake.
  # 
  #

  if( my $parent = $self->{'parent'} ) {

    $self->{'top_html_path'} 
      =  $parent->{'top_html_path'}
      unless $self->{'top_html_path'};
  }
  $self->SUPER::set_defaults(%defaults);
  return;
}  

sub set_param_data { 
  my $self = shift;
  my $p = shift;
  my $size = shift;
  my $caller = shift || $self;
  
  if( $p eq 'href' ) {
    my $path = $self->clean_path( "$self->{'html_path'}" );
    return $self->{'cgi'}->script_name()."?size=$size->{'name'}&path=$path";
  }
  if( $p eq 'src' ) {
    my $i = $self->first_image();
    my $thumb = $size->first();
    my $output_image = $i->get_output_image($thumb);
    my $cgi = $self->{'cgi'};
    if( $thumb->{'padded'} ) {
      return "$caller->{'top_image_path'}/$i->{'image_url'}/$thumb->{'name'}/".$caller->set_param_data('bg_color', $size, $caller)."/$output_image";
    } else {
      return "$caller->{'top_image_path'}/$i->{'image_url'}/$thumb->{'name'}/$output_image";
    }
  }
  return $self->SUPER::set_param_data($p, $size, $caller);
}

sub clean_path {
  my $self = shift;
  my $path = shift;
  # remove groups of "stuff/../" from the path
  # so t/gallery/set1/../medium_index.html will turn into
  # t/gallery/medium_index.html
  while( $path =~ /[.][.]\// ) {
    $path =~ s/[^\/]+\/[.][.]\///;
  }
  
  # clean up the "./" in the middle path.  This is needtd
  # to make sure the path names are unique for the cache.
  
  $path =~ s/[.]\///g;
  return $path;
}
1;    

