/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_45 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 9006, "epsg", 9006,
        "IGS00", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGS00\",DATUM[\"IGS00\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1245\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9006\"]]");
    p = add_epsg_def_ex (filter, first, last, 9008, "epsg", 9008,
        "IGb00", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGb00\",DATUM[\"IGb00\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 2,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 3,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 4,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 5,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 7,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 8,
        "[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]],ID[");
    add_srs_wkt (p, 9,
        "\"EPSG\",9008]]");
    p = add_epsg_def_ex (filter, first, last, 9009, "epsg", 9009,
        "IGb00", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGb00\",DATUM[\"IGb00\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1246\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9009\"]]");
    p = add_epsg_def_ex (filter, first, last, 9011, "epsg", 9011,
        "IGS05", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS05", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGS05\",DATUM[\"IGS05\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 2,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 3,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 4,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 5,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 7,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 8,
        "[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]],ID[");
    add_srs_wkt (p, 9,
        "\"EPSG\",9011]]");
    p = add_epsg_def_ex (filter, first, last, 9012, "epsg", 9012,
        "IGS05", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS05", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGS05\",DATUM[\"IGS05\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1247\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9012\"]]");
    p = add_epsg_def_ex (filter, first, last, 9013, "epsg", 9013,
        "IGS08", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS08", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGS08\",DATUM[\"IGS08\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 2,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 3,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 4,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 5,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 7,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 8,
        "[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]],ID[");
    add_srs_wkt (p, 9,
        "\"EPSG\",9013]]");
    p = add_epsg_def_ex (filter, first, last, 9014, "epsg", 9014,
        "IGS08", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS08", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGS08\",DATUM[\"IGS08\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1141\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9014\"]]");
    p = add_epsg_def_ex (filter, first, last, 9016, "epsg", 9016,
        "IGb08", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb08", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGb08\",DATUM[\"IGb08\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 2,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 3,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 4,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 5,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 7,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 8,
        "[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]],ID[");
    add_srs_wkt (p, 9,
        "\"EPSG\",9016]]");
    p = add_epsg_def_ex (filter, first, last, 9017, "epsg", 9017,
        "IGb08", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb08", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGb08\",DATUM[\"IGb08\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1248\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9017\"]]");
    p = add_epsg_def_ex (filter, first, last, 9018, "epsg", 9018,
        "IGS14", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS14", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGS14\",DATUM[\"IGS14\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 2,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 3,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 4,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 5,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 7,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 8,
        "[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]],ID[");
    add_srs_wkt (p, 9,
        "\"EPSG\",9018]]");
    p = add_epsg_def_ex (filter, first, last, 9019, "epsg", 9019,
        "IGS14", 1, 1,
        "GRS 1980", "Greenwich",
        "IGS14", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGS14\",DATUM[\"IGS14\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1191\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9019\"]]");
    p = add_epsg_def_ex (filter, first, last, 9039, "epsg", 9039,
        "ISN2016 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2016", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2016 / LAEA Europe\",GEOGCS[\"ISN2016\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Islands_Net_2016\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1187\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8086\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"lati");
    add_srs_wkt (p, 7,
        "tude_of_center\",52],PARAMETER[\"longitude_of_center\",1");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"false_easting\",4321000],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_northing\",3210000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AUTHORITY[\"EPSG\",\"9039\"]]");
    p = add_epsg_def_ex (filter, first, last, 9040, "epsg", 9040,
        "ISN2016 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2016", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=52 +lon_0=10 +lat_1=35 +lat_2=65 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2016 / LCC Europe\",GEOGCS[\"ISN2016\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Islands_Net_2016\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1187\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8086\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 7,
        "de_of_origin\",52],PARAMETER[\"central_meridian\",10],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"standard_parallel_1\",35],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",65],PARAMETER[\"false_easting\",4000000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",2800000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9040\"]]");
    p = add_epsg_def_ex (filter, first, last, 9053, "epsg", 9053,
        "WGS 84 (G730)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G730", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G730)\",DATUM[\"World_Geodetic_System_1");
    add_srs_wkt (p, 1,
        "984_G730\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1152\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9053\"]]");
    p = add_epsg_def_ex (filter, first, last, 9054, "epsg", 9054,
        "WGS 84 (G873)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G873", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G873)\",DATUM[\"World_Geodetic_System_1");
    add_srs_wkt (p, 1,
        "984_G873\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1153\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9054\"]]");
    p = add_epsg_def_ex (filter, first, last, 9055, "epsg", 9055,
        "WGS 84 (G1150)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1150", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G1150)\",DATUM[\"World_Geodetic_System_");
    add_srs_wkt (p, 1,
        "1984_G1150\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1154\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9055\"]]");
    p = add_epsg_def_ex (filter, first, last, 9056, "epsg", 9056,
        "WGS 84 (G1674)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1674", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G1674)\",DATUM[\"World_Geodetic_System_");
    add_srs_wkt (p, 1,
        "1984_G1674\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1155\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9056\"]]");
    p = add_epsg_def_ex (filter, first, last, 9057, "epsg", 9057,
        "WGS 84 (G1762)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G1762", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G1762)\",DATUM[\"World_Geodetic_System_");
    add_srs_wkt (p, 1,
        "1984_G1762\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1156\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9057\"]]");
    p = add_epsg_def_ex (filter, first, last, 9059, "epsg", 9059,
        "ETRF89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF89\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1989\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"117");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9059\"]]");
    p = add_epsg_def_ex (filter, first, last, 9060, "epsg", 9060,
        "ETRF90", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF90\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1990\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"117");
    add_srs_wkt (p, 3,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9060\"]]");
    p = add_epsg_def_ex (filter, first, last, 9061, "epsg", 9061,
        "ETRF91", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF91\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1991\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9061\"]]");
    p = add_epsg_def_ex (filter, first, last, 9062, "epsg", 9062,
        "ETRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF92\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1992\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9062\"]]");
    p = add_epsg_def_ex (filter, first, last, 9063, "epsg", 9063,
        "ETRF93", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF93\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1993\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "2\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9063\"]]");
    p = add_epsg_def_ex (filter, first, last, 9064, "epsg", 9064,
        "ETRF94", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF94\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1994\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9064\"]]");
    p = add_epsg_def_ex (filter, first, last, 9065, "epsg", 9065,
        "ETRF96", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF96\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1996\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9065\"]]");
    p = add_epsg_def_ex (filter, first, last, 9066, "epsg", 9066,
        "ETRF97", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF97\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_1997\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"118");
    add_srs_wkt (p, 3,
        "5\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9066\"]]");
    p = add_epsg_def_ex (filter, first, last, 9067, "epsg", 9067,
        "ETRF2000", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF2000\",DATUM[\"European_Terrestrial_Referen");
    add_srs_wkt (p, 1,
        "ce_Frame_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 3,
        "186\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"9067\"]]");
    p = add_epsg_def_ex (filter, first, last, 9068, "epsg", 9068,
        "ETRF2005", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF2005\",DATUM[\"European_Terrestrial_Referen");
    add_srs_wkt (p, 1,
        "ce_Frame_2005\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 3,
        "204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"9068\"]]");
    p = add_epsg_def_ex (filter, first, last, 9069, "epsg", 9069,
        "ETRF2014", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF2014\",DATUM[\"European_Terrestrial_Referen");
    add_srs_wkt (p, 1,
        "ce_Frame_2014\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 3,
        "206\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"9069\"]]");
    p = add_epsg_def_ex (filter, first, last, 9071, "epsg", 9071,
        "NAD83(MARP00)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_MARP00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(MARP00)\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (MARP00)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"Pacific - US interests Mariana plate\"],BBOX[1.64,1");
    add_srs_wkt (p, 10,
        "29.48,23.9,149.55]],ID[\"EPSG\",9071]]");
    p = add_epsg_def_ex (filter, first, last, 9072, "epsg", 9072,
        "NAD83(MARP00)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_MARP00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(MARP00)\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_MARP00\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 3,
        "21\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9072\"]]");
    p = add_epsg_def_ex (filter, first, last, 9074, "epsg", 9074,
        "NAD83(PACP00)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_PACP00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(PACP00)\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (PACP00)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"Pacific - US interests Pacific plate\"],BBOX[-17.56");
    add_srs_wkt (p, 10,
        ",157.47,31.8,-151.27]],ID[\"EPSG\",9074]]");
    p = add_epsg_def_ex (filter, first, last, 9075, "epsg", 9075,
        "NAD83(PACP00)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_PACP00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(PACP00)\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_PACP00\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 3,
        "49\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9075\"]]");
    p = add_epsg_def_ex (filter, first, last, 9139, "epsg", 9139,
        "KOSOVAREF01", 1, 1,
        "GRS 1980", "Greenwich",
        "Kosovo_Reference_System_2001", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"KOSOVAREF01\",DATUM[\"Kosovo Reference System ");
    add_srs_wkt (p, 1,
        "2001\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Kosovo\"");
    add_srs_wkt (p, 9,
        "],BBOX[41.85,19.97,43.25,21.8]],ID[\"EPSG\",9139]]");
    p = add_epsg_def_ex (filter, first, last, 9140, "epsg", 9140,
        "KOSOVAREF01", 1, 1,
        "GRS 1980", "Greenwich",
        "Kosovo_Reference_System_2001", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KOSOVAREF01\",DATUM[\"Kosovo_Reference_System_2");
    add_srs_wkt (p, 1,
        "001\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1251\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9140\"]]");
    p = add_epsg_def_ex (filter, first, last, 9141, "epsg", 9141,
        "KOSOVAREF01 / Balkans zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "Kosovo_Reference_System_2001", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KOSOVAREF01 / Balkans zone 7\",GEOGCS[\"KOSOVAR");
    add_srs_wkt (p, 1,
        "EF01\",DATUM[\"Kosovo_Reference_System_2001\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"1251\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9140\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",21],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",7500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9141\"]]");
    p = add_epsg_def_ex (filter, first, last, 9147, "epsg", 9147,
        "SIRGAS-Chile 2013", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_3_epoch_2013_00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-Chile 2013\",DATUM[\"SIRGAS-Chile reali");
    add_srs_wkt (p, 1,
        "zation 3 epoch 2013.00\",ELLIPSOID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 3,
        "ch\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[elli");
    add_srs_wkt (p, 4,
        "psoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[");
    add_srs_wkt (p, 5,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geod");
    add_srs_wkt (p, 6,
        "etic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"Chile\"],BBOX[-59.87,-113.21,-17.5,-65.72]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",9147]]");
    p = add_epsg_def_ex (filter, first, last, 9148, "epsg", 9148,
        "SIRGAS-Chile 2013", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_3_epoch_2013_00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile 2013\",DATUM[\"SIRGAS-Chile_realiz");
    add_srs_wkt (p, 1,
        "ation_3_epoch_2013_00\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1252\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"9148\"]]");
    p = add_epsg_def_ex (filter, first, last, 9149, "epsg", 9149,
        "SIRGAS-Chile 2013 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_3_epoch_2013_00", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2013 / UTM zone 18S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2013\",DATUM[\"SIRGAS-Chile_realization_3_epoc");
    add_srs_wkt (p, 2,
        "h_2013_00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1252\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"9148\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9149\"]]");
    p = add_epsg_def_ex (filter, first, last, 9150, "epsg", 9150,
        "SIRGAS-Chile 2013 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_3_epoch_2013_00", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2013 / UTM zone 19S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2013\",DATUM[\"SIRGAS-Chile_realization_3_epoc");
    add_srs_wkt (p, 2,
        "h_2013_00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1252\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"9148\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9150\"]]");
    p = add_epsg_def_ex (filter, first, last, 9152, "epsg", 9152,
        "SIRGAS-Chile 2016", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_4_epoch_2016_00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-Chile 2016\",DATUM[\"SIRGAS-Chile reali");
    add_srs_wkt (p, 1,
        "zation 4 epoch 2016.00\",ELLIPSOID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 3,
        "ch\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[elli");
    add_srs_wkt (p, 4,
        "psoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[");
    add_srs_wkt (p, 5,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geod");
    add_srs_wkt (p, 6,
        "etic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"Chile\"],BBOX[-59.87,-113.21,-17.5,-65.72]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",9152]]");
    p = add_epsg_def_ex (filter, first, last, 9153, "epsg", 9153,
        "SIRGAS-Chile 2016", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_4_epoch_2016_00", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile 2016\",DATUM[\"SIRGAS-Chile_realiz");
    add_srs_wkt (p, 1,
        "ation_4_epoch_2016_00\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1253\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"9153\"]]");
    p = add_epsg_def_ex (filter, first, last, 9154, "epsg", 9154,
        "SIRGAS-Chile 2016 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_4_epoch_2016_00", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2016 / UTM zone 18S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2016\",DATUM[\"SIRGAS-Chile_realization_4_epoc");
    add_srs_wkt (p, 2,
        "h_2016_00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1253\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"9153\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9154\"]]");
    p = add_epsg_def_ex (filter, first, last, 9155, "epsg", 9155,
        "SIRGAS-Chile 2016 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile_realization_4_epoch_2016_00", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile 2016 / UTM zone 19S\",GEOGCS[\"SIR");
    add_srs_wkt (p, 1,
        "GAS-Chile 2016\",DATUM[\"SIRGAS-Chile_realization_4_epoc");
    add_srs_wkt (p, 2,
        "h_2016_00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1253\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"9153\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9155\"]]");
    p = add_epsg_def_ex (filter, first, last, 9156, "epsg", 9156,
        "RSAO13 / UTM zone 32S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSAO13 / UTM zone 32S\",GEOGCS[\"RSAO13\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reference_System_de_Angola_2013\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1220\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8699\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9156\"]]");
    p = add_epsg_def_ex (filter, first, last, 9157, "epsg", 9157,
        "RSAO13 / UTM zone 33S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSAO13 / UTM zone 33S\",GEOGCS[\"RSAO13\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reference_System_de_Angola_2013\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1220\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8699\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9157\"]]");
    p = add_epsg_def_ex (filter, first, last, 9158, "epsg", 9158,
        "RSAO13 / UTM zone 34S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSAO13 / UTM zone 34S\",GEOGCS[\"RSAO13\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reference_System_de_Angola_2013\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1220\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8699\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9158\"]]");
    p = add_epsg_def_ex (filter, first, last, 9159, "epsg", 9159,
        "RSAO13 / TM 12 SE", 0, 0,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSAO13 / TM 12 SE\",GEOGCS[\"RSAO13\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eference_System_de_Angola_2013\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1220\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8699");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",12],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",500000],PARAMETER[\"false_northing\",10000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9159\"]]");
    p = add_epsg_def_ex (filter, first, last, 9183, "epsg", 9183,
        "SIRGAS-Chile", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS-Chile\",DATUM[\"SIRGAS-Chile\",ELLIPSOI");
    add_srs_wkt (p, 1,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 2,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 3,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 4,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 6,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 7,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 8,
        "],USAGE[SCOPE[\"unknown\"],AREA[\"Chile\"],BBOX[-59.87,-");
    add_srs_wkt (p, 9,
        "113.21,-17.5,-65.72]],ID[\"EPSG\",9183]]");
    p = add_epsg_def_ex (filter, first, last, 9184, "epsg", 9184,
        "SIRGAS-Chile", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS-Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile\",DATUM[\"SIRGAS-Chile\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7019\"]],AUTHORITY[\"EPSG\",\"1254\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9184\"]]");
    p = add_epsg_def_ex (filter, first, last, 9191, "epsg", 9191,
        "WGS 84 / NIWA Albers", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=-40 +lon_0=175 +lat_1=-30 +lat_2=-50 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NIWA Albers\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Albe");
    add_srs_wkt (p, 6,
        "rs_Conic_Equal_Area\"],PARAMETER[\"latitude_of_center\",");
    add_srs_wkt (p, 7,
        "-40],PARAMETER[\"longitude_of_center\",175],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",-30],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",-50],PARAMETER[\"false_easting\",0],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9191\"]]");
    p = add_epsg_def_ex (filter, first, last, 9205, "epsg", 9205,
        "VN-2000 / TM-3 103-00", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=103 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 103-00\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",103],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"9205\"]]");
    p = add_epsg_def_ex (filter, first, last, 9206, "epsg", 9206,
        "VN-2000 / TM-3 104-00", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=104 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 104-00\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",104],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"9206\"]]");
    p = add_epsg_def_ex (filter, first, last, 9207, "epsg", 9207,
        "VN-2000 / TM-3 104-30", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=104.5 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,");
    add_proj4text (p, 2,
        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906");
    add_proj4text (p, 3,
        "278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 104-30\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",104.5],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9207\"]]");
    p = add_epsg_def_ex (filter, first, last, 9208, "epsg", 9208,
        "VN-2000 / TM-3 104-45", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=104.75 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 104-45\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",104.75],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"9208\"]]");
    p = add_epsg_def_ex (filter, first, last, 9209, "epsg", 9209,
        "VN-2000 / TM-3 105-30", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.5 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,");
    add_proj4text (p, 2,
        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906");
    add_proj4text (p, 3,
        "278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 105-30\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",105.5],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9209\"]]");
    p = add_epsg_def_ex (filter, first, last, 9210, "epsg", 9210,
        "VN-2000 / TM-3 105-45", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.75 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 105-45\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",105.75],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"9210\"]]");
    p = add_epsg_def_ex (filter, first, last, 9211, "epsg", 9211,
        "VN-2000 / TM-3 106-00", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 106-00\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",106],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"9211\"]]");
    p = add_epsg_def_ex (filter, first, last, 9212, "epsg", 9212,
        "VN-2000 / TM-3 106-15", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.25 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 106-15\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",106.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"9212\"]]");
    p = add_epsg_def_ex (filter, first, last, 9213, "epsg", 9213,
        "VN-2000 / TM-3 106-30", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,");
    add_proj4text (p, 2,
        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906");
    add_proj4text (p, 3,
        "278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 106-30\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",106.5],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9213\"]]");
    p = add_epsg_def_ex (filter, first, last, 9214, "epsg", 9214,
        "VN-2000 / TM-3 107-00", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 107-00\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",107],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"9214\"]]");
    p = add_epsg_def_ex (filter, first, last, 9215, "epsg", 9215,
        "VN-2000 / TM-3 107-15", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107.25 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 107-15\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",107.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"9215\"]]");
    p = add_epsg_def_ex (filter, first, last, 9216, "epsg", 9216,
        "VN-2000 / TM-3 107-30", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107.5 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,");
    add_proj4text (p, 2,
        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906");
    add_proj4text (p, 3,
        "278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 107-30\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",107.5],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9216\"]]");
    p = add_epsg_def_ex (filter, first, last, 9217, "epsg", 9217,
        "VN-2000 / TM-3 108-15", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108.25 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 108-15\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",108.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"9217\"]]");
    p = add_epsg_def_ex (filter, first, last, 9218, "epsg", 9218,
        "VN-2000 / TM-3 108-30", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108.5 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,");
    add_proj4text (p, 2,
        "-111.45032835,0.00928836,-0.01975479,0.00427372,0.252906");
    add_proj4text (p, 3,
        "278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 108-30\",GEOGCS[\"VN-2000\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6756\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",108.5],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"9218\"]]");
    p = add_epsg_def_ex (filter, first, last, 9221, "epsg", 9221,
        "Hartebeesthoek94 / ZAF BSU Albers 25E", 0, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Albers_Conic_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=-30 +lon_0=25 +lat_1=-22 +lat_2=-38 +x_");
    add_proj4text (p, 1,
        "0=1400000 +y_0=1300000 +ellps=WGS84 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / ZAF BSU Albers 25E\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Hartebeesthoek94\",DATUM[\"Hartebeesthoek94\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4148\"]],PROJECTION[\"Albers_Conic_Equal_Area\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_center\",-30],PARAMETER[\"long");
    add_srs_wkt (p, 8,
        "itude_of_center\",25],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "-22],PARAMETER[\"standard_parallel_2\",-38],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1400000],PARAMETER[\"false_northing\",13");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9221\"]]");
    p = add_epsg_def_ex (filter, first, last, 9222, "epsg", 9222,
        "Hartebeesthoek94 / ZAF BSU Albers 44E", 0, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Albers_Conic_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=-42 +lon_0=44 +lat_1=-34 +lat_2=-50 +x_");
    add_proj4text (p, 1,
        "0=1200000 +y_0=1300000 +ellps=WGS84 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / ZAF BSU Albers 44E\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Hartebeesthoek94\",DATUM[\"Hartebeesthoek94\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4148\"]],PROJECTION[\"Albers_Conic_Equal_Area\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_center\",-42],PARAMETER[\"long");
    add_srs_wkt (p, 8,
        "itude_of_center\",44],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "-34],PARAMETER[\"standard_parallel_2\",-50],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1200000],PARAMETER[\"false_northing\",13");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9222\"]]");
    p = add_epsg_def_ex (filter, first, last, 9248, "epsg", 9248,
        "Tapi Aike", 1, 1,
        "International 1924", "Greenwich",
        "Tapi_Aike", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-192.26,65.72,132.08,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tapi Aike\",DATUM[\"Tapi_Aike\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"1257\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"92");
    add_srs_wkt (p, 6,
        "48\"]]");
    p = add_epsg_def_ex (filter, first, last, 9249, "epsg", 9249,
        "Tapi Aike / Argentina 1", 0, 1,
        "International 1924", "Greenwich",
        "Tapi_Aike", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-192.26,65.72,132.08,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tapi Aike / Argentina 1\",GEOGCS[\"Tapi Aike\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Tapi_Aike\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1257\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9248\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",-90],PARAMETER[\"central_meridian\",-72],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",1500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9249\"]]");
    p = add_epsg_def_ex (filter, first, last, 9250, "epsg", 9250,
        "Tapi Aike / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Tapi_Aike", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-192.26,65.72,132.08,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tapi Aike / Argentina 2\",GEOGCS[\"Tapi Aike\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Tapi_Aike\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1257\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9248\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",-90],PARAMETER[\"central_meridian\",-69],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",2500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9250\"]]");
    p = add_epsg_def_ex (filter, first, last, 9251, "epsg", 9251,
        "MMN", 1, 1,
        "International 1924", "Greenwich",
        "Ministerio_de_Marina_Norte", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-9.5,122.9,138.2,0,0,");
    add_proj4text (p, 1,
        "0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MMN\",DATUM[\"Ministerio_de_Marina_Norte\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7022\"]],AUTHORITY[\"EPSG\",\"1258\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 3,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9251\"]]");
    p = add_epsg_def_ex (filter, first, last, 9252, "epsg", 9252,
        "MMN / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Ministerio_de_Marina_Norte", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-9.5,122.9,138.2,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MMN / Argentina 2\",GEOGCS[\"MMN\",DATUM[\"Mini");
    add_srs_wkt (p, 1,
        "sterio_de_Marina_Norte\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9251\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",-90],PARAMETER[\"central_meridian\",-69],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",250");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9252\"]]");
    p = add_epsg_def_ex (filter, first, last, 9253, "epsg", 9253,
        "MMS", 1, 1,
        "International 1924", "Greenwich",
        "Ministerio_de_Marina_Sur", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-78.1,101.6,133.3,0,0");
    add_proj4text (p, 1,
        ",0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MMS\",DATUM[\"Ministerio_de_Marina_Sur\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1259\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9253\"]]");
    p = add_epsg_def_ex (filter, first, last, 9254, "epsg", 9254,
        "MMS / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Ministerio_de_Marina_Sur", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-78.1,101.6,133.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MMS / Argentina 2\",GEOGCS[\"MMS\",DATUM[\"Mini");
    add_srs_wkt (p, 1,
        "sterio_de_Marina_Sur\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1259\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9253\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-69],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",25000");
    add_srs_wkt (p, 9,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9254\"]]");
    p = add_epsg_def_ex (filter, first, last, 9265, "epsg", 9265,
        "POSGAR 2007 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=-0.41,0.");
    add_proj4text (p, 1,
        "46,-0.35,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / UTM zone 19S\",GEOGCS[\"POSGAR 20");
    add_srs_wkt (p, 1,
        "07\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1062\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5340\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9265\"]]");
    p = add_epsg_def_ex (filter, first, last, 9267, "epsg", 9267,
        "MGI", 1, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 1,
        "919,5.137,1.474,5.297,2.4232 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"MGI\",DATUM[\"Militar-Geographische Institut\"");
    add_srs_wkt (p, 1,
        ",ELLIPSOID[\"Bessel 1841\",6377397.155,299.1528128,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Austria");
    add_srs_wkt (p, 9,
        "\"],BBOX[46.4,9.53,49.02,17.17]],ID[\"EPSG\",9267]]");
    p = add_epsg_def_ex (filter, first, last, 9271, "epsg", 9271,
        "MGI / Austria West", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.3333333333333 +k=1 +x_0=0");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.");
    add_proj4text (p, 2,
        "137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria West\",GEOGCS[\"MGI\",DATUM[\"Mil");
    add_srs_wkt (p, 1,
        "itar-Geographische_Institut\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 8,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9271\"]]");
    p = add_epsg_def_ex (filter, first, last, 9272, "epsg", 9272,
        "MGI / Austria Central", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.3333333333333 +k=1 +x_0=0");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.");
    add_proj4text (p, 2,
        "137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria Central\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "3.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9272\"]]");
    p = add_epsg_def_ex (filter, first, last, 9273, "epsg", 9273,
        "MGI / Austria East", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.3333333333333 +k=1 +x_0=0");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.");
    add_proj4text (p, 2,
        "137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria East\",GEOGCS[\"MGI\",DATUM[\"Mil");
    add_srs_wkt (p, 1,
        "itar-Geographische_Institut\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 8,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9273\"]]");
    p = add_epsg_def_ex (filter, first, last, 9284, "epsg", 9284,
        "Pampa del Castillo / Argentina 1", 0, 1,
        "International 1924", "Greenwich",
        "Pampa_del_Castillo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pampa del Castillo / Argentina 1\",GEOGCS[\"Pam");
    add_srs_wkt (p, 1,
        "pa del Castillo\",DATUM[\"Pampa_del_Castillo\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6161\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4161\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-72],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",1500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9284\"]]");
    p = add_epsg_def_ex (filter, first, last, 9285, "epsg", 9285,
        "Pampa del Castillo / Argentina 3", 0, 1,
        "International 1924", "Greenwich",
        "Pampa_del_Castillo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pampa del Castillo / Argentina 3\",GEOGCS[\"Pam");
    add_srs_wkt (p, 1,
        "pa del Castillo\",DATUM[\"Pampa_del_Castillo\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6161\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4161\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-66],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",3500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9285\"]]");
    p = add_epsg_def_ex (filter, first, last, 9293, "epsg", 9293,
        "ONGD17", 1, 1,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2017", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ONGD17\",DATUM[\"Oman National Geodetic Datum ");
    add_srs_wkt (p, 1,
        "2017\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Oman\"]");
    add_srs_wkt (p, 9,
        ",BBOX[14.33,51.99,26.74,63.38]],ID[\"EPSG\",9293]]");
    p = add_epsg_def_ex (filter, first, last, 9294, "epsg", 9294,
        "ONGD17", 1, 1,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2017", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ONGD17\",DATUM[\"Oman_National_Geodetic_Datum_2");
    add_srs_wkt (p, 1,
        "017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1263\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9294\"]]");
    p = add_epsg_def_ex (filter, first, last, 9295, "epsg", 9295,
        "ONGD17 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD17 / UTM zone 39N\",GEOGCS[\"ONGD17\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2017\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1263\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9294\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9295\"]]");
    p = add_epsg_def_ex (filter, first, last, 9296, "epsg", 9296,
        "ONGD17 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD17 / UTM zone 40N\",GEOGCS[\"ONGD17\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2017\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1263\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9294\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9296\"]]");
    p = add_epsg_def_ex (filter, first, last, 9297, "epsg", 9297,
        "ONGD17 / UTM zone 41N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD17 / UTM zone 41N\",GEOGCS[\"ONGD17\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2017\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1263\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9294\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9297\"]]");
    p = add_epsg_def_ex (filter, first, last, 9311, "epsg", 9311,
        "NAD27 / US National Atlas Equal Area", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +datum=NA");
    add_proj4text (p, 1,
        "D27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / US National Atlas Equal Area\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Azimuthal_E");
    add_srs_wkt (p, 7,
        "qual_Area\"],PARAMETER[\"latitude_of_center\",45],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"longitude_of_center\",-100],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9311\"]]");
    p = add_epsg_def_ex (filter, first, last, 9332, "epsg", 9332,
        "KSA-GRF17", 1, 1,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,-0.008393,0.00");
    add_proj4text (p, 1,
        "0749,-0.010276,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"KSA-GRF17\",DATUM[\"Kingdom of Saudi Arabia Ge");
    add_srs_wkt (p, 1,
        "odetic Reference Frame 2017\",ELLIPSOID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 4,
        "[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,O");
    add_srs_wkt (p, 5,
        "RDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 6,
        "geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)");
    add_srs_wkt (p, 8,
        "\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 9,
        "known\"],AREA[\"Saudi Arabia\"],BBOX[16.29,34.44,32.16,5");
    add_srs_wkt (p, 10,
        "5.67]],ID[\"EPSG\",9332]]");
    p = add_epsg_def_ex (filter, first, last, 9333, "epsg", 9333,
        "KSA-GRF17", 1, 1,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,-0.008393,0.00");
    add_proj4text (p, 1,
        "0749,-0.010276,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KSA-GRF17\",DATUM[\"Kingdom_of_Saudi_Arabia_Geo");
    add_srs_wkt (p, 1,
        "detic_Reference_Frame_2017\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9333\"]]");
    p = add_epsg_def_ex (filter, first, last, 9354, "epsg", 9354,
        "WGS 84 / IBCSO Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "North", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-65 +lon_0=0 +x_0=0 +y_0=");
    add_proj4text (p, 1,
        "0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / IBCSO Polar Stereographic\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",-65],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 9,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 10,
        "sting\",NORTH],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9354\"]]");
    p = add_epsg_def_ex (filter, first, last, 9356, "epsg", 9356,
        "KSA-GRF17 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 36N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",33],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9356\"]]");
    p = add_epsg_def_ex (filter, first, last, 9357, "epsg", 9357,
        "KSA-GRF17 / UTM zone 37N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 37N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",39],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9357\"]]");
    p = add_epsg_def_ex (filter, first, last, 9358, "epsg", 9358,
        "KSA-GRF17 / UTM zone 38N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 38N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",45],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9358\"]]");
    p = add_epsg_def_ex (filter, first, last, 9359, "epsg", 9359,
        "KSA-GRF17 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 39N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",51],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9359\"]]");
    p = add_epsg_def_ex (filter, first, last, 9360, "epsg", 9360,
        "KSA-GRF17 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 40N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",57],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9360\"]]");
    p = add_epsg_def_ex (filter, first, last, 9364, "epsg", 9364,
        "TPEN11-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TPEN11-IRF\",DATUM[\"TPEN11_Intermediate_Refere");
    add_srs_wkt (p, 1,
        "nce_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1266\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9364\"]]");
    p = add_epsg_def_ex (filter, first, last, 9367, "epsg", 9367,
        "TPEN11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-2.25 +k=1 +x_0=203252.17");
    add_proj4text (p, 1,
        "5 +y_0=407512.765 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TPEN11 Grid\",GEOGCS[\"TPEN11-IRF\",DATUM[\"TPE");
    add_srs_wkt (p, 1,
        "N11_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1266\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"93");
    add_srs_wkt (p, 6,
        "64\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",53.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-2.25],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",203252.175],PARAMETER[\"false_northing\",40751");
    add_srs_wkt (p, 10,
        "2.765],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9367\"]]");
    p = add_epsg_def_ex (filter, first, last, 9368, "epsg", 9368,
        "TPEN11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-2.25 +k=1 +x_0=203252.17");
    add_proj4text (p, 1,
        "5 +y_0=407512.765 +ellps=GRS80 +units=m +vunits=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"TPEN11 Grid + ODN height\",PROJCS[\"TPEN11 Gr");
    add_srs_wkt (p, 1,
        "id\",GEOGCS[\"TPEN11-IRF\",DATUM[\"TPEN11_Intermediate_R");
    add_srs_wkt (p, 2,
        "eference_Frame\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1266\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"9364\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",53.5],PARAMETER[\"central_meridian\",-2.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",203252.175");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",407512.765],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9367\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn");
    add_srs_wkt (p, 14,
        "\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related heig");
    add_srs_wkt (p, 16,
        "ht\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9368\"]]");
    p = add_epsg_def_ex (filter, first, last, 9372, "epsg", 9372,
        "MML07-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MML07-IRF\",DATUM[\"MML07_Intermediate_Referenc");
    add_srs_wkt (p, 1,
        "e_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1271\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"9372\"]]");
    p = add_epsg_def_ex (filter, first, last, 9373, "epsg", 9373,
        "MML07 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.45 +lon_0=-0.85 +k=1 +x_0=49350.15");
    add_proj4text (p, 1,
        "7 +y_0=108398.212 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MML07 Grid\",GEOGCS[\"MML07-IRF\",DATUM[\"MML07");
    add_srs_wkt (p, 1,
        "_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1271\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9372\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",52.45],PARAMETER[\"central_meridian\",-0");
    add_srs_wkt (p, 8,
        ".85],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",49350.157],PARAMETER[\"false_northing\",108398.21");
    add_srs_wkt (p, 10,
        "2],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9373\"]]");
    p = add_epsg_def_ex (filter, first, last, 9374, "epsg", 9374,
        "MML07 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.45 +lon_0=-0.85 +k=1 +x_0=49350.15");
    add_proj4text (p, 1,
        "7 +y_0=108398.212 +ellps=GRS80 +units=m +vunits=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"MML07 Grid + ODN height\",PROJCS[\"MML07 Grid");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"MML07-IRF\",DATUM[\"MML07_Intermediate_Refer");
    add_srs_wkt (p, 2,
        "ence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1271");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"9372\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",52");
    add_srs_wkt (p, 8,
        ".45],PARAMETER[\"central_meridian\",-0.85],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",49350.157],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",108398.212],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9373\"]],VE");
    add_srs_wkt (p, 13,
        "RT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn\"");
    add_srs_wkt (p, 14,
        ",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 16,
        "\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 17,
        "\"9374\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

