/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_46 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 28476, "epsg", 28476,
        "Pulkovo 1942 / Gauss-Kruger 16N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 16N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",93],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28476\"]]");
    p = add_epsg_def_ex (filter, first, last, 28477, "epsg", 28477,
        "Pulkovo 1942 / Gauss-Kruger 17N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 17N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",99],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28477\"]]");
    p = add_epsg_def_ex (filter, first, last, 28478, "epsg", 28478,
        "Pulkovo 1942 / Gauss-Kruger 18N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 18N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",105],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28478\"]]");
    p = add_epsg_def_ex (filter, first, last, 28479, "epsg", 28479,
        "Pulkovo 1942 / Gauss-Kruger 19N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 19N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",111],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28479\"]]");
    p = add_epsg_def_ex (filter, first, last, 28480, "epsg", 28480,
        "Pulkovo 1942 / Gauss-Kruger 20N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 20N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",117],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28480\"]]");
    p = add_epsg_def_ex (filter, first, last, 28481, "epsg", 28481,
        "Pulkovo 1942 / Gauss-Kruger 21N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 21N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",123],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28481\"]]");
    p = add_epsg_def_ex (filter, first, last, 28482, "epsg", 28482,
        "Pulkovo 1942 / Gauss-Kruger 22N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 22N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",129],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28482\"]]");
    p = add_epsg_def_ex (filter, first, last, 28483, "epsg", 28483,
        "Pulkovo 1942 / Gauss-Kruger 23N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 23N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",135],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28483\"]]");
    p = add_epsg_def_ex (filter, first, last, 28484, "epsg", 28484,
        "Pulkovo 1942 / Gauss-Kruger 24N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 24N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",141],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28484\"]]");
    p = add_epsg_def_ex (filter, first, last, 28485, "epsg", 28485,
        "Pulkovo 1942 / Gauss-Kruger 25N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 25N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",147],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28485\"]]");
    p = add_epsg_def_ex (filter, first, last, 28486, "epsg", 28486,
        "Pulkovo 1942 / Gauss-Kruger 26N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 26N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",153],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28486\"]]");
    p = add_epsg_def_ex (filter, first, last, 28487, "epsg", 28487,
        "Pulkovo 1942 / Gauss-Kruger 27N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 27N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",159],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28487\"]]");
    p = add_epsg_def_ex (filter, first, last, 28488, "epsg", 28488,
        "Pulkovo 1942 / Gauss-Kruger 28N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 28N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",165],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28488\"]]");
    p = add_epsg_def_ex (filter, first, last, 28489, "epsg", 28489,
        "Pulkovo 1942 / Gauss-Kruger 29N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 29N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",171],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28489\"]]");
    p = add_epsg_def_ex (filter, first, last, 28490, "epsg", 28490,
        "Pulkovo 1942 / Gauss-Kruger 30N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 30N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",177],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28490\"]]");
    p = add_epsg_def_ex (filter, first, last, 28491, "epsg", 28491,
        "Pulkovo 1942 / Gauss-Kruger 31N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 31N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-177],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28491\"]]");
    p = add_epsg_def_ex (filter, first, last, 28492, "epsg", 28492,
        "Pulkovo 1942 / Gauss-Kruger 32N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 32N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-171],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28492\"]]");
    p = add_epsg_def_ex (filter, first, last, 28600, "epsg", 28600,
        "Qatar 1974 / Qatar National Grid", 0, 0,
        "International 1924", "Greenwich",
        "Qatar_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.9");
    add_proj4text (p, 1,
        "9999 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-128.1");
    add_proj4text (p, 2,
        "6,-282.42,21.93,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Qatar 1974 / Qatar National Grid\",GEOGCS[\"Qat");
    add_srs_wkt (p, 1,
        "ar 1974\",DATUM[\"Qatar_1974\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-128.16,-282.42,21.93,0,0,0,0],AUTHORITY[\"EPSG\",\"628");
    add_srs_wkt (p, 4,
        "5\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4285\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",24.45],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",51.21666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.99999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",200000],PARAMETER[\"false_northing\",300000],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"28600\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28991, "epsg", 28991,
        "Amersfoort / RD Old", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=0 +y_0=0 +ellps=bessel +towgs84=");
    add_proj4text (p, 2,
        "565.2369,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0");
    add_proj4text (p, 3,
        "812 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Amersfoort / RD Old\",GEOGCS[\"Amersfoort\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Amersfoort\",SPHEROID[\"Bessel 1841\",6377397.155,2");
    add_srs_wkt (p, 2,
        "99.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.236");
    add_srs_wkt (p, 3,
        "9,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0812],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4289\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",52.15616055555555],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",5.38763888888889],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "0.9999079],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"28991\"]]");
    p = add_epsg_def_ex (filter, first, last, 28992, "epsg", 28992,
        "Amersfoort / RD New", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=565.2369,50.0087,465.658,-0.406857,0.350733,-1");
    add_proj4text (p, 3,
        ".87035,4.0812 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Amersfoort / RD New\",GEOGCS[\"Amersfoort\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Amersfoort\",SPHEROID[\"Bessel 1841\",6377397.155,2");
    add_srs_wkt (p, 2,
        "99.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.236");
    add_srs_wkt (p, 3,
        "9,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0812],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4289\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",52.15616055555555],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",5.38763888888889],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "0.9999079],PARAMETER[\"false_easting\",155000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",463000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"28992\"]]");
    p = add_epsg_def_ex (filter, first, last, 29100, "epsg", 29100,
        "SAD69 / Brazil Polyconic (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Polyconic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / Brazil Polyconic (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"SAD69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "36\"]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "291\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Polyco");
    add_srs_wkt (p, 8,
        "nic\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-54],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"29100\"]]");
    p = add_epsg_def_ex (filter, first, last, 29101, "epsg", 29101,
        "SAD69 / Brazil Polyconic", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Polyconic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=aust_SA +towgs84=-66.87,4.37,-38.52,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / Brazil Polyconic\",GEOGCS[\"SAD69\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"South_American_Datum_1969\",SPHEROID[\"GRS 1967 Mod");
    add_srs_wkt (p, 2,
        "ified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 4,
        "18\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Polycon");
    add_srs_wkt (p, 8,
        "ic\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-54],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"29101\"]]");
    p = add_epsg_def_ex (filter, first, last, 29118, "epsg", 29118,
        "SAD69 / UTM zone 18N (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-75],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"29118\"]]");
    p = add_epsg_def_ex (filter, first, last, 29119, "epsg", 29119,
        "SAD69 / UTM zone 19N (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-69],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"29119\"]]");
    p = add_epsg_def_ex (filter, first, last, 29120, "epsg", 29120,
        "SAD69 / UTM zone 20N (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-63],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"29120\"]]");
    p = add_epsg_def_ex (filter, first, last, 29121, "epsg", 29121,
        "SAD69 / UTM zone 21N (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-57],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"29121\"]]");
    p = add_epsg_def_ex (filter, first, last, 29122, "epsg", 29122,
        "SAD69 / UTM zone 22N (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-51],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"29122\"]]");
    p = add_epsg_def_ex (filter, first, last, 29168, "epsg", 29168,
        "SAD69 / UTM zone 18N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-75],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29168\"]]");
    p = add_epsg_def_ex (filter, first, last, 29169, "epsg", 29169,
        "SAD69 / UTM zone 19N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-69],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29169\"]]");
    p = add_epsg_def_ex (filter, first, last, 29170, "epsg", 29170,
        "SAD69 / UTM zone 20N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-63],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29170\"]]");
    p = add_epsg_def_ex (filter, first, last, 29171, "epsg", 29171,
        "SAD69 / UTM zone 21N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-57],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29171\"]]");
    p = add_epsg_def_ex (filter, first, last, 29172, "epsg", 29172,
        "SAD69 / UTM zone 22N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-51],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29172\"]]");
    p = add_epsg_def_ex (filter, first, last, 29177, "epsg", 29177,
        "SAD69 / UTM zone 17S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-81],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29177\"]]");
    p = add_epsg_def_ex (filter, first, last, 29178, "epsg", 29178,
        "SAD69 / UTM zone 18S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-75],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29178\"]]");
    p = add_epsg_def_ex (filter, first, last, 29179, "epsg", 29179,
        "SAD69 / UTM zone 19S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-69],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29179\"]]");
    p = add_epsg_def_ex (filter, first, last, 29180, "epsg", 29180,
        "SAD69 / UTM zone 20S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-63],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29180\"]]");
    p = add_epsg_def_ex (filter, first, last, 29181, "epsg", 29181,
        "SAD69 / UTM zone 21S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-57],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29181\"]]");
    p = add_epsg_def_ex (filter, first, last, 29182, "epsg", 29182,
        "SAD69 / UTM zone 22S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-51],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29182\"]]");
    p = add_epsg_def_ex (filter, first, last, 29183, "epsg", 29183,
        "SAD69 / UTM zone 23S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 23S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-45],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29183\"]]");
    p = add_epsg_def_ex (filter, first, last, 29184, "epsg", 29184,
        "SAD69 / UTM zone 24S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 24S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-39],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29184\"]]");
    p = add_epsg_def_ex (filter, first, last, 29185, "epsg", 29185,
        "SAD69 / UTM zone 25S (deprecated)", 0, 0,
        "GRS 1967", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-33],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29185\"]]");
    p = add_epsg_def_ex (filter, first, last, 29187, "epsg", 29187,
        "SAD69 / UTM zone 17S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-81],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29187\"]]");
    p = add_epsg_def_ex (filter, first, last, 29188, "epsg", 29188,
        "SAD69 / UTM zone 18S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-75],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29188\"]]");
    p = add_epsg_def_ex (filter, first, last, 29189, "epsg", 29189,
        "SAD69 / UTM zone 19S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-69],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29189\"]]");
    p = add_epsg_def_ex (filter, first, last, 29190, "epsg", 29190,
        "SAD69 / UTM zone 20S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-63],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29190\"]]");
    p = add_epsg_def_ex (filter, first, last, 29191, "epsg", 29191,
        "SAD69 / UTM zone 21S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-57],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29191\"]]");
    p = add_epsg_def_ex (filter, first, last, 29192, "epsg", 29192,
        "SAD69 / UTM zone 22S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-51],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29192\"]]");
    p = add_epsg_def_ex (filter, first, last, 29193, "epsg", 29193,
        "SAD69 / UTM zone 23S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 23S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-45],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29193\"]]");
    p = add_epsg_def_ex (filter, first, last, 29194, "epsg", 29194,
        "SAD69 / UTM zone 24S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 24S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-39],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29194\"]]");
    p = add_epsg_def_ex (filter, first, last, 29195, "epsg", 29195,
        "SAD69 / UTM zone 25S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-33],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"29195\"]]");
    p = add_epsg_def_ex (filter, first, last, 29220, "epsg", 29220,
        "Sapper Hill 1943 / UTM zone 20S", 0, 0,
        "International 1924", "Greenwich",
        "Sapper_Hill_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 20S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-355,21,72,0,0,0,0],AUTHORITY[\"EPSG\",\"6292");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4292\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-63],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29220\"]]");
    p = add_epsg_def_ex (filter, first, last, 29221, "epsg", 29221,
        "Sapper Hill 1943 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Sapper_Hill_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 21S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-355,21,72,0,0,0,0],AUTHORITY[\"EPSG\",\"6292");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4292\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-57],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"29221\"]]");
    p = add_epsg_def_ex (filter, first, last, 29333, "epsg", 29333,
        "Schwarzeck / UTM zone 33S", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=bess_nam +towgs84=616,9");
    add_proj4text (p, 1,
        "7,-251,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / UTM zone 33S\",GEOGCS[\"Schwarzeck");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\"");
    add_srs_wkt (p, 2,
        ",6377483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "293\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",15],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"29333\"]]");
    p = add_epsg_def_ex (filter, first, last, 29371, "epsg", 29371,
        "Schwarzeck / Lo22/11", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=11 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/11\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",11],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29371\"]]");
    p = add_epsg_def_ex (filter, first, last, 29373, "epsg", 29373,
        "Schwarzeck / Lo22/13", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=13 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/13\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",13],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29373\"]]");
    p = add_epsg_def_ex (filter, first, last, 29375, "epsg", 29375,
        "Schwarzeck / Lo22/15", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/15\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",15],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29375\"]]");
    p = add_epsg_def_ex (filter, first, last, 29377, "epsg", 29377,
        "Schwarzeck / Lo22/17", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/17\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",17],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29377\"]]");
    p = add_epsg_def_ex (filter, first, last, 29379, "epsg", 29379,
        "Schwarzeck / Lo22/19", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/19\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",19],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29379\"]]");
    p = add_epsg_def_ex (filter, first, last, 29381, "epsg", 29381,
        "Schwarzeck / Lo22/21", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/21\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",21],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29381\"]]");
    p = add_epsg_def_ex (filter, first, last, 29383, "epsg", 29383,
        "Schwarzeck / Lo22/23", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/23\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",23],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29383\"]]");
    p = add_epsg_def_ex (filter, first, last, 29385, "epsg", 29385,
        "Schwarzeck / Lo22/25", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Y", "West", "X", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/25\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator_South_Orientated\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",-22],PARAMETER[\"central_meridian\",25],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"German legal metre\",");
    add_srs_wkt (p, 12,
        "1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"Y\",WE");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29385\"]]");
    p = add_epsg_def_ex (filter, first, last, 29635, "epsg", 29635,
        "Sudan / UTM zone 35N (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Sudan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sudan / UTM zone 35N (deprecated)\",GEOGCS[\"Su");
    add_srs_wkt (p, 1,
        "dan\",DATUM[\"Sudan\",SPHEROID[\"Clarke 1880 (IGN)\",637");
    add_srs_wkt (p, 2,
        "8249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6296\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4296\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",27],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29635\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 29636, "epsg", 29636,
        "Sudan / UTM zone 36N (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Sudan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sudan / UTM zone 36N (deprecated)\",GEOGCS[\"Su");
    add_srs_wkt (p, 1,
        "dan\",DATUM[\"Sudan\",SPHEROID[\"Clarke 1880 (IGN)\",637");
    add_srs_wkt (p, 2,
        "8249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6296\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4296\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",33],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29636\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 29700, "epsg", 29700,
        "Tananarive (Paris) / Laborde Grid (deprecated)", 0, 0,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[-189,-242,-91,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.3372291");
    add_srs_wkt (p, 5,
        "7,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.01570796");
    add_srs_wkt (p, 6,
        "326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"48");
    add_srs_wkt (p, 8,
        "10\"]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Cent");
    add_srs_wkt (p, 9,
        "er\"],PARAMETER[\"latitude_of_center\",-21],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "longitude_of_center\",49],PARAMETER[\"azimuth\",21],PARA");
    add_srs_wkt (p, 11,
        "METER[\"rectified_grid_angle\",21],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 12,
        "tor\",0.9995],PARAMETER[\"false_easting\",400000],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"29700\"]]");
    p = add_epsg_def_ex (filter, first, last, 29702, "epsg", 29702,
        "Tananarive (Paris) / Laborde Grid approximation", 0, 1,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid approximation");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"International 1924\",6378388,297,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7022\"]],TOWGS84[-189,-242,-91,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.33722");
    add_srs_wkt (p, 5,
        "917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.015707");
    add_srs_wkt (p, 6,
        "96326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4810\"]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Ce");
    add_srs_wkt (p, 9,
        "nter\"],PARAMETER[\"latitude_of_center\",-21],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"longitude_of_center\",49],PARAMETER[\"azimuth\",21],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"rectified_grid_angle\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 12,
        "actor\",0.9995],PARAMETER[\"false_easting\",400000],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 15,
        "T],AUTHORITY[\"EPSG\",\"29702\"]]");
    p = add_epsg_def_ex (filter, first, last, 29738, "epsg", 29738,
        "Tananarive / UTM zone 38S", 0, 0,
        "International 1924", "Greenwich",
        "Tananarive_1925", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 38S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "189,-242,-91,0,0,0,0],AUTHORITY[\"EPSG\",\"6297\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4297\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",45],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29738\"]]");
    p = add_epsg_def_ex (filter, first, last, 29739, "epsg", 29739,
        "Tananarive / UTM zone 39S", 0, 0,
        "International 1924", "Greenwich",
        "Tananarive_1925", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 39S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "189,-242,-91,0,0,0,0],AUTHORITY[\"EPSG\",\"6297\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4297\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",51],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"29739\"]]");
    p = add_epsg_def_ex (filter, first, last, 29849, "epsg", 29849,
        "Timbalai 1948 / UTM zone 49N", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=evrstSS +towgs84=-679,669,-48,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 49N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4298\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",111],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29849\"]]");
    p = add_epsg_def_ex (filter, first, last, 29850, "epsg", 29850,
        "Timbalai 1948 / UTM zone 50N", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=evrstSS +towgs84=-679,669,-48,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 50N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4298\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",117],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29850\"]]");
    p = add_epsg_def_ex (filter, first, last, 29871, "epsg", 29871,
        "Timbalai 1948 / RSO Borneo (ch)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "British chain (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8714630401 +y_0=442857.653094361 ");
    add_proj4text (p, 2,
        "+gamma=53.13010236111111 +ellps=evrstSS +towgs84=-679,66");
    add_proj4text (p, 3,
        "9,-48,0,0,0,0 +to_meter=20.11676512155263 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ch)\",GEOGCS[\"Timb");
    add_srs_wkt (p, 1,
        "alai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4298\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_center\",4],PARAMETER[\"longitude_of_c");
    add_srs_wkt (p, 10,
        "enter\",115],PARAMETER[\"azimuth\",53.31582047222222],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"rectified_grid_angle\",53.13010236111111],PARA");
    add_srs_wkt (p, 12,
        "METER[\"scale_factor\",0.99984],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 13,
        "g\",29352.4763],PARAMETER[\"false_northing\",22014.3572]");
    add_srs_wkt (p, 14,
        ",UNIT[\"British chain (Sears 1922)\",20.11676512155263,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"9042\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 16,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29871\"]]");
    p = add_epsg_def_ex (filter, first, last, 29872, "epsg", 29872,
        "Timbalai 1948 / RSO Borneo (ftSe)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "British foot (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8727431979 +y_0=442857.6545573985");
    add_proj4text (p, 2,
        " +gamma=53.13010236111111 +ellps=evrstSS +towgs84=-679,6");
    add_proj4text (p, 3,
        "69,-48,0,0,0,0 +to_meter=0.3047994715386762 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ftSe)\",GEOGCS[\"Ti");
    add_srs_wkt (p, 1,
        "mbalai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4298\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_center\",4],PARAMETER[\"longitude_");
    add_srs_wkt (p, 10,
        "of_center\",115],PARAMETER[\"azimuth\",53.31582047222222");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"rectified_grid_angle\",53.13010236111111],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_ea");
    add_srs_wkt (p, 13,
        "sting\",1937263.44],PARAMETER[\"false_northing\",1452947");
    add_srs_wkt (p, 14,
        ".58],UNIT[\"British foot (Sears 1922)\",0.30479947153867");
    add_srs_wkt (p, 15,
        "62,AUTHORITY[\"EPSG\",\"9041\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 16,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29872\"]]");
    p = add_epsg_def_ex (filter, first, last, 29873, "epsg", 29873,
        "Timbalai 1948 / RSO Borneo (m)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.87 +y_0=442857.65 +gamma=53.13010");
    add_proj4text (p, 2,
        "236111111 +ellps=evrstSS +towgs84=-679,669,-48,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (m)\",GEOGCS[\"Timba");
    add_srs_wkt (p, 1,
        "lai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 18");
    add_srs_wkt (p, 2,
        "30 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4298\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_center\",4],PARAMETER[\"longitude_of_c");
    add_srs_wkt (p, 10,
        "enter\",115],PARAMETER[\"azimuth\",53.31582047222222],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"rectified_grid_angle\",53.13010236111111],PARA");
    add_srs_wkt (p, 12,
        "METER[\"scale_factor\",0.99984],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 13,
        "g\",590476.87],PARAMETER[\"false_northing\",442857.65],U");
    add_srs_wkt (p, 14,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 15,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"29873\"]]");
    p = add_epsg_def_ex (filter, first, last, 29900, "epsg", 29900,
        "TM65 / Irish National Grid (deprecated)", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "TM65", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish National Grid (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"TM65\",DATUM[\"TM65\",SPHEROID[\"Airy Modified 1849\"");
    add_srs_wkt (p, 2,
        ",6377340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6299\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4299\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",53.5],PARAMETER[\"central_meridian\",-8],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1.000035],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",200000],PARAMETER[\"false_northing\",250000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "29900\"]]");
    p = add_epsg_def_ex (filter, first, last, 29901, "epsg", 29901,
        "OSNI 1952 / Irish National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSNI_1952", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1 +x_0=200000 +y_0=");
    add_proj4text (p, 1,
        "250000 +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0");
    add_proj4text (p, 2,
        ".214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSNI 1952 / Irish National Grid\",GEOGCS[\"OSNI");
    add_srs_wkt (p, 1,
        " 1952\",DATUM[\"OSNI_1952\",SPHEROID[\"Airy 1830\",63775");
    add_srs_wkt (p, 2,
        "63.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6188\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4188\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",53.5],PARAMETER[\"central_meridian\",-8],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29901\"]]");
    p = add_epsg_def_ex (filter, first, last, 29902, "epsg", 29902,
        "TM65 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "TM65", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish Grid\",GEOGCS[\"TM65\",DATUM[\"TM6");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"Airy Modified 1849\",6377340.189,299.3249");
    add_srs_wkt (p, 2,
        "646,AUTHORITY[\"EPSG\",\"7002\"]],TOWGS84[482.5,-130.6,5");
    add_srs_wkt (p, 3,
        "64.6,-1.042,-0.214,-0.631,8.15],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4299\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",53.5],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-8],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1.000035],PARAMETER[\"false_easting\",200000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",250000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29902\"]]");
    p = add_epsg_def_ex (filter, first, last, 29903, "epsg", 29903,
        "TM75 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "Geodetic_Datum_of_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM75 / Irish Grid\",GEOGCS[\"TM75\",DATUM[\"Geo");
    add_srs_wkt (p, 1,
        "detic_Datum_of_1965\",SPHEROID[\"Airy Modified 1849\",63");
    add_srs_wkt (p, 2,
        "77340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6300\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4300\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",53.5],PARAMETER[\"central_meridian\",-8],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.000035],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",200000],PARAMETER[\"false_northing\",250000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"299");
    add_srs_wkt (p, 14,
        "03\"]]");
    p = add_epsg_def_ex (filter, first, last, 30161, "epsg", 30161,
        "Tokyo / Japan Plane Rectangular CS I", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS I\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",33],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",129.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"30161\"]]");
    p = add_epsg_def_ex (filter, first, last, 30162, "epsg", 30162,
        "Tokyo / Japan Plane Rectangular CS II", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS II\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",33],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",131],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"30162\"]]");
    p = add_epsg_def_ex (filter, first, last, 30163, "epsg", 30163,
        "Tokyo / Japan Plane Rectangular CS III", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS III\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",132.1666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"30163\"]]");
    p = add_epsg_def_ex (filter, first, last, 30164, "epsg", 30164,
        "Tokyo / Japan Plane Rectangular CS IV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",33],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",133.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"30164\"]]");
    p = add_epsg_def_ex (filter, first, last, 30165, "epsg", 30165,
        "Tokyo / Japan Plane Rectangular CS V", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS V\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",36],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",134.3333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"30165\"]]");
    p = add_epsg_def_ex (filter, first, last, 30166, "epsg", 30166,
        "Tokyo / Japan Plane Rectangular CS VI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",136],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"30166\"]]");
    p = add_epsg_def_ex (filter, first, last, 30167, "epsg", 30167,
        "Tokyo / Japan Plane Rectangular CS VII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",137.1666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"30167\"]]");
    p = add_epsg_def_ex (filter, first, last, 30168, "epsg", 30168,
        "Tokyo / Japan Plane Rectangular CS VIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",138.5],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"30168\"]]");
    p = add_epsg_def_ex (filter, first, last, 30169, "epsg", 30169,
        "Tokyo / Japan Plane Rectangular CS IX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IX\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",139.8333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"30169\"]]");
    p = add_epsg_def_ex (filter, first, last, 30170, "epsg", 30170,
        "Tokyo / Japan Plane Rectangular CS X", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS X\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",40],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",140.8333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"30170\"]]");
    p = add_epsg_def_ex (filter, first, last, 30171, "epsg", 30171,
        "Tokyo / Japan Plane Rectangular CS XI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",140.25],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"30171\"]]");
    p = add_epsg_def_ex (filter, first, last, 30172, "epsg", 30172,
        "Tokyo / Japan Plane Rectangular CS XII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",142.25],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"30172\"]]");
    p = add_epsg_def_ex (filter, first, last, 30173, "epsg", 30173,
        "Tokyo / Japan Plane Rectangular CS XIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",144.25],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"30173\"]]");
    p = add_epsg_def_ex (filter, first, last, 30174, "epsg", 30174,
        "Tokyo / Japan Plane Rectangular CS XIV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIV\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",26],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",142],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"30174\"]]");
    p = add_epsg_def_ex (filter, first, last, 30175, "epsg", 30175,
        "Tokyo / Japan Plane Rectangular CS XV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",26],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",127.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"30175\"]]");
    p = add_epsg_def_ex (filter, first, last, 30176, "epsg", 30176,
        "Tokyo / Japan Plane Rectangular CS XVI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVI\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",26],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",124],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"30176\"]]");
    p = add_epsg_def_ex (filter, first, last, 30177, "epsg", 30177,
        "Tokyo / Japan Plane Rectangular CS XVII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",131],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"30177\"]]");
    p = add_epsg_def_ex (filter, first, last, 30178, "epsg", 30178,
        "Tokyo / Japan Plane Rectangular CS XVIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVIII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",2");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"central_meridian\",136],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"30178\"]]");
    p = add_epsg_def_ex (filter, first, last, 30179, "epsg", 30179,
        "Tokyo / Japan Plane Rectangular CS XIX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIX\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",26],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",154],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"30179\"]]");
    p = add_epsg_def_ex (filter, first, last, 30200, "epsg", 30200,
        "Trinidad 1903 / Trinidad Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "Cassini_Soldner", "Clarke's link",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.333333333");
    add_proj4text (p, 1,
        "33334 +x_0=86501.46392051999 +y_0=65379.0134283 +a=63782");
    add_proj4text (p, 2,
        "93.645208759 +b=6356617.987679838 +towgs84=-61.702,284.4");
    add_proj4text (p, 3,
        "88,472.052,0,0,0,0 +to_meter=0.201166195164 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Trinidad 1903 / Trinidad Grid\",GEOGCS[\"Trinid");
    add_srs_wkt (p, 1,
        "ad 1903\",DATUM[\"Trinidad_1903\",SPHEROID[\"Clarke 1858");
    add_srs_wkt (p, 2,
        "\",6378293.645208759,294.2606763692606,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7007\"]],TOWGS84[-61.702,284.488,472.052,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4302\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",10.44166666666667],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-61.33333333333334],PARAMETER[\"false_easting\",4300");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",325000],UNIT[\"Clarke's");
    add_srs_wkt (p, 12,
        " link\",0.201166195164,AUTHORITY[\"EPSG\",\"9039\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"30200\"]]");
    p = add_epsg_def_ex (filter, first, last, 30339, "epsg", 30339,
        "TC(1948) / UTM zone 39N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 39N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4303\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30339\"]]");
    p = add_epsg_def_ex (filter, first, last, 30340, "epsg", 30340,
        "TC(1948) / UTM zone 40N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 40N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4303\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30340\"]]");
    p = add_epsg_def_ex (filter, first, last, 30491, "epsg", 30491,
        "Voirol 1875 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 2,
        "84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4304\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",36],PARAMETER[\"central_meridian\",2.7],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.999625544],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",500000],PARAMETER[\"false_northing\",300000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"30491\"]]");
    p = add_epsg_def_ex (filter, first, last, 30492, "epsg", 30492,
        "Voirol 1875 / Sud Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +t");
    add_proj4text (p, 2,
        "owgs84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Sud Algerie (ancienne)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4304\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",33.3],PARAMETER[\"central_meridian\",2.7],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.999625769],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",500000],PARAMETER[\"false_northing\",300000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"30492\"]]");
    p = add_epsg_def_ex (filter, first, last, 30493, "epsg", 30493,
        "Voirol 1879 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1879 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4671\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",2.7],PARAMETER[\"scale_factor\",0.99962");
    add_srs_wkt (p, 10,
        "5544],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"30493\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

