/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_45 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 27226, "epsg", 27226,
        "NZGD49 / Timaru Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Timaru Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",-44.40222036111111],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",171.0572508333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",300000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"27226\"]]");
    p = add_epsg_def_ex (filter, first, last, 27227, "epsg", 27227,
        "NZGD49 / Lindis Peak Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Lindis Peak Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-44.73526797222222],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",169.4677550833333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27227\"]]");
    p = add_epsg_def_ex (filter, first, last, 27228, "epsg", 27228,
        "NZGD49 / Mount Nicholas Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Nicholas Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5");
    add_srs_wkt (p, 4,
        "993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",-45.13290258333333],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",168.3986411944444],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 11,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AUTHORITY[\"EPSG\",\"27228\"]]");
    p = add_epsg_def_ex (filter, first, last, 27229, "epsg", 27229,
        "NZGD49 / Mount York Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount York Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",-45.56372616666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",167.7388617777778],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"27229\"]]");
    p = add_epsg_def_ex (filter, first, last, 27230, "epsg", 27230,
        "NZGD49 / Observation Point Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Observation Point Circuit\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-");
    add_srs_wkt (p, 4,
        "4.5993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",-45.81619661111111],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",170.6285951666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 11,
        "factor\",1],PARAMETER[\"false_easting\",300000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 14,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"27230\"]]");
    p = add_epsg_def_ex (filter, first, last, 27231, "epsg", 27231,
        "NZGD49 / North Taieri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891");
    add_proj4text (p, 1,
        "111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +t");
    add_proj4text (p, 2,
        "owgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Taieri Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 8,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",-45.86151336111111],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",170.2825891111111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 11,
        "or\",0.99996],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 14,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27231\"]]");
    p = add_epsg_def_ex (filter, first, last, 27232, "epsg", 27232,
        "NZGD49 / Bluff Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +towgs84=");
    add_proj4text (p, 2,
        "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bluff Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",-46.60000961111111],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",168.342872],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",300002.66],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",699999.58],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"27232\"]]");
    p = add_epsg_def_ex (filter, first, last, 27258, "epsg", 27258,
        "NZGD49 / UTM zone 58S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 58S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",165],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2725");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 27259, "epsg", 27259,
        "NZGD49 / UTM zone 59S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 59S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",171],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2725");
    add_srs_wkt (p, 14,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 27260, "epsg", 27260,
        "NZGD49 / UTM zone 60S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 60S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",177],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2726");
    add_srs_wkt (p, 14,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 27291, "epsg", 27291,
        "NZGD49 / North Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.524");
    add_proj4text (p, 1,
        "3848086 +y_0=365759.3658464114 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-39],PARAMETER[\"central_meridian\",175.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",300000],PARAMETER[\"false_northing\",400000],UNIT[\"");
    add_srs_wkt (p, 12,
        "British yard (Sears 1922)\",0.9143984146160287,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27291\"]]");
    p = add_epsg_def_ex (filter, first, last, 27292, "epsg", 27292,
        "NZGD49 / South Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.207");
    add_proj4text (p, 1,
        "3080143 +y_0=457199.2073080143 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / South Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4272\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",-44],PARAMETER[\"central_meridian\",171.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 12,
        "British yard (Sears 1922)\",0.9143984146160287,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27292\"]]");
    p = add_epsg_def_ex (filter, first, last, 27391, "epsg", 27391,
        "NGO 1948 (Oslo) / NGO zone I", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone I\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitu");
    add_srs_wkt (p, 7,
        "de\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 8,
        "\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",58],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-4.666666666666667],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27391");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 27392, "epsg", 27392,
        "NGO 1948 (Oslo) / NGO zone II", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone II\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",58],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-2.333333333333333],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27392");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 27393, "epsg", 27393,
        "NGO 1948 (Oslo) / NGO zone III", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=637");
    add_proj4text (p, 1,
        "7492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.");
    add_proj4text (p, 2,
        "889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone III\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "66667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",58],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"y\",EAST],AUTHORITY[\"EPSG\",\"27393\"]]");
    p = add_epsg_def_ex (filter, first, last, 27394, "epsg", 27394,
        "NGO 1948 (Oslo) / NGO zone IV", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,");
    add_proj4text (p, 2,
        "7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone IV\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",58],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",2.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH],A");
    add_srs_wkt (p, 13,
        "XIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27394\"]]");
    p = add_epsg_def_ex (filter, first, last, 27395, "epsg", 27395,
        "NGO 1948 (Oslo) / NGO zone V", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone V\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitu");
    add_srs_wkt (p, 7,
        "de\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 8,
        "\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",58],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",6.166666666666667],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27395\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 27396, "epsg", 27396,
        "NGO 1948 (Oslo) / NGO zone VI", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VI\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",58],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",10.16666666666667],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27396");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 27397, "epsg", 27397,
        "NGO 1948 (Oslo) / NGO zone VII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VII\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "66667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",58],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",14.16666666666667],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27397");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 27398, "epsg", 27398,
        "NGO 1948 (Oslo) / NGO zone VIII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VIII\",GEOGCS[\"NGO ");
    add_srs_wkt (p, 1,
        "1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666");
    add_srs_wkt (p, 5,
        "666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",58],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",18.33333333333333],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"273");
    add_srs_wkt (p, 14,
        "98\"]]");
    p = add_epsg_def_ex (filter, first, last, 27429, "epsg", 27429,
        "Datum 73 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193");
    add_proj4text (p, 1,
        ",36.649,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / UTM zone 29N\",GEOGCS[\"Datum 73\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Datum_73\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-223.237,110");
    add_srs_wkt (p, 3,
        ".193,36.649,0,0,0,0],AUTHORITY[\"EPSG\",\"6274\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4274\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-9],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"27429\"]]");
    p = add_epsg_def_ex (filter, first, last, 27492, "epsg", 27492,
        "Datum 73 / Modified Portuguese Grid (deprecated)", 0, 1,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-223.237,110.193,36.649,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4274\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",39.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-8.131906111111112],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",180.598],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"27492\"]]");
    p = add_epsg_def_ex (filter, first, last, 27493, "epsg", 27493,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-223.237,110.193,36.649,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "74\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.6666");
    add_srs_wkt (p, 9,
        "6666666666],PARAMETER[\"central_meridian\",-8.1319061111");
    add_srs_wkt (p, 10,
        "11112],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",180.598],PARAMETER[\"false_northing\",-86.99],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27500, "epsg", 27500,
        "ATF (Paris) / Nord de Guerre", 0, 0,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=5.399999999999999 +k_0=0.99950908 +x_0=500000");
    add_proj4text (p, 2,
        " +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.33720");
    add_proj4text (p, 3,
        "8333333333 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATF (Paris) / Nord de Guerre\",GEOGCS[\"ATF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Ancienne_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 4,
        "ris RGS\",2.337208333333333,AUTHORITY[\"EPSG\",\"8914\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4901\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",5.999999999999998],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.99950908],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",500000],PARAMETER[\"false_northing\",300000],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"27500\"]]");
    p = add_epsg_def_ex (filter, first, last, 27561, "epsg", 27561,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "2936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,3");
    add_srs_wkt (p, 4,
        "20,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 5,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[");
    add_srs_wkt (p, 7,
        "\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 8,
        "EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 9,
        "SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",0],PARAMETER[\"scale_factor\",0.999877");
    add_srs_wkt (p, 11,
        "341],PARAMETER[\"false_easting\",600000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27562, "epsg", 27562,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 7,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 8,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 9,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "987742],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27563, "epsg", 27563,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 9,
        "P\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",0],PARAMETER[\"scale_factor\",0.9998774");
    add_srs_wkt (p, 11,
        "99],PARAMETER[\"false_easting\",600000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27564, "epsg", 27564,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293626");
    add_srs_wkt (p, 3,
        "9,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.3");
    add_srs_wkt (p, 5,
        "3722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.01");
    add_srs_wkt (p, 6,
        "570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",46.85],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",0],PARAMETER[\"scale_factor\",0.9999447");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",234.358],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",185861.369],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"27564\"]]");
    p = add_epsg_def_ex (filter, first, last, 27571, "epsg", 27571,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "69,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0");
    add_srs_wkt (p, 6,
        "1570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",55],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",0],PARAMETER[\"scale_factor\",0.999877341]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",600000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"27571\"]]");
    p = add_epsg_def_ex (filter, first, last, 27572, "epsg", 27572,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 9,
        "\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987742");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",600000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"27572\"]]");
    p = add_epsg_def_ex (filter, first, last, 27573, "epsg", 27573,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 9,
        "\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987749");
    add_srs_wkt (p, 11,
        "9],PARAMETER[\"false_easting\",600000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"27573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27574, "epsg", 27574,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 9,
        "\"],PARAMETER[\"latitude_of_origin\",46.85],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",0],PARAMETER[\"scale_factor\",0.99994");
    add_srs_wkt (p, 11,
        "471],PARAMETER[\"false_easting\",234.358],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",4185861.369],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27581, "epsg", 27581,
        "NTF (Paris) / France I (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France I (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 7,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 8,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 9,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "9877341],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"27581\"]]");
    p = add_epsg_def_ex (filter, first, last, 27582, "epsg", 27582,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 7,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 8,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 9,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "987742],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"27582\"]]");
    p = add_epsg_def_ex (filter, first, last, 27583, "epsg", 27583,
        "NTF (Paris) / France III (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France III (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 4,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 5,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 7,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 8,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 9,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 11,
        "999877499],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"27583\"]]");
    p = add_epsg_def_ex (filter, first, last, 27584, "epsg", 27584,
        "NTF (Paris) / France IV (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France IV (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 7,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 8,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 9,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 11,
        ".99994471],PARAMETER[\"false_easting\",234.358],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",4185861.369],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"27584\"]]");
    p = add_epsg_def_ex (filter, first, last, 27591, "epsg", 27591,
        "NTF (Paris) / Nord France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Nord France (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francais");
    add_srs_wkt (p, 2,
        "e_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4");
    add_srs_wkt (p, 3,
        "660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,");
    add_srs_wkt (p, 4,
        "-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 9,
        "Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 11,
        ".999877341],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"27591\"]]");
    p = add_epsg_def_ex (filter, first, last, 27592, "epsg", 27592,
        "NTF (Paris) / Centre France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Centre France (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Franca");
    add_srs_wkt (p, 2,
        "ise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293");
    add_srs_wkt (p, 3,
        ".4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-16");
    add_srs_wkt (p, 4,
        "8,-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[");
    add_srs_wkt (p, 5,
        "\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 9,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.99987742],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"27592\"]]");
    p = add_epsg_def_ex (filter, first, last, 27593, "epsg", 27593,
        "NTF (Paris) / Sud France (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Sud France (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 4,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 5,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 7,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 8,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 9,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 11,
        "999877499],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"27593\"]]");
    p = add_epsg_def_ex (filter, first, last, 27594, "epsg", 27594,
        "NTF (Paris) / Corse (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Corse (deprecated)\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 9,
        "P\"],PARAMETER[\"latitude_of_origin\",46.85],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",0],PARAMETER[\"scale_factor\",0.99994");
    add_srs_wkt (p, 11,
        "471],PARAMETER[\"false_easting\",234.358],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",185861.369],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"27594\"]]");
    p = add_epsg_def_ex (filter, first, last, 27700, "epsg", 27700,
        "OSGB 1936 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[\"OS");
    add_srs_wkt (p, 1,
        "GB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\",637");
    add_srs_wkt (p, 2,
        "7563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[446.448,-125.157,542.06,0.15,0.247,0.842,-20.489],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4277\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",49],PARAMETER[\"central_meridian\",-2],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996012717],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",400000],PARAMETER[\"false_northing\",-100000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"27700\"]]");
    p = add_epsg_def_ex (filter, first, last, 28191, "epsg", 28191,
        "Palestine 1923 / Palestine Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6");
    add_proj4text (p, 2,
        "356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-4");
    add_proj4text (p, 3,
        ".42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Grid\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],TOWGS84[-275.7224,94.7824,340.8944,-");
    add_srs_wkt (p, 4,
        "8.001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldner\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",31.73409694444445],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",35.21208055555556],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",170251.555],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"28191\"]]");
    p = add_epsg_def_ex (filter, first, last, 28192, "epsg", 28192,
        "Palestine 1923 / Palestine Belt", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.212080555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=170251.555 +y_0=1126867.909 +a=6378300.7");
    add_proj4text (p, 2,
        "89 +b=6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8");
    add_proj4text (p, 3,
        ".001,-4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Belt\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],TOWGS84[-275.7224,94.7824,340.8944,-");
    add_srs_wkt (p, 4,
        "8.001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",31.73409694444445");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",35.21208055555556],PARA");
    add_srs_wkt (p, 11,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",17");
    add_srs_wkt (p, 12,
        "0251.555],PARAMETER[\"false_northing\",1126867.909],UNIT");
    add_srs_wkt (p, 13,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 14,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "28192\"]]");
    p = add_epsg_def_ex (filter, first, last, 28193, "epsg", 28193,
        "Palestine 1923 / Israeli CS Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=");
    add_proj4text (p, 2,
        "6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-");
    add_proj4text (p, 3,
        "4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Israeli CS Grid\",GEOGCS[\"Pal");
    add_srs_wkt (p, 1,
        "estine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7010\"]],TOWGS84[-275.7224,94.7824,340.8944,");
    add_srs_wkt (p, 4,
        "-8.001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldner\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",31.73409694444445],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",35.21208055555556],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",170251.555],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",1126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"28193\"]]");
    p = add_epsg_def_ex (filter, first, last, 28232, "epsg", 28232,
        "Pointe Noire / UTM zone 32S", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Congo_1960_Pointe_Noire", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-148,51,-291,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pointe Noire / UTM zone 32S\",GEOGCS[\"Pointe N");
    add_srs_wkt (p, 1,
        "oire\",DATUM[\"Congo_1960_Pointe_Noire\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7011\"]],TOWGS84[-148,51,-291,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6282\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4282\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"28232\"]]");
    p = add_epsg_def_ex (filter, first, last, 28348, "epsg", 28348,
        "GDA94 / MGA zone 48", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 48\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",105],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28348\"]]");
    p = add_epsg_def_ex (filter, first, last, 28349, "epsg", 28349,
        "GDA94 / MGA zone 49", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 49\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",111],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28349\"]]");
    p = add_epsg_def_ex (filter, first, last, 28350, "epsg", 28350,
        "GDA94 / MGA zone 50", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 50\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",117],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28350\"]]");
    p = add_epsg_def_ex (filter, first, last, 28351, "epsg", 28351,
        "GDA94 / MGA zone 51", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 51\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",123],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28351\"]]");
    p = add_epsg_def_ex (filter, first, last, 28352, "epsg", 28352,
        "GDA94 / MGA zone 52", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 52\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",129],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28352\"]]");
    p = add_epsg_def_ex (filter, first, last, 28353, "epsg", 28353,
        "GDA94 / MGA zone 53", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 53\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",135],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28353\"]]");
    p = add_epsg_def_ex (filter, first, last, 28354, "epsg", 28354,
        "GDA94 / MGA zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 54\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",141],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28354\"]]");
    p = add_epsg_def_ex (filter, first, last, 28355, "epsg", 28355,
        "GDA94 / MGA zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 55\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",147],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28355\"]]");
    p = add_epsg_def_ex (filter, first, last, 28356, "epsg", 28356,
        "GDA94 / MGA zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 56\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",153],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28356\"]]");
    p = add_epsg_def_ex (filter, first, last, 28357, "epsg", 28357,
        "GDA94 / MGA zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 57\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",159],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28357\"]]");
    p = add_epsg_def_ex (filter, first, last, 28358, "epsg", 28358,
        "GDA94 / MGA zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 58\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",165],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"28358\"]]");
    p = add_epsg_def_ex (filter, first, last, 28402, "epsg", 28402,
        "Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"428");
    add_srs_wkt (p, 8,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",9],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",EAST],AUTHORITY[\"EPSG\",\"28402\"]]");
    p = add_epsg_def_ex (filter, first, last, 28403, "epsg", 28403,
        "Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"428");
    add_srs_wkt (p, 8,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",15]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28403\"]]");
    p = add_epsg_def_ex (filter, first, last, 28404, "epsg", 28404,
        "Pulkovo 1942 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",4500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28404\"]]");
    p = add_epsg_def_ex (filter, first, last, 28405, "epsg", 28405,
        "Pulkovo 1942 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",5500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28405\"]]");
    p = add_epsg_def_ex (filter, first, last, 28406, "epsg", 28406,
        "Pulkovo 1942 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",6500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28406\"]]");
    p = add_epsg_def_ex (filter, first, last, 28407, "epsg", 28407,
        "Pulkovo 1942 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",7500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28407\"]]");
    p = add_epsg_def_ex (filter, first, last, 28408, "epsg", 28408,
        "Pulkovo 1942 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",8500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28408\"]]");
    p = add_epsg_def_ex (filter, first, last, 28409, "epsg", 28409,
        "Pulkovo 1942 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",9500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"28409\"]]");
    p = add_epsg_def_ex (filter, first, last, 28410, "epsg", 28410,
        "Pulkovo 1942 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",10500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28410\"]]");
    p = add_epsg_def_ex (filter, first, last, 28411, "epsg", 28411,
        "Pulkovo 1942 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",63],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",11500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28411\"]]");
    p = add_epsg_def_ex (filter, first, last, 28412, "epsg", 28412,
        "Pulkovo 1942 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",69],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",12500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28412\"]]");
    p = add_epsg_def_ex (filter, first, last, 28413, "epsg", 28413,
        "Pulkovo 1942 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",13500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28413\"]]");
    p = add_epsg_def_ex (filter, first, last, 28414, "epsg", 28414,
        "Pulkovo 1942 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",14500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28414\"]]");
    p = add_epsg_def_ex (filter, first, last, 28415, "epsg", 28415,
        "Pulkovo 1942 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",15500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28415\"]]");
    p = add_epsg_def_ex (filter, first, last, 28416, "epsg", 28416,
        "Pulkovo 1942 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",16500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28416\"]]");
    p = add_epsg_def_ex (filter, first, last, 28417, "epsg", 28417,
        "Pulkovo 1942 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",17500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28417\"]]");
    p = add_epsg_def_ex (filter, first, last, 28418, "epsg", 28418,
        "Pulkovo 1942 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",105],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",18500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28418\"]]");
    p = add_epsg_def_ex (filter, first, last, 28419, "epsg", 28419,
        "Pulkovo 1942 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",111],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",19500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28419\"]]");
    p = add_epsg_def_ex (filter, first, last, 28420, "epsg", 28420,
        "Pulkovo 1942 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",117],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",20500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28420\"]]");
    p = add_epsg_def_ex (filter, first, last, 28421, "epsg", 28421,
        "Pulkovo 1942 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",123],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",21500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28421\"]]");
    p = add_epsg_def_ex (filter, first, last, 28422, "epsg", 28422,
        "Pulkovo 1942 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",129],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",22500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28422\"]]");
    p = add_epsg_def_ex (filter, first, last, 28423, "epsg", 28423,
        "Pulkovo 1942 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",135],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",23500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28423\"]]");
    p = add_epsg_def_ex (filter, first, last, 28424, "epsg", 28424,
        "Pulkovo 1942 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",141],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",24500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28424\"]]");
    p = add_epsg_def_ex (filter, first, last, 28425, "epsg", 28425,
        "Pulkovo 1942 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",147],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",25500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28425\"]]");
    p = add_epsg_def_ex (filter, first, last, 28426, "epsg", 28426,
        "Pulkovo 1942 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",153],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",26500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28426\"]]");
    p = add_epsg_def_ex (filter, first, last, 28427, "epsg", 28427,
        "Pulkovo 1942 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",159],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",27500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28427\"]]");
    p = add_epsg_def_ex (filter, first, last, 28428, "epsg", 28428,
        "Pulkovo 1942 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",165],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",28500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28428\"]]");
    p = add_epsg_def_ex (filter, first, last, 28429, "epsg", 28429,
        "Pulkovo 1942 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",171],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",29500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28429\"]]");
    p = add_epsg_def_ex (filter, first, last, 28430, "epsg", 28430,
        "Pulkovo 1942 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",177],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",30500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"28430\"]]");
    p = add_epsg_def_ex (filter, first, last, 28431, "epsg", 28431,
        "Pulkovo 1942 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",-177],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",3150000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"28431\"]]");
    p = add_epsg_def_ex (filter, first, last, 28432, "epsg", 28432,
        "Pulkovo 1942 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",-171],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",3250000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 13,
        "AST],AUTHORITY[\"EPSG\",\"28432\"]]");
    p = add_epsg_def_ex (filter, first, last, 28462, "epsg", 28462,
        "Pulkovo 1942 / Gauss-Kruger 2N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
        "llps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.1");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 2N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28462\"]]");
    p = add_epsg_def_ex (filter, first, last, 28463, "epsg", 28463,
        "Pulkovo 1942 / Gauss-Kruger 3N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 3N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28463\"]]");
    p = add_epsg_def_ex (filter, first, last, 28464, "epsg", 28464,
        "Pulkovo 1942 / Gauss-Kruger 4N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 4N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",21],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28464\"]]");
    p = add_epsg_def_ex (filter, first, last, 28465, "epsg", 28465,
        "Pulkovo 1942 / Gauss-Kruger 5N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 5N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",27],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28465\"]]");
    p = add_epsg_def_ex (filter, first, last, 28466, "epsg", 28466,
        "Pulkovo 1942 / Gauss-Kruger 6N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 6N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28466\"]]");
    p = add_epsg_def_ex (filter, first, last, 28467, "epsg", 28467,
        "Pulkovo 1942 / Gauss-Kruger 7N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 7N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",39],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28467\"]]");
    p = add_epsg_def_ex (filter, first, last, 28468, "epsg", 28468,
        "Pulkovo 1942 / Gauss-Kruger 8N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 8N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",45],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28468\"]]");
    p = add_epsg_def_ex (filter, first, last, 28469, "epsg", 28469,
        "Pulkovo 1942 / Gauss-Kruger 9N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 9N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",51],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"28469\"]]");
    p = add_epsg_def_ex (filter, first, last, 28470, "epsg", 28470,
        "Pulkovo 1942 / Gauss-Kruger 10N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 10N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",57],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28470\"]]");
    p = add_epsg_def_ex (filter, first, last, 28471, "epsg", 28471,
        "Pulkovo 1942 / Gauss-Kruger 11N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 11N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",63],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28471\"]]");
    p = add_epsg_def_ex (filter, first, last, 28472, "epsg", 28472,
        "Pulkovo 1942 / Gauss-Kruger 12N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 12N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",69],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28472\"]]");
    p = add_epsg_def_ex (filter, first, last, 28473, "epsg", 28473,
        "Pulkovo 1942 / Gauss-Kruger 13N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 13N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",75],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28473\"]]");
    p = add_epsg_def_ex (filter, first, last, 28474, "epsg", 28474,
        "Pulkovo 1942 / Gauss-Kruger 14N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 14N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",81],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28474\"]]");
    p = add_epsg_def_ex (filter, first, last, 28475, "epsg", 28475,
        "Pulkovo 1942 / Gauss-Kruger 15N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 15N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,0,0.35,0.82,-0.12],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4284\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",87],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28475\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

