/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_38 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7763, "epsg", 7763,
        "WGS 84 / Himachal Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=32.75 +lat_0=31.75183497 +");
    add_proj4text (p, 1,
        "lon_0=77.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Himachal Pradesh\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 8,
        "\",30.75],PARAMETER[\"standard_parallel_2\",32.75],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",31.75183497],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",77.375],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7763\"]]");
    p = add_epsg_def_ex (filter, first, last, 7764, "epsg", 7764,
        "WGS 84 / Jammu and Kashmir", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.08333333333334 +lat_2=36.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=34.75570874 +lon_0=76.5 +x_0=1000000 +y_0=100");
    add_proj4text (p, 2,
        "0000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Jammu and Kashmir\",GEOGCS[\"WGS 84\",");
    add_srs_wkt (p, 1,
        "DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",33.08333333333334],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",36.41666666666666],PARAMETER[\"latitude_of_origin\",34.");
    add_srs_wkt (p, 10,
        "75570874],PARAMETER[\"central_meridian\",76.5],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",1000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7764\"]]");
    p = add_epsg_def_ex (filter, first, last, 7765, "epsg", 7765,
        "WGS 84 / Jharkhand", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.54166666666667 +lat_2=24.70833333333");
    add_proj4text (p, 1,
        "333 +lat_0=23.62652682 +lon_0=85.625 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Jharkhand\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",22.");
    add_srs_wkt (p, 8,
        "54166666666667],PARAMETER[\"standard_parallel_2\",24.708");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"latitude_of_origin\",23.6265268");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"central_meridian\",85.625],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7765");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7766, "epsg", 7766,
        "WGS 84 / Madhya Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22 +lat_2=26 +lat_0=24.00529821 +lon_0=");
    add_proj4text (p, 1,
        "78.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Madhya Pradesh\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",22],PARAMETER[\"standard_parallel_2\",26],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",24.00529821],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",78.375],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"7766\"]]");
    p = add_epsg_def_ex (filter, first, last, 7767, "epsg", 7767,
        "WGS 84 / Maharashtra", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.625 +lat_2=21.125 +lat_0=18.88015774");
    add_proj4text (p, 1,
        " +lon_0=76.75 +x_0=1000000 +y_0=1000000 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Maharashtra\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",1");
    add_srs_wkt (p, 8,
        "6.625],PARAMETER[\"standard_parallel_2\",21.125],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",18.88015774],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",76.75],PARAMETER[\"false_easting\",1000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7767\"]]");
    p = add_epsg_def_ex (filter, first, last, 7768, "epsg", 7768,
        "WGS 84 / Manipur", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.08333333333333 +lat_2=25.41666666666");
    add_proj4text (p, 1,
        "667 +lat_0=24.75060911 +lon_0=94 +x_0=1000000 +y_0=10000");
    add_proj4text (p, 2,
        "00 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Manipur\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",24.08");
    add_srs_wkt (p, 8,
        "333333333333],PARAMETER[\"standard_parallel_2\",25.41666");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"latitude_of_origin\",24.75060911]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",94],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7768\"]]");
    p = add_epsg_def_ex (filter, first, last, 7769, "epsg", 7769,
        "WGS 84 / Meghalaya", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=25.20833333333333 +lat_2=26.04166666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.62524747 +lon_0=91.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Meghalaya\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",25.");
    add_srs_wkt (p, 8,
        "20833333333333],PARAMETER[\"standard_parallel_2\",26.041");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"latitude_of_origin\",25.6252474");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"central_meridian\",91.375],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7769");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7770, "epsg", 7770,
        "WGS 84 / Nagaland", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=25.375 +lat_2=26.875 +lat_0=26.12581974");
    add_proj4text (p, 1,
        " +lon_0=94.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Nagaland\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",25.3");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"standard_parallel_2\",26.875],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",26.12581974],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",94.375],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7770\"]]");
    p = add_epsg_def_ex (filter, first, last, 7771, "epsg", 7771,
        "WGS 84 / India Northeast", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=23.04166666666667 +lat_2=28.20833333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.63452135 +lon_0=93.5 +x_0=1000000 +y_0=100");
    add_proj4text (p, 2,
        "0000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / India Northeast\",GEOGCS[\"WGS 84\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",23.04166666666667],PARAMETER[\"standard_parallel_2\",28");
    add_srs_wkt (p, 9,
        ".20833333333333],PARAMETER[\"latitude_of_origin\",25.634");
    add_srs_wkt (p, 10,
        "52135],PARAMETER[\"central_meridian\",93.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"77");
    add_srs_wkt (p, 14,
        "71\"]]");
    p = add_epsg_def_ex (filter, first, last, 7772, "epsg", 7772,
        "WGS 84 / Orissa", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.58333333333333 +lat_2=21.91666666666");
    add_proj4text (p, 1,
        "667 +lat_0=20.25305174 +lon_0=84.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Orissa\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",18.5833");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"standard_parallel_2\",21.9166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",20.25305174],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"central_meridian\",84.375],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",1000000],PARAMETER[\"false_northing\",1000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7772\"]]");
    p = add_epsg_def_ex (filter, first, last, 7773, "epsg", 7773,
        "WGS 84 / Punjab", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30 +lat_2=32 +lat_0=31.00178226 +lon_0=");
    add_proj4text (p, 1,
        "75.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Punjab\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",30],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",32],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",31.00178226],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "75.375],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"7773\"]]");
    p = add_epsg_def_ex (filter, first, last, 7774, "epsg", 7774,
        "WGS 84 / Rajasthan", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.29166666666667 +lat_2=29.45833333333");
    add_proj4text (p, 1,
        "333 +lat_0=26.88505546 +lon_0=73.875 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Rajasthan\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",24.");
    add_srs_wkt (p, 8,
        "29166666666667],PARAMETER[\"standard_parallel_2\",29.458");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"latitude_of_origin\",26.8850554");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"central_meridian\",73.875],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1000000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7774");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7775, "epsg", 7775,
        "WGS 84 / Uttar Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.875 +lat_2=29.375 +lat_0=27.13270823");
    add_proj4text (p, 1,
        " +lon_0=80.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Uttar Pradesh\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",24.875],PARAMETER[\"standard_parallel_2\",29.375],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",27.13270823],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",80.875],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7775\"]]");
    p = add_epsg_def_ex (filter, first, last, 7776, "epsg", 7776,
        "WGS 84 / Uttaranchal", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29 +lat_2=31 +lat_0=30.0017132 +lon_0=7");
    add_proj4text (p, 1,
        "9.375 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Uttaranchal\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",2");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"standard_parallel_2\",31],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",30.0017132],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",79.375],PARAMETER[\"false_easting\",1000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"7776\"]]");
    p = add_epsg_def_ex (filter, first, last, 7777, "epsg", 7777,
        "WGS 84 / Andaman and Nicobar", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.25 +lon_0=93.25 +k=0.9999428 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Andaman and Nicobar\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",10.2");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",93.25],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999428],PARAMETER[\"false_easting\",10000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7777\"]]");
    p = add_epsg_def_ex (filter, first, last, 7778, "epsg", 7778,
        "WGS 84 / Chhattisgarh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21 +lon_0=82.25 +k=0.9998332 +x_0=100");
    add_proj4text (p, 1,
        "0000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Chhattisgarh\",GEOGCS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",21],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",82.25],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9998332],PARAMETER[\"false_easting\",1000000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"7778\"]]");
    p = add_epsg_def_ex (filter, first, last, 7779, "epsg", 7779,
        "WGS 84 / Goa", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=15.375 +lon_0=74 +k=0.9999913 +x_0=10");
    add_proj4text (p, 1,
        "00000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Goa\",GEOGCS[\"WGS 84\",DATUM[\"WGS_19");
    add_srs_wkt (p, 1,
        "84\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 7,
        "r\"],PARAMETER[\"latitude_of_origin\",15.375],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",74],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99913],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"7779\"]]");
    p = add_epsg_def_ex (filter, first, last, 7780, "epsg", 7780,
        "WGS 84 / Karnataka", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=15.125 +lon_0=76.375 +k=0.99980119999");
    add_proj4text (p, 1,
        "99999 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Karnataka\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",15.125],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",76.375],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9998012],PARAMETER[\"false_easting\",1000000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"7780\"]]");
    p = add_epsg_def_ex (filter, first, last, 7781, "epsg", 7781,
        "WGS 84 / Kerala", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.5 +lon_0=76 +k=0.9999177 +x_0=1000");
    add_proj4text (p, 1,
        "000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Kerala\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",10.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",76],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99177],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"7781\"]]");
    p = add_epsg_def_ex (filter, first, last, 7782, "epsg", 7782,
        "WGS 84 / Lakshadweep", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10 +lon_0=73.125 +k=0.9999536 +x_0=10");
    add_proj4text (p, 1,
        "00000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Lakshadweep\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",10],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",73.125],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999536],PARAMETER[\"false_easting\",1000000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"7782\"]]");
    p = add_epsg_def_ex (filter, first, last, 7783, "epsg", 7783,
        "WGS 84 / Mizoram", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=23.125 +lon_0=92.75 +k=0.9999821 +x_0");
    add_proj4text (p, 1,
        "=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Mizoram\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",23.125],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",92.75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9999821],PARAMETER[\"false_easting\",1000000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"7783\"]]");
    p = add_epsg_def_ex (filter, first, last, 7784, "epsg", 7784,
        "WGS 84 / Sikkim", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=27.625 +lon_0=88.5 +k=0.9999926 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Sikkim\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",27.625],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",88.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9999926],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"7784\"]]");
    p = add_epsg_def_ex (filter, first, last, 7785, "epsg", 7785,
        "WGS 84 / Tamil Nadu", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=10.875 +lon_0=78.375 +k=0.9997942 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Tamil Nadu\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",10.875],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",78.375],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9997942],PARAMETER[\"false_easting\",1000000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"7785\"]]");
    p = add_epsg_def_ex (filter, first, last, 7786, "epsg", 7786,
        "WGS 84 / Tripura", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=23.75 +lon_0=91.75 +k=0.9999822 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Tripura\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",23.75],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",91.75],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999822],PARAMETER[\"false_easting\",1000000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"7786\"]]");
    p = add_epsg_def_ex (filter, first, last, 7787, "epsg", 7787,
        "WGS 84 / West Bengal", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.375 +lon_0=87.875 +k=0.9998584 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / West Bengal\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",24.375],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",87.875],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9998584],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"7787\"]]");
    p = add_epsg_def_ex (filter, first, last, 7791, "epsg", 7791,
        "RDN2008 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 32N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",9],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7791\"]]");
    p = add_epsg_def_ex (filter, first, last, 7792, "epsg", 7792,
        "RDN2008 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 33N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",15],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"7792\"]]");
    p = add_epsg_def_ex (filter, first, last, 7793, "epsg", 7793,
        "RDN2008 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 34N\",GEOGCS[\"RDN2008\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",21],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"7793\"]]");
    p = add_epsg_def_ex (filter, first, last, 7794, "epsg", 7794,
        "RDN2008 / Italy zone (E-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9985000000000001 +x_");
    add_proj4text (p, 1,
        "0=7000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Italy zone (E-N)\",GEOGCS[\"RDN2008\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",12],PARAMETER[\"scale_factor\",0.9985");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",7000000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7794\"]]");
    p = add_epsg_def_ex (filter, first, last, 7795, "epsg", 7795,
        "RDN2008 / Zone 12 (E-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=3000000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Zone 12 (E-N)\",GEOGCS[\"RDN2008\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",12],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",3000000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7795\"]]");
    p = add_epsg_def_ex (filter, first, last, 7798, "epsg", 7798,
        "BGS2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"BGS2005\",DATUM[\"Bulgaria_Geodetic_System_2005");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"7798\"]]");
    p = add_epsg_def_ex (filter, first, last, 7799, "epsg", 7799,
        "BGS2005 / UTM zone 34N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 34N (N-E)\",GEOGCS[\"BGS2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"7799\"]]");
    p = add_epsg_def_ex (filter, first, last, 7800, "epsg", 7800,
        "BGS2005 / UTM zone 35N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 35N (N-E)\",GEOGCS[\"BGS2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"7800\"]]");
    p = add_epsg_def_ex (filter, first, last, 7801, "epsg", 7801,
        "BGS2005 / CCS2005", 0, 1,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Lambert_Conformal_Conic_2SP", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42 +lat_2=43.33333333333334 +lat_0=42.6");
    add_proj4text (p, 1,
        "6787568333333 +lon_0=25.5 +x_0=500000 +y_0=4725824.3591 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / CCS2005\",GEOGCS[\"BGS2005\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7798\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_1\",42],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 9,
        ",43.33333333333334],PARAMETER[\"latitude_of_origin\",42.");
    add_srs_wkt (p, 10,
        "66787568333333],PARAMETER[\"central_meridian\",25.5],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",4725824.3591],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"7801\"]]");
    p = add_epsg_def_ex (filter, first, last, 7803, "epsg", 7803,
        "BGS2005 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 34N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7798\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",21],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7803\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7804, "epsg", 7804,
        "BGS2005 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 35N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7798\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",21],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7804\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7805, "epsg", 7805,
        "BGS2005 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 36N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7798\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",33],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7805\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7825, "epsg", 7825,
        "Pulkovo 1942 / CS63 zone X1", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=23.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=1300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X1\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",23.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",1300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7825\"]]");
    p = add_epsg_def_ex (filter, first, last, 7826, "epsg", 7826,
        "Pulkovo 1942 / CS63 zone X2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=26.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X2\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",26.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7826\"]]");
    p = add_epsg_def_ex (filter, first, last, 7827, "epsg", 7827,
        "Pulkovo 1942 / CS63 zone X3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=29.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X3\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",29.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",3300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7827\"]]");
    p = add_epsg_def_ex (filter, first, last, 7828, "epsg", 7828,
        "Pulkovo 1942 / CS63 zone X4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=32.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X4\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",32.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",4300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7828\"]]");
    p = add_epsg_def_ex (filter, first, last, 7829, "epsg", 7829,
        "Pulkovo 1942 / CS63 zone X5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=35.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=5300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X5\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",35.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",5300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7829\"]]");
    p = add_epsg_def_ex (filter, first, last, 7830, "epsg", 7830,
        "Pulkovo 1942 / CS63 zone X6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=38.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=6300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X6\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",38.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",6300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7830\"]]");
    p = add_epsg_def_ex (filter, first, last, 7831, "epsg", 7831,
        "Pulkovo 1942 / CS63 zone X7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0.08333333333333333 +lon_0=41.5 +k=1 ");
    add_proj4text (p, 1,
        "+x_0=7300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,");
    add_proj4text (p, 2,
        "-80.9,0,0.35,0.82,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / CS63 zone X7\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassowsky 1940");
    add_srs_wkt (p, 2,
        "\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[2");
    add_srs_wkt (p, 3,
        "3.92,-141.27,-80.9,0,0.35,0.82,-0.12],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        ".08333333333333333],PARAMETER[\"central_meridian\",41.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",7300000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"7831\"]]");
    p = add_epsg_def_ex (filter, first, last, 7844, "epsg", 7844,
        "GDA2020", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDA2020\",DATUM[\"Geocentric_Datum_of_Australia");
    add_srs_wkt (p, 1,
        "_2020\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1168\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"7844\"]]");
    p = add_epsg_def_ex (filter, first, last, 7845, "epsg", 7845,
        "GDA2020 / GA LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / GA LCC\",GEOGCS[\"GDA2020\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "eocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7844\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",-18],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",-36],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",134],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7845\"]]");
    p = add_epsg_def_ex (filter, first, last, 7846, "epsg", 7846,
        "GDA2020 / MGA zone 46", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 46\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",93");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7846\"]]");
    p = add_epsg_def_ex (filter, first, last, 7847, "epsg", 7847,
        "GDA2020 / MGA zone 47", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 47\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",99");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7847\"]]");
    p = add_epsg_def_ex (filter, first, last, 7848, "epsg", 7848,
        "GDA2020 / MGA zone 48", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 48\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7848\"]]");
    p = add_epsg_def_ex (filter, first, last, 7849, "epsg", 7849,
        "GDA2020 / MGA zone 49", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 49\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7849\"]]");
    p = add_epsg_def_ex (filter, first, last, 7850, "epsg", 7850,
        "GDA2020 / MGA zone 50", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 50\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7850\"]]");
    p = add_epsg_def_ex (filter, first, last, 7851, "epsg", 7851,
        "GDA2020 / MGA zone 51", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 51\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7851\"]]");
    p = add_epsg_def_ex (filter, first, last, 7852, "epsg", 7852,
        "GDA2020 / MGA zone 52", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 52\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7852\"]]");
    p = add_epsg_def_ex (filter, first, last, 7853, "epsg", 7853,
        "GDA2020 / MGA zone 53", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 53\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7853\"]]");
    p = add_epsg_def_ex (filter, first, last, 7854, "epsg", 7854,
        "GDA2020 / MGA zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 54\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7854\"]]");
    p = add_epsg_def_ex (filter, first, last, 7855, "epsg", 7855,
        "GDA2020 / MGA zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 55\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7855\"]]");
    p = add_epsg_def_ex (filter, first, last, 7856, "epsg", 7856,
        "GDA2020 / MGA zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 56\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7856\"]]");
    p = add_epsg_def_ex (filter, first, last, 7857, "epsg", 7857,
        "GDA2020 / MGA zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 57\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7857\"]]");
    p = add_epsg_def_ex (filter, first, last, 7858, "epsg", 7858,
        "GDA2020 / MGA zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 58\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7858\"]]");
    p = add_epsg_def_ex (filter, first, last, 7859, "epsg", 7859,
        "GDA2020 / MGA zone 59", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 59\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",17");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7859\"]]");
    p = add_epsg_def_ex (filter, first, last, 7877, "epsg", 7877,
        "Astro DOS 71 / SHLG71", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-15.96666666666667 +lon_0=-5.71666666");
    add_proj4text (p, 1,
        "6666667 +k=1 +x_0=300000 +y_0=2000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=-320,550,-494,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Astro DOS 71 / SHLG71\",GEOGCS[\"Astro DOS 71\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Astro_DOS_71\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-320,5");
    add_srs_wkt (p, 3,
        "50,-494,0,0,0,0],AUTHORITY[\"EPSG\",\"6710\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4710\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",-15.96666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-5.716666666666667],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",2000000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7877\"]]");
    p = add_epsg_def_ex (filter, first, last, 7878, "epsg", 7878,
        "Astro DOS 71 / UTM zone 30S", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=intl +towgs84=-320,550,");
    add_proj4text (p, 1,
        "-494,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Astro DOS 71 / UTM zone 30S\",GEOGCS[\"Astro DO");
    add_srs_wkt (p, 1,
        "S 71\",DATUM[\"Astro_DOS_71\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-320,550,-494,0,0,0,0],AUTHORITY[\"EPSG\",\"6710\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4710\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-3],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"7878\"]]");
    p = add_epsg_def_ex (filter, first, last, 7881, "epsg", 7881,
        "St. Helena Tritan", 1, 1,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-0.077,0.079,0.086,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Helena Tritan\",DATUM[\"St_Helena_Tritan\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7030\"]],TOWGS84[-0.077,0.079,0.086,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1173\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7881\"]]");
    p = add_epsg_def_ex (filter, first, last, 7882, "epsg", 7882,
        "St. Helena Tritan / SHLG(Tritan)", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-15.96666666666667 +lon_0=-5.71666666");
    add_proj4text (p, 1,
        "6666667 +k=1 +x_0=299483.737 +y_0=2000527.879 +ellps=WGS");
    add_proj4text (p, 2,
        "84 +towgs84=-0.077,0.079,0.086,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Helena Tritan / SHLG(Tritan)\",GEOGCS[\"St.");
    add_srs_wkt (p, 1,
        " Helena Tritan\",DATUM[\"St_Helena_Tritan\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-0.077,0.079,0.086,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1173\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"7881\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 9,
        "15.96666666666667],PARAMETER[\"central_meridian\",-5.716");
    add_srs_wkt (p, 10,
        "666666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",299483.737],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",2000527.879],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"7882\"]]");
    p = add_epsg_def_ex (filter, first, last, 7883, "epsg", 7883,
        "St. Helena Tritan / UTM zone 30S", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS84 +towgs84=-0.077,0");
    add_proj4text (p, 1,
        ".079,0.086,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Helena Tritan / UTM zone 30S\",GEOGCS[\"St.");
    add_srs_wkt (p, 1,
        " Helena Tritan\",DATUM[\"St_Helena_Tritan\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-0.077,0.079,0.086,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1173\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"7881\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7883\"]]");
    p = add_epsg_def_ex (filter, first, last, 7886, "epsg", 7886,
        "SHGD2015", 1, 1,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SHGD2015\",DATUM[\"St_Helena_Geodetic_Datum_201");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1174\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"7886\"]]");
    p = add_epsg_def_ex (filter, first, last, 7887, "epsg", 7887,
        "SHMG2015", 0, 0,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SHMG2015\",GEOGCS[\"SHGD2015\",DATUM[\"St_Helen");
    add_srs_wkt (p, 1,
        "a_Geodetic_Datum_2015\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1174\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"7886\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7887\"]]");
    p = add_epsg_def_ex (filter, first, last, 7899, "epsg", 7899,
        "GDA2020 / Vicgrid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x");
    add_proj4text (p, 1,
        "_0=2500000 +y_0=2500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / Vicgrid\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7844\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",-36],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",-38],PARAMETER[\"latitude_of_origin\",-37],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",145],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2500000],PARAMETER[\"false_northing\",2500000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"789");
    add_srs_wkt (p, 14,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 7954, "epsg", 7954,
        "Astro DOS 71 / UTM zone 30S", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=intl +towgs84=-320,550,");
    add_proj4text (p, 1,
        "-494,0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Astro DOS 71 / UTM zone 30S + Jamestown 1971 ");
    add_srs_wkt (p, 1,
        "height\",PROJCS[\"Astro DOS 71 / UTM zone 30S\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "Astro DOS 71\",DATUM[\"Astro_DOS_71\",SPHEROID[\"Interna");
    add_srs_wkt (p, 3,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[-320,550,-494,0,0,0,0],AUTHORITY[\"EPSG\",\"6710");
    add_srs_wkt (p, 5,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 6,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 8,
        "AST],AUTHORITY[\"EPSG\",\"4710\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 9,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-3],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7878\"]],VERT_CS[\"Jamest");
    add_srs_wkt (p, 15,
        "own 1971 height\",VERT_DATUM[\"Jamestown 1971\",2005,AUT");
    add_srs_wkt (p, 16,
        "HORITY[\"EPSG\",\"1175\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 18,
        "888\"]],AUTHORITY[\"EPSG\",\"7954\"]]");
    p = add_epsg_def_ex (filter, first, last, 7955, "epsg", 7955,
        "St. Helena Tritan / UTM zone 30S", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS84 +towgs84=-0.077,0");
    add_proj4text (p, 1,
        ".079,0.086,0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"St. Helena Tritan / UTM zone 30S +  Tritan 20");
    add_srs_wkt (p, 1,
        "11 height\",PROJCS[\"St. Helena Tritan / UTM zone 30S\",");
    add_srs_wkt (p, 2,
        "GEOGCS[\"St. Helena Tritan\",DATUM[\"St_Helena_Tritan\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7030\"]],TOWGS84[-0.077,0.079,0.086,0,0,0,0],AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"1173\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 8,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7881\"]],");
    add_srs_wkt (p, 9,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 10,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-3],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7883");
    add_srs_wkt (p, 15,
        "\"]],VERT_CS[\"St. Helena Tritan 2011 height\",VERT_DATU");
    add_srs_wkt (p, 16,
        "M[\"St. Helena Tritan Vertical Datum 2011\",2005,AUTHORI");
    add_srs_wkt (p, 17,
        "TY[\"EPSG\",\"1176\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"7889\"");
    add_srs_wkt (p, 19,
        "]],AUTHORITY[\"EPSG\",\"7955\"]]");
    p = add_epsg_def_ex (filter, first, last, 7956, "epsg", 7956,
        "SHMG2015", 0, 0,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SHMG2015 +  SHVD2015 height\",PROJCS[\"SHMG20");
    add_srs_wkt (p, 1,
        "15\",GEOGCS[\"SHGD2015\",DATUM[\"St_Helena_Geodetic_Datu");
    add_srs_wkt (p, 2,
        "m_2015\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1174\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7886\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",-3],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",10000000],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7887\"");
    add_srs_wkt (p, 14,
        "]],VERT_CS[\"SHVD2015 height\",VERT_DATUM[\"St. Helena V");
    add_srs_wkt (p, 15,
        "ertical Datum 2015\",2005,AUTHORITY[\"EPSG\",\"1177\"]],");
    add_srs_wkt (p, 16,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up");
    add_srs_wkt (p, 17,
        "\",UP],AUTHORITY[\"EPSG\",\"7890\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 18,
        "\"7956\"]]");
    p = add_epsg_def_ex (filter, first, last, 20004, "epsg", 20004,
        "Pulkovo 1995 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",4500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20004\"]]");
    p = add_epsg_def_ex (filter, first, last, 20005, "epsg", 20005,
        "Pulkovo 1995 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",5500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20005\"]]");
    p = add_epsg_def_ex (filter, first, last, 20006, "epsg", 20006,
        "Pulkovo 1995 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",6500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20006\"]]");
    p = add_epsg_def_ex (filter, first, last, 20007, "epsg", 20007,
        "Pulkovo 1995 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",7500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20007\"]]");
    p = add_epsg_def_ex (filter, first, last, 20008, "epsg", 20008,
        "Pulkovo 1995 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",8500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20008\"]]");
    p = add_epsg_def_ex (filter, first, last, 20009, "epsg", 20009,
        "Pulkovo 1995 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",9500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"20009\"]]");
    p = add_epsg_def_ex (filter, first, last, 20010, "epsg", 20010,
        "Pulkovo 1995 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",10500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20010\"]]");
    p = add_epsg_def_ex (filter, first, last, 20011, "epsg", 20011,
        "Pulkovo 1995 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",63],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",11500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20011\"]]");
    p = add_epsg_def_ex (filter, first, last, 20012, "epsg", 20012,
        "Pulkovo 1995 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",69],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",12500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20012\"]]");
    p = add_epsg_def_ex (filter, first, last, 20013, "epsg", 20013,
        "Pulkovo 1995 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",13500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20013\"]]");
    p = add_epsg_def_ex (filter, first, last, 20014, "epsg", 20014,
        "Pulkovo 1995 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",14500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20014\"]]");
    p = add_epsg_def_ex (filter, first, last, 20015, "epsg", 20015,
        "Pulkovo 1995 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",15500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20015\"]]");
    p = add_epsg_def_ex (filter, first, last, 20016, "epsg", 20016,
        "Pulkovo 1995 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",16500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20016\"]]");
    p = add_epsg_def_ex (filter, first, last, 20017, "epsg", 20017,
        "Pulkovo 1995 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",17500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20017\"]]");
    p = add_epsg_def_ex (filter, first, last, 20018, "epsg", 20018,
        "Pulkovo 1995 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",18500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20018\"]]");
    p = add_epsg_def_ex (filter, first, last, 20019, "epsg", 20019,
        "Pulkovo 1995 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",19500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20019\"]]");
    p = add_epsg_def_ex (filter, first, last, 20020, "epsg", 20020,
        "Pulkovo 1995 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",20500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20020\"]]");
    p = add_epsg_def_ex (filter, first, last, 20021, "epsg", 20021,
        "Pulkovo 1995 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",123],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",21500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20021\"]]");
    p = add_epsg_def_ex (filter, first, last, 20022, "epsg", 20022,
        "Pulkovo 1995 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",129],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",22500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20022\"]]");
    p = add_epsg_def_ex (filter, first, last, 20023, "epsg", 20023,
        "Pulkovo 1995 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",23500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20023\"]]");
    p = add_epsg_def_ex (filter, first, last, 20024, "epsg", 20024,
        "Pulkovo 1995 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",141],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",24500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20024\"]]");
    p = add_epsg_def_ex (filter, first, last, 20025, "epsg", 20025,
        "Pulkovo 1995 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",147],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",25500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20025\"]]");
    p = add_epsg_def_ex (filter, first, last, 20026, "epsg", 20026,
        "Pulkovo 1995 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",153],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",26500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20026\"]]");
    p = add_epsg_def_ex (filter, first, last, 20027, "epsg", 20027,
        "Pulkovo 1995 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",159],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",27500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20027\"]]");
    p = add_epsg_def_ex (filter, first, last, 20028, "epsg", 20028,
        "Pulkovo 1995 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",165],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",28500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20028\"]]");
    p = add_epsg_def_ex (filter, first, last, 20029, "epsg", 20029,
        "Pulkovo 1995 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",171],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",29500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20029\"]]");
    p = add_epsg_def_ex (filter, first, last, 20030, "epsg", 20030,
        "Pulkovo 1995 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",177],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",30500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20030\"]]");
    p = add_epsg_def_ex (filter, first, last, 20031, "epsg", 20031,
        "Pulkovo 1995 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",-177],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",31500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20031\"]]");
    p = add_epsg_def_ex (filter, first, last, 20032, "epsg", 20032,
        "Pulkovo 1995 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",-171],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",32500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20032\"]]");
    p = add_epsg_def_ex (filter, first, last, 20064, "epsg", 20064,
        "Pulkovo 1995 / Gauss-Kruger 4N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 4N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",21],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20064\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

