/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_34 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6835, "epsg", 6835,
        "NAD83(2011) / Oregon La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=39999.");
    add_proj4text (p, 1,
        "99999984 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon La Grande zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-118],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.00013],PARAMETER[\"false_easting\",131233.5958");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6835\"]]");
    p = add_epsg_def_ex (filter, first, last, 6836, "epsg", 6836,
        "NAD83(CORS96) / Oregon Ontario zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Ontario zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",43.25],PARAMETER[\"central_meridian\",-117],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.0001],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "80000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6836\"]]");
    p = add_epsg_def_ex (filter, first, last, 6837, "epsg", 6837,
        "NAD83(CORS96) / Oregon Ontario zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Ontario zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operatin");
    add_srs_wkt (p, 2,
        "g_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",43.25],PARAMETER[\"central_meridian\",-117],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.0001],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "262467.1916],PARAMETER[\"false_northing\",0],UNIT[\"foot");
    add_srs_wkt (p, 12,
        "\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6837\"]]");
    p = add_epsg_def_ex (filter, first, last, 6838, "epsg", 6838,
        "NAD83(2011) / Oregon Ontario zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ontario zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.25],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-117],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.0001],PARAMETER[\"false_easting\",80000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6838\"]]");
    p = add_epsg_def_ex (filter, first, last, 6839, "epsg", 6839,
        "NAD83(2011) / Oregon Ontario zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.25 +lon_0=-117 +k=1.0001 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ontario zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.25]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-117],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1.0001],PARAMETER[\"false_easting\",262467.1916");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6839\"]]");
    p = add_epsg_def_ex (filter, first, last, 6840, "epsg", 6840,
        "NAD83(CORS96) / Oregon Coast zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-300000 +y_0=-4600000 +no_uoff +gamma=5 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Coast zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_of_cen");
    add_srs_wkt (p, 9,
        "ter\",44.75],PARAMETER[\"longitude_of_center\",-124.05],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"azimuth\",5],PARAMETER[\"rectified_grid_angl");
    add_srs_wkt (p, 11,
        "e\",5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",-300000],PARAMETER[\"false_northing\",-4600000]");
    add_srs_wkt (p, 13,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6840\"]]");
    p = add_epsg_def_ex (filter, first, last, 6841, "epsg", 6841,
        "NAD83(CORS96) / Oregon Coast zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-299999.9999988 +y_0=-4600000.00001208 +no_uoff +gamma");
    add_proj4text (p, 2,
        "=5 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Coast zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_of_c");
    add_srs_wkt (p, 9,
        "enter\",44.75],PARAMETER[\"longitude_of_center\",-124.05");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"azimuth\",5],PARAMETER[\"rectified_grid_an");
    add_srs_wkt (p, 11,
        "gle\",5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",-984251.9685],PARAMETER[\"false_northing\",-1");
    add_srs_wkt (p, 13,
        "5091863.5171],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"6841\"]]");
    p = add_epsg_def_ex (filter, first, last, 6842, "epsg", 6842,
        "NAD83(2011) / Oregon Coast zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-300000 +y_0=-4600000 +no_uoff +gamma=5 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Hotine_O");
    add_srs_wkt (p, 8,
        "blique_Mercator\"],PARAMETER[\"latitude_of_center\",44.7");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"longitude_of_center\",-124.05],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"azimuth\",5],PARAMETER[\"rectified_grid_angle\",5],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",-");
    add_srs_wkt (p, 12,
        "300000],PARAMETER[\"false_northing\",-4600000],UNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6842\"]]");
    p = add_epsg_def_ex (filter, first, last, 6843, "epsg", 6843,
        "NAD83(2011) / Oregon Coast zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=44.75 +lonc=-124.05 +alpha=5 +k=1 +x_");
    add_proj4text (p, 1,
        "0=-299999.9999988 +y_0=-4600000.00001208 +no_uoff +gamma");
    add_proj4text (p, 2,
        "=5 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Hotine_O");
    add_srs_wkt (p, 8,
        "blique_Mercator\"],PARAMETER[\"latitude_of_center\",44.7");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"longitude_of_center\",-124.05],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"azimuth\",5],PARAMETER[\"rectified_grid_angle\",5],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",-");
    add_srs_wkt (p, 12,
        "984251.9685],PARAMETER[\"false_northing\",-15091863.5171");
    add_srs_wkt (p, 13,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"684");
    add_srs_wkt (p, 15,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 6844, "epsg", 6844,
        "NAD83(CORS96) / Oregon Pendleton zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton zone (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",45.25],PARAMETER[\"central_meridian\",-119.166666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"scale_factor\",1.000045],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",60000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6844\"]]");
    p = add_epsg_def_ex (filter, first, last, 6845, "epsg", 6845,
        "NAD83(CORS96) / Oregon Pendleton zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=59999.99999976 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton zone (ft)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",45.25],PARAMETER[\"central_meridian\",-119.16666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"scale_factor\",1.000045],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",196850.3937],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6845\"]]");
    p = add_epsg_def_ex (filter, first, last, 6846, "epsg", 6846,
        "NAD83(2011) / Oregon Pendleton zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.2");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",-119.1666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1.000045],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",60000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6846\"]]");
    p = add_epsg_def_ex (filter, first, last, 6847, "epsg", 6847,
        "NAD83(2011) / Oregon Pendleton zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-119.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=59999.99999976 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45.2");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",-119.1666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1.000045],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",196850.3937],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6847\"]]");
    p = add_epsg_def_ex (filter, first, last, 6848, "epsg", 6848,
        "NAD83(CORS96) / Oregon Pendleton-La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton-La Grande zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",45.08333333333334],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-118.3333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1.000175],PARAMETER[\"false_easting\",30000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"6848\"]]");
    p = add_epsg_def_ex (filter, first, last, 6849, "epsg", 6849,
        "NAD83(CORS96) / Oregon Pendleton-La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000.00001512 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Pendleton-La Grande zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",45.08333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-118.3333333333333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",1.000175],PARAMETER[\"false_easting\",98425.1969],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6849\"]]");
    p = add_epsg_def_ex (filter, first, last, 6850, "epsg", 6850,
        "NAD83(2011) / Oregon Pendleton-La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton-La Grande zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",45.08333333333334],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 10,
        "118.3333333333333],PARAMETER[\"scale_factor\",1.000175],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",30000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6850\"]]");
    p = add_epsg_def_ex (filter, first, last, 6851, "epsg", 6851,
        "NAD83(2011) / Oregon Pendleton-La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.08333333333334 +lon_0=-118.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000175 +x_0=30000.00001512 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pendleton-La Grande zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",45.08333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-118.3333333333333],PARAMETER[\"scale_factor\",1.000175");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",98425.1969],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"6851\"]]");
    p = add_epsg_def_ex (filter, first, last, 6852, "epsg", 6852,
        "NAD83(CORS96) / Oregon Portland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=100000 +y_0=50000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Portland zone (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operatin");
    add_srs_wkt (p, 2,
        "g_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",45.5],PARAMETER[\"central_meridian\",-122.7");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1.000002],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",100000],PARAMETER[\"false_northing\",50000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6852\"]]");
    p = add_epsg_def_ex (filter, first, last, 6853, "epsg", 6853,
        "NAD83(CORS96) / Oregon Portland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=99999.99999960001 +y_0=50000.00001504 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Portland zone (ft)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",45.5],PARAMETER[\"central_meridian\",-122");
    add_srs_wkt (p, 10,
        ".75],PARAMETER[\"scale_factor\",1.000002],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",328083.9895],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "164041.9948],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6853\"]]");
    p = add_epsg_def_ex (filter, first, last, 6854, "epsg", 6854,
        "NAD83(2011) / Oregon Portland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=100000 +y_0=50000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Portland zone (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",45.5],PARAMETER[\"central_meridian\",-122.75],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1.000002],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "100000],PARAMETER[\"false_northing\",50000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6854\"]]");
    p = add_epsg_def_ex (filter, first, last, 6855, "epsg", 6855,
        "NAD83(2011) / Oregon Portland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_0=45.5 +lon_0=-122.75 +k_0=1.");
    add_proj4text (p, 1,
        "000002 +x_0=99999.99999960001 +y_0=50000.00001504 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Portland zone (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",45.5],PARAMETER[\"central_meridian\",-122.75],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1.000002],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",328083.9895],PARAMETER[\"false_northing\",164041.9948");
    add_srs_wkt (p, 12,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"685");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 6856, "epsg", 6856,
        "NAD83(CORS96) / Oregon Salem zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000 +y_0=0 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Salem zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",44.33333333333334],PARAMETER[\"central_meridian\",-123.");
    add_srs_wkt (p, 10,
        "0833333333333],PARAMETER[\"scale_factor\",1.00001],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",50000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"685");
    add_srs_wkt (p, 14,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 6857, "epsg", 6857,
        "NAD83(CORS96) / Oregon Salem zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000.00001504 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Salem zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",44.33333333333334],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "23.0833333333333],PARAMETER[\"scale_factor\",1.00001],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",164041.9948],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6857\"]]");
    p = add_epsg_def_ex (filter, first, last, 6858, "epsg", 6858,
        "NAD83(2011) / Oregon Salem zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000 +y_0=0 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Salem zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.33333");
    add_srs_wkt (p, 9,
        "333333334],PARAMETER[\"central_meridian\",-123.083333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"scale_factor\",1.00001],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",50000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6858\"]]");
    p = add_epsg_def_ex (filter, first, last, 6859, "epsg", 6859,
        "NAD83(2011) / Oregon Salem zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.33333333333334 +lon_0=-123.0833333");
    add_proj4text (p, 1,
        "333333 +k=1.00001 +x_0=50000.00001504 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Salem zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.33333");
    add_srs_wkt (p, 9,
        "333333334],PARAMETER[\"central_meridian\",-123.083333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"scale_factor\",1.00001],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",164041.9948],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 14,
        "59\"]]");
    p = add_epsg_def_ex (filter, first, last, 6860, "epsg", 6860,
        "NAD83(CORS96) / Oregon Santiam Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Santiam Pass zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 2,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",44.08333333333334],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-122.5],PARAMETER[\"scale_factor\",1.000155],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6860\"]]");
    p = add_epsg_def_ex (filter, first, last, 6861, "epsg", 6861,
        "NAD83(CORS96) / Oregon Santiam Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Santiam Pass zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Ope");
    add_srs_wkt (p, 2,
        "rating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",44.08333333333334],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-122.5],PARAMETER[\"scale_factor\",1.000155],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",0],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6861");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6862, "epsg", 6862,
        "NAD83(2011) / Oregon Santiam Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Santiam Pass zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 9,
        "4.08333333333334],PARAMETER[\"central_meridian\",-122.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1.000155],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6862\"]]");
    p = add_epsg_def_ex (filter, first, last, 6863, "epsg", 6863,
        "NAD83(2011) / Oregon Santiam Pass (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.08333333333334 +lon_0=-122.5 +k=1.");
    add_proj4text (p, 1,
        "000155 +x_0=0 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Santiam Pass (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.083");
    add_srs_wkt (p, 9,
        "33333333334],PARAMETER[\"central_meridian\",-122.5],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.000155],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.");
    add_srs_wkt (p, 12,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6863\"]]");
    p = add_epsg_def_ex (filter, first, last, 6867, "epsg", 6867,
        "NAD83(CORS96) / Oregon LCC (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon LCC (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Referenc");
    add_srs_wkt (p, 2,
        "e_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",43],PARAMETER[\"standard_parallel_2\",45.5],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"latitude_of_origin\",41.75],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-120.5],PARAMETER[\"false_easting\",400000],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6867\"]]");
    p = add_epsg_def_ex (filter, first, last, 6868, "epsg", 6868,
        "NAD83(CORS96) / Oregon GIC Lambert (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120");
    add_proj4text (p, 1,
        ".5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +units=ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon GIC Lambert (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",43],PARAMETER[\"standard_parallel_2\",45.5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",41.75],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-120.5],PARAMETER[\"false_easting\",131");
    add_srs_wkt (p, 12,
        "2335.958],PARAMETER[\"false_northing\",0],UNIT[\"foot\",");
    add_srs_wkt (p, 13,
        "0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6868\"]]");
    p = add_epsg_def_ex (filter, first, last, 6870, "epsg", 6870,
        "ETRS89 / Albania TM 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Albania TM 2010\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",20],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"6870\"]]");
    p = add_epsg_def_ex (filter, first, last, 6871, "epsg", 6871,
        "WGS 84 / Pseudo-Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +geoidgrids=egm08_25.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 / Pseudo-Mercator +  EGM2008 geoid hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 2,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"M");
    add_srs_wkt (p, 8,
        "ercator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "EXTENSION[\"PROJ4\",\"+proj=merc +a=6378137 +b=6378137 +");
    add_srs_wkt (p, 13,
        "lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +n");
    add_srs_wkt (p, 14,
        "adgrids=@null +wktext +no_defs\"],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "857\"]],VERT_CS[\"EGM2008 geoid height\",VERT_DATUM[\"EG");
    add_srs_wkt (p, 16,
        "M2008 geoid\",2005,EXTENSION[\"PROJ4_GRIDS\",\"egm08_25.");
    add_srs_wkt (p, 17,
        "gtx\"],AUTHORITY[\"EPSG\",\"1027\"]],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"3855\"]],AUTHORITY[\"EPSG\",\"6871\"]]");
    p = add_epsg_def_ex (filter, first, last, 6875, "epsg", 6875,
        "RDN2008 / Italy zone (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9985000000000001 +x_");
    add_proj4text (p, 1,
        "0=7000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Italy zone (N-E)\",GEOGCS[\"RDN2008\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",12],PARAMETER[\"scale_factor\",0.9985");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",7000000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6875\"]]");
    p = add_epsg_def_ex (filter, first, last, 6876, "epsg", 6876,
        "RDN2008 / Zone 12 (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=3000000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / Zone 12 (N-E)\",GEOGCS[\"RDN2008\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",12],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",3000000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6876\"]]");
    p = add_epsg_def_ex (filter, first, last, 6879, "epsg", 6879,
        "NAD83(2011) / Wisconsin Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Wisconsin Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_2\",44.25],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",43.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-90],PARAMETER[\"false_easting\",600000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"6879\"]]");
    p = add_epsg_def_ex (filter, first, last, 6880, "epsg", 6880,
        "NAD83(2011) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",43],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",40],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",39.83333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-100],PARAMETER[\"false_easting\",1640416.6667],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6880\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6881, "epsg", 6881,
        "Aden 1925", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Aden_1925", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-24,-203,268,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Aden 1925\",DATUM[\"Aden_1925\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7012\"]],TOWGS84[-24,-203,268,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1135\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6881\"]]");
    p = add_epsg_def_ex (filter, first, last, 6882, "epsg", 6882,
        "Bekaa Valley 1920", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Bekaa_Valley_1920", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-183,-15,273,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bekaa Valley 1920\",DATUM[\"Bekaa_Valley_1920\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7012\"]],TOWGS84[-183,-15,273,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1137\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 6,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6882\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6883, "epsg", 6883,
        "Bioko", 1, 1,
        "International 1924", "Greenwich",
        "Bioko", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-235,-110,393,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bioko\",DATUM[\"Bioko\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 2,
        "84[-235,-110,393,0,0,0,0],AUTHORITY[\"EPSG\",\"1136\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"6883\"]]");
    p = add_epsg_def_ex (filter, first, last, 6884, "epsg", 6884,
        "NAD83(CORS96) / Oregon North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",46],PARAMETER[\"standard_parallel_2\",44.33333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",43.66666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-120.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6884\"]]");
    p = add_epsg_def_ex (filter, first, last, 6885, "epsg", 6885,
        "NAD83(CORS96) / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",46],PARAMETER[\"standard_parallel_2\",44.3333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"latitude_of_origin\",43.66666666666");
    add_srs_wkt (p, 11,
        "666],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",8202099.738],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "885\"]]");
    p = add_epsg_def_ex (filter, first, last, 6886, "epsg", 6886,
        "NAD83(CORS96) / Oregon South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South\",GEOGCS[\"NAD83(C");
    add_srs_wkt (p, 1,
        "ORS96)\",DATUM[\"NAD83_Continuously_Operating_Reference_");
    add_srs_wkt (p, 2,
        "Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "33\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",44],PARAMETER[\"standard_parallel_2\",42.33333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",41.66666666666666],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-120.5],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",1500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6886\"]]");
    p = add_epsg_def_ex (filter, first, last, 6887, "epsg", 6887,
        "NAD83(CORS96) / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_Refer");
    add_srs_wkt (p, 2,
        "ence_Station_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",44],PARAMETER[\"standard_parallel_2\",42.3333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 11,
        "666],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",4921259.843],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "887\"]]");
    p = add_epsg_def_ex (filter, first, last, 6892, "epsg", 6892,
        "South East Island 1943", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "South_East_Island_1943", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-43.685,-179.785,-2");
    add_proj4text (p, 1,
        "67.721,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"South East Island 1943\",DATUM[\"South_East_Isl");
    add_srs_wkt (p, 1,
        "and_1943\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-43.685,-179");
    add_srs_wkt (p, 3,
        ".785,-267.721,0,0,0,0],AUTHORITY[\"EPSG\",\"1138\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6892\"]]");
    p = add_epsg_def_ex (filter, first, last, 6893, "epsg", 6893,
        "WGS 84 / World Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +uni");
    add_proj4text (p, 1,
        "ts=m +geoidgrids=egm08_25.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 / World Mercator +  EGM2008 height\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 2,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator");
    add_srs_wkt (p, 8,
        "_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3395\"]],VERT_CS[\"EGM2008 ge");
    add_srs_wkt (p, 13,
        "oid height\",VERT_DATUM[\"EGM2008 geoid\",2005,EXTENSION");
    add_srs_wkt (p, 14,
        "[\"PROJ4_GRIDS\",\"egm08_25.gtx\"],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "1027\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 16,
        "AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"3855\"]],AUTHORITY[");
    add_srs_wkt (p, 17,
        "\"EPSG\",\"6893\"]]");
    p = add_epsg_def_ex (filter, first, last, 6894, "epsg", 6894,
        "Gambia", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Gambia", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-63,176,185,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gambia\",DATUM[\"Gambia\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-63,176,185,0,0,0,0],AUTHORITY[\"EPSG\",\"113");
    add_srs_wkt (p, 3,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"6894\"]]");
    p = add_epsg_def_ex (filter, first, last, 6915, "epsg", 6915,
        "South East Island 1943 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "South_East_Island_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-43.685,-179.7");
    add_proj4text (p, 1,
        "85,-267.721,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South East Island 1943 / UTM zone 40N\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"South East Island 1943\",DATUM[\"South_East_Island_194");
    add_srs_wkt (p, 2,
        "3\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-43.685,-179.785,-2");
    add_srs_wkt (p, 4,
        "67.721,0,0,0,0],AUTHORITY[\"EPSG\",\"1138\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 7,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"6892\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 10,
        "meridian\",57],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6915\"]]");
    p = add_epsg_def_ex (filter, first, last, 6917, "epsg", 6917,
        "SVY21", 1, 1,
        "WGS 84", "Greenwich",
        "SVY21", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SVY21 + SHD height\",GEOGCS[\"SVY21\",DATUM[\"");
    add_srs_wkt (p, 1,
        "SVY21\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4757\"]],VERT_CS[\"SHD height\",VERT_D");
    add_srs_wkt (p, 7,
        "ATUM[\"Singapore Height Datum\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 8,
        "\"1140\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 9,
        "],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"6916\"]],AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"6917\"]]");
    p = add_epsg_def_ex (filter, first, last, 6922, "epsg", 6922,
        "NAD83 / Kansas LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas LCC\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",39.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",37.5],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 10,
        "in\",36],PARAMETER[\"central_meridian\",-98.25],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",400000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6922\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6923, "epsg", 6923,
        "NAD83 / Kansas LCC (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas LCC (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",39.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",37.5],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",36],PARAMETER[\"central_meridian\",-98.25],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",1312333.3333],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6923\"]]");
    p = add_epsg_def_ex (filter, first, last, 6924, "epsg", 6924,
        "NAD83(2011) / Kansas LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Kansas LCC\",GEOGCS[\"NAD83(2011)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_National_Spatial_Reference_System_2011\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",39.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",37.5],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",36],PARAMETER[\"central_meridian\",-98.25],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",400000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6924\"]]");
    p = add_epsg_def_ex (filter, first, last, 6925, "epsg", 6925,
        "NAD83(2011) / Kansas LCC (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_2=37.5 +lat_0=36 +lon_0=-98.2");
    add_proj4text (p, 1,
        "5 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Kansas LCC (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_2\",37.5],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",36],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 11,
        "98.25],PARAMETER[\"false_easting\",1312333.3333],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6925\"]]");
    p = add_epsg_def_ex (filter, first, last, 6927, "epsg", 6927,
        "SVY21 / Singapore TM", 0, 1,
        "WGS 84", "Greenwich",
        "SVY21", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.83333333");
    add_proj4text (p, 1,
        "33333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SVY21 / Singapore TM + SHD height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "SVY21 / Singapore TM\",GEOGCS[\"SVY21\",DATUM[\"SVY21\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6757\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4757\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",1.366666666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",103.8333333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",28001.64");
    add_srs_wkt (p, 11,
        "2],PARAMETER[\"false_northing\",38744.572],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3414\"]],V");
    add_srs_wkt (p, 14,
        "ERT_CS[\"SHD height\",VERT_DATUM[\"Singapore Height Datu");
    add_srs_wkt (p, 15,
        "m\",2005,AUTHORITY[\"EPSG\",\"1140\"]],UNIT[\"metre\",1,");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[");
    add_srs_wkt (p, 17,
        "\"EPSG\",\"6916\"]],AUTHORITY[\"EPSG\",\"6927\"]]");
    p = add_epsg_def_ex (filter, first, last, 6931, "epsg", 6931,
        "WGS 84 / NSIDC EASE-Grid 2.0 North", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 North\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 6,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_center\",90],PARAMETER[\"longitude_of_center\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6931\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6932, "epsg", 6932,
        "WGS 84 / NSIDC EASE-Grid 2.0 South", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS8");
    add_proj4text (p, 1,
        "4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 South\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 6,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_center\",-90],PARAMETER[\"longitude_of_center\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"693");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 6933, "epsg", 6933,
        "WGS 84 / NSIDC EASE-Grid 2.0 Global", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Cylindrical_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 Global\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,");
    add_srs_wkt (p, 2,
        "298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Cylindrical_Equal_Area\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 8,
        "llel_1\",30],PARAMETER[\"central_meridian\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6933\"]]");
    p = add_epsg_def_ex (filter, first, last, 6956, "epsg", 6956,
        "VN-2000 / TM-3 zone 481", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 481\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",102],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6956\"]]");
    p = add_epsg_def_ex (filter, first, last, 6957, "epsg", 6957,
        "VN-2000 / TM-3 zone 482", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 482\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",105],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6957\"]]");
    p = add_epsg_def_ex (filter, first, last, 6958, "epsg", 6958,
        "VN-2000 / TM-3 zone 491", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=0 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 491\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",108],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6958\"]]");
    p = add_epsg_def_ex (filter, first, last, 6959, "epsg", 6959,
        "VN-2000 / TM-3 Da Nang zone", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=500000 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 Da Nang zone\",GEOGCS[\"VN-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904");
    add_srs_wkt (p, 3,
        "41429,-39.30318279,-111.45032835,0.00928836,-0.01975479,");
    add_srs_wkt (p, 4,
        "0.00427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",107.75],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 11,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"6959\"]]");
    p = add_epsg_def_ex (filter, first, last, 6962, "epsg", 6962,
        "ETRS89 / Albania LCC 2010", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=43 +lat_0=41 +lon_0=20 +x_0=0");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Albania LCC 2010\",GEOGCS[\"ETRS89\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"European_Terrestrial_Reference_System_1989\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",39],PARAMETER[\"standard_parallel_2\",43],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"latitude_of_origin\",41],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",20],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"6962\"]]");
    p = add_epsg_def_ex (filter, first, last, 6980, "epsg", 6980,
        "IGD05", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05\",DATUM[\"Israeli_Geodetic_Datum_2005\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1143\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"6980\"]]");
    p = add_epsg_def_ex (filter, first, last, 6983, "epsg", 6983,
        "IG05 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_Intermediate_Datum", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IG05 Intermediate CRS\",DATUM[\"IG05_Intermedia");
    add_srs_wkt (p, 1,
        "te_Datum\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1142\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"6983\"]]");
    p = add_epsg_def_ex (filter, first, last, 6984, "epsg", 6984,
        "Israeli Grid 05", 0, 0,
        "GRS 1980", "Greenwich",
        "IG05_Intermediate_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
        "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Israeli Grid 05\",GEOGCS[\"IG05 Intermediate CR");
    add_srs_wkt (p, 1,
        "S\",DATUM[\"IG05_Intermediate_Datum\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1142\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 6,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6983\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",31.73439361111111],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",35.20451694444445],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1.0000067],PARAMETER[\"false_easting\",219529.584],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",626907.39],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"6984\"]]");
    p = add_epsg_def_ex (filter, first, last, 6987, "epsg", 6987,
        "IGD05/12", 1, 1,
        "GRS 1980", "Greenwich",
        "Israeli_Geodetic_Datum_2005_2012", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGD05/12\",DATUM[\"Israeli_Geodetic_Datum_2005_");
    add_srs_wkt (p, 1,
        "2012\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1145\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"6987\"]]");
    p = add_epsg_def_ex (filter, first, last, 6990, "epsg", 6990,
        "IG05/12 Intermediate CRS", 1, 1,
        "GRS 1980", "Greenwich",
        "IG05_12_Intermediate_Datum", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IG05/12 Intermediate CRS\",DATUM[\"IG05_12_Inte");
    add_srs_wkt (p, 1,
        "rmediate_Datum\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"6990\"]]");
    p = add_epsg_def_ex (filter, first, last, 6991, "epsg", 6991,
        "Israeli Grid 05/12", 0, 0,
        "GRS 1980", "Greenwich",
        "IG05_12_Intermediate_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
        "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Israeli Grid 05/12\",GEOGCS[\"IG05/12 Intermedi");
    add_srs_wkt (p, 1,
        "ate CRS\",DATUM[\"IG05_12_Intermediate_Datum\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1144\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6990\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",31.73439361111111],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",35.20451694444445],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1.0000067],PARAMETER[\"false_easting\",219529.5");
    add_srs_wkt (p, 11,
        "84],PARAMETER[\"false_northing\",626907.39],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6991\"]]");
    p = add_epsg_def_ex (filter, first, last, 6996, "epsg", 6996,
        "NAD83(2011) / San Francisco CS13 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",37.75],PARAMETER[\"central_meridian\",-122.45],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",1.000007],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",48000],PARAMETER[\"false_northing\",24000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6996\"]]");
    p = add_epsg_def_ex (filter, first, last, 6997, "epsg", 6997,
        "NAD83(2011) / San Francisco CS13 (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-122.45 +k=1.000007 +x_0");
    add_proj4text (p, 1,
        "=48000 +y_0=24000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / San Francisco CS13 (ftUS) (deprec");
    add_srs_wkt (p, 1,
        "ated)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",37.75],PARAMETER[\"central_meridian\",-122.45],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1.000007],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",157480],PARAMETER[\"false_northing\",78740],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"6997\"]]");
    p = add_epsg_def_ex (filter, first, last, 7005, "epsg", 7005,
        "Nahrwan 1934 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 37N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6744\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4744\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7005\"]]");
    p = add_epsg_def_ex (filter, first, last, 7006, "epsg", 7006,
        "Nahrwan 1934 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 38N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6744\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4744\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7006\"]]");
    p = add_epsg_def_ex (filter, first, last, 7007, "epsg", 7007,
        "Nahrwan 1934 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-242.2,-144.9,");
    add_proj4text (p, 1,
        "370.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6744\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4744\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",51],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7007\"]]");
    p = add_epsg_def_ex (filter, first, last, 7035, "epsg", 7035,
        "RGSPM06 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Lon", "East", "Lat", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGSPM06 (lon-lat)\",DATUM[\"Reseau_Geodesique_d");
    add_srs_wkt (p, 1,
        "e_Saint_Pierre_et_Miquelon_2006\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1038\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lon\",EAST],AXIS[");
    add_srs_wkt (p, 6,
        "\"Lat\",NORTH],AUTHORITY[\"EPSG\",\"7035\"]]");
    p = add_epsg_def_ex (filter, first, last, 7037, "epsg", 7037,
        "RGR92 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Lon", "East", "Lat", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGR92 (lon-lat)\",DATUM[\"Reseau_Geodesique_de_");
    add_srs_wkt (p, 1,
        "la_Reunion_1992\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6627\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Lon\",EAST],AXIS[\"Lat\",NORTH],AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"7037\"]]");
    p = add_epsg_def_ex (filter, first, last, 7039, "epsg", 7039,
        "RGM04 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Mayotte_2004", "none", "degree",
        "Lon", "East", "Lat", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGM04 (lon-lat)\",DATUM[\"Reseau_Geodesique_de_");
    add_srs_wkt (p, 1,
        "Mayotte_2004\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"10");
    add_srs_wkt (p, 3,
        "36\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Lon\",EAST],AXIS[\"Lat\",NORTH],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"7039\"]]");
    p = add_epsg_def_ex (filter, first, last, 7041, "epsg", 7041,
        "RGFG95 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Lon", "East", "Lat", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGFG95 (lon-lat)\",DATUM[\"Reseau_Geodesique_Fr");
    add_srs_wkt (p, 1,
        "ancais_Guyane_1995\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6624\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Lon\",EAST],AXIS[\"Lat\",NORTH]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"7041\"]]");
    p = add_epsg_def_ex (filter, first, last, 7057, "epsg", 7057,
        "NAD83(2011) / IaRCS zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.2 +lat_0=43.2 +lon_0=-95.25 +k_0=1.0");
    add_proj4text (p, 1,
        "00052 +x_0=3505207.010414021 +y_0=2926085.852171705 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 1\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.2],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-95.25],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1.000052],PARAMETER[\"false_easting\",11500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",9600000.000000002],UNIT[\"US");
    add_srs_wkt (p, 12,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"7057\"]]");
    p = add_epsg_def_ex (filter, first, last, 7058, "epsg", 7058,
        "NAD83(2011) / IaRCS zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.16666666666666 +lat_0=43.16666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-92.75 +k_0=1.000043 +x_0=3810007.62001524 +y");
    add_proj4text (p, 2,
        "_0=2987045.974091948 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 2\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.166666");
    add_srs_wkt (p, 9,
        "66666666],PARAMETER[\"central_meridian\",-92.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.000043],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",12500000],PARAMETER[\"false_northing\",9800000.00000000");
    add_srs_wkt (p, 12,
        "2],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"7058\"]]");
    p = add_epsg_def_ex (filter, first, last, 7059, "epsg", 7059,
        "NAD83(2011) / IaRCS zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.2 +k=1.000035 +x_0=4");
    add_proj4text (p, 1,
        "114808.229616459 +y_0=2529845.05969012 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 3\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-91.2],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".000035],PARAMETER[\"false_easting\",13500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",8300000.000000002],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7059\"]]");
    p = add_epsg_def_ex (filter, first, last, 7060, "epsg", 7060,
        "NAD83(2011) / IaRCS zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.53333333333333 +lat_0=42.53333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-94.83333333333333 +k_0=1.000045 +x_0=4419608");
    add_proj4text (p, 2,
        ".839217679 +y_0=2621285.242570485 +ellps=GRS80 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 4\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42.533333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"central_meridian\",-94.83333333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"scale_factor\",1.000045],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",14500000],PARAMETER[\"false_northing\",860");
    add_srs_wkt (p, 12,
        "0000.000000002],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7060\"]]");
    p = add_epsg_def_ex (filter, first, last, 7061, "epsg", 7061,
        "NAD83(2011) / IaRCS zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.65 +lat_0=42.65 +lon_0=-92.25 +k_0=1");
    add_proj4text (p, 1,
        ".000032 +x_0=4724409.448818898 +y_0=2712725.425450851 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 5\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42.65],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-92.25],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.000032],PARAMETER[\"false_easting\",15500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",8900000.000000002],UNIT[\"U");
    add_srs_wkt (p, 12,
        "S survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"7061\"]]");
    p = add_epsg_def_ex (filter, first, last, 7062, "epsg", 7062,
        "NAD83(2011) / IaRCS zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-95.73333333333333 +k=1.");
    add_proj4text (p, 1,
        "000039 +x_0=5029210.058420117 +y_0=2011684.023368047 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 6\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-95.73333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000039],PARAMETER[\"false_easting\",165000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",6600000.000000002],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7062\"]]");
    p = add_epsg_def_ex (filter, first, last, 7063, "epsg", 7063,
        "NAD83(2011) / IaRCS zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-94.63333333333334 +k=1.");
    add_proj4text (p, 1,
        "000045 +x_0=5334010.668021336 +y_0=2072644.145288291 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 7\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-94.63333333333334],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000045],PARAMETER[\"false_easting\",175000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",6800000.000000002],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7063\"]]");
    p = add_epsg_def_ex (filter, first, last, 7064, "epsg", 7064,
        "NAD83(2011) / IaRCS zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-93.71666666666667 +k=1.");
    add_proj4text (p, 1,
        "000033 +x_0=5638811.277622555 +y_0=2133604.267208535 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 8\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-93.71666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000033],PARAMETER[\"false_easting\",185000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",7000000.000000002],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7064\"]]");
    p = add_epsg_def_ex (filter, first, last, 7065, "epsg", 7065,
        "NAD83(2011) / IaRCS zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-92.81666666666666 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=5943611.887223775 +y_0=2194564.389128779 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 9\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-92.81666666666666],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000027],PARAMETER[\"false_easting\",195000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",7200000.000000002],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7065\"]]");
    p = add_epsg_def_ex (filter, first, last, 7066, "epsg", 7066,
        "NAD83(2011) / IaRCS zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.83333333333334 +lat_0=41.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.66666666666667 +k_0=1.00002 +x_0=6248412.");
    add_proj4text (p, 2,
        "496824994 +y_0=2438404.876809754 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 10\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",41.833333");
    add_srs_wkt (p, 9,
        "33333334],PARAMETER[\"central_meridian\",-91.66666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"scale_factor\",1.00002],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",20500000],PARAMETER[\"false_northing\",8000");
    add_srs_wkt (p, 12,
        "000.000000002],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7066\"]]");
    p = add_epsg_def_ex (filter, first, last, 7067, "epsg", 7067,
        "NAD83(2011) / IaRCS zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-90.53333333333333 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=6553213.106426213 +y_0=2316484.632969266 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 11\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-90.53333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000027],PARAMETER[\"false_easting\",215000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",7600000.000000002],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7067\"]]");
    p = add_epsg_def_ex (filter, first, last, 7068, "epsg", 7068,
        "NAD83(2011) / IaRCS zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.91666666666666 +lat_0=40.91666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-93.75 +k_0=1.000037 +x_0=6858013.716027432 +");
    add_proj4text (p, 2,
        "y_0=1889763.779527559 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 12\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",40.916666");
    add_srs_wkt (p, 9,
        "66666666],PARAMETER[\"central_meridian\",-93.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.000037],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",22500000],PARAMETER[\"false_northing\",6200000.00000000");
    add_srs_wkt (p, 12,
        "2],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"7068\"]]");
    p = add_epsg_def_ex (filter, first, last, 7069, "epsg", 7069,
        "NAD83(2011) / IaRCS zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.91666666666667 +k=1.");
    add_proj4text (p, 1,
        "00002 +x_0=7162814.325628651 +y_0=1950723.901447803 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 13\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-91.91666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.00002],PARAMETER[\"false_easting\",2350000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",6400000.000000002],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7069\"]]");
    p = add_epsg_def_ex (filter, first, last, 7070, "epsg", 7070,
        "NAD83(2011) / IaRCS zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.25 +lon_0=-91.25 +k=1.000018 +x_0=");
    add_proj4text (p, 1,
        "7467614.93522987 +y_0=1889763.779527559 +ellps=GRS80 +un");
    add_proj4text (p, 2,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / IaRCS zone 14\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",40.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-91.25],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1.000018],PARAMETER[\"false_easting\",24500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",6200000.000000002],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7070\"]]");
    p = add_epsg_def_ex (filter, first, last, 7073, "epsg", 7073,
        "RGTAAF07", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGTAAF07\",DATUM[\"Reseau_Geodesique_des_Terres");
    add_srs_wkt (p, 1,
        "_Australes_et_Antarctiques_Francaises_2007\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"1113\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "7073\"]]");
    p = add_epsg_def_ex (filter, first, last, 7074, "epsg", 7074,
        "RGTAAF07 / UTM zone 37S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 37S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7074\"]]");
    p = add_epsg_def_ex (filter, first, last, 7075, "epsg", 7075,
        "RGTAAF07 / UTM zone 38S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 38S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7075\"]]");
    p = add_epsg_def_ex (filter, first, last, 7076, "epsg", 7076,
        "RGTAAF07 / UTM zone 39S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 39S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7076\"]]");
    p = add_epsg_def_ex (filter, first, last, 7077, "epsg", 7077,
        "RGTAAF07 / UTM zone 40S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 40S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7077\"]]");
    p = add_epsg_def_ex (filter, first, last, 7078, "epsg", 7078,
        "RGTAAF07 / UTM zone 41S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 41S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",63],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7078\"]]");
    p = add_epsg_def_ex (filter, first, last, 7079, "epsg", 7079,
        "RGTAAF07 / UTM zone 42S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 42S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",69],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7079\"]]");
    p = add_epsg_def_ex (filter, first, last, 7080, "epsg", 7080,
        "RGTAAF07 / UTM zone 43S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 43S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7080\"]]");
    p = add_epsg_def_ex (filter, first, last, 7081, "epsg", 7081,
        "RGTAAF07 / UTM zone 44S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 44S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"7073\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7081\"]]");
    p = add_epsg_def_ex (filter, first, last, 7084, "epsg", 7084,
        "RGF93 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Lon", "East", "Lat", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 (lon-lat)\",DATUM[\"Reseau_Geodesique_Fra");
    add_srs_wkt (p, 1,
        "ncais_1993\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6171");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Lon\",EAST],AXIS[\"Lat\",NORTH],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"7084\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

