/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_22 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4514, "epsg", 4514,
        "CGCS2000 / 3-degree Gauss-Kruger zone 26", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 26\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",78],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",26500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4514\"]]");
    p = add_epsg_def_ex (filter, first, last, 4515, "epsg", 4515,
        "CGCS2000 / 3-degree Gauss-Kruger zone 27", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 27\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",81],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",27500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4515\"]]");
    p = add_epsg_def_ex (filter, first, last, 4516, "epsg", 4516,
        "CGCS2000 / 3-degree Gauss-Kruger zone 28", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 28\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",84],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",28500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4516\"]]");
    p = add_epsg_def_ex (filter, first, last, 4517, "epsg", 4517,
        "CGCS2000 / 3-degree Gauss-Kruger zone 29", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 29\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",87],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",29500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4517\"]]");
    p = add_epsg_def_ex (filter, first, last, 4518, "epsg", 4518,
        "CGCS2000 / 3-degree Gauss-Kruger zone 30", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 30\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",90],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",30500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4518\"]]");
    p = add_epsg_def_ex (filter, first, last, 4519, "epsg", 4519,
        "CGCS2000 / 3-degree Gauss-Kruger zone 31", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 31\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",93],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",31500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4519\"]]");
    p = add_epsg_def_ex (filter, first, last, 4520, "epsg", 4520,
        "CGCS2000 / 3-degree Gauss-Kruger zone 32", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 32\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",96],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",32500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4520\"]]");
    p = add_epsg_def_ex (filter, first, last, 4521, "epsg", 4521,
        "CGCS2000 / 3-degree Gauss-Kruger zone 33", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 33\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",99],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",33500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4521\"]]");
    p = add_epsg_def_ex (filter, first, last, 4522, "epsg", 4522,
        "CGCS2000 / 3-degree Gauss-Kruger zone 34", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 34\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",102],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",34500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4522\"]]");
    p = add_epsg_def_ex (filter, first, last, 4523, "epsg", 4523,
        "CGCS2000 / 3-degree Gauss-Kruger zone 35", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 35\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",105],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",35500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4523\"]]");
    p = add_epsg_def_ex (filter, first, last, 4524, "epsg", 4524,
        "CGCS2000 / 3-degree Gauss-Kruger zone 36", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 36\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",108],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",36500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4524\"]]");
    p = add_epsg_def_ex (filter, first, last, 4525, "epsg", 4525,
        "CGCS2000 / 3-degree Gauss-Kruger zone 37", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 37\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",111],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",37500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4525\"]]");
    p = add_epsg_def_ex (filter, first, last, 4526, "epsg", 4526,
        "CGCS2000 / 3-degree Gauss-Kruger zone 38", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 38\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",114],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",38500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4526\"]]");
    p = add_epsg_def_ex (filter, first, last, 4527, "epsg", 4527,
        "CGCS2000 / 3-degree Gauss-Kruger zone 39", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 39\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",117],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",39500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4527\"]]");
    p = add_epsg_def_ex (filter, first, last, 4528, "epsg", 4528,
        "CGCS2000 / 3-degree Gauss-Kruger zone 40", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 40\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",120],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",40500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4528\"]]");
    p = add_epsg_def_ex (filter, first, last, 4529, "epsg", 4529,
        "CGCS2000 / 3-degree Gauss-Kruger zone 41", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 41\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",123],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",41500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4529\"]]");
    p = add_epsg_def_ex (filter, first, last, 4530, "epsg", 4530,
        "CGCS2000 / 3-degree Gauss-Kruger zone 42", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 42\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",126],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",42500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4530\"]]");
    p = add_epsg_def_ex (filter, first, last, 4531, "epsg", 4531,
        "CGCS2000 / 3-degree Gauss-Kruger zone 43", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 43\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",129],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",43500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4531\"]]");
    p = add_epsg_def_ex (filter, first, last, 4532, "epsg", 4532,
        "CGCS2000 / 3-degree Gauss-Kruger zone 44", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 44\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",132],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",44500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4532\"]]");
    p = add_epsg_def_ex (filter, first, last, 4533, "epsg", 4533,
        "CGCS2000 / 3-degree Gauss-Kruger zone 45", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 45\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",135],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",45500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"4533\"]]");
    p = add_epsg_def_ex (filter, first, last, 4534, "epsg", 4534,
        "CGCS2000 / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 75E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",75],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4534\"]]");
    p = add_epsg_def_ex (filter, first, last, 4535, "epsg", 4535,
        "CGCS2000 / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 78E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",78],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4535\"]]");
    p = add_epsg_def_ex (filter, first, last, 4536, "epsg", 4536,
        "CGCS2000 / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 81E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",81],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4536\"]]");
    p = add_epsg_def_ex (filter, first, last, 4537, "epsg", 4537,
        "CGCS2000 / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 84E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",84],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4537\"]]");
    p = add_epsg_def_ex (filter, first, last, 4538, "epsg", 4538,
        "CGCS2000 / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 87E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",87],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4538\"]]");
    p = add_epsg_def_ex (filter, first, last, 4539, "epsg", 4539,
        "CGCS2000 / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 90E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",90],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4539\"]]");
    p = add_epsg_def_ex (filter, first, last, 4540, "epsg", 4540,
        "CGCS2000 / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 93E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",93],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4540\"]]");
    p = add_epsg_def_ex (filter, first, last, 4541, "epsg", 4541,
        "CGCS2000 / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 96E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",96],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4541\"]]");
    p = add_epsg_def_ex (filter, first, last, 4542, "epsg", 4542,
        "CGCS2000 / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 99E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",99],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4542\"]]");
    p = add_epsg_def_ex (filter, first, last, 4543, "epsg", 4543,
        "CGCS2000 / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 102E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",102],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4543\"]]");
    p = add_epsg_def_ex (filter, first, last, 4544, "epsg", 4544,
        "CGCS2000 / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 105E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",105],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4544\"]]");
    p = add_epsg_def_ex (filter, first, last, 4545, "epsg", 4545,
        "CGCS2000 / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 108E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",108],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4545\"]]");
    p = add_epsg_def_ex (filter, first, last, 4546, "epsg", 4546,
        "CGCS2000 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 111E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",111],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4546\"]]");
    p = add_epsg_def_ex (filter, first, last, 4547, "epsg", 4547,
        "CGCS2000 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 114E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",114],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4547\"]]");
    p = add_epsg_def_ex (filter, first, last, 4548, "epsg", 4548,
        "CGCS2000 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 117E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",117],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4548\"]]");
    p = add_epsg_def_ex (filter, first, last, 4549, "epsg", 4549,
        "CGCS2000 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 120E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",120],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4549\"]]");
    p = add_epsg_def_ex (filter, first, last, 4550, "epsg", 4550,
        "CGCS2000 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 123E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",123],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4550\"]]");
    p = add_epsg_def_ex (filter, first, last, 4551, "epsg", 4551,
        "CGCS2000 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 126E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",126],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4551\"]]");
    p = add_epsg_def_ex (filter, first, last, 4552, "epsg", 4552,
        "CGCS2000 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 129E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",129],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4552\"]]");
    p = add_epsg_def_ex (filter, first, last, 4553, "epsg", 4553,
        "CGCS2000 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 132E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",132],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4553\"]]");
    p = add_epsg_def_ex (filter, first, last, 4554, "epsg", 4554,
        "CGCS2000 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "CGCS2000", "Greenwich",
        "China_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 135E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",135],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"4554\"]]");
    p = add_epsg_def_ex (filter, first, last, 4555, "epsg", 4555,
        "New Beijing", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 2,
        "4\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4555\"]]");
    p = add_epsg_def_ex (filter, first, last, 4558, "epsg", 4558,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RRAF 1991\",DATUM[\"Reseau_de_Reference_des_Ant");
    add_srs_wkt (p, 1,
        "illes_Francaises_1991\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1047\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4558\"]]");
    p = add_epsg_def_ex (filter, first, last, 4559, "epsg", 4559,
        "RRAF 1991 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RRAF 1991 / UTM zone 20N\",GEOGCS[\"RRAF 1991\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_de_Reference_des_Antilles_Francaises_199");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4558\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"4559\"]]");
    p = add_epsg_def_ex (filter, first, last, 4568, "epsg", 4568,
        "New Beijing / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 13\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",75],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",135");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"4568\"]]");
    p = add_epsg_def_ex (filter, first, last, 4569, "epsg", 4569,
        "New Beijing / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 14\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",81],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",145");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"4569\"]]");
    p = add_epsg_def_ex (filter, first, last, 4570, "epsg", 4570,
        "New Beijing / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 15\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",87],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",155");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"4570\"]]");
    p = add_epsg_def_ex (filter, first, last, 4571, "epsg", 4571,
        "New Beijing / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 16\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",93],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",165");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"4571\"]]");
    p = add_epsg_def_ex (filter, first, last, 4572, "epsg", 4572,
        "New Beijing / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 17\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",99],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",175");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"4572\"]]");
    p = add_epsg_def_ex (filter, first, last, 4573, "epsg", 4573,
        "New Beijing / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 18\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",105],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",18");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4573\"]]");
    p = add_epsg_def_ex (filter, first, last, 4574, "epsg", 4574,
        "New Beijing / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 19\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",19");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4574\"]]");
    p = add_epsg_def_ex (filter, first, last, 4575, "epsg", 4575,
        "New Beijing / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 20\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4575\"]]");
    p = add_epsg_def_ex (filter, first, last, 4576, "epsg", 4576,
        "New Beijing / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 21\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",123],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",21");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4576\"]]");
    p = add_epsg_def_ex (filter, first, last, 4577, "epsg", 4577,
        "New Beijing / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 22\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",129],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",22");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4577\"]]");
    p = add_epsg_def_ex (filter, first, last, 4578, "epsg", 4578,
        "New Beijing / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 23\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",135],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",23");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"4578\"]]");
    p = add_epsg_def_ex (filter, first, last, 4579, "epsg", 4579,
        "New Beijing / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 75E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",0],PARAMETER[\"central_meridian\",75],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"4579\"]]");
    p = add_epsg_def_ex (filter, first, last, 4580, "epsg", 4580,
        "New Beijing / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 81E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",0],PARAMETER[\"central_meridian\",81],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"4580\"]]");
    p = add_epsg_def_ex (filter, first, last, 4581, "epsg", 4581,
        "New Beijing / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 87E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",0],PARAMETER[\"central_meridian\",87],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"4581\"]]");
    p = add_epsg_def_ex (filter, first, last, 4582, "epsg", 4582,
        "New Beijing / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 93E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",0],PARAMETER[\"central_meridian\",93],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"4582\"]]");
    p = add_epsg_def_ex (filter, first, last, 4583, "epsg", 4583,
        "New Beijing / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 99E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],P");
    add_srs_wkt (p, 7,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",0],PARAMETER[\"central_meridian\",99],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"4583\"]]");
    p = add_epsg_def_ex (filter, first, last, 4584, "epsg", 4584,
        "New Beijing / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 105E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",105],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4584\"]]");
    p = add_epsg_def_ex (filter, first, last, 4585, "epsg", 4585,
        "New Beijing / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 111E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4585\"]]");
    p = add_epsg_def_ex (filter, first, last, 4586, "epsg", 4586,
        "New Beijing / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 117E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4586\"]]");
    p = add_epsg_def_ex (filter, first, last, 4587, "epsg", 4587,
        "New Beijing / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 123E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",123],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4587\"]]");
    p = add_epsg_def_ex (filter, first, last, 4588, "epsg", 4588,
        "New Beijing / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 129E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",129],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4588\"]]");
    p = add_epsg_def_ex (filter, first, last, 4589, "epsg", 4589,
        "New Beijing / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 135E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4555\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",135],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"4589\"]]");
    p = add_epsg_def_ex (filter, first, last, 4600, "epsg", 4600,
        "Anguilla 1957", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Anguilla_1957", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Anguilla 1957\",DATUM[\"Anguilla_1957\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6600\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4600\"]]");
    p = add_epsg_def_ex (filter, first, last, 4601, "epsg", 4601,
        "Antigua 1943", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Antigua_1943", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Antigua 1943\",DATUM[\"Antigua_1943\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6601\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4601\"]]");
    p = add_epsg_def_ex (filter, first, last, 4602, "epsg", 4602,
        "Dominica 1945", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Dominica_1945", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dominica 1945\",DATUM[\"Dominica_1945\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6602\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4602\"]]");
    p = add_epsg_def_ex (filter, first, last, 4603, "epsg", 4603,
        "Grenada 1953", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Grenada_1953", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grenada 1953\",DATUM[\"Grenada_1953\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6603\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4603\"]]");
    p = add_epsg_def_ex (filter, first, last, 4604, "epsg", 4604,
        "Montserrat 1958", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Montserrat_1958", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Montserrat 1958\",DATUM[\"Montserrat_1958\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],TOWGS84[174,359,365,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6604\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4604\"]]");
    p = add_epsg_def_ex (filter, first, last, 4605, "epsg", 4605,
        "St. Kitts 1955", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Kitts_1955", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Kitts 1955\",DATUM[\"St_Kitts_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6605\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4605\"]]");
    p = add_epsg_def_ex (filter, first, last, 4606, "epsg", 4606,
        "St. Lucia 1955", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Lucia_1955", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Lucia 1955\",DATUM[\"St_Lucia_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[-149,128,296,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6606\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4606\"]]");
    p = add_epsg_def_ex (filter, first, last, 4607, "epsg", 4607,
        "St. Vincent 1945", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Vincent_1945", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274");
    add_proj4text (p, 1,
        ".607,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Vincent 1945\",DATUM[\"St_Vincent_1945\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7012\"]],TOWGS84[195.671,332.517,274.607,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6607\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4607\"]]");
    p = add_epsg_def_ex (filter, first, last, 4608, "epsg", 4608,
        "NAD27(76)", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(76)\",DATUM[\"North_American_Datum_1927_1");
    add_srs_wkt (p, 1,
        "976\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 2,
        "82,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 3,
        "08\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4608\"]]");
    p = add_epsg_def_ex (filter, first, last, 4609, "epsg", 4609,
        "NAD27(CGQ77)", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(CGQ77)\",DATUM[\"North_American_Datum_192");
    add_srs_wkt (p, 1,
        "7_CGQ77\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982");
    add_srs_wkt (p, 2,
        "138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6609\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4609\"]]");
    p = add_epsg_def_ex (filter, first, last, 4610, "epsg", 4610,
        "Xian 1980", 1, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG ");
    add_srs_wkt (p, 1,
        "1975\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 5,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]]");
    p = add_epsg_def_ex (filter, first, last, 4611, "epsg", 4611,
        "Hong Kong 1980", 1, 1,
        "International 1924", "Greenwich",
        "Hong_Kong_1980", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-16");
    add_proj4text (p, 1,
        "1.764,0.067753,-2.243649,-1.158827,-1.094246 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1980\",DATUM[\"Hong_Kong_1980\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],TOWGS84[-162.619,-276.959,-161.764,0.067753,");
    add_srs_wkt (p, 3,
        "-2.243649,-1.158827,-1.094246],AUTHORITY[\"EPSG\",\"6611");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4611\"]]");
    p = add_epsg_def_ex (filter, first, last, 4612, "epsg", 4612,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4612\"]]");
    p = add_epsg_def_ex (filter, first, last, 4613, "epsg", 4613,
        "Segara", 1, 1,
        "Bessel 1841", "Greenwich",
        "Gunung_Segara", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara\",DATUM[\"Gunung_Segara\",SPHEROID[\"Bes");
    add_srs_wkt (p, 1,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6613\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4613\"]]");
    p = add_epsg_def_ex (filter, first, last, 4614, "epsg", 4614,
        "QND95", 1, 1,
        "International 1924", "Greenwich",
        "Qatar_National_Datum_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-119.4248,-303.65872,");
    add_proj4text (p, 1,
        "-11.00061,1.164298,0.174458,1.096259,3.657065 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"QND95\",DATUM[\"Qatar_National_Datum_1995\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-119.4248,-303.65872,-11.00061,1.");
    add_srs_wkt (p, 3,
        "164298,0.174458,1.096259,3.657065],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6614\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4614\"]]");
    p = add_epsg_def_ex (filter, first, last, 4615, "epsg", 4615,
        "Porto Santo", 1, 1,
        "International 1924", "Greenwich",
        "Porto_Santo_1936", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Porto Santo\",DATUM[\"Porto_Santo_1936\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],TOWGS84[-499,-249,314,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6615\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 6,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4615\"]]");
    p = add_epsg_def_ex (filter, first, last, 4616, "epsg", 4616,
        "Selvagem Grande", 1, 1,
        "International 1924", "Greenwich",
        "Selvagem_Grande", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-289,-124,60,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Selvagem Grande\",DATUM[\"Selvagem_Grande\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-289,-124,60,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6616\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4616\"]]");
    p = add_epsg_def_ex (filter, first, last, 4617, "epsg", 4617,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"461");
    add_srs_wkt (p, 7,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 4618, "epsg", 4618,
        "SAD69", 1, 1,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-66.87,4.37,-38.52");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69\",DATUM[\"South_American_Datum_1969\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7050\"]],TOWGS84[-66.87,4.37,-38.52,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6618\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4618\"]]");
    p = add_epsg_def_ex (filter, first, last, 4619, "epsg", 4619,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4619\"]]");
    p = add_epsg_def_ex (filter, first, last, 4620, "epsg", 4620,
        "Point 58", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Point_58", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Point 58\",DATUM[\"Point_58\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],TOWGS84[-106,-129,165,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6620\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4620\"]]");
    p = add_epsg_def_ex (filter, first, last, 4621, "epsg", 4621,
        "Fort Marigot", 1, 1,
        "International 1924", "Greenwich",
        "Fort_Marigot", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fort Marigot\",DATUM[\"Fort_Marigot\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[137,248,-430,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6621\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4621\"]]");
    p = add_epsg_def_ex (filter, first, last, 4622, "epsg", 4622,
        "Guadeloupe 1948", 1, 1,
        "International 1924", "Greenwich",
        "Guadeloupe_1948", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-467,-16,-300,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guadeloupe 1948\",DATUM[\"Guadeloupe_1948\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-467,-16,-300,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6622\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4622\"]]");
    p = add_epsg_def_ex (filter, first, last, 4623, "epsg", 4623,
        "CSG67", 1, 1,
        "International 1924", "Greenwich",
        "Centre_Spatial_Guyanais_1967", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CSG67\",DATUM[\"Centre_Spatial_Guyanais_1967\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-186,230,110,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6623\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4623\"]]");
    p = add_epsg_def_ex (filter, first, last, 4624, "epsg", 4624,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGFG95\",DATUM[\"Reseau_Geodesique_Francais_Guy");
    add_srs_wkt (p, 1,
        "ane_1995\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6624\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4624\"]]");
    p = add_epsg_def_ex (filter, first, last, 4625, "epsg", 4625,
        "Martinique 1938", 1, 1,
        "International 1924", "Greenwich",
        "Martinique_1938", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=186,482,151,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Martinique 1938\",DATUM[\"Martinique_1938\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[186,482,151,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6625\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4625\"]]");
    p = add_epsg_def_ex (filter, first, last, 4626, "epsg", 4626,
        "Reunion 1947", 1, 1,
        "International 1924", "Greenwich",
        "Reunion_1947", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=94,-948,-1262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Reunion 1947\",DATUM[\"Reunion_1947\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[94,-948,-1262,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6626\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4626\"]]");
    p = add_epsg_def_ex (filter, first, last, 4627, "epsg", 4627,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGR92\",DATUM[\"Reseau_Geodesique_de_la_Reunion");
    add_srs_wkt (p, 1,
        "_1992\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6627\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4627\"]]");
    p = add_epsg_def_ex (filter, first, last, 4628, "epsg", 4628,
        "Tahiti 52", 1, 1,
        "International 1924", "Greenwich",
        "Tahiti_52", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahiti 52\",DATUM[\"Tahiti_52\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[162,117,154,0,0,0,0],AUTHORITY[\"EPSG\",\"662");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4628\"]]");
    p = add_epsg_def_ex (filter, first, last, 4629, "epsg", 4629,
        "Tahaa 54", 1, 1,
        "International 1924", "Greenwich",
        "Tahaa_54", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486");
    add_proj4text (p, 1,
        ",1.6045,0.8823,0.5565,1.3746 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahaa 54\",DATUM[\"Tahaa_54\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[72.438,345.918,79.486,1.6045,0.8823,0.5565,1.37");
    add_srs_wkt (p, 3,
        "46],AUTHORITY[\"EPSG\",\"6629\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 7,
        "29\"]]");
    p = add_epsg_def_ex (filter, first, last, 4630, "epsg", 4630,
        "IGN72 Nuku Hiva", 1, 1,
        "International 1924", "Greenwich",
        "IGN72_Nuku_Hiva", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=84,274,65,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Nuku Hiva\",DATUM[\"IGN72_Nuku_Hiva\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[84,274,65,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6630\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4630\"]]");
    p = add_epsg_def_ex (filter, first, last, 4631, "epsg", 4631,
        "K0 1949", 1, 1,
        "International 1924", "Greenwich",
        "K0_1949", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"K0 1949\",DATUM[\"K0_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 1,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 2,
        "OWGS84[145,-187,103,0,0,0,0],AUTHORITY[\"EPSG\",\"6631\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4631\"]]");
    p = add_epsg_def_ex (filter, first, last, 4632, "epsg", 4632,
        "Combani 1950", 1, 1,
        "International 1924", "Greenwich",
        "Combani_1950", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Combani 1950\",DATUM[\"Combani_1950\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-382,-59,-262,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6632\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4632\"]]");
    p = add_epsg_def_ex (filter, first, last, 4633, "epsg", 4633,
        "IGN56 Lifou", 1, 1,
        "International 1924", "Greenwich",
        "IGN56_Lifou", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN56 Lifou\",DATUM[\"IGN56_Lifou\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[335.47,222.58,-230.94,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6633\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4633\"]]");
    p = add_epsg_def_ex (filter, first, last, 4634, "epsg", 4634,
        "IGN72 Grand Terre", 1, 1,
        "International 1924", "Greenwich",
        "IGN72_Grande_Terre", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Grand Terre\",DATUM[\"IGN72_Grande_Terre\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-13,-348,292,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6634\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4634\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

