/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_16 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 3649, "epsg", 3649,
        "NAD83(NSRS2007) / Pennsylvania North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Pennsylvania North\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",41.95],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",40.88333333333333],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",40.16666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-77.75],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"3649\"]]");
    p = add_epsg_def_ex (filter, first, last, 3650, "epsg", 3650,
        "NAD83(NSRS2007) / Pennsylvania North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Pennsylvania North (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",41.95],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",40.88333333333333],PARAMETER[\"lati");
    add_srs_wkt (p, 11,
        "tude_of_origin\",40.16666666666666],PARAMETER[\"central_");
    add_srs_wkt (p, 12,
        "meridian\",-77.75],PARAMETER[\"false_easting\",1968500],");
    add_srs_wkt (p, 13,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 14,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 15,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3650\"]");
    add_srs_wkt (p, 16,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3651, "epsg", 3651,
        "NAD83(NSRS2007) / Pennsylvania South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Pennsylvania South\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",40.96666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",39.93333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",39.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-77.75],PARAMETER[\"false_easting\",60000");
    add_srs_wkt (p, 13,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 15,
        "RTH],AUTHORITY[\"EPSG\",\"3651\"]]");
    p = add_epsg_def_ex (filter, first, last, 3652, "epsg", 3652,
        "NAD83(NSRS2007) / Pennsylvania South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Pennsylvania South (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",40.96666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",39.93333333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",39.33333333333334],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"central_meridian\",-77.75],PARAMETER[\"false_easting");
    add_srs_wkt (p, 13,
        "\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 14,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 15,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"3652\"]]");
    p = add_epsg_def_ex (filter, first, last, 3653, "epsg", 3653,
        "NAD83(NSRS2007) / Rhode Island", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Rhode Island\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",41.08333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-71.5],PARAMETER[\"scale_factor\",0.99999375],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3653\"]]");
    p = add_epsg_def_ex (filter, first, last, 3654, "epsg", 3654,
        "NAD83(NSRS2007) / Rhode Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Rhode Island (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",41.08333333333334],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-71.5],PARAMETER[\"scale_factor\",0.999993");
    add_srs_wkt (p, 11,
        "75],PARAMETER[\"false_easting\",328083.3333],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3654\"]]");
    p = add_epsg_def_ex (filter, first, last, 3655, "epsg", 3655,
        "NAD83(NSRS2007) / South Carolina", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Carolina\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",34.83333333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",32.5],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 11,
        "in\",31.83333333333333],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 12,
        "81],PARAMETER[\"false_easting\",609600],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"3655\"]]");
    p = add_epsg_def_ex (filter, first, last, 3656, "epsg", 3656,
        "NAD83(NSRS2007) / South Carolina (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Carolina (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",34.83333333333334],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",32.5],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",31.83333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-81],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"3656\"]]");
    p = add_epsg_def_ex (filter, first, last, 3657, "epsg", 3657,
        "NAD83(NSRS2007) / South Dakota North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Dakota North\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",45.68333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",44.41666666666666],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",43.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-100],PARAMETER[\"false_easting\",600000]");
    add_srs_wkt (p, 13,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"3657\"]]");
    p = add_epsg_def_ex (filter, first, last, 3658, "epsg", 3658,
        "NAD83(NSRS2007) / South Dakota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Dakota North (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",45.68333333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",44.41666666666666],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",43.83333333333334],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"central_meridian\",-100],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 14,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 15,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"3658\"]]");
    p = add_epsg_def_ex (filter, first, last, 3659, "epsg", 3659,
        "NAD83(NSRS2007) / South Dakota South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Dakota South\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",44.4],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",42.83333333333334],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 11,
        "rigin\",42.33333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-100.3333333333333],PARAMETER[\"false_easting\",600000]");
    add_srs_wkt (p, 13,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"3659\"]]");
    p = add_epsg_def_ex (filter, first, last, 3660, "epsg", 3660,
        "NAD83(NSRS2007) / South Dakota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / South Dakota South (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",44.4],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",42.83333333333334],PARAMETER[\"latit");
    add_srs_wkt (p, 11,
        "ude_of_origin\",42.33333333333334],PARAMETER[\"central_m");
    add_srs_wkt (p, 12,
        "eridian\",-100.3333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 14,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 15,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"3660\"]]");
    p = add_epsg_def_ex (filter, first, last, 3661, "epsg", 3661,
        "NAD83(NSRS2007) / Tennessee", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Tennessee\",GEOGCS[\"NAD83(NS");
    add_srs_wkt (p, 1,
        "RS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",36.41666666666666],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_2\",35.25],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",34.33333333333334],PARAMETER[\"central_meridian\",-86],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_easting\",600000],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 14,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"3661\"]]");
    p = add_epsg_def_ex (filter, first, last, 3662, "epsg", 3662,
        "NAD83(NSRS2007) / Tennessee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Tennessee (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",36.41666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",35.25],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 11,
        "rigin\",34.33333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-86],PARAMETER[\"false_easting\",1968500],PARAMETER[\"f");
    add_srs_wkt (p, 13,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 14,
        "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 15,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3662\"]]");
    p = add_epsg_def_ex (filter, first, last, 3663, "epsg", 3663,
        "NAD83(NSRS2007) / Texas Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 3,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",31.88333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",30.11666666666667],PARAMETER[\"lati");
    add_srs_wkt (p, 11,
        "tude_of_origin\",29.66666666666667],PARAMETER[\"central_");
    add_srs_wkt (p, 12,
        "meridian\",-100.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 13,
        "\",700000],PARAMETER[\"false_northing\",3000000],UNIT[\"");
    add_srs_wkt (p, 14,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 15,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3663\"]]");
    p = add_epsg_def_ex (filter, first, last, 3664, "epsg", 3664,
        "NAD83(NSRS2007) / Texas Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 3,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",31.88333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",30.11666666666667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",29.66666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-100.3333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "easting\",2296583.333],PARAMETER[\"false_northing\",9842");
    add_srs_wkt (p, 14,
        "500.000000002],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 15,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 16,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3664\"]]");
    p = add_epsg_def_ex (filter, first, last, 3665, "epsg", 3665,
        "NAD83(NSRS2007) / Texas Centric Albers Equal Area", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Albers_Conic_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas Centric Albers Equal Ar");
    add_srs_wkt (p, 1,
        "ea\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2007\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 4,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 7,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"4759\"]],PROJECTION[\"Albers_Conic_Equal_Area");
    add_srs_wkt (p, 9,
        "\"],PARAMETER[\"standard_parallel_1\",27.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",35],PARAMETER[\"latitude_of_center");
    add_srs_wkt (p, 11,
        "\",18],PARAMETER[\"longitude_of_center\",-100],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_easting\",1500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",6000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3665\"]]");
    p = add_epsg_def_ex (filter, first, last, 3666, "epsg", 3666,
        "NAD83(NSRS2007) / Texas Centric Lambert Conformal", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x");
    add_proj4text (p, 1,
        "_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas Centric Lambert Conform");
    add_srs_wkt (p, 1,
        "al\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2007\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 4,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 7,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 9,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",27.5],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",35],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 11,
        "igin\",18],PARAMETER[\"central_meridian\",-100],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_easting\",1500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3666\"]]");
    p = add_epsg_def_ex (filter, first, last, 3667, "epsg", 3667,
        "NAD83(NSRS2007) / Texas North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas North\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",36.18333333333333],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",34.65],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 11,
        "\",34],PARAMETER[\"central_meridian\",-101.5],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_easting\",200000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 13,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "667\"]]");
    p = add_epsg_def_ex (filter, first, last, 3668, "epsg", 3668,
        "NAD83(NSRS2007) / Texas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.99989");
    add_proj4text (p, 2,
        "83998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",36.18333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",34.65],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",34],PARAMETER[\"central_meridian\",-101.5],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",656166.667],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",3280833.333],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 14,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 15,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3668\"]]");
    p = add_epsg_def_ex (filter, first, last, 3669, "epsg", 3669,
        "NAD83(NSRS2007) / Texas North Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas North Central\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",33.96666666666667],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",32.13333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",31.66666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-98.5],PARAMETER[\"false_easting\",600000");
    add_srs_wkt (p, 13,
        "],PARAMETER[\"false_northing\",2000000],UNIT[\"metre\",1");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 15,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3669\"]]");
    p = add_epsg_def_ex (filter, first, last, 3670, "epsg", 3670,
        "NAD83(NSRS2007) / Texas North Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas North Central (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",33.96666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",32.13333333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",31.66666666666667],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"central_meridian\",-98.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",1968500],PARAMETER[\"false_northing\",6561666.667],UNIT");
    add_srs_wkt (p, 14,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"3670\"]]");
    p = add_epsg_def_ex (filter, first, last, 3671, "epsg", 3671,
        "NAD83(NSRS2007) / Texas South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y");
    add_proj4text (p, 2,
        "_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas South\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",27.83333333333333],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",26.16666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 11,
        "de_of_origin\",25.66666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 12,
        "ridian\",-98.5],PARAMETER[\"false_easting\",300000],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",5000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"3671\"]]");
    p = add_epsg_def_ex (filter, first, last, 3672, "epsg", 3672,
        "NAD83(NSRS2007) / Texas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.00");
    add_proj4text (p, 2,
        "00000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",27.83333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",26.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",25.66666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-98.5],PARAMETER[\"false_easting\",984250");
    add_srs_wkt (p, 13,
        ".0000000002],PARAMETER[\"false_northing\",16404166.667],");
    add_srs_wkt (p, 14,
        "UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 16,
        "ORITY[\"EPSG\",\"3672\"]]");
    p = add_epsg_def_ex (filter, first, last, 3673, "epsg", 3673,
        "NAD83(NSRS2007) / Texas South Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas South Central\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",30.28333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",28.38333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",27.83333333333333],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-99],PARAMETER[\"false_easting\",600000],");
    add_srs_wkt (p, 13,
        "PARAMETER[\"false_northing\",4000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"3673\"]]");
    p = add_epsg_def_ex (filter, first, last, 3674, "epsg", 3674,
        "NAD83(NSRS2007) / Texas South Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Texas South Central (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",30.28333333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",28.38333333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",27.83333333333333],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"central_meridian\",-99],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 13,
        "1968500],PARAMETER[\"false_northing\",13123333.333],UNIT");
    add_srs_wkt (p, 14,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"3674\"]]");
    p = add_epsg_def_ex (filter, first, last, 3675, "epsg", 3675,
        "NAD83(NSRS2007) / Utah Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",40.65],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",39.01666666666667],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 11,
        "\",38.33333333333334],PARAMETER[\"central_meridian\",-11");
    add_srs_wkt (p, 12,
        "1.5],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 13,
        "se_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"3675\"]]");
    p = add_epsg_def_ex (filter, first, last, 3676, "epsg", 3676,
        "NAD83(NSRS2007) / Utah Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah Central (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",40.65],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",39.01666666666667],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",38.33333333333334],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-111.5],PARAMETER[\"false_easting\",1640419.948],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",6561679.79],UNIT[\"foot\",0.304");
    add_srs_wkt (p, 14,
        "8,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3676\"]]");
    p = add_epsg_def_ex (filter, first, last, 3677, "epsg", 3677,
        "NAD83(NSRS2007) / Utah Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0");
    add_proj4text (p, 2,
        "=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 3,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",40.65],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",39.01666666666667],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 11,
        "_origin\",38.33333333333334],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 12,
        "n\",-111.5],PARAMETER[\"false_easting\",1640416.6667],PA");
    add_srs_wkt (p, 13,
        "RAMETER[\"false_northing\",6561666.666700001],UNIT[\"US ");
    add_srs_wkt (p, 14,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 15,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"3677\"]]");
    p = add_epsg_def_ex (filter, first, last, 3678, "epsg", 3678,
        "NAD83(NSRS2007) / Utah North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah North\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",41.78333333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",40.71666666666667],PARAMETER[\"latitud");
    add_srs_wkt (p, 11,
        "e_of_origin\",40.33333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 12,
        "idian\",-111.5],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"3678\"]]");
    p = add_epsg_def_ex (filter, first, last, 3679, "epsg", 3679,
        "NAD83(NSRS2007) / Utah North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",41.78333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",40.71666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 11,
        "itude_of_origin\",40.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 12,
        "_meridian\",-111.5],PARAMETER[\"false_easting\",1640419.");
    add_srs_wkt (p, 13,
        "948],PARAMETER[\"false_northing\",3280839.895],UNIT[\"fo");
    add_srs_wkt (p, 14,
        "ot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 15,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3679\"]]");
    p = add_epsg_def_ex (filter, first, last, 3680, "epsg", 3680,
        "NAD83(NSRS2007) / Utah North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "0001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 3,
        ",0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",41.78333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",40.71666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",40.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 12,
        "ral_meridian\",-111.5],PARAMETER[\"false_easting\",16404");
    add_srs_wkt (p, 13,
        "16.6667],PARAMETER[\"false_northing\",3280833.333300001]");
    add_srs_wkt (p, 14,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 16,
        "HORITY[\"EPSG\",\"3680\"]]");
    p = add_epsg_def_ex (filter, first, last, 3681, "epsg", 3681,
        "NAD83(NSRS2007) / Utah South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah South\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",38.35],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",37.21666666666667],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",36.66666666666666],PARAMETER[\"central_meridian\",-111.");
    add_srs_wkt (p, 12,
        "5],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 13,
        "_northing\",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"3681\"]]");
    p = add_epsg_def_ex (filter, first, last, 3682, "epsg", 3682,
        "NAD83(NSRS2007) / Utah South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",38.35],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",37.21666666666667],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 11,
        "gin\",36.66666666666666],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 12,
        "-111.5],PARAMETER[\"false_easting\",1640419.948],PARAMET");
    add_srs_wkt (p, 13,
        "ER[\"false_northing\",9842519.685],UNIT[\"foot\",0.3048,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"3682\"]]");
    p = add_epsg_def_ex (filter, first, last, 3683, "epsg", 3683,
        "NAD83(NSRS2007) / Utah South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0");
    add_proj4text (p, 2,
        "=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Utah South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",38.35],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",37.21666666666667],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",36.66666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-111.5],PARAMETER[\"false_easting\",1640416.6667],PAR");
    add_srs_wkt (p, 13,
        "AMETER[\"false_northing\",9842500.000000002],UNIT[\"US s");
    add_srs_wkt (p, 14,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 15,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"3683\"]]");
    p = add_epsg_def_ex (filter, first, last, 3684, "epsg", 3684,
        "NAD83(NSRS2007) / Vermont", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Vermont\",GEOGCS[\"NAD83(NSRS");
    add_srs_wkt (p, 1,
        "2007)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",42.5],PARAMETER[\"central_meridian\",-72.5],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.999964286],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3684\"]]");
    p = add_epsg_def_ex (filter, first, last, 3685, "epsg", 3685,
        "NAD83(NSRS2007) / Virginia North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",39.2],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_2\",38.03333333333333],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 11,
        "in\",37.66666666666666],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 12,
        "78.5],PARAMETER[\"false_easting\",3500000],PARAMETER[\"f");
    add_srs_wkt (p, 13,
        "alse_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"3685\"]]");
    p = add_epsg_def_ex (filter, first, last, 3686, "epsg", 3686,
        "NAD83(NSRS2007) / Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2");
    add_proj4text (p, 2,
        "000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",39.2],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",38.03333333333333],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 11,
        "f_origin\",37.66666666666666],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 12,
        "an\",-78.5],PARAMETER[\"false_easting\",11482916.667],PA");
    add_srs_wkt (p, 13,
        "RAMETER[\"false_northing\",6561666.667],UNIT[\"US survey");
    add_srs_wkt (p, 14,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 15,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 16,
        "3686\"]]");
    p = add_epsg_def_ex (filter, first, last, 3687, "epsg", 3687,
        "NAD83(NSRS2007) / Virginia South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",37.96666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",36.76666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 11,
        "itude_of_origin\",36.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 12,
        "_meridian\",-78.5],PARAMETER[\"false_easting\",3500000],");
    add_srs_wkt (p, 13,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"3687\"]]");
    p = add_epsg_def_ex (filter, first, last, 3688, "epsg", 3688,
        "NAD83(NSRS2007) / Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0");
    add_proj4text (p, 2,
        "001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",37.96666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",36.76666666666667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",36.33333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-78.5],PARAMETER[\"false_easting\",114");
    add_srs_wkt (p, 13,
        "82916.667],PARAMETER[\"false_northing\",3280833.333],UNI");
    add_srs_wkt (p, 14,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"3688\"]]");
    p = add_epsg_def_ex (filter, first, last, 3689, "epsg", 3689,
        "NAD83(NSRS2007) / Washington North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Washington North\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",48.73333333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",47.5],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 11,
        "igin\",47],PARAMETER[\"central_meridian\",-120.833333333");
    add_srs_wkt (p, 12,
        "3333],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 13,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"3689\"]]");
    p = add_epsg_def_ex (filter, first, last, 3690, "epsg", 3690,
        "NAD83(NSRS2007) / Washington North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Washington North (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",48.73333333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",47.5],PARAMETER[\"latitud");
    add_srs_wkt (p, 11,
        "e_of_origin\",47],PARAMETER[\"central_meridian\",-120.83");
    add_srs_wkt (p, 12,
        "33333333333],PARAMETER[\"false_easting\",1640416.667],PA");
    add_srs_wkt (p, 13,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 14,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 15,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3690\"]]");
    p = add_epsg_def_ex (filter, first, last, 3691, "epsg", 3691,
        "NAD83(NSRS2007) / Washington South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Washington South\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",47.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",45.83333333333334],PARAMETER[\"l");
    add_srs_wkt (p, 11,
        "atitude_of_origin\",45.33333333333334],PARAMETER[\"centr");
    add_srs_wkt (p, 12,
        "al_meridian\",-120.5],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 13,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"3691\"]]");
    p = add_epsg_def_ex (filter, first, last, 3692, "epsg", 3692,
        "NAD83(NSRS2007) / Washington South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Washington South (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 7,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",47.33333333333334],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",45.83333333333334],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"latitude_of_origin\",45.33333333333334],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"central_meridian\",-120.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",1640416.667],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 14,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 15,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"3692\"]]");
    p = add_epsg_def_ex (filter, first, last, 3693, "epsg", 3693,
        "NAD83(NSRS2007) / West Virginia North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia North\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",40.25],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",39],PARAMETER[\"latitude_of_origin\",38.5]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"central_meridian\",-79.5],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",600000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 13,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3693\"]]");
    p = add_epsg_def_ex (filter, first, last, 3694, "epsg", 3694,
        "NAD83(NSRS2007) / West Virginia South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia South\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",38.88333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",37.48333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",37],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 12,
        "-81],PARAMETER[\"false_easting\",600000],PARAMETER[\"fal");
    add_srs_wkt (p, 13,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"3694\"]]");
    p = add_epsg_def_ex (filter, first, last, 3695, "epsg", 3695,
        "NAD83(NSRS2007) / Wisconsin Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin Central\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",45.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",44.25],PARAMETER[\"latitude_of_origin\",43.8");
    add_srs_wkt (p, 11,
        "3333333333334],PARAMETER[\"central_meridian\",-90],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_easting\",600000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 13,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"36");
    add_srs_wkt (p, 15,
        "95\"]]");
    p = add_epsg_def_ex (filter, first, last, 3696, "epsg", 3696,
        "NAD83(NSRS2007) / Wisconsin Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin Central (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",45.5],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",44.25],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",43.83333333333334],PARAMETER[\"central_meridian\",-90],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_easting\",1968500],PARAMETER[\"false_n");
    add_srs_wkt (p, 13,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"3696\"]]");
    p = add_epsg_def_ex (filter, first, last, 3697, "epsg", 3697,
        "NAD83(NSRS2007) / Wisconsin North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin North\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",46.76666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",45.56666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 11,
        "itude_of_origin\",45.16666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 12,
        "_meridian\",-90],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 13,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"3697\"]]");
    p = add_epsg_def_ex (filter, first, last, 3698, "epsg", 3698,
        "NAD83(NSRS2007) / Wisconsin North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",46.76666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",45.56666666666667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",45.16666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-90],PARAMETER[\"false_easting\",19685");
    add_srs_wkt (p, 13,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 14,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 15,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"369");
    add_srs_wkt (p, 16,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3699, "epsg", 3699,
        "NAD83(NSRS2007) / Wisconsin South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin South\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",44.06666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",42.73333333333333],PARAMETER[\"lat");
    add_srs_wkt (p, 11,
        "itude_of_origin\",42],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",600000],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"3699\"]]");
    p = add_epsg_def_ex (filter, first, last, 3700, "epsg", 3700,
        "NAD83(NSRS2007) / Wisconsin South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",44.06666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",42.73333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",42],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-90],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 14,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3700\"]]");
    p = add_epsg_def_ex (filter, first, last, 3701, "epsg", 3701,
        "NAD83(NSRS2007) / Wisconsin Transverse Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y");
    add_proj4text (p, 1,
        "_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wisconsin Transverse Mercator");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2007\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-90],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",520000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",-4480000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"3701\"]]");
    p = add_epsg_def_ex (filter, first, last, 3702, "epsg", 3702,
        "NAD83(NSRS2007) / Wyoming East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",40.5],PARAMETER[\"central_meridian\",-105.");
    add_srs_wkt (p, 10,
        "1666666666667],PARAMETER[\"scale_factor\",0.9999375],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",200000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3702\"]]");
    p = add_epsg_def_ex (filter, first, last, 3703, "epsg", 3703,
        "NAD83(NSRS2007) / Wyoming East Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming East Central\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",40.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-107.3333333333333],PARAMETER[\"scale_factor\",0.999937");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",400000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"3703\"]]");
    p = add_epsg_def_ex (filter, first, last, 3704, "epsg", 3704,
        "NAD83(NSRS2007) / Wyoming West Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming West Central\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",40.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-108.75],PARAMETER[\"scale_factor\",0.9999375],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",600000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3704\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3705, "epsg", 3705,
        "NAD83(NSRS2007) / Wyoming West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",40.5],PARAMETER[\"central_meridian\",-110.");
    add_srs_wkt (p, 10,
        "0833333333333],PARAMETER[\"scale_factor\",0.9999375],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",800000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"3705\"]]");
    p = add_epsg_def_ex (filter, first, last, 3706, "epsg", 3706,
        "NAD83(NSRS2007) / UTM zone 59N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 59N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",171],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3706\"]]");
    p = add_epsg_def_ex (filter, first, last, 3707, "epsg", 3707,
        "NAD83(NSRS2007) / UTM zone 60N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 60N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",177],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3707\"]]");
    p = add_epsg_def_ex (filter, first, last, 3708, "epsg", 3708,
        "NAD83(NSRS2007) / UTM zone 1N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 1N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-177],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3708\"]]");
    p = add_epsg_def_ex (filter, first, last, 3709, "epsg", 3709,
        "NAD83(NSRS2007) / UTM zone 2N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 2N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-171],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3709\"]]");
    p = add_epsg_def_ex (filter, first, last, 3710, "epsg", 3710,
        "NAD83(NSRS2007) / UTM zone 3N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 3N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-165],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3710\"]]");
    p = add_epsg_def_ex (filter, first, last, 3711, "epsg", 3711,
        "NAD83(NSRS2007) / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 4N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-159],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3711\"]]");
    p = add_epsg_def_ex (filter, first, last, 3712, "epsg", 3712,
        "NAD83(NSRS2007) / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 5N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-153],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3712\"]]");
    p = add_epsg_def_ex (filter, first, last, 3713, "epsg", 3713,
        "NAD83(NSRS2007) / UTM zone 6N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 6N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-147],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3713\"]]");
    p = add_epsg_def_ex (filter, first, last, 3714, "epsg", 3714,
        "NAD83(NSRS2007) / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 7N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-141],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3714\"]]");
    p = add_epsg_def_ex (filter, first, last, 3715, "epsg", 3715,
        "NAD83(NSRS2007) / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 8N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-135],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3715\"]]");
    p = add_epsg_def_ex (filter, first, last, 3716, "epsg", 3716,
        "NAD83(NSRS2007) / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 9N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-129],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3716\"]]");
    p = add_epsg_def_ex (filter, first, last, 3717, "epsg", 3717,
        "NAD83(NSRS2007) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 10N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-123],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3717\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3718, "epsg", 3718,
        "NAD83(NSRS2007) / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 11N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-117],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3718\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3719, "epsg", 3719,
        "NAD83(NSRS2007) / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 12N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3719\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3720, "epsg", 3720,
        "NAD83(NSRS2007) / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 13N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-105],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3720\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3721, "epsg", 3721,
        "NAD83(NSRS2007) / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 14N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-99],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3721\"]]");
    p = add_epsg_def_ex (filter, first, last, 3722, "epsg", 3722,
        "NAD83(NSRS2007) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 15N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-93],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3722\"]]");
    p = add_epsg_def_ex (filter, first, last, 3723, "epsg", 3723,
        "NAD83(NSRS2007) / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 16N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-87],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3723\"]]");
    p = add_epsg_def_ex (filter, first, last, 3724, "epsg", 3724,
        "NAD83(NSRS2007) / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 17N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-81],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3724\"]]");
    p = add_epsg_def_ex (filter, first, last, 3725, "epsg", 3725,
        "NAD83(NSRS2007) / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 18N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-75],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3725\"]]");
    p = add_epsg_def_ex (filter, first, last, 3726, "epsg", 3726,
        "NAD83(NSRS2007) / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / UTM zone 19N\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-69],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3726\"]]");
    p = add_epsg_def_ex (filter, first, last, 3727, "epsg", 3727,
        "Reunion 1947 / TM Reunion", 0, 0,
        "International 1924", "Greenwich",
        "Reunion_1947", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=160000 +y_0=50000 +ellps=intl +towgs84=");
    add_proj4text (p, 2,
        "94,-948,-1262,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Reunion 1947 / TM Reunion\",GEOGCS[\"Reunion 19");
    add_srs_wkt (p, 1,
        "47\",DATUM[\"Reunion_1947\",SPHEROID[\"International 192");
    add_srs_wkt (p, 2,
        "4\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[94");
    add_srs_wkt (p, 3,
        ",-948,-1262,0,0,0,0],AUTHORITY[\"EPSG\",\"6626\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4626\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",-21.11666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",55.53333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",16");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",50000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3727\"]]");
    p = add_epsg_def_ex (filter, first, last, 3728, "epsg", 3728,
        "NAD83(NSRS2007) / Ohio North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Ohio North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",41.7],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",40.43333333333333],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 11,
        "rigin\",39.66666666666666],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 12,
        ",-82.5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 14,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3728\"]]");
    p = add_epsg_def_ex (filter, first, last, 3729, "epsg", 3729,
        "NAD83(NSRS2007) / Ohio South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Ohio South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",40.03333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",38.73333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 12,
        "-82.5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 14,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3729\"]]");
    p = add_epsg_def_ex (filter, first, last, 3730, "epsg", 3730,
        "NAD83(NSRS2007) / Wyoming East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",40.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-105.1666666666667],PARAMETER[\"scale_factor\",0.999937");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",656166.6667],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3730\"]]");
    p = add_epsg_def_ex (filter, first, last, 3731, "epsg", 3731,
        "NAD83(NSRS2007) / Wyoming East Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming East Central (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",40.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-107.3333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.9999375],PARAMETER[\"false_easting\",1312333.3333],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",328083.3333],UNIT[\"US survey");
    add_srs_wkt (p, 13,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3731\"]]");
    p = add_epsg_def_ex (filter, first, last, 3732, "epsg", 3732,
        "NAD83(NSRS2007) / Wyoming West Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming West Central (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",40.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-108.75],PARAMETER[\"scale_factor\",0.9999375]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",1968500],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3732\"]]");
    p = add_epsg_def_ex (filter, first, last, 3733, "epsg", 3733,
        "NAD83(NSRS2007) / Wyoming West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Wyoming West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 8,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",40.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-110.0833333333333],PARAMETER[\"scale_factor\",0.999937");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",2624666.6667],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",328083.3333],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3733\"]]");
    p = add_epsg_def_ex (filter, first, last, 3734, "epsg", 3734,
        "NAD83 / Ohio North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ohio North (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",41.7],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",40.43333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"latitude_of_origin\",39.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-82.5],PARAMETER[\"false_easting\",19");
    add_srs_wkt (p, 12,
        "68500],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "3734\"]]");
    p = add_epsg_def_ex (filter, first, last, 3735, "epsg", 3735,
        "NAD83 / Ohio South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ohio South (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",40.03333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",38.73333333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",-82.5],PARAMETER[\"false_easting\",1968");
    add_srs_wkt (p, 12,
        "500],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 13,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"37");
    add_srs_wkt (p, 15,
        "35\"]]");
    p = add_epsg_def_ex (filter, first, last, 3736, "epsg", 3736,
        "NAD83 / Wyoming East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-105.1666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999375],PARAMETER[\"false_easting\",656166.6");
    add_srs_wkt (p, 11,
        "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"37");
    add_srs_wkt (p, 14,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 3737, "epsg", 3737,
        "NAD83 / Wyoming East Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming East Central (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-107.3333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",0.9999375],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1312333.3333],PARAMETER[\"false_northing\",328083.3333]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"3737\"]]");
    p = add_epsg_def_ex (filter, first, last, 3738, "epsg", 3738,
        "NAD83 / Wyoming West Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming West Central (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-108.75],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999375],PARAMETER[\"false_easting\",1968500],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3738\"]]");
    p = add_epsg_def_ex (filter, first, last, 3739, "epsg", 3739,
        "NAD83 / Wyoming West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-110.0833333333333],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999375],PARAMETER[\"false_easting\",2624666.");
    add_srs_wkt (p, 11,
        "6667],PARAMETER[\"false_northing\",328083.3333],UNIT[\"U");
    add_srs_wkt (p, 12,
        "S survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3739\"]]");
    p = add_epsg_def_ex (filter, first, last, 3740, "epsg", 3740,
        "NAD83(HARN) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 10N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-123],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3740\"]]");
    p = add_epsg_def_ex (filter, first, last, 3741, "epsg", 3741,
        "NAD83(HARN) / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 11N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-117],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3741\"]]");
    p = add_epsg_def_ex (filter, first, last, 3742, "epsg", 3742,
        "NAD83(HARN) / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 12N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-111],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3742\"]]");
    p = add_epsg_def_ex (filter, first, last, 3743, "epsg", 3743,
        "NAD83(HARN) / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 13N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-105],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3743\"]]");
    p = add_epsg_def_ex (filter, first, last, 3744, "epsg", 3744,
        "NAD83(HARN) / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 14N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-99],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3744\"]]");
    p = add_epsg_def_ex (filter, first, last, 3745, "epsg", 3745,
        "NAD83(HARN) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 15N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-93],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3745\"]]");
    p = add_epsg_def_ex (filter, first, last, 3746, "epsg", 3746,
        "NAD83(HARN) / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 16N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-87],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3746\"]]");
    p = add_epsg_def_ex (filter, first, last, 3747, "epsg", 3747,
        "NAD83(HARN) / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 17N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3747\"]]");
    p = add_epsg_def_ex (filter, first, last, 3748, "epsg", 3748,
        "NAD83(HARN) / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 18N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3748\"]]");
    p = add_epsg_def_ex (filter, first, last, 3749, "epsg", 3749,
        "NAD83(HARN) / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 19N\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3749\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

