/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_53 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 31289, "epsg", 31289,
        "MGI (Ferro) / M31", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=450000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / M31\",GEOGCS[\"MGI (Ferro)\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Militar_Geographische_Institut_Ferro\",SPHEROID[\"Be");
    add_srs_wkt (p, 2,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5.29");
    add_srs_wkt (p, 4,
        "7,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],PRIMEM[\"Ferro\"");
    add_srs_wkt (p, 5,
        ",-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",31],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",450000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"31289\"]]");
    p = add_epsg_def_ex (filter, first, last, 31290, "epsg", 31290,
        "MGI (Ferro) / M34", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=750000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / M34\",GEOGCS[\"MGI (Ferro)\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Militar_Geographische_Institut_Ferro\",SPHEROID[\"Be");
    add_srs_wkt (p, 2,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5.29");
    add_srs_wkt (p, 4,
        "7,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],PRIMEM[\"Ferro\"");
    add_srs_wkt (p, 5,
        ",-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",34],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",750000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"31290\"]]");
    p = add_epsg_def_ex (filter, first, last, 31291, "epsg", 31291,
        "MGI (Ferro) / Austria West Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria West Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5");
    add_srs_wkt (p, 4,
        ".137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"31281\"]]");
    p = add_epsg_def_ex (filter, first, last, 31292, "epsg", 31292,
        "MGI (Ferro) / Austria Central Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria Central Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.91");
    add_srs_wkt (p, 4,
        "9,5.137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",31],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"31282\"]]");
    p = add_epsg_def_ex (filter, first, last, 31293, "epsg", 31293,
        "MGI (Ferro) / Austria East Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria East Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5");
    add_srs_wkt (p, 4,
        ".137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"31283\"]]");
    p = add_epsg_def_ex (filter, first, last, 31294, "epsg", 31294,
        "MGI / Austria M28", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M28\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",150000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31284\"]]");
    p = add_epsg_def_ex (filter, first, last, 31295, "epsg", 31295,
        "MGI / Austria M31", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M31\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",450000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31285\"]]");
    p = add_epsg_def_ex (filter, first, last, 31296, "epsg", 31296,
        "MGI / Austria M34", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M34\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",750000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31286\"]]");
    p = add_epsg_def_ex (filter, first, last, 31297, "epsg", 31297,
        "MGI / Austria Lambert", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs8");
    add_proj4text (p, 2,
        "4=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria Lambert\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",47.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",13.3333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_1\",49],PARAMETER[\"standard_parallel_2\",46],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",400000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"31287\"]]");
    p = add_epsg_def_ex (filter, first, last, 31300, "epsg", 31300,
        "Belge 1972 / Belge Lambert 72", 0, 0,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "Lambert_Conformal_Conic_2SP_Belgium", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=90 +lon_0=4.356939722222222 +x_0=150000.01256");
    add_proj4text (p, 2,
        " +y_0=5400088.4378 +ellps=intl +towgs84=-106.8686,52.297");
    add_proj4text (p, 3,
        "8,-103.7239,0.3366,-0.457,1.8422,-1.2747 +units=m +no_de");
    add_proj4text (p, 4,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Belge 1972 / Belge Lambert 72\",GEOGCS[\"Belge ");
    add_srs_wkt (p, 1,
        "1972\",DATUM[\"Reseau_National_Belge_1972\",SPHEROID[\"I");
    add_srs_wkt (p, 2,
        "nternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "2\"]],TOWGS84[-99.059,53.322,-112.486,0.419,-0.83,1.885,");
    add_srs_wkt (p, 4,
        "-1],AUTHORITY[\"EPSG\",\"6313\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4313\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP_B");
    add_srs_wkt (p, 8,
        "elgium\"],PARAMETER[\"latitude_of_origin\",90],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",4.35693972222222],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_1\",49.8333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 11,
        "_parallel_2\",51.1666666666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",150000.01256],PARAMETER[\"false_northing\",5400088.4");
    add_srs_wkt (p, 13,
        "378],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"31300\"]]");
    p = add_epsg_def_ex (filter, first, last, 31370, "epsg", 31370,
        "Belge 1972 / Belgian Lambert 72", 0, 0,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=51.16666723333333 +lat_2=49.8333339 +la");
    add_proj4text (p, 1,
        "t_0=90 +lon_0=4.367486666666666 +x_0=150000.013 +y_0=540");
    add_proj4text (p, 2,
        "0088.438 +ellps=intl +towgs84=-106.8686,52.2978,-103.723");
    add_proj4text (p, 3,
        "9,0.3366,-0.457,1.8422,-1.2747 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Belge 1972 / Belgian Lambert 72\",GEOGCS[\"Belg");
    add_srs_wkt (p, 1,
        "e 1972\",DATUM[\"Reseau_National_Belge_1972\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-99.059,53.322,-112.486,0.419,-0.83,1.885");
    add_srs_wkt (p, 4,
        ",-1],AUTHORITY[\"EPSG\",\"6313\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4313\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",90],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",4.36748666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_1\",51.1666672333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 11,
        "l_2\",49.8333339],PARAMETER[\"false_easting\",150000.013");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",5400088.438],UNIT[\"metre");
    add_srs_wkt (p, 13,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31370\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 31461, "epsg", 31461,
        "DHDN / 3-degree Gauss zone 1 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 1 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[612.4,77,440.2,-0.054,0.057,-2");
    add_srs_wkt (p, 4,
        ".797,2.55],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",3],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"31461\"]]");
    p = add_epsg_def_ex (filter, first, last, 31462, "epsg", 31462,
        "DHDN / 3-degree Gauss-Kruger zone 2", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",6],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31466\"]]");
    p = add_epsg_def_ex (filter, first, last, 31463, "epsg", 31463,
        "DHDN / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",3500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31467\"]]");
    p = add_epsg_def_ex (filter, first, last, 31464, "epsg", 31464,
        "DHDN / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31468\"]]");
    p = add_epsg_def_ex (filter, first, last, 31465, "epsg", 31465,
        "DHDN / 3-degree Gauss-Kruger zone 5", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",5500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31469\"]]");
    p = add_epsg_def_ex (filter, first, last, 31466, "epsg", 31466,
        "DHDN / 3-degree Gauss-Kruger zone 2", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",6],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31466\"]]");
    p = add_epsg_def_ex (filter, first, last, 31467, "epsg", 31467,
        "DHDN / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",3500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31467\"]]");
    p = add_epsg_def_ex (filter, first, last, 31468, "epsg", 31468,
        "DHDN / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31468\"]]");
    p = add_epsg_def_ex (filter, first, last, 31469, "epsg", 31469,
        "DHDN / 3-degree Gauss-Kruger zone 5", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",5500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31469\"]]");
    p = add_epsg_def_ex (filter, first, last, 31528, "epsg", 31528,
        "Conakry 1905 / UTM zone 28N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 28N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "1\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-15],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31528\"]]");
    p = add_epsg_def_ex (filter, first, last, 31529, "epsg", 31529,
        "Conakry 1905 / UTM zone 29N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 29N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "1\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"31529\"]]");
    p = add_epsg_def_ex (filter, first, last, 31600, "epsg", 31600,
        "Dealul Piscului 1930 / Stereo 33", 0, 0,
        "International 1924", "Greenwich",
        "Dealul_Piscului_1930", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=45.9 +lon_0=25.39246588888889 +k=0.9");
    add_proj4text (p, 1,
        "996667 +x_0=500000 +y_0=500000 +ellps=intl +towgs84=103.");
    add_proj4text (p, 2,
        "25,-100.4,-307.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dealul Piscului 1930 / Stereo 33\",GEOGCS[\"Dea");
    add_srs_wkt (p, 1,
        "lul Piscului 1930\",DATUM[\"Dealul_Piscului_1930\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[103.25,-100.4,-307.19,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6316\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4316");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",45.9],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",25.3924658888889],PARAMETER[\"scale_factor\",0.9996667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"31600\"]]");
    p = add_epsg_def_ex (filter, first, last, 31700, "epsg", 31700,
        "Pulkovo 1942(58) / Stereo70", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=500000 +ellps=krass +towgs84=28,-121,-77,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Stereo70\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[2.329,-147.042,-92.08,-0.309,0.325,0.497,5.69],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "79\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",46],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "25],PARAMETER[\"scale_factor\",0.99975],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",500000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"3844\"]]");
    p = add_epsg_def_ex (filter, first, last, 31838, "epsg", 31838,
        "NGN / UTM zone 38N", 0, 0,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 38N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-3.2,-5");
    add_srs_wkt (p, 3,
        ".7,2.8,0,0,0,0],AUTHORITY[\"EPSG\",\"6318\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",45],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"31838\"]]");
    p = add_epsg_def_ex (filter, first, last, 31839, "epsg", 31839,
        "NGN / UTM zone 39N", 0, 0,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 39N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-3.2,-5");
    add_srs_wkt (p, 3,
        ".7,2.8,0,0,0,0],AUTHORITY[\"EPSG\",\"6318\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",51],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"31839\"]]");
    p = add_epsg_def_ex (filter, first, last, 31900, "epsg", 31900,
        "KUDAMS / KTM", 0, 0,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM\",GEOGCS[\"KUDAMS\",DATUM[\"Kuwait");
    add_srs_wkt (p, 1,
        "_Utility\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-20.8,11.3,2.4,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6319\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4319\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",48],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "31901\"]]");
    p = add_epsg_def_ex (filter, first, last, 31901, "epsg", 31901,
        "KUDAMS / KTM", 0, 0,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM\",GEOGCS[\"KUDAMS\",DATUM[\"Kuwait");
    add_srs_wkt (p, 1,
        "_Utility\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-20.8,11.3,2.4,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6319\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4319\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",48],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "31901\"]]");
    p = add_epsg_def_ex (filter, first, last, 31965, "epsg", 31965,
        "SIRGAS 2000 / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 11N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31965\"]]");
    p = add_epsg_def_ex (filter, first, last, 31966, "epsg", 31966,
        "SIRGAS 2000 / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 12N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31966\"]]");
    p = add_epsg_def_ex (filter, first, last, 31967, "epsg", 31967,
        "SIRGAS 2000 / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 13N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31967\"]]");
    p = add_epsg_def_ex (filter, first, last, 31968, "epsg", 31968,
        "SIRGAS 2000 / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 14N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31968\"]]");
    p = add_epsg_def_ex (filter, first, last, 31969, "epsg", 31969,
        "SIRGAS 2000 / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 15N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31969\"]]");
    p = add_epsg_def_ex (filter, first, last, 31970, "epsg", 31970,
        "SIRGAS 2000 / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 16N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31970\"]]");
    p = add_epsg_def_ex (filter, first, last, 31971, "epsg", 31971,
        "SIRGAS 2000 / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31971\"]]");
    p = add_epsg_def_ex (filter, first, last, 31972, "epsg", 31972,
        "SIRGAS 2000 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31972\"]]");
    p = add_epsg_def_ex (filter, first, last, 31973, "epsg", 31973,
        "SIRGAS 2000 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31973\"]]");
    p = add_epsg_def_ex (filter, first, last, 31974, "epsg", 31974,
        "SIRGAS 2000 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31974\"]]");
    p = add_epsg_def_ex (filter, first, last, 31975, "epsg", 31975,
        "SIRGAS 2000 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31975\"]]");
    p = add_epsg_def_ex (filter, first, last, 31976, "epsg", 31976,
        "SIRGAS 2000 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31976\"]]");
    p = add_epsg_def_ex (filter, first, last, 31977, "epsg", 31977,
        "SIRGAS 2000 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31977\"]]");
    p = add_epsg_def_ex (filter, first, last, 31978, "epsg", 31978,
        "SIRGAS 2000 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31978\"]]");
    p = add_epsg_def_ex (filter, first, last, 31979, "epsg", 31979,
        "SIRGAS 2000 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31979\"]]");
    p = add_epsg_def_ex (filter, first, last, 31980, "epsg", 31980,
        "SIRGAS 2000 / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31980\"]]");
    p = add_epsg_def_ex (filter, first, last, 31981, "epsg", 31981,
        "SIRGAS 2000 / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31981\"]]");
    p = add_epsg_def_ex (filter, first, last, 31982, "epsg", 31982,
        "SIRGAS 2000 / UTM zone 22S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31982\"]]");
    p = add_epsg_def_ex (filter, first, last, 31983, "epsg", 31983,
        "SIRGAS 2000 / UTM zone 23S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 23S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31983\"]]");
    p = add_epsg_def_ex (filter, first, last, 31984, "epsg", 31984,
        "SIRGAS 2000 / UTM zone 24S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 24S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31984\"]]");
    p = add_epsg_def_ex (filter, first, last, 31985, "epsg", 31985,
        "SIRGAS 2000 / UTM zone 25S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 25S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31985\"]]");
    p = add_epsg_def_ex (filter, first, last, 31986, "epsg", 31986,
        "SIRGAS 1995 / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31986\"]]");
    p = add_epsg_def_ex (filter, first, last, 31987, "epsg", 31987,
        "SIRGAS 1995 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31987\"]]");
    p = add_epsg_def_ex (filter, first, last, 31988, "epsg", 31988,
        "SIRGAS 1995 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31988\"]]");
    p = add_epsg_def_ex (filter, first, last, 31989, "epsg", 31989,
        "SIRGAS 1995 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31989\"]]");
    p = add_epsg_def_ex (filter, first, last, 31990, "epsg", 31990,
        "SIRGAS 1995 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31990\"]]");
    p = add_epsg_def_ex (filter, first, last, 31991, "epsg", 31991,
        "SIRGAS 1995 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31991\"]]");
    p = add_epsg_def_ex (filter, first, last, 31992, "epsg", 31992,
        "SIRGAS 1995 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31992\"]]");
    p = add_epsg_def_ex (filter, first, last, 31993, "epsg", 31993,
        "SIRGAS 1995 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31993\"]]");
    p = add_epsg_def_ex (filter, first, last, 31994, "epsg", 31994,
        "SIRGAS 1995 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31994\"]]");
    p = add_epsg_def_ex (filter, first, last, 31995, "epsg", 31995,
        "SIRGAS 1995 / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31995\"]]");
    p = add_epsg_def_ex (filter, first, last, 31996, "epsg", 31996,
        "SIRGAS 1995 / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31996\"]]");
    p = add_epsg_def_ex (filter, first, last, 31997, "epsg", 31997,
        "SIRGAS 1995 / UTM zone 22S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31997\"]]");
    p = add_epsg_def_ex (filter, first, last, 31998, "epsg", 31998,
        "SIRGAS 1995 / UTM zone 23S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 23S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31998\"]]");
    p = add_epsg_def_ex (filter, first, last, 31999, "epsg", 31999,
        "SIRGAS 1995 / UTM zone 24S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 24S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31999\"]]");
    p = add_epsg_def_ex (filter, first, last, 32000, "epsg", 32000,
        "SIRGAS 1995 / UTM zone 25S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 25S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"32000\"]]");
    p = add_epsg_def_ex (filter, first, last, 32001, "epsg", 32001,
        "NAD27 / Montana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=4");
    add_proj4text (p, 1,
        "7 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",47],PARAMETER[\"central_meridian\",-109.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",48.7166666666667],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",47.85],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"32001\"]]");
    p = add_epsg_def_ex (filter, first, last, 32002, "epsg", 32002,
        "NAD27 / Montana Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=4");
    add_proj4text (p, 1,
        "5.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",45.8333333333333],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 9,
        "9.5],PARAMETER[\"standard_parallel_1\",47.8833333333333]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"standard_parallel_2\",46.45],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2000000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"32002\"]]");
    p = add_epsg_def_ex (filter, first, last, 32003, "epsg", 32003,
        "NAD27 / Montana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44");
    add_proj4text (p, 1,
        " +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana South\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",44],PARAMETER[\"central_meridian\",-109.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",46.4],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",44.8666666666667],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"32003\"]]");
    p = add_epsg_def_ex (filter, first, last, 32005, "epsg", 32005,
        "NAD27 / Nebraska North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "1.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",41.3333333333333],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"standard_parallel_1\",41.85],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",42.8166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",2000000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"32005\"]]");
    p = add_epsg_def_ex (filter, first, last, 32006, "epsg", 32006,
        "NAD27 / Nebraska South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",39.6666666666667],PARAMETER[\"central_meridian\",-99");
    add_srs_wkt (p, 9,
        ".5],PARAMETER[\"standard_parallel_1\",40.2833333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"standard_parallel_2\",41.7166666666667],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",2000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"32006\"]]");
    p = add_epsg_def_ex (filter, first, last, 32007, "epsg", 32007,
        "NAD27 / Nevada East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",34.75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-115.583333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32007\"]]");
    p = add_epsg_def_ex (filter, first, last, 32008, "epsg", 32008,
        "NAD27 / Nevada Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada Central\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",34.7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-116.666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"32008\"]]");
    p = add_epsg_def_ex (filter, first, last, 32009, "epsg", 32009,
        "NAD27 / Nevada West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",34.75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-118.583333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"32009\"]]");
    p = add_epsg_def_ex (filter, first, last, 32010, "epsg", 32010,
        "NAD27 / New Hampshire", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Hampshire\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-71.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999966667],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"32010\"]]");
    p = add_epsg_def_ex (filter, first, last, 32011, "epsg", 32011,
        "NAD27 / New Jersey", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Jersey\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",38.83333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-74.66666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",0.999975],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",2000000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"32011\"]]");
    p = add_epsg_def_ex (filter, first, last, 32012, "epsg", 32012,
        "NAD27 / New Mexico East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico East\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",31],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-104.333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.999909091],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"32012\"]]");
    p = add_epsg_def_ex (filter, first, last, 32013, "epsg", 32013,
        "NAD27 / New Mexico Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=1524");
    add_proj4text (p, 1,
        "00.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico Central\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"central_meridian\",-106.25],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"32013\"]]");
    p = add_epsg_def_ex (filter, first, last, 32014, "epsg", 32014,
        "NAD27 / New Mexico West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico West\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",31],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-107.833333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.999916667],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"32014\"]]");
    p = add_epsg_def_ex (filter, first, last, 32015, "epsg", 32015,
        "NAD27 / New York East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999");
    add_proj4text (p, 1,
        "966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-74.3333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999966667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"32015\"]]");
    p = add_epsg_def_ex (filter, first, last, 32016, "epsg", 32016,
        "NAD27 / New York Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-76.5833333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.9999375],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"32016\"]]");
    p = add_epsg_def_ex (filter, first, last, 32017, "epsg", 32017,
        "NAD27 / New York West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-78.5833333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.9999375],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US sur");
    add_srs_wkt (p, 11,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"32017\"]]");
    p = add_epsg_def_ex (filter, first, last, 32018, "epsg", 32018,
        "NAD27 / New York Long Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",40.5],PARAMETER[\"central_meridian\",-74],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",41.0333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",40.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"4456\"]]");
    p = add_epsg_def_ex (filter, first, last, 32019, "epsg", 32019,
        "NAD27 / North Carolina", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Carolina\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",33.75],PARAMETER[\"central_meridian\",-79],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",34.3333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",36.1666666666667],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2000000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"32019\"]]");
    p = add_epsg_def_ex (filter, first, last, 32020, "epsg", 32020,
        "NAD27 / North Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",47],PARAMETER[\"central_meridian\",-100.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",47.4333333333333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",48.7333333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2000000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"32020\"]]");
    p = add_epsg_def_ex (filter, first, last, 32021, "epsg", 32021,
        "NAD27 / North Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",45.6666666666667],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-100.5],PARAMETER[\"standard_parallel_1\",46.18333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_2\",47.4833333333333],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32021\"]]");
    p = add_epsg_def_ex (filter, first, last, 32022, "epsg", 32022,
        "NAD27 / Ohio North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "39.6666666666667],PARAMETER[\"central_meridian\",-82.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",40.4333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",41.7],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"32022\"]]");
    p = add_epsg_def_ex (filter, first, last, 32023, "epsg", 32023,
        "NAD27 / Ohio South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "38],PARAMETER[\"central_meridian\",-82.5],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",38.7333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",40.0333333333333],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 12,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"32023\"]]");
    p = add_epsg_def_ex (filter, first, last, 32024, "epsg", 32024,
        "NAD27 / Oklahoma North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",35],PARAMETER[\"central_meridian\",-98],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",35.5666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",36.7666666666667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"32024\"]]");
    p = add_epsg_def_ex (filter, first, last, 32025, "epsg", 32025,
        "NAD27 / Oklahoma South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",33.3333333333333],PARAMETER[\"central_meridian\",-98");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",33.9333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",35.2333333333333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",2000000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 14,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32025\"]]");
    p = add_epsg_def_ex (filter, first, last, 32026, "epsg", 32026,
        "NAD27 / Oregon North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.6666666666667],PARAMETER[\"central_meridian\",-120.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",44.3333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",46],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"32026\"]]");
    p = add_epsg_def_ex (filter, first, last, 32027, "epsg", 32027,
        "NAD27 / Oregon South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",41.6666666666667],PARAMETER[\"central_meridian\",-120.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",42.3333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",44],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"32027\"]]");
    p = add_epsg_def_ex (filter, first, last, 32028, "epsg", 32028,
        "NAD27 / Pennsylvania North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",40.1666666666667],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-77.75],PARAMETER[\"standard_parallel_1\",40.88333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_2\",41.95],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2000000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"32028\"]]");
    p = add_epsg_def_ex (filter, first, last, 32029, "epsg", 32029,
        "NAD27 / Pennsylvania South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",39.3333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-77.75],PARAMETER[\"standard_parallel_1\",40.96666666666");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"standard_parallel_2\",39.9333333333333],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4455\"]]");
    p = add_epsg_def_ex (filter, first, last, 32030, "epsg", 32030,
        "NAD27 / Rhode Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "999938 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Rhode Island\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.0833");
    add_srs_wkt (p, 8,
        "333333333],PARAMETER[\"central_meridian\",-71.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.9999938],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US sur");
    add_srs_wkt (p, 11,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"32030\"]]");
    p = add_epsg_def_ex (filter, first, last, 32031, "epsg", 32031,
        "NAD27 / South Carolina North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina North\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",33],PARAMETER[\"central_meridian\",-81],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",33.7666666666667],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_2\",34.9666666666667],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2000000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"32031\"]]");
    p = add_epsg_def_ex (filter, first, last, 32033, "epsg", 32033,
        "NAD27 / South Carolina South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina South\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",31.8333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-81],PARAMETER[\"standard_parallel_1\",32.33333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_2\",33.6666666666667],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32033\"]]");
    p = add_epsg_def_ex (filter, first, last, 32034, "epsg", 32034,
        "NAD27 / South Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",43.8333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-100],PARAMETER[\"standard_parallel_1\",44.4166666666667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",45.6833333333333],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",2000000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32034\"]]");
    p = add_epsg_def_ex (filter, first, last, 32035, "epsg", 32035,
        "NAD27 / South Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",42.3333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-100.333333333333],PARAMETER[\"standard_parallel_1\",42.");
    add_srs_wkt (p, 10,
        "8333333333333],PARAMETER[\"standard_parallel_2\",44.4],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32035\"]]");
    p = add_epsg_def_ex (filter, first, last, 32036, "epsg", 32036,
        "NAD27 / Tennessee", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee\",GEOGCS[\"NAD27\",DATUM[\"No");
    add_srs_wkt (p, 1,
        "rth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",63782");
    add_srs_wkt (p, 2,
        "06.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",34");
    add_srs_wkt (p, 8,
        ".6666666666667],PARAMETER[\"central_meridian\",-86],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",35.25],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",36.4166666666667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",2000000],PARAMETER[\"false_northing\",100000],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2204\"]]");
    p = add_epsg_def_ex (filter, first, last, 32037, "epsg", 32037,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",34],PARAMETER[\"central_meridian\",-101.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",34.65],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",36.1833333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"32037\"]]");
    p = add_epsg_def_ex (filter, first, last, 32038, "epsg", 32038,
        "NAD27 / Texas North Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",31.6666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-97.5],PARAMETER[\"standard_parallel_1\",32.13333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_2\",33.9666666666667],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32038\"]]");
    p = add_epsg_def_ex (filter, first, last, 32039, "epsg", 32039,
        "NAD27 / Texas Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",29.6666666666667],PARAMETER[\"central_meridian\",-100");
    add_srs_wkt (p, 9,
        ".333333333333],PARAMETER[\"standard_parallel_1\",30.1166");
    add_srs_wkt (p, 10,
        "666666667],PARAMETER[\"standard_parallel_2\",31.88333333");
    add_srs_wkt (p, 11,
        "33333],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32039\"");
    add_srs_wkt (p, 15,
        "]]");
}

#endif /* full EPSG initialization enabled/disabled */

