/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_45 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 20253, "epsg", 20253,
        "AGD66 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 53\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",135],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20253\"]]");
    p = add_epsg_def_ex (filter, first, last, 20254, "epsg", 20254,
        "AGD66 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 54\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",141],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20254\"]]");
    p = add_epsg_def_ex (filter, first, last, 20255, "epsg", 20255,
        "AGD66 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 55\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",147],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20255\"]]");
    p = add_epsg_def_ex (filter, first, last, 20256, "epsg", 20256,
        "AGD66 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 56\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",153],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20256\"]]");
    p = add_epsg_def_ex (filter, first, last, 20257, "epsg", 20257,
        "AGD66 / AMG zone 57", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 57\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",159],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20257\"]]");
    p = add_epsg_def_ex (filter, first, last, 20258, "epsg", 20258,
        "AGD66 / AMG zone 58", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 58\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",165],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20258\"]]");
    p = add_epsg_def_ex (filter, first, last, 20348, "epsg", 20348,
        "AGD84 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20348\"]]");
    p = add_epsg_def_ex (filter, first, last, 20349, "epsg", 20349,
        "AGD84 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 49\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",111],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20349\"]]");
    p = add_epsg_def_ex (filter, first, last, 20350, "epsg", 20350,
        "AGD84 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 50\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",117],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20350\"]]");
    p = add_epsg_def_ex (filter, first, last, 20351, "epsg", 20351,
        "AGD84 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 51\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",123],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20351\"]]");
    p = add_epsg_def_ex (filter, first, last, 20352, "epsg", 20352,
        "AGD84 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 52\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",129],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20352\"]]");
    p = add_epsg_def_ex (filter, first, last, 20353, "epsg", 20353,
        "AGD84 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 53\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",135],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20353\"]]");
    p = add_epsg_def_ex (filter, first, last, 20354, "epsg", 20354,
        "AGD84 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 54\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",141],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20354\"]]");
    p = add_epsg_def_ex (filter, first, last, 20355, "epsg", 20355,
        "AGD84 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 55\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",147],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20355\"]]");
    p = add_epsg_def_ex (filter, first, last, 20356, "epsg", 20356,
        "AGD84 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 56\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.763,-51.51,139.061,0.292,0.443,0.27");
    add_srs_wkt (p, 4,
        "7,-0.191],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",153],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20356\"]]");
    p = add_epsg_def_ex (filter, first, last, 20357, "epsg", 20357,
        "AGD84 / AMG zone 57 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 57 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",159],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20357\"]]");
    p = add_epsg_def_ex (filter, first, last, 20358, "epsg", 20358,
        "AGD84 / AMG zone 58 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 58 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",165],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20358\"]]");
    p = add_epsg_def_ex (filter, first, last, 20436, "epsg", 20436,
        "Ain el Abd / UTM zone 36N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 36N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",33],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20436\"]]");
    p = add_epsg_def_ex (filter, first, last, 20437, "epsg", 20437,
        "Ain el Abd / UTM zone 37N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 37N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",39],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20437\"]]");
    p = add_epsg_def_ex (filter, first, last, 20438, "epsg", 20438,
        "Ain el Abd / UTM zone 38N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 38N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",45],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20438\"]]");
    p = add_epsg_def_ex (filter, first, last, 20439, "epsg", 20439,
        "Ain el Abd / UTM zone 39N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 39N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",51],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20439\"]]");
    p = add_epsg_def_ex (filter, first, last, 20440, "epsg", 20440,
        "Ain el Abd / UTM zone 40N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 40N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",57],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20440\"]]");
    p = add_epsg_def_ex (filter, first, last, 20499, "epsg", 20499,
        "Ain el Abd / Bahrain Grid", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / Bahrain Grid\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",51],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"20499\"]]");
    p = add_epsg_def_ex (filter, first, last, 20538, "epsg", 20538,
        "Afgooye / UTM zone 38N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 38N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[-43,-163,45,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6205\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4205\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20538\"]]");
    p = add_epsg_def_ex (filter, first, last, 20539, "epsg", 20539,
        "Afgooye / UTM zone 39N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 39N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[-43,-163,45,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6205\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4205\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"20539\"]]");
    p = add_epsg_def_ex (filter, first, last, 20790, "epsg", 20790,
        "Lisbon (Lisbon) / Portuguese National Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "200000 +y_0=300000 +ellps=intl +towgs84=-304.046,-60.576");
    add_proj4text (p, 2,
        ",103.64,0,0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese National Grid\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7022\"]],TOWGS84[-288.885,-91.744,126.244,-1.691,");
    add_srs_wkt (p, 4,
        "0.41,-0.211,-4.598],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM");
    add_srs_wkt (p, 5,
        "[\"Lisbon\",-9.13190611111111,AUTHORITY[\"EPSG\",\"8902\"");
    add_srs_wkt (p, 6,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4803\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 9,
        "9.6666666666667],PARAMETER[\"central_meridian\",1],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",300000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"20790\"]]");
    p = add_epsg_def_ex (filter, first, last, 20791, "epsg", 20791,
        "Lisbon (Lisbon) / Portuguese Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,");
    add_proj4text (p, 2,
        "0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese Grid\",GEOGCS[\"Li");
    add_srs_wkt (p, 1,
        "sbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288.885,-91.744,126.244,-1.691,0.41,-0.2");
    add_srs_wkt (p, 4,
        "11,-4.598],AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"Lisbon");
    add_srs_wkt (p, 5,
        "\",-9.13190611111111,AUTHORITY[\"EPSG\",\"8902\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4803\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",39.6666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"central_meridian\",1],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"20791\"]]");
    p = add_epsg_def_ex (filter, first, last, 20822, "epsg", 20822,
        "Aratu / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 22S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],TOWGS84[-157.84,308.54,-146.6,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4208\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"20822\"]]");
    p = add_epsg_def_ex (filter, first, last, 20823, "epsg", 20823,
        "Aratu / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 23S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-45],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"20823\"]]");
    p = add_epsg_def_ex (filter, first, last, 20824, "epsg", 20824,
        "Aratu / UTM zone 24S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 24S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-39],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"20824\"]]");
    p = add_epsg_def_ex (filter, first, last, 20934, "epsg", 20934,
        "Arc 1950 / UTM zone 34S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 34S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",21],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"20934\"]]");
    p = add_epsg_def_ex (filter, first, last, 20935, "epsg", 20935,
        "Arc 1950 / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 35S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",27],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"20935\"]]");
    p = add_epsg_def_ex (filter, first, last, 20936, "epsg", 20936,
        "Arc 1950 / UTM zone 36S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 36S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",33],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"20936\"]]");
    p = add_epsg_def_ex (filter, first, last, 21035, "epsg", 21035,
        "Arc 1960 / UTM zone 35S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"21035\"]]");
    p = add_epsg_def_ex (filter, first, last, 21036, "epsg", 21036,
        "Arc 1960 / UTM zone 36S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"21036\"]]");
    p = add_epsg_def_ex (filter, first, last, 21037, "epsg", 21037,
        "Arc 1960 / UTM zone 37S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"21037\"]]");
    p = add_epsg_def_ex (filter, first, last, 21095, "epsg", 21095,
        "Arc 1960 / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21095\"]]");
    p = add_epsg_def_ex (filter, first, last, 21096, "epsg", 21096,
        "Arc 1960 / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21096\"]]");
    p = add_epsg_def_ex (filter, first, last, 21097, "epsg", 21097,
        "Arc 1960 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-157,");
    add_srs_wkt (p, 3,
        "-2,-299,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21097\"]]");
    p = add_epsg_def_ex (filter, first, last, 21100, "epsg", 21100,
        "Batavia / NEIEZ", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / NEIEZ\",GEOGCS[\"Batavia\",DATUM[\"Ba");
    add_srs_wkt (p, 1,
        "tavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6211");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTION[\"Me");
    add_srs_wkt (p, 6,
        "rcator_1SP\"],PARAMETER[\"central_meridian\",110],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"scale_factor\",0.997],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 8,
        "3900000],PARAMETER[\"false_northing\",900000],UNIT[\"met");
    add_srs_wkt (p, 9,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 10,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3001\"");
    add_srs_wkt (p, 11,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21148, "epsg", 21148,
        "Batavia / UTM zone 48S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 48S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21148\"]]");
    p = add_epsg_def_ex (filter, first, last, 21149, "epsg", 21149,
        "Batavia / UTM zone 49S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 49S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21149\"]]");
    p = add_epsg_def_ex (filter, first, last, 21150, "epsg", 21150,
        "Batavia / UTM zone 50S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 50S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21150\"]]");
    p = add_epsg_def_ex (filter, first, last, 21291, "epsg", 21291,
        "Barbados 1938 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419");
    add_proj4text (p, 2,
        ".19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],TOWGS84[31.95,300.99,419.19,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6212\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4212");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-62]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9995],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",400000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2129");
    add_srs_wkt (p, 13,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 21292, "epsg", 21292,
        "Barbados 1938 / Barbados National Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222");
    add_proj4text (p, 1,
        "222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 ");
    add_proj4text (p, 2,
        "+towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / Barbados National Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7012\"]],TOWGS84[31.95,300.99,419.19,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6212\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4212\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",13.1763888888889],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-59.5597222222222],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999986],PARAMETER[\"false_easting\",30000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",75000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"21292\"]]");
    p = add_epsg_def_ex (filter, first, last, 21413, "epsg", 21413,
        "Beijing 1954 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21413");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21414, "epsg", 21414,
        "Beijing 1954 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21414");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21415, "epsg", 21415,
        "Beijing 1954 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21415");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21416, "epsg", 21416,
        "Beijing 1954 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21416");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21417, "epsg", 21417,
        "Beijing 1954 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21417");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21418, "epsg", 21418,
        "Beijing 1954 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2141");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 21419, "epsg", 21419,
        "Beijing 1954 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2141");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 21420, "epsg", 21420,
        "Beijing 1954 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 21421, "epsg", 21421,
        "Beijing 1954 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 21422, "epsg", 21422,
        "Beijing 1954 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 21423, "epsg", 21423,
        "Beijing 1954 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 21453, "epsg", 21453,
        "Beijing 1954 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21453\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21454, "epsg", 21454,
        "Beijing 1954 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21454\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21455, "epsg", 21455,
        "Beijing 1954 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21455\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21456, "epsg", 21456,
        "Beijing 1954 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21456\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21457, "epsg", 21457,
        "Beijing 1954 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21457\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21458, "epsg", 21458,
        "Beijing 1954 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21458\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21459, "epsg", 21459,
        "Beijing 1954 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21459\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21460, "epsg", 21460,
        "Beijing 1954 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21460\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21461, "epsg", 21461,
        "Beijing 1954 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21461\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21462, "epsg", 21462,
        "Beijing 1954 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21462\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21463, "epsg", 21463,
        "Beijing 1954 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21463\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21473, "epsg", 21473,
        "Beijing 1954 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21453\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21474, "epsg", 21474,
        "Beijing 1954 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21454\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21475, "epsg", 21475,
        "Beijing 1954 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21455\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21476, "epsg", 21476,
        "Beijing 1954 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21456\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21477, "epsg", 21477,
        "Beijing 1954 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21457\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21478, "epsg", 21478,
        "Beijing 1954 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21458\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21479, "epsg", 21479,
        "Beijing 1954 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21459\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21480, "epsg", 21480,
        "Beijing 1954 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21460\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21481, "epsg", 21481,
        "Beijing 1954 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21461\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21482, "epsg", 21482,
        "Beijing 1954 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21462\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21483, "epsg", 21483,
        "Beijing 1954 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21463\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21500, "epsg", 21500,
        "Belge 1950 (Brussels) / Belge Lambert 50", 0, 0,
        "International 1924", "Brussels",
        "Reseau_National_Belge_1950_Brussels", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=90 +lon_0=0 +x_0=150000 +y_0=5400000 +ellps=i");
    add_proj4text (p, 2,
        "ntl +pm=brussels +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Belge 1950 (Brussels) / Belge Lambert 50\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National_Bel");
    add_srs_wkt (p, 2,
        "ge_1950_Brussels\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 3,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4809\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",90],PARAMETER[\"central_meridian\",0],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",49.8333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",51.1666666666667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",150000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",5400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"21500\"]]");
    p = add_epsg_def_ex (filter, first, last, 21780, "epsg", 21780,
        "Bern 1898 (Bern) / LV03C", 0, 0,
        "Bessel 1841", "Bern",
        "CH1903_Bern", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=0 +k_0=1 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +ellps=bessel +towgs84=674.374,15.056,405.34");
    add_proj4text (p, 2,
        "6,0,0,0,0 +pm=bern +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bern 1898 (Bern) / LV03C\",GEOGCS[\"Bern 1898 (");
    add_srs_wkt (p, 1,
        "Bern)\",DATUM[\"CH1903_Bern\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6801\"]],PRIMEM[\"Bern\",7.43958333333");
    add_srs_wkt (p, 4,
        "333,AUTHORITY[\"EPSG\",\"8907\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 5,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4801\"]],PROJECTION[\"Hotine_Oblique_Mercator_Az");
    add_srs_wkt (p, 7,
        "imuth_Center\"],PARAMETER[\"latitude_of_center\",46.9524");
    add_srs_wkt (p, 8,
        "055555556],PARAMETER[\"longitude_of_center\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"azimuth\",90],PARAMETER[\"rectified_grid_angle\",90]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21780\"]]");
    p = add_epsg_def_ex (filter, first, last, 21781, "epsg", 21781,
        "CH1903 / LV03", 0, 0,
        "Bessel 1841", "Greenwich",
        "CH1903", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=600000 +y_0=200000 +ellps=bessel +tow");
    add_proj4text (p, 2,
        "gs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03\",GEOGCS[\"CH1903\",DATUM[\"CH190");
    add_srs_wkt (p, 1,
        "3\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[674.374,15.056,405.34");
    add_srs_wkt (p, 3,
        "6,0,0,0,0],AUTHORITY[\"EPSG\",\"6149\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4149\"]],PROJECTION[\"Hotine_Oblique_Mercato");
    add_srs_wkt (p, 7,
        "r_Azimuth_Center\"],PARAMETER[\"latitude_of_center\",46.");
    add_srs_wkt (p, 8,
        "9524055555556],PARAMETER[\"longitude_of_center\",7.43958");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"azimuth\",90],PARAMETER[\"rectifi");
    add_srs_wkt (p, 10,
        "ed_grid_angle\",90],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",600000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"21781\"]]");
    p = add_epsg_def_ex (filter, first, last, 21782, "epsg", 21782,
        "CH1903 / LV03C-G", 0, 0,
        "Bessel 1841", "Greenwich",
        "CH1903", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +towgs84=674.3");
    add_proj4text (p, 2,
        "74,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03C-G\",GEOGCS[\"CH1903\",DATUM[\"CH");
    add_srs_wkt (p, 1,
        "1903\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[674.374,15.056,405");
    add_srs_wkt (p, 3,
        ".346,0,0,0,0],AUTHORITY[\"EPSG\",\"6149\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4149\"]],PROJECTION[\"Hotine_Oblique_Merc");
    add_srs_wkt (p, 7,
        "ator_Azimuth_Center\"],PARAMETER[\"latitude_of_center\",");
    add_srs_wkt (p, 8,
        "46.9524055555556],PARAMETER[\"longitude_of_center\",7.43");
    add_srs_wkt (p, 9,
        "958333333333],PARAMETER[\"azimuth\",90],PARAMETER[\"rect");
    add_srs_wkt (p, 10,
        "ified_grid_angle\",90],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"21782\"]]");
    p = add_epsg_def_ex (filter, first, last, 21817, "epsg", 21817,
        "Bogota 1975 / UTM zone 17N (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 17N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[304.5,306.5,-318.1,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"21817\"]]");
    p = add_epsg_def_ex (filter, first, last, 21818, "epsg", 21818,
        "Bogota 1975 / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 18N\",GEOGCS[\"Bogota 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Bogota_1975\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[307");
    add_srs_wkt (p, 3,
        ",304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"21818\"]]");
    p = add_epsg_def_ex (filter, first, last, 21891, "epsg", 21891,
        "Bogota 1975 / Colombia West zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",4.599047");
    add_srs_wkt (p, 8,
        "22222222],PARAMETER[\"central_meridian\",-77.08091666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",1000000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "21896\"]]");
    p = add_epsg_def_ex (filter, first, last, 21892, "epsg", 21892,
        "Bogota 1975 / Colombia Bogota zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "ogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.5990");
    add_srs_wkt (p, 8,
        "4722222222],PARAMETER[\"central_meridian\",-74.080916666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"21897\"]]");
    p = add_epsg_def_ex (filter, first, last, 21893, "epsg", 21893,
        "Bogota 1975 / Colombia East Central zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "18\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        ".59904722222222],PARAMETER[\"central_meridian\",-71.0809");
    add_srs_wkt (p, 9,
        "166666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",1000000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"21898\"]]");
    p = add_epsg_def_ex (filter, first, last, 21894, "epsg", 21894,
        "Bogota 1975 / Colombia East zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[221.899,274.136,-397.554,-2.80844591036,0.44850858891");
    add_srs_wkt (p, 4,
        "3,2.81017234679,-2.199943],AUTHORITY[\"EPSG\",\"6218\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.5990");
    add_srs_wkt (p, 9,
        "4722222222],PARAMETER[\"central_meridian\",-68.080916666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"21899\"]]");
    p = add_epsg_def_ex (filter, first, last, 21896, "epsg", 21896,
        "Bogota 1975 / Colombia West zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",4.599047");
    add_srs_wkt (p, 8,
        "22222222],PARAMETER[\"central_meridian\",-77.08091666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",1000000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "21896\"]]");
    p = add_epsg_def_ex (filter, first, last, 21897, "epsg", 21897,
        "Bogota 1975 / Colombia Bogota zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "ogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.5990");
    add_srs_wkt (p, 8,
        "4722222222],PARAMETER[\"central_meridian\",-74.080916666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"21897\"]]");
    p = add_epsg_def_ex (filter, first, last, 21898, "epsg", 21898,
        "Bogota 1975 / Colombia East Central zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "18\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        ".59904722222222],PARAMETER[\"central_meridian\",-71.0809");
    add_srs_wkt (p, 9,
        "166666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",1000000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"21898\"]]");
    p = add_epsg_def_ex (filter, first, last, 21899, "epsg", 21899,
        "Bogota 1975 / Colombia East zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[221.899,274.136,-397.554,-2.80844591036,0.44850858891");
    add_srs_wkt (p, 4,
        "3,2.81017234679,-2.199943],AUTHORITY[\"EPSG\",\"6218\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.5990");
    add_srs_wkt (p, 9,
        "4722222222],PARAMETER[\"central_meridian\",-68.080916666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"21899\"]]");
    p = add_epsg_def_ex (filter, first, last, 22032, "epsg", 22032,
        "Camacupa / UTM zone 32S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / UTM zone 32S\",GEOGCS[\"Camacupa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4220\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",9],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22032\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 22033, "epsg", 22033,
        "Camacupa / UTM zone 33S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / UTM zone 33S\",GEOGCS[\"Camacupa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-93.7");
    add_srs_wkt (p, 3,
        "99,-132.737,-219.073,-1.844,0.648,-6.37,-0.169],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4220\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"220");
    add_srs_wkt (p, 13,
        "33\"]]");
    p = add_epsg_def_ex (filter, first, last, 22091, "epsg", 22091,
        "Camacupa / TM 11.30 SE", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / TM 11.30 SE\",GEOGCS[\"Camacupa\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.");
    add_srs_wkt (p, 2,
        "145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-50.9,");
    add_srs_wkt (p, 3,
        "-347.6,-231,0,0,0,0],AUTHORITY[\"EPSG\",\"6220\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4220\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",11.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22091\"]]");
    p = add_epsg_def_ex (filter, first, last, 22092, "epsg", 22092,
        "Camacupa / TM 12 SE", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / TM 12 SE\",GEOGCS[\"Camacupa\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6220\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4220\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22092\"]]");
    p = add_epsg_def_ex (filter, first, last, 22171, "epsg", 22171,
        "POSGAR 98 / Argentina 1", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 1\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-72],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",1500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22171\"]]");
    p = add_epsg_def_ex (filter, first, last, 22172, "epsg", 22172,
        "POSGAR 98 / Argentina 2", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 2\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",2500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22172\"]]");
    p = add_epsg_def_ex (filter, first, last, 22173, "epsg", 22173,
        "POSGAR 98 / Argentina 3", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 3\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",3500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22173\"]]");
    p = add_epsg_def_ex (filter, first, last, 22174, "epsg", 22174,
        "POSGAR 98 / Argentina 4", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 4\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",4500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22174\"]]");
    p = add_epsg_def_ex (filter, first, last, 22175, "epsg", 22175,
        "POSGAR 98 / Argentina 5", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 5\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-60],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",5500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22175\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

