/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_44 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8791, "epsg", 8791,
        "NAD83 / Washington South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45.3333333333333 +lon_0=-120.5 +lat_1=4");
    add_proj4text (p, 1,
        "7.3333333333333 +lat_2=45.8333333333333 +x_0=500000.0001");
    add_proj4text (p, 2,
        "016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us");
    add_proj4text (p, 3,
        "-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Washington South (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Washington South (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",45.3333333333333],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-120.5],PARAMETER[\"standard_parallel_1\",47.333333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"standard_parallel_2\",45.8333333333");
    add_srs_wkt (p, 12,
        "333],PARAMETER[\"false_easting\",1640416.667],PARAMETER[");
    add_srs_wkt (p, 13,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 14,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 15,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2286\"");
    add_srs_wkt (p, 16,
        "]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North A");
    add_srs_wkt (p, 17,
        "merican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 18,
        "5103\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 19,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 20,
        ",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 21,
        "8791\"]]");
    p = add_epsg_def_ex (filter, first, last, 8792, "epsg", 8792,
        "NAD83 / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=38.5 +lon_0=-79.5 +lat_1=40.25 +lat_2=3");
    add_proj4text (p, 1,
        "9 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / West Virginia North (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / West Virginia North (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",38.5],PARAMETER[\"central_meridian\",-79");
    add_srs_wkt (p, 10,
        ".5],PARAMETER[\"standard_parallel_1\",40.25],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",39],PARAMETER[\"false_easting\",19");
    add_srs_wkt (p, 12,
        "68500],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"26853\"]],VERT_CS[\"NAVD88 height (ftUS)\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"North American Vertical Datum 1988\",2005,AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 18,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 19,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AU");
    add_srs_wkt (p, 20,
        "THORITY[\"EPSG\",\"8792\"]]");
    p = add_epsg_def_ex (filter, first, last, 8793, "epsg", 8793,
        "NAD83 / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37 +lon_0=-81 +lat_1=38.8833333333333 +");
    add_proj4text (p, 1,
        "lat_2=37.4833333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "towgs84=0,0,0,0,0,0,0 +units=us-ft +vunits=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / West Virginia South (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / West Virginia South (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",37],PARAMETER[\"central_meridian\",-81],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"standard_parallel_1\",38.8833333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"standard_parallel_2\",37.4833333333333],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_easting\",1968500],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 15,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26854\"]],VERT_CS[\"NAV");
    add_srs_wkt (p, 16,
        "D88 height (ftUS)\",VERT_DATUM[\"North American Vertical");
    add_srs_wkt (p, 17,
        " Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"");
    add_srs_wkt (p, 18,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 20,
        "EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8793\"]]");
    p = add_epsg_def_ex (filter, first, last, 8794, "epsg", 8794,
        "NAD83 / Wisconsin North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45.1666666666667 +lon_0=-90 +lat_1=46.7");
    add_proj4text (p, 1,
        "666666666667 +lat_2=45.5666666666667 +x_0=600000 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +vunits");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin North (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Wisconsin North (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 6,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",45.1666666666667],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-90],PARAMETER[\"standard_parallel_1\",46.76666666666");
    add_srs_wkt (p, 11,
        "67],PARAMETER[\"standard_parallel_2\",45.5666666666667],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_easting\",1968500],PARAMETER[\"false_n");
    add_srs_wkt (p, 13,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 15,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2287\"]],VERT_");
    add_srs_wkt (p, 16,
        "CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North American ");
    add_srs_wkt (p, 17,
        "Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]]");
    add_srs_wkt (p, 18,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 19,
        "PSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUT");
    add_srs_wkt (p, 20,
        "HORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8794\"]]");
    p = add_epsg_def_ex (filter, first, last, 8795, "epsg", 8795,
        "NAD83 / Wisconsin Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43.8333333333333 +lon_0=-90 +lat_1=45.5");
    add_proj4text (p, 1,
        " +lat_2=44.25 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin Central (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / Wisconsin Central (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",43.8333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-90],PARAMETER[\"standard_parallel_1\",45.5],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"standard_parallel_2\",44.25],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 13,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"2288\"]],VERT_CS[\"NAVD88 height (");
    add_srs_wkt (p, 16,
        "ftUS)\",VERT_DATUM[\"North American Vertical Datum 1988\"");
    add_srs_wkt (p, 17,
        ",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foo");
    add_srs_wkt (p, 18,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 19,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"636");
    add_srs_wkt (p, 20,
        "0\"]],AUTHORITY[\"EPSG\",\"8795\"]]");
    p = add_epsg_def_ex (filter, first, last, 8796, "epsg", 8796,
        "NAD83 / Wisconsin South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=42 +lon_0=-90 +lat_1=44.0666666666667 +");
    add_proj4text (p, 1,
        "lat_2=42.7333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "towgs84=0,0,0,0,0,0,0 +units=us-ft +vunits=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wisconsin South (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Wisconsin South (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 6,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",42],PARAMETER[\"central_meridian\",-90],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_1\",44.0666666666667],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"standard_parallel_2\",42.7333333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_easting\",1968500],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"2289\"]],VERT_CS[\"NAVD88 he");
    add_srs_wkt (p, 16,
        "ight (ftUS)\",VERT_DATUM[\"North American Vertical Datum");
    add_srs_wkt (p, 17,
        " 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US sur");
    add_srs_wkt (p, 18,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8796\"]]");
    p = add_epsg_def_ex (filter, first, last, 8797, "epsg", 8797,
        "NAD83 / Wyoming East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.166666666667 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming East (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Wyoming East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-105.166666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.9999375],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",656166.6667],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"3736\"]],VERT_CS[\"NAVD88 height");
    add_srs_wkt (p, 15,
        " (ftUS)\",VERT_DATUM[\"North American Vertical Datum 198");
    add_srs_wkt (p, 16,
        "8\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey ");
    add_srs_wkt (p, 17,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 18,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "6360\"]],AUTHORITY[\"EPSG\",\"8797\"]]");
    p = add_epsg_def_ex (filter, first, last, 8798, "epsg", 8798,
        "NAD83 / Wyoming East Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.333333333333 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=399999.99998984 +y_0=99999.9999898399 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +vunits=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming East Central (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / Wyoming East Central (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",40.5],PARAMETER[\"central_meridian\",-107.333");
    add_srs_wkt (p, 10,
        "333333333],PARAMETER[\"scale_factor\",0.9999375],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",1312333.3333],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",328083.3333],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 13,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3737\"");
    add_srs_wkt (p, 15,
        "]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North A");
    add_srs_wkt (p, 16,
        "merican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5103\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 19,
        ",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "8798\"]]");
    p = add_epsg_def_ex (filter, first, last, 8799, "epsg", 8799,
        "NAD83 / Wyoming West Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming West Central (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / Wyoming West Central (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",40.5],PARAMETER[\"central_meridian\",-108.75]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1968500],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"3738\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 15,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 16,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 17,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 18,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "6360\"]],AUTHORITY[\"EPSG\",\"8799\"]]");
    p = add_epsg_def_ex (filter, first, last, 8800, "epsg", 8800,
        "NAD83 / Wyoming West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.083333333333 +k=0.99");
    add_proj4text (p, 1,
        "99375 +x_0=800000.00001016 +y_0=99999.9999898399 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +vunits=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Wyoming West (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Wyoming West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-110.083333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",0.9999375],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2624666.6667],PARAMETER[\"false_northing\",328083.");
    add_srs_wkt (p, 12,
        "3333],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3739\"]],VERT_CS[\"NA");
    add_srs_wkt (p, 15,
        "VD88 height (ftUS)\",VERT_DATUM[\"North American Vertica");
    add_srs_wkt (p, 16,
        "l Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"");
    add_srs_wkt (p, 17,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 18,
        "9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8800\"]]");
    p = add_epsg_def_ex (filter, first, last, 8801, "epsg", 8801,
        "NAD83 / Alabama East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.8333333333333 +k=0.99");
    add_proj4text (p, 1,
        "996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alabama East + NAVD88 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NAD83 / Alabama East\",GEOGCS[\"NAD83\",DATUM[\"North");
    add_srs_wkt (p, 2,
        "_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",30.5],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-85.8333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99996],PARAMETER[\"false_easting\",200000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"26929\"]],VERT_CS[\"NAVD88 heig");
    add_srs_wkt (p, 14,
        "ht\",VERT_DATUM[\"North American Vertical Datum 1988\",2");
    add_srs_wkt (p, 15,
        "005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 17,
        ",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 18,
        "8801\"]]");
    p = add_epsg_def_ex (filter, first, last, 8802, "epsg", 8802,
        "NAD83 / Alabama West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alabama West + NAVD88 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NAD83 / Alabama West\",GEOGCS[\"NAD83\",DATUM[\"North");
    add_srs_wkt (p, 2,
        "_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",30],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-87.5],PARAMETER[\"scale_factor\",0.999933333]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",600000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"26930\"]],VERT_CS[\"NAVD88 height\",VERT");
    add_srs_wkt (p, 14,
        "_DATUM[\"North American Vertical Datum 1988\",2005,AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8802\"]]");
    p = add_epsg_def_ex (filter, first, last, 8803, "epsg", 8803,
        "NAD83 / Alaska zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +no_uoff +lat_0=57 +lonc=-133.666666666667 +");
    add_proj4text (p, 1,
        "alpha=323.130102361111 +gamma=323.130102361111 +k=0.9999");
    add_proj4text (p, 2,
        " +x_0=5000000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 3,
        "0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 1 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 1\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Hotine_Oblique_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_center\",57],PARAMETER[\"lon");
    add_srs_wkt (p, 9,
        "gitude_of_center\",-133.666666666667],PARAMETER[\"azimut");
    add_srs_wkt (p, 10,
        "h\",323.130102361111],PARAMETER[\"rectified_grid_angle\"");
    add_srs_wkt (p, 11,
        ",323.130102361111],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_easting\",5000000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"26931\"]],VERT_CS[\"NAVD88 height\"");
    add_srs_wkt (p, 16,
        ",VERT_DATUM[\"North American Vertical Datum 1988\",2005,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 18,
        "[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 19,
        ",AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8803");
    add_srs_wkt (p, 20,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8804, "epsg", 8804,
        "NAD83 / Alaska zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 2 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 2\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-142],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26932\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8804\"]]");
    p = add_epsg_def_ex (filter, first, last, 8805, "epsg", 8805,
        "NAD83 / Alaska zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 3 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 3\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-146],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26933\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8805\"]]");
    p = add_epsg_def_ex (filter, first, last, 8806, "epsg", 8806,
        "NAD83 / Alaska zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 4 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 4\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-150],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26934\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8806\"]]");
    p = add_epsg_def_ex (filter, first, last, 8807, "epsg", 8807,
        "NAD83 / Alaska zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 5 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 5\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-154],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26935\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8807\"]]");
    p = add_epsg_def_ex (filter, first, last, 8808, "epsg", 8808,
        "NAD83 / Alaska zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 6 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 6\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-158],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26936\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8808\"]]");
    p = add_epsg_def_ex (filter, first, last, 8809, "epsg", 8809,
        "NAD83 / Alaska zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 7 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 7\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-162],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26937\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8809\"]]");
    p = add_epsg_def_ex (filter, first, last, 8810, "epsg", 8810,
        "NAD83 / Alaska zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 8 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 8\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-166],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"26938\"]],VERT_CS[\"NAVD88 height\",VERT_DA");
    add_srs_wkt (p, 14,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"8810\"]]");
    p = add_epsg_def_ex (filter, first, last, 8811, "epsg", 8811,
        "NAD83 / Alaska zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 9 + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Alaska zone 9\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",54],PARAMETER[\"central_meridian\",-170],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26939\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 14,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"8811\"]]");
    p = add_epsg_def_ex (filter, first, last, 8812, "epsg", 8812,
        "NAD83 / Alaska zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=51 +lon_0=-176 +lat_1=53.8333333333333 ");
    add_proj4text (p, 1,
        "+lat_2=51.8333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=-2,0,4,0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Alaska zone 10 + NAVD88 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"NAD83 / Alaska zone 10\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 2,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-2,");
    add_srs_wkt (p, 4,
        "0,4,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",51],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-176],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_1\",53.8333333333333],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 11,
        "\",51.8333333333333],PARAMETER[\"false_easting\",1000000");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26940\"]],VERT_CS[");
    add_srs_wkt (p, 15,
        "\"NAVD88 height\",VERT_DATUM[\"North American Vertical D");
    add_srs_wkt (p, 16,
        "atum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"me");
    add_srs_wkt (p, 17,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-rel");
    add_srs_wkt (p, 18,
        "ated height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORIT");
    add_srs_wkt (p, 19,
        "Y[\"EPSG\",\"8812\"]]");
    p = add_epsg_def_ex (filter, first, last, 8813, "epsg", 8813,
        "NAD83 / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.8333333333333 +lon_0=-90.5 +k=0.99");
    add_proj4text (p, 1,
        "9933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri East + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Missouri East\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",35.8333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-90.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999933333],PARAMETER[\"false_easting\",250000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26996\"]],VERT_CS[\"NAV");
    add_srs_wkt (p, 14,
        "D88 height\",VERT_DATUM[\"North American Vertical Datum ");
    add_srs_wkt (p, 15,
        "1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 16,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 17,
        "height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 18,
        "PSG\",\"8813\"]]");
    p = add_epsg_def_ex (filter, first, last, 8814, "epsg", 8814,
        "NAD83 / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.8333333333333 +lon_0=-92.5 +k=0.99");
    add_proj4text (p, 1,
        "9933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri Central + NAVD88 height\",PR");
    add_srs_wkt (p, 1,
        "OJCS[\"NAD83 / Missouri Central\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 2,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 4,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",35.8333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-92.5],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.999933333],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26997\"]],VERT_CS");
    add_srs_wkt (p, 14,
        "[\"NAVD88 height\",VERT_DATUM[\"North American Vertical ");
    add_srs_wkt (p, 15,
        "Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"m");
    add_srs_wkt (p, 16,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-re");
    add_srs_wkt (p, 17,
        "lated height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"8814\"]]");
    p = add_epsg_def_ex (filter, first, last, 8815, "epsg", 8815,
        "NAD83 / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.1666666666667 +lon_0=-94.5 +k=0.99");
    add_proj4text (p, 1,
        "9941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Missouri West + NAVD88 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"NAD83 / Missouri West\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 2,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",36.1666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-94.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999941177],PARAMETER[\"false_easting\",850000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26998\"]],VERT_CS[\"NAV");
    add_srs_wkt (p, 14,
        "D88 height\",VERT_DATUM[\"North American Vertical Datum ");
    add_srs_wkt (p, 15,
        "1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 16,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 17,
        "height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 18,
        "PSG\",\"8815\"]]");
    p = add_epsg_def_ex (filter, first, last, 8817, "epsg", 8817,
        "MTRF-2000", 1, 1,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"MTRF-2000\",DATUM[\"MOMRA T");
    add_srs_wkt (p, 1,
        "errestrial Reference Frame 2000\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"unknown\"],AREA[\"Saudi Arabia\"],BBOX[15.61,34.44,32");
    add_srs_wkt (p, 10,
        ".16,55.67]],ID[\"EPSG\",8817]]],TARGETCRS[GEOGCRS[\"WGS ");
    add_srs_wkt (p, 11,
        "84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WG");
    add_srs_wkt (p, 12,
        "S 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 13,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 14,
        "99433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[");
    add_srs_wkt (p, 15,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"long");
    add_srs_wkt (p, 16,
        "itude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 17,
        "99433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"MTR");
    add_srs_wkt (p, 18,
        "F-2000 to WGS 84 (1)\",METHOD[\"Geocentric translations ");
    add_srs_wkt (p, 19,
        "(geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis ");
    add_srs_wkt (p, 20,
        "translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tr");
    add_srs_wkt (p, 21,
        "anslation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis tran");
    add_srs_wkt (p, 22,
        "slation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],");
    add_srs_wkt (p, 23,
        "AREA[\"Saudi Arabia\"],BBOX[15.61,34.44,32.16,55.67]],ID");
    add_srs_wkt (p, 24,
        "[\"EPSG\",8822]]]");
    p = add_epsg_def_ex (filter, first, last, 8818, "epsg", 8818,
        "MTRF-2000", 1, 1,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MTRF-2000\",DATUM[\"MOMRA_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_Frame_2000\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1218\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8818\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8826, "epsg", 8826,
        "NAD83 / Idaho Transverse Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42 +lon_0=-114 +k=0.9996 +x_0=2500000");
    add_proj4text (p, 1,
        " +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Transverse Mercator\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",42],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-114],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",2500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8826\"]]");
    p = add_epsg_def_ex (filter, first, last, 8836, "epsg", 8836,
        "MTRF-2000 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 36N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8818\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8836\"]]");
    p = add_epsg_def_ex (filter, first, last, 8837, "epsg", 8837,
        "MTRF-2000 / UTM zone 37N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 37N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8818\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8837\"]]");
    p = add_epsg_def_ex (filter, first, last, 8838, "epsg", 8838,
        "MTRF-2000 / UTM zone 38N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 38N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8818\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8838\"]]");
    p = add_epsg_def_ex (filter, first, last, 8839, "epsg", 8839,
        "MTRF-2000 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 39N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8818\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8839\"]]");
    p = add_epsg_def_ex (filter, first, last, 8840, "epsg", 8840,
        "MTRF-2000 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "MOMRA_Terrestrial_Reference_Frame_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MTRF-2000 / UTM zone 40N\",GEOGCS[\"MTRF-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MOMRA_Terrestrial_Reference_Frame_2000\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8818\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8840\"]]");
    p = add_epsg_def_ex (filter, first, last, 8860, "epsg", 8860,
        "NAD83(FBN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Federal_Base_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(FBN)\",DATUM[\"NAD83_Federal_Base_Network");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1211\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"8860\"]]");
    p = add_epsg_def_ex (filter, first, last, 20004, "epsg", 20004,
        "Pulkovo 1995 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",21],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",450000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20004\"]]");
    p = add_epsg_def_ex (filter, first, last, 20005, "epsg", 20005,
        "Pulkovo 1995 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",550000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20005\"]]");
    p = add_epsg_def_ex (filter, first, last, 20006, "epsg", 20006,
        "Pulkovo 1995 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",650000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20006\"]]");
    p = add_epsg_def_ex (filter, first, last, 20007, "epsg", 20007,
        "Pulkovo 1995 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",750000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20007\"]]");
    p = add_epsg_def_ex (filter, first, last, 20008, "epsg", 20008,
        "Pulkovo 1995 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",45],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",850000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20008\"]]");
    p = add_epsg_def_ex (filter, first, last, 20009, "epsg", 20009,
        "Pulkovo 1995 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",51],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",950000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20009\"]]");
    p = add_epsg_def_ex (filter, first, last, 20010, "epsg", 20010,
        "Pulkovo 1995 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",57],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",10500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20010\"]]");
    p = add_epsg_def_ex (filter, first, last, 20011, "epsg", 20011,
        "Pulkovo 1995 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",63],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",11500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20011\"]]");
    p = add_epsg_def_ex (filter, first, last, 20012, "epsg", 20012,
        "Pulkovo 1995 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",69],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",12500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20012\"]]");
    p = add_epsg_def_ex (filter, first, last, 20013, "epsg", 20013,
        "Pulkovo 1995 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",13500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20013\"]]");
    p = add_epsg_def_ex (filter, first, last, 20014, "epsg", 20014,
        "Pulkovo 1995 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",81],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",14500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20014\"]]");
    p = add_epsg_def_ex (filter, first, last, 20015, "epsg", 20015,
        "Pulkovo 1995 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",87],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",15500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20015\"]]");
    p = add_epsg_def_ex (filter, first, last, 20016, "epsg", 20016,
        "Pulkovo 1995 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",93],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",16500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20016\"]]");
    p = add_epsg_def_ex (filter, first, last, 20017, "epsg", 20017,
        "Pulkovo 1995 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",99],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",17500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20017\"]]");
    p = add_epsg_def_ex (filter, first, last, 20018, "epsg", 20018,
        "Pulkovo 1995 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1850");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20018\"]]");
    p = add_epsg_def_ex (filter, first, last, 20019, "epsg", 20019,
        "Pulkovo 1995 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",111],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1950");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20019\"]]");
    p = add_epsg_def_ex (filter, first, last, 20020, "epsg", 20020,
        "Pulkovo 1995 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",117],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2050");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20020\"]]");
    p = add_epsg_def_ex (filter, first, last, 20021, "epsg", 20021,
        "Pulkovo 1995 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",123],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2150");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20021\"]]");
    p = add_epsg_def_ex (filter, first, last, 20022, "epsg", 20022,
        "Pulkovo 1995 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",129],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2250");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20022\"]]");
    p = add_epsg_def_ex (filter, first, last, 20023, "epsg", 20023,
        "Pulkovo 1995 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",135],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2350");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20023\"]]");
    p = add_epsg_def_ex (filter, first, last, 20024, "epsg", 20024,
        "Pulkovo 1995 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",141],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2450");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20024\"]]");
    p = add_epsg_def_ex (filter, first, last, 20025, "epsg", 20025,
        "Pulkovo 1995 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",147],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20025\"]]");
    p = add_epsg_def_ex (filter, first, last, 20026, "epsg", 20026,
        "Pulkovo 1995 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",153],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2650");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20026\"]]");
    p = add_epsg_def_ex (filter, first, last, 20027, "epsg", 20027,
        "Pulkovo 1995 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",159],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2750");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20027\"]]");
    p = add_epsg_def_ex (filter, first, last, 20028, "epsg", 20028,
        "Pulkovo 1995 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",165],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2850");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20028\"]]");
    p = add_epsg_def_ex (filter, first, last, 20029, "epsg", 20029,
        "Pulkovo 1995 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",171],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",2950");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20029\"]]");
    p = add_epsg_def_ex (filter, first, last, 20030, "epsg", 20030,
        "Pulkovo 1995 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",177],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3050");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20030\"]]");
    p = add_epsg_def_ex (filter, first, last, 20031, "epsg", 20031,
        "Pulkovo 1995 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",-177],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",315");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20031\"]]");
    p = add_epsg_def_ex (filter, first, last, 20032, "epsg", 20032,
        "Pulkovo 1995 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",-171],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",325");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20032\"]]");
    p = add_epsg_def_ex (filter, first, last, 20064, "epsg", 20064,
        "Pulkovo 1995 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",21],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2463\"]]");
    p = add_epsg_def_ex (filter, first, last, 20065, "epsg", 20065,
        "Pulkovo 1995 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2464\"]]");
    p = add_epsg_def_ex (filter, first, last, 20066, "epsg", 20066,
        "Pulkovo 1995 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2465\"]]");
    p = add_epsg_def_ex (filter, first, last, 20067, "epsg", 20067,
        "Pulkovo 1995 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2466\"]]");
    p = add_epsg_def_ex (filter, first, last, 20068, "epsg", 20068,
        "Pulkovo 1995 / Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",45],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2467\"]]");
    p = add_epsg_def_ex (filter, first, last, 20069, "epsg", 20069,
        "Pulkovo 1995 / Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",51],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2468\"]]");
    p = add_epsg_def_ex (filter, first, last, 20070, "epsg", 20070,
        "Pulkovo 1995 / Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",57],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2469\"]]");
    p = add_epsg_def_ex (filter, first, last, 20071, "epsg", 20071,
        "Pulkovo 1995 / Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",63],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2470\"]]");
    p = add_epsg_def_ex (filter, first, last, 20072, "epsg", 20072,
        "Pulkovo 1995 / Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",69],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2471\"]]");
    p = add_epsg_def_ex (filter, first, last, 20073, "epsg", 20073,
        "Pulkovo 1995 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2472\"]]");
    p = add_epsg_def_ex (filter, first, last, 20074, "epsg", 20074,
        "Pulkovo 1995 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",81],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2473\"]]");
    p = add_epsg_def_ex (filter, first, last, 20075, "epsg", 20075,
        "Pulkovo 1995 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",87],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2474\"]]");
    p = add_epsg_def_ex (filter, first, last, 20076, "epsg", 20076,
        "Pulkovo 1995 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",93],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2475\"]]");
    p = add_epsg_def_ex (filter, first, last, 20077, "epsg", 20077,
        "Pulkovo 1995 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",99],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"2476\"]]");
    p = add_epsg_def_ex (filter, first, last, 20078, "epsg", 20078,
        "Pulkovo 1995 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2477\"]]");
    p = add_epsg_def_ex (filter, first, last, 20079, "epsg", 20079,
        "Pulkovo 1995 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",111],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2478\"]]");
    p = add_epsg_def_ex (filter, first, last, 20080, "epsg", 20080,
        "Pulkovo 1995 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",117],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2479\"]]");
    p = add_epsg_def_ex (filter, first, last, 20081, "epsg", 20081,
        "Pulkovo 1995 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",123],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2480\"]]");
    p = add_epsg_def_ex (filter, first, last, 20082, "epsg", 20082,
        "Pulkovo 1995 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",129],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2481\"]]");
    p = add_epsg_def_ex (filter, first, last, 20083, "epsg", 20083,
        "Pulkovo 1995 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",135],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2482\"]]");
    p = add_epsg_def_ex (filter, first, last, 20084, "epsg", 20084,
        "Pulkovo 1995 / Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",141],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2483\"]]");
    p = add_epsg_def_ex (filter, first, last, 20085, "epsg", 20085,
        "Pulkovo 1995 / Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",147],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2484\"]]");
    p = add_epsg_def_ex (filter, first, last, 20086, "epsg", 20086,
        "Pulkovo 1995 / Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",153],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2485\"]]");
    p = add_epsg_def_ex (filter, first, last, 20087, "epsg", 20087,
        "Pulkovo 1995 / Gauss-Kruger CM 159E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",159],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2486\"]]");
    p = add_epsg_def_ex (filter, first, last, 20088, "epsg", 20088,
        "Pulkovo 1995 / Gauss-Kruger CM 165E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",165],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2487\"]]");
    p = add_epsg_def_ex (filter, first, last, 20089, "epsg", 20089,
        "Pulkovo 1995 / Gauss-Kruger CM 171E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",171],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2488\"]]");
    p = add_epsg_def_ex (filter, first, last, 20090, "epsg", 20090,
        "Pulkovo 1995 / Gauss-Kruger CM 177E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",177],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2489\"]]");
    p = add_epsg_def_ex (filter, first, last, 20091, "epsg", 20091,
        "Pulkovo 1995 / Gauss-Kruger CM 177W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 177W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",-177],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2490\"]]");
    p = add_epsg_def_ex (filter, first, last, 20092, "epsg", 20092,
        "Pulkovo 1995 / Gauss-Kruger CM 171W", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 171W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4200\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",-171],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2491\"]]");
    p = add_epsg_def_ex (filter, first, last, 20135, "epsg", 20135,
        "Adindan / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 35N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-161,-14");
    add_srs_wkt (p, 3,
        ",205,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20135\"]]");
    p = add_epsg_def_ex (filter, first, last, 20136, "epsg", 20136,
        "Adindan / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 36N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-161,-14");
    add_srs_wkt (p, 3,
        ",205,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20136\"]]");
    p = add_epsg_def_ex (filter, first, last, 20137, "epsg", 20137,
        "Adindan / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 37N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-166,-15");
    add_srs_wkt (p, 3,
        ",204,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20137\"]]");
    p = add_epsg_def_ex (filter, first, last, 20138, "epsg", 20138,
        "Adindan / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 38N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-165,-11");
    add_srs_wkt (p, 3,
        ",206,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20138\"]]");
    p = add_epsg_def_ex (filter, first, last, 20248, "epsg", 20248,
        "AGD66 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "66\",DATUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"20248\"]]");
    p = add_epsg_def_ex (filter, first, last, 20249, "epsg", 20249,
        "AGD66 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 49\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",111],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20249\"]]");
    p = add_epsg_def_ex (filter, first, last, 20250, "epsg", 20250,
        "AGD66 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 50\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",117],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20250\"]]");
    p = add_epsg_def_ex (filter, first, last, 20251, "epsg", 20251,
        "AGD66 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 51\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",123],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20251\"]]");
    p = add_epsg_def_ex (filter, first, last, 20252, "epsg", 20252,
        "AGD66 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 52\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",129],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"20252\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

