/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_42 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8237, "epsg", 8237,
        "NAD83(CSRS)v2", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v2\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_2\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1193\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8237\"]]");
    p = add_epsg_def_ex (filter, first, last, 8239, "epsg", 8239,
        "NAD83(CSRS)v3", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_3", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v3\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 3\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8239]]");
    p = add_epsg_def_ex (filter, first, last, 8240, "epsg", 8240,
        "NAD83(CSRS)v3", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_3", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v3\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_3\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1194\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8240\"]]");
    p = add_epsg_def_ex (filter, first, last, 8244, "epsg", 8244,
        "NAD83(CSRS)v4", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_4", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v4\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 4\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8244]]");
    p = add_epsg_def_ex (filter, first, last, 8246, "epsg", 8246,
        "NAD83(CSRS)v4", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_4", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v4\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_4\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1195\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8246\"]]");
    p = add_epsg_def_ex (filter, first, last, 8248, "epsg", 8248,
        "NAD83(CSRS)v5", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_5", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v5\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 5\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8248]]");
    p = add_epsg_def_ex (filter, first, last, 8249, "epsg", 8249,
        "NAD83(CSRS)v5", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_5", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v5\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_5\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1196\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8249\"]]");
    p = add_epsg_def_ex (filter, first, last, 8251, "epsg", 8251,
        "NAD83(CSRS)v6", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_6", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v6\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 6\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8251]]");
    p = add_epsg_def_ex (filter, first, last, 8252, "epsg", 8252,
        "NAD83(CSRS)v6", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_6", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v6\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_6\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8252\"]]");
    p = add_epsg_def_ex (filter, first, last, 8254, "epsg", 8254,
        "NAD83(CSRS)v7", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_7", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v7\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 7\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8254]]");
    p = add_epsg_def_ex (filter, first, last, 8255, "epsg", 8255,
        "NAD83(CSRS)v7", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_7", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)v7\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS_version_7\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1198\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8255\"]]");
    p = add_epsg_def_ex (filter, first, last, 8311, "epsg", 8311,
        "NAD83(2011) / Oregon Burns-Harper zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-117.666666666667 +k=1.00");
    add_proj4text (p, 1,
        "014 +x_0=90000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Burns-Harper zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",43.5],PARAMETER[\"central_meridian\",-117.666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",1.00014],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",90000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8311\"]]");
    p = add_epsg_def_ex (filter, first, last, 8312, "epsg", 8312,
        "NAD83(2011) / Oregon Burns-Harper zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-117.666666666667 +k=1.00");
    add_proj4text (p, 1,
        "014 +x_0=90000.00001488 +y_0=0 +ellps=GRS80 +units=ft +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Burns-Harper zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",43.5],PARAMETER[\"central_meridian\",-117.666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",1.00014],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",295275.5906],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8312\"]]");
    p = add_epsg_def_ex (filter, first, last, 8313, "epsg", 8313,
        "NAD83(2011) / Oregon Canyon City-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-119 +k=1.00022 +x_0=2000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyon City-Burns zone (m)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",43.5],PARAMETER[\"central_meridian\",-119],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.00022],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",20000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8313\"]]");
    p = add_epsg_def_ex (filter, first, last, 8314, "epsg", 8314,
        "NAD83(2011) / Oregon Canyon City-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-119 +k=1.00022 +x_0=1999");
    add_proj4text (p, 1,
        "9.99999992 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyon City-Burns zone (ft");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.5],PARAMETER[\"central_meridian\",-119],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00022],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",65616.7979],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8314\"]]");
    p = add_epsg_def_ex (filter, first, last, 8315, "epsg", 8315,
        "NAD83(2011) / Oregon Coast Range North zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5833333333333 +lat_0=45.583333333333");
    add_proj4text (p, 1,
        "3 +lon_0=-123.416666666667 +k_0=1.000045 +x_0=30000 +y_0");
    add_proj4text (p, 2,
        "=20000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast Range North zone (m)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",45.5833333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-123.416666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000045],PARAMETER[\"false_easting\",30000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",20000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8315\"]]");
    p = add_epsg_def_ex (filter, first, last, 8316, "epsg", 8316,
        "NAD83(2011) / Oregon Coast Range North zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5833333333333 +lat_0=45.583333333333");
    add_proj4text (p, 1,
        "3 +lon_0=-123.416666666667 +k_0=1.000045 +x_0=30000.0000");
    add_proj4text (p, 2,
        "1512 +y_0=19999.99999992 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Coast Range North zone (ft");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.5833333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-123.416666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000045],PARAMETER[\"false_easting\",98425.1969],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",65616.7979],UNIT[\"foot\",0.3048");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8316\"]]");
    p = add_epsg_def_ex (filter, first, last, 8317, "epsg", 8317,
        "NAD83(2011) / Oregon Dayville-Prairie City zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25 +lon_0=-119.633333333333 +k=1.0");
    add_proj4text (p, 1,
        "0012 +x_0=20000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dayville-Prairie City zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",44.25],PARAMETER[\"central_meridian\",-119");
    add_srs_wkt (p, 9,
        ".633333333333],PARAMETER[\"scale_factor\",1.00012],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",20000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8317\"]]");
    p = add_epsg_def_ex (filter, first, last, 8318, "epsg", 8318,
        "NAD83(2011) / Oregon Dayville-Prairie City zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25 +lon_0=-119.633333333333 +k=1.0");
    add_proj4text (p, 1,
        "0012 +x_0=19999.99999992 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dayville-Prairie City zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",44.25],PARAMETER[\"central_meridian\",-119");
    add_srs_wkt (p, 9,
        ".633333333333],PARAMETER[\"scale_factor\",1.00012],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",65616.7979],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "2\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"8318\"]]");
    p = add_epsg_def_ex (filter, first, last, 8319, "epsg", 8319,
        "NAD83(2011) / Oregon Denio-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-118.416666666667 +k=1.0");
    add_proj4text (p, 1,
        "0019 +x_0=80000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Denio-Burns zone (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",41.75],PARAMETER[\"central_meridian\",-118.416666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",1.00019],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",80000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8319\"]]");
    p = add_epsg_def_ex (filter, first, last, 8320, "epsg", 8320,
        "NAD83(2011) / Oregon Denio-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-118.416666666667 +k=1.0");
    add_proj4text (p, 1,
        "0019 +x_0=79999.99999968 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Denio-Burns zone (ft)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",41.75],PARAMETER[\"central_meridian\",-118.41666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",1.00019],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",262467.1916],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8320\"]]");
    p = add_epsg_def_ex (filter, first, last, 8321, "epsg", 8321,
        "NAD83(2011) / Oregon Halfway zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_0=45.25 +lon_0=-117.25 +k_0=");
    add_proj4text (p, 1,
        "1.000085 +x_0=40000 +y_0=70000 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Halfway zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",45.25],PARAMETER[\"central_meridian\",-117.25],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000085],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",40000],PARAMETER[\"false_northing\",70000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"832");
    add_srs_wkt (p, 13,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 8322, "epsg", 8322,
        "NAD83(2011) / Oregon Halfway zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_0=45.25 +lon_0=-117.25 +k_0=");
    add_proj4text (p, 1,
        "1.000085 +x_0=39999.99999984 +y_0=70000.00001496 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Halfway zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",45.25],PARAMETER[\"central_meridian\",-117.25],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.000085],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",131233.5958],PARAMETER[\"false_northing\",229658");
    add_srs_wkt (p, 11,
        ".7927],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"8322\"]]");
    p = add_epsg_def_ex (filter, first, last, 8323, "epsg", 8323,
        "NAD83(2011) / Oregon Medford-Diamond Lake zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42 +lat_0=42 +lon_0=-122.25 +k_0=1.0000");
    add_proj4text (p, 1,
        "4 +x_0=60000 +y_0=-60000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Medford-Diamond Lake zone ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-122.25],PARAMETER[\"scale_factor\",1.00004],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",60000],PARAMETER[\"false_northing\",-600");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"8323\"]]");
    p = add_epsg_def_ex (filter, first, last, 8324, "epsg", 8324,
        "NAD83(2011) / Oregon Medford-Diamond Lake zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42 +lat_0=42 +lon_0=-122.25 +k_0=1.0000");
    add_proj4text (p, 1,
        "4 +x_0=59999.99999976 +y_0=-59999.99999976 +ellps=GRS80 ");
    add_proj4text (p, 2,
        "+units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Medford-Diamond Lake zone ");
    add_srs_wkt (p, 1,
        "(ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-122.25],PARAMETER[\"scale_factor\",1.00004],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",196850.3937],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",-196850.3937],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8324\"]]");
    p = add_epsg_def_ex (filter, first, last, 8325, "epsg", 8325,
        "NAD83(2011) / Oregon Mitchell zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47 +lat_0=47 +lon_0=-120.25 +k_0=0.9992");
    add_proj4text (p, 1,
        "7 +x_0=30000 +y_0=290000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Mitchell zone (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",47],PARAMETER[\"central_meridian\",-120.25],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99927],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",30000],PARAMETER[\"false_northing\",290000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8325");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8326, "epsg", 8326,
        "NAD83(2011) / Oregon Mitchell zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47 +lat_0=47 +lon_0=-120.25 +k_0=0.9992");
    add_proj4text (p, 1,
        "7 +x_0=30000.00001512 +y_0=290000.00001408 +ellps=GRS80 ");
    add_proj4text (p, 2,
        "+units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Mitchell zone (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",47],PARAMETER[\"central_meridian\",-120.25],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99927],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",98425.1969],PARAMETER[\"false_northing\",951443.56");
    add_srs_wkt (p, 11,
        "96],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8326\"]]");
    p = add_epsg_def_ex (filter, first, last, 8327, "epsg", 8327,
        "NAD83(2011) / Oregon North Central zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.1666666666667 +lat_0=46.166666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-120.5 +k_0=1 +x_0=100000 +y_0=140000 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon North Central zone (m)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",46.1666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-120.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",100000],PARAMETER[\"false_northing\",140");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8327\"]]");
    p = add_epsg_def_ex (filter, first, last, 8328, "epsg", 8328,
        "NAD83(2011) / Oregon North Central zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.1666666666667 +lat_0=46.166666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-120.5 +k_0=1 +x_0=99999.9999996 +y_0=139999.99");
    add_proj4text (p, 2,
        "999944 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon North Central zone (ft)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",46.1666666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-120.5],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",328083.9895],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",459317.5853],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8328\"]]");
    p = add_epsg_def_ex (filter, first, last, 8329, "epsg", 8329,
        "NAD83(2011) / Oregon Ochoco Summit zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5 +lat_0=43.5 +lon_0=-120.5 +k_0=1.0");
    add_proj4text (p, 1,
        "0006 +x_0=40000 +y_0=-80000 +ellps=GRS80 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ochoco Summit zone (m)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.5],PARAMETER[\"central_meridian\",-120.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.00006],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",40000],PARAMETER[\"false_northing\",-80000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"8329\"]]");
    p = add_epsg_def_ex (filter, first, last, 8330, "epsg", 8330,
        "NAD83(2011) / Oregon Ochoco Summit zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5 +lat_0=43.5 +lon_0=-120.5 +k_0=1.0");
    add_proj4text (p, 1,
        "0006 +x_0=39999.99999984 +y_0=-79999.99999968 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ochoco Summit zone (ft)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",43.5],PARAMETER[\"central_meridian\",-120");
    add_srs_wkt (p, 9,
        ".5],PARAMETER[\"scale_factor\",1.00006],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",131233.5958],PARAMETER[\"false_northing\",-2");
    add_srs_wkt (p, 11,
        "62467.1916],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "02\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"8330\"]]");
    p = add_epsg_def_ex (filter, first, last, 8331, "epsg", 8331,
        "NAD83(2011) / Oregon Owyhee zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-117.583333333333 +k=1.0");
    add_proj4text (p, 1,
        "0018 +x_0=70000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Owyhee zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41");
    add_srs_wkt (p, 8,
        ".75],PARAMETER[\"central_meridian\",-117.583333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.00018],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",70000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8331\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8332, "epsg", 8332,
        "NAD83(2011) / Oregon Owyhee zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-117.583333333333 +k=1.0");
    add_proj4text (p, 1,
        "0018 +x_0=70000.00001496 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Owyhee zone (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "1.75],PARAMETER[\"central_meridian\",-117.583333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.00018],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",229658.7927],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"8332\"]]");
    p = add_epsg_def_ex (filter, first, last, 8333, "epsg", 8333,
        "NAD83(2011) / Oregon Pilot Rock-Ukiah zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.1666666666667 +lat_0=46.166666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-119 +k_0=1.000025 +x_0=50000 +y_0=130000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pilot Rock-Ukiah zone (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",46.1666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-119],PARAMETER[\"scale_factor\",1.000025],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",50000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",130000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8333\"]]");
    p = add_epsg_def_ex (filter, first, last, 8334, "epsg", 8334,
        "NAD83(2011) / Oregon Pilot Rock-Ukiah zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.1666666666667 +lat_0=46.166666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-119 +k_0=1.000025 +x_0=50000.00001504 +y_0=130");
    add_proj4text (p, 2,
        "000.00001472 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Pilot Rock-Ukiah zone (ft)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",46.1666666666667],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-119],PARAMETER[\"scale_factor\",1.000025],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",164041.9948],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",426509.1864],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8334\"]]");
    p = add_epsg_def_ex (filter, first, last, 8335, "epsg", 8335,
        "NAD83(2011) / Oregon Prairie City-Brogan zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_0=44 +lon_0=-118 +k_0=1.00017 +");
    add_proj4text (p, 1,
        "x_0=60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Prairie City-Brogan zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",44],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "18],PARAMETER[\"scale_factor\",1.00017],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",60000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 13,
        "335\"]]");
    p = add_epsg_def_ex (filter, first, last, 8336, "epsg", 8336,
        "NAD83(2011) / Oregon Prairie City-Brogan zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_0=44 +lon_0=-118 +k_0=1.00017 +");
    add_proj4text (p, 1,
        "x_0=59999.99999976 +y_0=0 +ellps=GRS80 +units=ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Prairie City-Brogan zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-118],PARAMETER[\"scale_factor\",1.00017],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",196850.3937],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8336\"]]");
    p = add_epsg_def_ex (filter, first, last, 8337, "epsg", 8337,
        "NAD83(2011) / Oregon Riley-Lakeview zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-120.333333333333 +k=1.0");
    add_proj4text (p, 1,
        "00215 +x_0=70000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Riley-Lakeview zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",41.75],PARAMETER[\"central_meridian\",-120.333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.000215],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",70000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"8337\"]]");
    p = add_epsg_def_ex (filter, first, last, 8338, "epsg", 8338,
        "NAD83(2011) / Oregon Riley-Lakeview zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-120.333333333333 +k=1.0");
    add_proj4text (p, 1,
        "00215 +x_0=70000.00001496 +y_0=0 +ellps=GRS80 +units=ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Riley-Lakeview zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",41.75],PARAMETER[\"central_meridian\",-120.33333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.000215],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",229658.7927],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"8338\"]]");
    p = add_epsg_def_ex (filter, first, last, 8339, "epsg", 8339,
        "NAD83(2011) / Oregon Siskiyou Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.5 +lat_0=42.5 +lon_0=-122.5833333333");
    add_proj4text (p, 1,
        "33 +k_0=1.00015 +x_0=10000 +y_0=60000 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Siskiyou Pass zone (m)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",42.5],PARAMETER[\"central_meridian\",-122.5");
    add_srs_wkt (p, 9,
        "83333333333],PARAMETER[\"scale_factor\",1.00015],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",10000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",60000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8339\"]]");
    p = add_epsg_def_ex (filter, first, last, 8340, "epsg", 8340,
        "NAD83(2011) / Oregon Siskiyou Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.5 +lat_0=42.5 +lon_0=-122.5833333333");
    add_proj4text (p, 1,
        "33 +k_0=1.00015 +x_0=10000.0000152 +y_0=59999.99999976 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Siskiyou Pass zone (ft)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",42.5],PARAMETER[\"central_meridian\",-122");
    add_srs_wkt (p, 9,
        ".583333333333],PARAMETER[\"scale_factor\",1.00015],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",32808.399],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",196850.3937],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"8340\"]]");
    p = add_epsg_def_ex (filter, first, last, 8341, "epsg", 8341,
        "NAD83(2011) / Oregon Ukiah-Fox zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_0=45.25 +lon_0=-119 +k_0=1.0");
    add_proj4text (p, 1,
        "0014 +x_0=30000 +y_0=90000 +ellps=GRS80 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ukiah-Fox zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",45.25],PARAMETER[\"central_meridian\",-119],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00014],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",30000],PARAMETER[\"false_northing\",90000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"834");
    add_srs_wkt (p, 13,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 8342, "epsg", 8342,
        "NAD83(2011) / Oregon Ukiah-Fox zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_0=45.25 +lon_0=-119 +k_0=1.0");
    add_proj4text (p, 1,
        "0014 +x_0=30000.00001512 +y_0=90000.00001488 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Ukiah-Fox zone (ft)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",45.25],PARAMETER[\"central_meridian\",-119],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00014],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",98425.1969],PARAMETER[\"false_northing\",295275.59");
    add_srs_wkt (p, 11,
        "06],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8342\"]]");
    p = add_epsg_def_ex (filter, first, last, 8343, "epsg", 8343,
        "NAD83(2011) / Oregon Wallowa zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-117.5 +k=1.000195 +x_0=");
    add_proj4text (p, 1,
        "60000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Wallowa zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "5.25],PARAMETER[\"central_meridian\",-117.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000195],PARAMETER[\"false_easting\",600");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8343\"]]");
    p = add_epsg_def_ex (filter, first, last, 8344, "epsg", 8344,
        "NAD83(2011) / Oregon Wallowa zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.25 +lon_0=-117.5 +k=1.000195 +x_0=");
    add_proj4text (p, 1,
        "59999.99999976 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Wallowa zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "45.25],PARAMETER[\"central_meridian\",-117.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000195],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "96850.3937],PARAMETER[\"false_northing\",0],UNIT[\"foot\"");
    add_srs_wkt (p, 11,
        ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8344\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8345, "epsg", 8345,
        "NAD83(2011) / Oregon Warner Highway zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.5 +lat_0=42.5 +lon_0=-120 +k_0=1.000");
    add_proj4text (p, 1,
        "245 +x_0=40000 +y_0=60000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Warner Highway zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",42.5],PARAMETER[\"central_meridian\",-120");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000245],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",40000],PARAMETER[\"false_northing\",60000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"8345\"]]");
    p = add_epsg_def_ex (filter, first, last, 8346, "epsg", 8346,
        "NAD83(2011) / Oregon Warner Highway zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.5 +lat_0=42.5 +lon_0=-120 +k_0=1.000");
    add_proj4text (p, 1,
        "245 +x_0=39999.99999984 +y_0=59999.99999976 +ellps=GRS80");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Warner Highway zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",42.5],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"scale_factor\",1.000245],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",131233.5958],PARAMETER[\"false_northing\",19");
    add_srs_wkt (p, 11,
        "6850.3937],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "2\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"8346\"]]");
    p = add_epsg_def_ex (filter, first, last, 8347, "epsg", 8347,
        "NAD83(2011) / Oregon Willamette Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-122 +k=1.000223 +x_0=20000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Willamette Pass zone (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43],PARAMETER[\"central_meridian\",-122],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000223],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",20000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8347\"]]");
    p = add_epsg_def_ex (filter, first, last, 8348, "epsg", 8348,
        "NAD83(2011) / Oregon Willamette Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-122 +k=1.000223 +x_0=19999");
    add_proj4text (p, 1,
        ".99999992 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Willamette Pass zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43],PARAMETER[\"central_meridian\",-122],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000223],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",65616.7979],PARAMETER[\"false_northing\",0],UNIT[\"foot");
    add_srs_wkt (p, 11,
        "\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"834");
    add_srs_wkt (p, 13,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 8349, "epsg", 8349,
        "GR96", 1, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GR96 + GVR2000 height\",GEOGCS[\"GR96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4747\"]],VERT_CS[\"GVR2000 height\",VERT_DATUM[\"Greenla");
    add_srs_wkt (p, 8,
        "nd  Vertical Reference 2000\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 9,
        "1199\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 10,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "8266\"]],AUTHORITY[\"EPSG\",\"8349\"]]");
    p = add_epsg_def_ex (filter, first, last, 8350, "epsg", 8350,
        "GR96", 1, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GR96 + GVR2016 height\",GEOGCS[\"GR96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4747\"]],VERT_CS[\"GVR2016 height\",VERT_DATUM[\"Greenla");
    add_srs_wkt (p, 8,
        "nd Vertical Reference 2016\",2005,AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 9,
        "200\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 10,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "8267\"]],AUTHORITY[\"EPSG\",\"8350\"]]");
    p = add_epsg_def_ex (filter, first, last, 8351, "epsg", 8351,
        "S-JTSK [JTSK03]", 1, 1,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_JTSK03", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=485.021,169.465,483");
    add_proj4text (p, 1,
        ".839,7.786342,4.397554,4.102655,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK [JTSK03]\",DATUM[\"System_of_the_Unified");
    add_srs_wkt (p, 1,
        "_Trigonometrical_Cadastral_Network_JTSK03\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],TOWGS84[485.021,169.465,483.839,7.786342,4.39");
    add_srs_wkt (p, 4,
        "7554,4.102655,0],AUTHORITY[\"EPSG\",\"1201\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 7,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 8,
        "[\"EPSG\",\"8351\"]]");
    p = add_epsg_def_ex (filter, first, last, 8352, "epsg", 8352,
        "S-JTSK [JTSK03] / Krovak", 0, 0,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_JTSK03", "Krovak", "metre",
        "Southing", "South", "Westing", "West");
    add_proj4text (p, 0,
        "+proj=krovak +axis=swu +lat_0=49.5 +lon_0=24.83333333333");
    add_proj4text (p, 1,
        "33 +alpha=30.2881397527778 +k=0.9999 +x_0=0 +y_0=0 +ellp");
    add_proj4text (p, 2,
        "s=bessel +towgs84=485.021,169.465,483.839,7.786342,4.397");
    add_proj4text (p, 3,
        "554,4.102655,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK [JTSK03] / Krovak\",GEOGCS[\"S-JTSK [JTS");
    add_srs_wkt (p, 1,
        "K03]\",DATUM[\"System_of_the_Unified_Trigonometrical_Cad");
    add_srs_wkt (p, 2,
        "astral_Network_JTSK03\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 3,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[4");
    add_srs_wkt (p, 4,
        "85.021,169.465,483.839,7.786342,4.397554,4.102655,0],AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"1201\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 7,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"83");
    add_srs_wkt (p, 8,
        "51\"]],PROJECTION[\"Krovak\"],PARAMETER[\"latitude_of_ce");
    add_srs_wkt (p, 9,
        "nter\",49.5],PARAMETER[\"longitude_of_center\",24.833333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"azimuth\",30.2881397527778],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"pseudo_standard_parallel_1\",78.5],PARAMETER[\"scal");
    add_srs_wkt (p, 12,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9001\"]],AXIS[\"Southing\",SOUTH],AXIS[\"Westing");
    add_srs_wkt (p, 15,
        "\",WEST],AUTHORITY[\"EPSG\",\"8352\"]]");
    p = add_epsg_def_ex (filter, first, last, 8353, "epsg", 8353,
        "S-JTSK [JTSK03] / Krovak East North", 0, 0,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_JTSK03", "Krovak", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=24.8333333333333 +alpha=");
    add_proj4text (p, 1,
        "30.2881397527778 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +");
    add_proj4text (p, 2,
        "towgs84=485.021,169.465,483.839,7.786342,4.397554,4.1026");
    add_proj4text (p, 3,
        "55,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK [JTSK03] / Krovak East North\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "S-JTSK [JTSK03]\",DATUM[\"System_of_the_Unified_Trigonom");
    add_srs_wkt (p, 2,
        "etrical_Cadastral_Network_JTSK03\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 3,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 4,
        "],TOWGS84[485.021,169.465,483.839,7.786342,4.397554,4.10");
    add_srs_wkt (p, 5,
        "2655,0],AUTHORITY[\"EPSG\",\"1201\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 6,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 8,
        "EPSG\",\"8351\"]],PROJECTION[\"Krovak\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_center\",49.5],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 10,
        ",24.8333333333333],PARAMETER[\"azimuth\",30.288139752777");
    add_srs_wkt (p, 11,
        "8],PARAMETER[\"pseudo_standard_parallel_1\",78.5],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 13,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8353\"]]");
    p = add_epsg_def_ex (filter, first, last, 8360, "epsg", 8360,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Baltic 1957 height\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"B");
    add_srs_wkt (p, 8,
        "altic 1957 height\",VERT_DATUM[\"Baltic 1957\",2005,AUTH");
    add_srs_wkt (p, 9,
        "ORITY[\"EPSG\",\"1202\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 10,
        "PSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"8357\"]],AUTHORITY[\"EPSG\",\"8360\"]]");
    p = add_epsg_def_ex (filter, first, last, 8370, "epsg", 8370,
        "ETRS89 / Belgian Lambert 2008", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=50.797815 +lon_0=4.35921583333333 +lat_");
    add_proj4text (p, 1,
        "1=49.8333333333333 +lat_2=51.1666666666667 +x_0=649328 +");
    add_proj4text (p, 2,
        "y_0=665262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Belgian Lambert 2008 + Ostend height");
    add_srs_wkt (p, 1,
        "\",PROJCS[\"ETRS89 / Belgian Lambert 2008\",GEOGCS[\"ETR");
    add_srs_wkt (p, 2,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 3,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",50.797815],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",4.35921583333333],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 11,
        ",49.8333333333333],PARAMETER[\"standard_parallel_2\",51.");
    add_srs_wkt (p, 12,
        "1666666666667],PARAMETER[\"false_easting\",649328],PARAM");
    add_srs_wkt (p, 13,
        "ETER[\"false_northing\",665262],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"3812\"]],VERT_CS[\"O");
    add_srs_wkt (p, 16,
        "stend height\",VERT_DATUM[\"Ostend\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"5110\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 18,
        "01\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"E");
    add_srs_wkt (p, 19,
        "PSG\",\"5710\"]],AUTHORITY[\"EPSG\",\"8370\"]]");
    p = add_epsg_def_ex (filter, first, last, 8379, "epsg", 8379,
        "NAD83 / NCRS Las Vegas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "001 +x_0=100000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / NCRS Las Vegas (m)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",36.25],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-114.966666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0001],PARAMETER[\"false_easting\",10000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",200000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8379\"]]");
    p = add_epsg_def_ex (filter, first, last, 8380, "epsg", 8380,
        "NAD83 / NCRS Las Vegas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "001 +x_0=99999.9999898399 +y_0=200000.00001016 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / NCRS Las Vegas (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",36.25],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-114.966666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.0001],PARAMETER[\"false_easting\",328");
    add_srs_wkt (p, 10,
        "083.3333],PARAMETER[\"false_northing\",656166.6667],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8380\"]]");
    p = add_epsg_def_ex (filter, first, last, 8381, "epsg", 8381,
        "NAD83 / NCRS Las Vegas high (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "00135 +x_0=300000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / NCRS Las Vegas high (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",36.25],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-114.966666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000135],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",300000],PARAMETER[\"false_northing\",400000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8381\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8382, "epsg", 8382,
        "NAD83 / NCRS Las Vegas high (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "00135 +x_0=300000 +y_0=399999.99998984 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / NCRS Las Vegas high (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",36.25");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-114.966666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.000135],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",984250],PARAMETER[\"false_northing\",1312333.3333],");
    add_srs_wkt (p, 11,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8382\"]]");
    p = add_epsg_def_ex (filter, first, last, 8383, "epsg", 8383,
        "NAD83(2011) / NCRS Las Vegas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "001 +x_0=100000 +y_0=200000 +ellps=GRS80 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / NCRS Las Vegas (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",36.25");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-114.966666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0001],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",100000],PARAMETER[\"false_northing\",200000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8383");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8384, "epsg", 8384,
        "NAD83(2011) / NCRS Las Vegas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "001 +x_0=99999.9999898399 +y_0=200000.00001016 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / NCRS Las Vegas (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",36");
    add_srs_wkt (p, 8,
        ".25],PARAMETER[\"central_meridian\",-114.966666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.0001],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",328083.3333],PARAMETER[\"false_northing\",656166.6");
    add_srs_wkt (p, 11,
        "667],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8384\"]]");
    p = add_epsg_def_ex (filter, first, last, 8385, "epsg", 8385,
        "NAD83(2011) / NCRS Las Vegas high (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "00135 +x_0=300000 +y_0=400000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / NCRS Las Vegas high (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "6.25],PARAMETER[\"central_meridian\",-114.966666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000135],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",300000],PARAMETER[\"false_northing\",400000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"8385\"]]");
    p = add_epsg_def_ex (filter, first, last, 8387, "epsg", 8387,
        "NAD83(2011) / NCRS Las Vegas high (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.25 +lon_0=-114.966666666667 +k=1.0");
    add_proj4text (p, 1,
        "00135 +x_0=300000 +y_0=399999.99998984 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / NCRS Las Vegas high (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36.25],PARAMETER[\"central_meridian\",-114.966666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000135],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",984250],PARAMETER[\"false_northing\",1312333.");
    add_srs_wkt (p, 11,
        "3333],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8387\"]]");
    p = add_epsg_def_ex (filter, first, last, 8391, "epsg", 8391,
        "GDA94 / WEIPA94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=0.999929 +x_0=300000 ");
    add_proj4text (p, 1,
        "+y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / WEIPA94\",GEOGCS[\"GDA94\",DATUM[\"Geoc");
    add_srs_wkt (p, 1,
        "entric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",141],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "29],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"8391\"]]");
    p = add_epsg_def_ex (filter, first, last, 8395, "epsg", 8395,
        "ETRS89 / Gauss-Kruger CM 9E", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Gauss-Kruger CM 9E\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8395\"]]");
    p = add_epsg_def_ex (filter, first, last, 8399, "epsg", 8399,
        "ETRF2005", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF2005\",DATUM[\"European Terrestrial Refere");
    add_srs_wkt (p, 1,
        "nce Frame 2005\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Europe - ETRS89\"],BBOX[32.88,-16.1,84.17,40.18]],ID");
    add_srs_wkt (p, 10,
        "[\"EPSG\",8399]]");
    p = add_epsg_def_ex (filter, first, last, 8403, "epsg", 8403,
        "ETRF2014", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF2014\",DATUM[\"European Terrestrial Refere");
    add_srs_wkt (p, 1,
        "nce Frame 2014\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Europe - ETRS89\"],BBOX[32.88,-16.1,84.17,40.18]],ID");
    add_srs_wkt (p, 10,
        "[\"EPSG\",8403]]");
    p = add_epsg_def_ex (filter, first, last, 8426, "epsg", 8426,
        "Hong Kong Geodetic CS", 1, 1,
        "GRS 1980", "Greenwich",
        "Hong_Kong_Geodetic", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Hong Kong Geodetic CS\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Hong Kong Geodetic\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"China - Hong Kong\"],BBOX[22.13,113.76,22.5");
    add_srs_wkt (p, 10,
        "8,114.51]],ID[\"EPSG\",8426]]],TARGETCRS[GEOGCRS[\"WGS 8");
    add_srs_wkt (p, 11,
        "4\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS");
    add_srs_wkt (p, 12,
        " 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PR");
    add_srs_wkt (p, 13,
        "IMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 14,
        "9433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1");
    add_srs_wkt (p, 15,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longi");
    add_srs_wkt (p, 16,
        "tude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 17,
        "9433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"Hong");
    add_srs_wkt (p, 18,
        " Kong Geodetic CS to WGS 84 (1)\",METHOD[\"Geocentric tr");
    add_srs_wkt (p, 19,
        "anslations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETE");
    add_srs_wkt (p, 20,
        "R[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[");
    add_srs_wkt (p, 21,
        "\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"");
    add_srs_wkt (p, 22,
        "Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 23,
        "unknown\"],AREA[\"China - Hong Kong\"],BBOX[22.13,113.76");
    add_srs_wkt (p, 24,
        ",22.58,114.51]],ID[\"EPSG\",8439]]]");
    p = add_epsg_def_ex (filter, first, last, 8427, "epsg", 8427,
        "Hong Kong Geodetic CS", 1, 1,
        "GRS 1980", "Greenwich",
        "Hong_Kong_Geodetic", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong Geodetic CS\",DATUM[\"Hong_Kong_Geode");
    add_srs_wkt (p, 1,
        "tic\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8427\"]]");
    p = add_epsg_def_ex (filter, first, last, 8428, "epsg", 8428,
        "Macao 1920", 1, 1,
        "International 1924", "Greenwich",
        "Macao_1920", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Macao 1920\",DATUM[\"Macao_1920\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"1207\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8428\"]]");
    p = add_epsg_def_ex (filter, first, last, 8430, "epsg", 8430,
        "Macao 2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Macao_Geodetic_Datum_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Macao 2008\",DATUM[\"Macao ");
    add_srs_wkt (p, 1,
        "Geodetic Datum 2008\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"]");
    add_srs_wkt (p, 9,
        ",AREA[\"China - Macao\"],BBOX[22.06,113.52,22.23,113.68]");
    add_srs_wkt (p, 10,
        "],ID[\"EPSG\",8430]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 11,
        "[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",637");
    add_srs_wkt (p, 12,
        "8137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 13,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 14,
        "[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 15,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"longitude\",ea");
    add_srs_wkt (p, 16,
        "st,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID");
    add_srs_wkt (p, 17,
        "[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"Macao 2008 to");
    add_srs_wkt (p, 18,
        " WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D d");
    add_srs_wkt (p, 19,
        "omain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translati");
    add_srs_wkt (p, 20,
        "on\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation");
    add_srs_wkt (p, 21,
        "\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Ch");
    add_srs_wkt (p, 23,
        "ina - Macao\"],BBOX[22.06,113.52,22.23,113.68]],ID[\"EPS");
    add_srs_wkt (p, 24,
        "G\",8436]]]");
    p = add_epsg_def_ex (filter, first, last, 8431, "epsg", 8431,
        "Macao 2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Macao_Geodetic_Datum_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Macao 2008\",DATUM[\"Macao_Geodetic_Datum_2008\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1208\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"8431\"]]");
    p = add_epsg_def_ex (filter, first, last, 8433, "epsg", 8433,
        "Macao 1920 / Macao Grid", 0, 1,
        "International 1924", "Greenwich",
        "Macao_1920", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=22.2123972222222 +lon_0=113.536469444");
    add_proj4text (p, 1,
        "444 +k=1 +x_0=20000 +y_0=20000 +ellps=intl +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Macao 1920 / Macao Grid\",GEOGCS[\"Macao 1920\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Macao_1920\",SPHEROID[\"International 1924\",63");
    add_srs_wkt (p, 2,
        "78388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1207\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8428\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",22.2123972222222],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "113.536469444444],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",20000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "20000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"8433\"]]");
    p = add_epsg_def_ex (filter, first, last, 8441, "epsg", 8441,
        "Tananarive / Laborde Grid", 0, 1,
        "International 1924", "Greenwich",
        "Tananarive_1925", "Laborde_Oblique_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=labrd +lat_0=-18.9 +lon_0=46.4372291666667 +azi=18");
    add_proj4text (p, 1,
        ".9 +k=0.9995 +x_0=400000 +y_0=800000 +ellps=intl +towgs8");
    add_proj4text (p, 2,
        "4=-198.383,-240.517,-107.909,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / Laborde Grid\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "198.383,-240.517,-107.909,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6297\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4297\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Laborde_Oblique_Mercator\"],PARAMETER[\"latitude_of_ce");
    add_srs_wkt (p, 8,
        "nter\",-18.9],PARAMETER[\"longitude_of_center\",46.43722");
    add_srs_wkt (p, 9,
        "91666667],PARAMETER[\"azimuth\",18.9],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9995],PARAMETER[\"false_easting\",400000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"8441\"]]");
    p = add_epsg_def_ex (filter, first, last, 8449, "epsg", 8449,
        "NAD83(FBN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Federal_Base_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(FBN)\",DATUM[\"NAD83_Federal_Base_Network");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1211\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"8860\"]]");
    p = add_epsg_def_ex (filter, first, last, 8455, "epsg", 8455,
        "RGTAAF07 / UTM zone 53S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 53S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",135],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8455\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8456, "epsg", 8456,
        "RGTAAF07 / UTM zone 54S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGTAAF07 / UTM zone 54S\",GEOGCS[\"RGTAAF07\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_des_Terres_Australes_et_Antarct");
    add_srs_wkt (p, 2,
        "iques_Francaises_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1113\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7073\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",141],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8456\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8518, "epsg", 8518,
        "NAD83(2011) / KS RCS zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-101.6 +k=1.000156 +x_0=4");
    add_proj4text (p, 1,
        "57200.914401829 +y_0=0 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 1\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-101.6],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1.000156],PARAMETER[\"false_easting\",1500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8518\"]]");
    p = add_epsg_def_ex (filter, first, last, 8519, "epsg", 8519,
        "NAD83(2011) / KS RCS zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-100.95 +k=1.000134 +x_0=");
    add_proj4text (p, 1,
        "762001.524003047 +y_0=0 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 2\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-100.95],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000134],PARAMETER[\"false_easting\",2500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"8519\"]]");
    p = add_epsg_def_ex (filter, first, last, 8520, "epsg", 8520,
        "NAD83(2011) / KS RCS zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-100.35 +k=1.000116 +x_0=");
    add_proj4text (p, 1,
        "1066802.13360427 +y_0=0 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 3\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-100.35],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000116],PARAMETER[\"false_easting\",3500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"8520\"]]");
    p = add_epsg_def_ex (filter, first, last, 8521, "epsg", 8521,
        "NAD83(2011) / KS RCS zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-99.45 +k=1.000082 +x_0=1");
    add_proj4text (p, 1,
        "371602.74320549 +y_0=0 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 4\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-99.45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1.000082],PARAMETER[\"false_easting\",4500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8521\"]]");
    p = add_epsg_def_ex (filter, first, last, 8522, "epsg", 8522,
        "NAD83(2011) / KS RCS zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-98.6666666666667 +k=1.00");
    add_proj4text (p, 1,
        "0078 +x_0=1676403.3528067 +y_0=0 +ellps=GRS80 +units=us-");
    add_proj4text (p, 2,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 5\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-98.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000078],PARAMETER[\"false_easting\",550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8522\"]]");
    p = add_epsg_def_ex (filter, first, last, 8523, "epsg", 8523,
        "NAD83(2011) / KS RCS zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-98.15 +k=1.000068 +x_0=1");
    add_proj4text (p, 1,
        "981203.96240792 +y_0=0 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 6\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-98.15],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1.000068],PARAMETER[\"false_easting\",6500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8523\"]]");
    p = add_epsg_def_ex (filter, first, last, 8524, "epsg", 8524,
        "NAD83(2011) / KS RCS zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-97.3333333333333 +k=1.00");
    add_proj4text (p, 1,
        "0049 +x_0=2286004.57200914 +y_0=0 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 7\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-97.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000049],PARAMETER[\"false_easting\",750");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8524\"]]");
    p = add_epsg_def_ex (filter, first, last, 8525, "epsg", 8525,
        "NAD83(2011) / KS RCS zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.1666666666667 +lat_0=39.166666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-96.5 +k_0=1.000044 +x_0=2590805.18161036 +y_0=");
    add_proj4text (p, 2,
        "182880.365760731 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 8\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",39.");
    add_srs_wkt (p, 8,
        "1666666666667],PARAMETER[\"central_meridian\",-96.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.000044],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",8500000],PARAMETER[\"false_northing\",600000],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8525\"]]");
    p = add_epsg_def_ex (filter, first, last, 8526, "epsg", 8526,
        "NAD83(2011) / KS RCS zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.5 +lat_0=38.5 +lon_0=-96.5 +k_0=1.00");
    add_proj4text (p, 1,
        "005 +x_0=2895605.79121158 +y_0=91440.1828803657 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 9\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",38.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-96.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.00005],PARAMETER[\"false_easting\",9500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",300000],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8526\"]]");
    p = add_epsg_def_ex (filter, first, last, 8527, "epsg", 8527,
        "NAD83(2011) / KS RCS zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.6333333333333 +lat_0=39.633333333333");
    add_proj4text (p, 1,
        "3 +lon_0=-95.75 +k_0=1.00004 +x_0=3200406.4008128 +y_0=2");
    add_proj4text (p, 2,
        "13360.426720853 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 10\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 8,
        ".6333333333333],PARAMETER[\"central_meridian\",-95.75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.00004],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",10500000],PARAMETER[\"false_northing\",700000],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"8527\"]]");
    p = add_epsg_def_ex (filter, first, last, 8528, "epsg", 8528,
        "NAD83(2011) / KS RCS zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.1 +lat_0=39.1 +lon_0=-95.25 +k_0=1.0");
    add_proj4text (p, 1,
        "00033 +x_0=3505207.01041402 +y_0=182880.365760731 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 11\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 8,
        ".1],PARAMETER[\"central_meridian\",-95.25],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000033],PARAMETER[\"false_easting\",1150");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",600000],UNIT[\"US sur");
    add_srs_wkt (p, 11,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8528\"]]");
    p = add_epsg_def_ex (filter, first, last, 8529, "epsg", 8529,
        "NAD83(2011) / KS RCS zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-101.416666666667 +k=1.0");
    add_proj4text (p, 1,
        "0014 +x_0=3810007.62001524 +y_0=0 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 12\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-101.416666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.00014],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "2500000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"8529\"]]");
    p = add_epsg_def_ex (filter, first, last, 8531, "epsg", 8531,
        "NAD83(2011) / KS RCS zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-100.4 +k=1.000109 +x_0=");
    add_proj4text (p, 1,
        "4114808.22961646 +y_0=0 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 13\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-100.4],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.000109],PARAMETER[\"false_easting\",13500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"8531\"]]");
    p = add_epsg_def_ex (filter, first, last, 8533, "epsg", 8533,
        "NAD83(2011) / KS RCS zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-99.6666666666667 +k=1.0");
    add_proj4text (p, 1,
        "00097 +x_0=4419608.83921768 +y_0=0 +ellps=GRS80 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 14\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-99.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.000097],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "14500000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"8533\"]]");
    p = add_epsg_def_ex (filter, first, last, 8534, "epsg", 8534,
        "NAD83(2011) / KS RCS zone 15", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-99.2 +k=1.000087 +x_0=4");
    add_proj4text (p, 1,
        "724409.4488189 +y_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 15\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-99.2],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000087],PARAMETER[\"false_easting\",15500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 11,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"8534\"]]");
    p = add_epsg_def_ex (filter, first, last, 8535, "epsg", 8535,
        "NAD83(2011) / KS RCS zone 16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-98.55 +k=1.000069 +x_0=");
    add_proj4text (p, 1,
        "5029210.05842011 +y_0=0 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 16\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-98.55],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.000069],PARAMETER[\"false_easting\",16500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"8535\"]]");
    p = add_epsg_def_ex (filter, first, last, 8536, "epsg", 8536,
        "NAD83(2011) / KS RCS zone 17", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.7666666666667 +lat_0=37.766666666666");
    add_proj4text (p, 1,
        "7 +lon_0=-97.5 +k_0=1.000059 +x_0=5334010.66802133 +y_0=");
    add_proj4text (p, 2,
        "121920.243840488 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 17\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",37");
    add_srs_wkt (p, 8,
        ".7666666666667],PARAMETER[\"central_meridian\",-97.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000059],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",17500000],PARAMETER[\"false_northing\",400000],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"8536\"]]");
    p = add_epsg_def_ex (filter, first, last, 8538, "epsg", 8538,
        "NAD83(2011) / KS RCS zone 18", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.1833333333333 +lat_0=37.183333333333");
    add_proj4text (p, 1,
        "3 +lon_0=-97.5 +k_0=1.000055 +x_0=5638811.27762255 +y_0=");
    add_proj4text (p, 2,
        "60960.1219202438 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 18\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",37");
    add_srs_wkt (p, 8,
        ".1833333333333],PARAMETER[\"central_meridian\",-97.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000055],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",18500000],PARAMETER[\"false_northing\",200000],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"8538\"]]");
    p = add_epsg_def_ex (filter, first, last, 8539, "epsg", 8539,
        "NAD83(2011) / KS RCS zone 19", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-95.9666666666667 +k=1.0");
    add_proj4text (p, 1,
        "00034 +x_0=5943611.88722377 +y_0=0 +ellps=GRS80 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 19\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-95.9666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.000034],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "19500000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"8539\"]]");
    p = add_epsg_def_ex (filter, first, last, 8540, "epsg", 8540,
        "NAD83(2011) / KS RCS zone 20", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.75 +lon_0=-95.0833333333333 +k=1.0");
    add_proj4text (p, 1,
        "00031 +x_0=6248412.49682499 +y_0=0 +ellps=GRS80 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / KS RCS zone 20\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",36.75],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-95.0833333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.000031],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "20500000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"8540\"]]");
    p = add_epsg_def_ex (filter, first, last, 8542, "epsg", 8542,
        "NAD83(FBN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Federal_Base_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(FBN)\",DATUM[\"NAD83 (Federal Base Netwo");
    add_srs_wkt (p, 1,
        "rk)\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"USA - F");
    add_srs_wkt (p, 9,
        "BN\"],BBOX[-14.59,144.58,49.38,-64.51]],ID[\"EPSG\",8542");
    add_srs_wkt (p, 10,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8544, "epsg", 8544,
        "NAD83(HARN Corrected)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network_Corrected", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(HARN Corrected)\",DATUM[\"NAD83 (High Ac");
    add_srs_wkt (p, 1,
        "curacy Reference Network - Corrected)\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 4,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 5,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 7,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 8,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 9,
        "[SCOPE[\"unknown\"],AREA[\"Caribbean - Puerto Rico and U");
    add_srs_wkt (p, 10,
        "S Virgin Islands - onshore\"],BBOX[17.62,-67.97,18.57,-6");
    add_srs_wkt (p, 11,
        "4.51]],ID[\"EPSG\",8544]]");
    p = add_epsg_def_ex (filter, first, last, 8545, "epsg", 8545,
        "NAD83(HARN Corrected)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network_Corrected", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(HARN Corrected)\",DATUM[\"NAD83_High_Accu");
    add_srs_wkt (p, 1,
        "racy_Reference_Network_Corrected\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1212\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"8545\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

