/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_41 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8111, "epsg", 8111,
        "NAD83(HARN) / WISCRS Vernon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5750329397222 +lat_0=43.575032939722");
    add_proj4text (p, 1,
        "2 +lon_0=-90.7833333333333 +k_0=1.0000408158 +x_0=222504");
    add_proj4text (p, 2,
        ".4451 +y_0=47532.0602 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vernon (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.5750329397222],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90.7833333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000408158],PARAMETER[\"false_easting\",222504.4451],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",47532.0602],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8111\"]]");
    p = add_epsg_def_ex (filter, first, last, 8112, "epsg", 8112,
        "NAD83(HARN) / WISCRS Vernon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5750329397222 +lat_0=43.575032939722");
    add_proj4text (p, 1,
        "2 +lon_0=-90.7833333333333 +k_0=1.0000408158 +x_0=222504");
    add_proj4text (p, 2,
        ".44500889 +y_0=47532.0603505207 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vernon (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.5750329397222],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-90.7833333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000408158],PARAMETER[\"false_easting\",730000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",155944.768],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8112\"]]");
    p = add_epsg_def_ex (filter, first, last, 8113, "epsg", 8113,
        "NAD83(HARN) / WISCRS Trempealeau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.1611111111111 +lon_0=-91.366666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000361538 +x_0=256946.9138 +y_0=0.0041 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Trempealeau (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",43.1611111111111],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-91.3666666666667],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000361538],PARAMETER[\"false_easting\",256946.9138],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0.0041],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"8113\"]]");
    p = add_epsg_def_ex (filter, first, last, 8114, "epsg", 8114,
        "NAD83(HARN) / WISCRS Trempealeau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.1611111111111 +lon_0=-91.366666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000361538 +x_0=256946.913893828 +y_0=0.003962");
    add_proj4text (p, 2,
        "40792481585 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Trempealeau (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",43.1611111111111],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-91.3666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000361538],PARAMETER[\"false_easting\",843000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.013],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8114\"]]");
    p = add_epsg_def_ex (filter, first, last, 8115, "epsg", 8115,
        "NAD83(HARN) / WISCRS Taylor (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1778220858333 +lat_0=45.177822085833");
    add_proj4text (p, 1,
        "3 +lon_0=-90.4833333333333 +k_0=1.0000597566 +x_0=187147");
    add_proj4text (p, 2,
        ".5744 +y_0=107746.7522 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Taylor (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45.1778220858333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90.4833333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000597566],PARAMETER[\"false_easting\",187147.5744],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",107746.7522],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8115\"]]");
    p = add_epsg_def_ex (filter, first, last, 8116, "epsg", 8116,
        "NAD83(HARN) / WISCRS Taylor (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1778220858333 +lat_0=45.177822085833");
    add_proj4text (p, 1,
        "3 +lon_0=-90.4833333333333 +k_0=1.0000597566 +x_0=187147");
    add_proj4text (p, 2,
        ".574295148 +y_0=107746.752146304 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Taylor (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.1778220858333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-90.4833333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000597566],PARAMETER[\"false_easting\",614000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",353499.136],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8116\"]]");
    p = add_epsg_def_ex (filter, first, last, 8117, "epsg", 8117,
        "NAD83(HARN) / WISCRS St. Croix (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000381803 +x_0=165506.7302 +y_0=0.0103 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS St. Croix (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.0361111111111],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-92.6333333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00381803],PARAMETER[\"false_easting\",165506.7302],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.0103],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8117\"]]");
    p = add_epsg_def_ex (filter, first, last, 8118, "epsg", 8118,
        "NAD83(HARN) / WISCRS St. Croix (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000381803 +x_0=165506.73009906 +y_0=0.0103632");
    add_proj4text (p, 2,
        "207264414 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS St. Croix (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.0361111111111],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-92.6333333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000381803],PARAMETER[\"false_easting\",542999.997],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0.034],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8118\"]]");
    p = add_epsg_def_ex (filter, first, last, 8119, "epsg", 8119,
        "NAD83(HARN) / WISCRS Shawano (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-88.605555555");
    add_proj4text (p, 1,
        "5556 +k=1.000032144 +x_0=262433.3253 +y_0=0.0096 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Shawano (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.0361111111111],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-88.6055555555556],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "32144],PARAMETER[\"false_easting\",262433.3253],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.0096],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8119\"]]");
    p = add_epsg_def_ex (filter, first, last, 8120, "epsg", 8120,
        "NAD83(HARN) / WISCRS Shawano (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-88.605555555");
    add_proj4text (p, 1,
        "5556 +k=1.000032144 +x_0=262433.32517145 +y_0=0.00944881");
    add_proj4text (p, 2,
        "889763779 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Shawano (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",44.0361111111111],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-88.6055555555556],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "00032144],PARAMETER[\"false_easting\",861000.001],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0.031],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8120\"]]");
    p = add_epsg_def_ex (filter, first, last, 8121, "epsg", 8121,
        "NAD83(HARN) / WISCRS Sawyer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9000991313889 +lat_0=45.900099131388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.1166666666667 +k_0=1.0000573461 +x_0=216713");
    add_proj4text (p, 2,
        ".2336 +y_0=120734.1631 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sawyer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45.9000991313889],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-91.1166666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000573461],PARAMETER[\"false_easting\",216713.2336],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",120734.1631],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8121\"]]");
    p = add_epsg_def_ex (filter, first, last, 8122, "epsg", 8122,
        "NAD83(HARN) / WISCRS Sawyer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9000991313889 +lat_0=45.900099131388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.1166666666667 +k_0=1.0000573461 +x_0=216713");
    add_proj4text (p, 2,
        ".233731267 +y_0=120734.163169926 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sawyer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.9000991313889],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-91.1166666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000573461],PARAMETER[\"false_easting\",711000.001");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",396108.667],UNIT[\"US sur");
    add_srs_wkt (p, 12,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"8122\"]]");
    p = add_epsg_def_ex (filter, first, last, 8123, "epsg", 8123,
        "NAD83(HARN) / WISCRS Sauk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.8194444444444 +lon_0=-89.9 +k=1.00");
    add_proj4text (p, 1,
        "00373868 +x_0=185623.5716 +y_0=0.0051 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sauk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",42.8194444444444],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-89.9],PARAMETER[\"scale_factor\",1.0000373868],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",185623.5716],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0051],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"8123\"]]");
    p = add_epsg_def_ex (filter, first, last, 8124, "epsg", 8124,
        "NAD83(HARN) / WISCRS Sauk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.8194444444444 +lon_0=-89.9 +k=1.00");
    add_proj4text (p, 1,
        "00373868 +x_0=185623.571551943 +y_0=0.00518161036322072 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sauk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",42.8194444444444],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-89.9],PARAMETER[\"scale_factor\",1.0000373868],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",609000.001],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.017],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8124\"]]");
    p = add_epsg_def_ex (filter, first, last, 8125, "epsg", 8125,
        "NAD83(HARN) / WISCRS Rusk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.9194444444444 +lon_0=-91.066666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000495976 +x_0=250546.1013 +y_0=0.0234 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rusk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43.9194444444444],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-91.0666666666667],PARAMETER[\"scale_factor\",1.0000495");
    add_srs_wkt (p, 10,
        "976],PARAMETER[\"false_easting\",250546.1013],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0234],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8125\"]]");
    p = add_epsg_def_ex (filter, first, last, 8126, "epsg", 8126,
        "NAD83(HARN) / WISCRS Rusk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.9194444444444 +lon_0=-91.066666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000495976 +x_0=250546.101397003 +y_0=0.023469");
    add_proj4text (p, 2,
        "6469392939 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rusk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.9194444444444],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-91.0666666666667],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "495976],PARAMETER[\"false_easting\",822000.001],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.077],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8126\"]]");
    p = add_epsg_def_ex (filter, first, last, 8127, "epsg", 8127,
        "NAD83(HARN) / WISCRS Rock (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.9444444444444 +lon_0=-89.072222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000337311 +x_0=146304.2926 +y_0=0.0068 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rock (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",41.9444444444444],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-89.0722222222222],PARAMETER[\"scale_factor\",1.0000337");
    add_srs_wkt (p, 10,
        "311],PARAMETER[\"false_easting\",146304.2926],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0068],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8127\"]]");
    p = add_epsg_def_ex (filter, first, last, 8128, "epsg", 8128,
        "NAD83(HARN) / WISCRS Rock (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.9444444444444 +lon_0=-89.072222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000337311 +x_0=146304.292608585 +y_0=0.006705");
    add_proj4text (p, 2,
        "61341122682 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rock (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.9444444444444],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-89.0722222222222],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "337311],PARAMETER[\"false_easting\",480000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.022],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"812");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 8129, "epsg", 8129,
        "NAD83(HARN) / WISCRS Richland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.4305555555556 +k_0=1.0000375653 +x_0=202387.6048 ");
    add_proj4text (p, 2,
        "+y_0=134255.4253 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Richland (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.3223129275],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90.4305555555556],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000375653],PARAMETER[\"false_easting\",202387.6048],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",134255.4253],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8129\"]]");
    p = add_epsg_def_ex (filter, first, last, 8130, "epsg", 8130,
        "NAD83(HARN) / WISCRS Richland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.4305555555556 +k_0=1.0000375653 +x_0=202387.60477");
    add_proj4text (p, 2,
        "5209 +y_0=134255.425450851 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 3,
        ",0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Richland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.3223129275],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-90.4305555555556],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000375653],PARAMETER[\"false_easting\",664000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",440469.675],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"8130\"]]");
    p = add_epsg_def_ex (filter, first, last, 8131, "epsg", 8131,
        "NAD83(HARN) / WISCRS Price (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5555555555556 +lon_0=-90.488888888");
    add_proj4text (p, 1,
        "8889 +k=1.0000649554 +x_0=227990.8546 +y_0=0.0109 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Price (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.5555555555556],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.4888888888889],PARAMETER[\"scale_factor\",1.0000649");
    add_srs_wkt (p, 10,
        "554],PARAMETER[\"false_easting\",227990.8546],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0109],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8131\"]]");
    p = add_epsg_def_ex (filter, first, last, 8132, "epsg", 8132,
        "NAD83(HARN) / WISCRS Price (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5555555555556 +lon_0=-90.488888888");
    add_proj4text (p, 1,
        "8889 +k=1.0000649554 +x_0=227990.854457709 +y_0=0.010972");
    add_proj4text (p, 2,
        "8219456439 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Price (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.5555555555556],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.4888888888889],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "649554],PARAMETER[\"false_easting\",747999.995],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.036],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8132\"]]");
    p = add_epsg_def_ex (filter, first, last, 8133, "epsg", 8133,
        "NAD83(HARN) / WISCRS Portage (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4168239752778 +lat_0=44.416823975277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1128 +y_0=500");
    add_proj4text (p, 2,
        "22.1874 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Portage (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",44.4168239752778],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-89.5],PARAMETER[\"scale_factor\",1.00003993");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",56388.1128],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",50022.1874],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8133\"]]");
    p = add_epsg_def_ex (filter, first, last, 8134, "epsg", 8134,
        "NAD83(HARN) / WISCRS Portage (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4168239752778 +lat_0=44.416823975277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1127762255 +y");
    add_proj4text (p, 2,
        "_0=50022.1874523749 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Portage (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44.4168239752778],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.5],PARAMETER[\"scale_factor\",1.000039");
    add_srs_wkt (p, 10,
        "936],PARAMETER[\"false_easting\",185000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",164114.46],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"813");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 8135, "epsg", 8135,
        "NAD83(HARN) / WISCRS Polk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6611111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000433849 +x_0=141732.2823 +y_0=0.0059 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Polk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.6611111111111],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-92.6333333333333],PARAMETER[\"scale_factor\",1.0000433");
    add_srs_wkt (p, 10,
        "849],PARAMETER[\"false_easting\",141732.2823],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0059],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8135\"]]");
    p = add_epsg_def_ex (filter, first, last, 8136, "epsg", 8136,
        "NAD83(HARN) / WISCRS Polk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6611111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000433849 +x_0=141732.282245364 +y_0=0.005791");
    add_proj4text (p, 2,
        "21158242316 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Polk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.6611111111111],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-92.6333333333333],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "433849],PARAMETER[\"false_easting\",464999.996],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.019],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8136\"]]");
    p = add_epsg_def_ex (filter, first, last, 8137, "epsg", 8137,
        "NAD83(HARN) / WISCRS Pepin and Pierce (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.6361488719444 +lat_0=44.636148871944");
    add_proj4text (p, 1,
        "4 +lon_0=-92.2277777777778 +k_0=1.0000362977 +x_0=167640");
    add_proj4text (p, 2,
        ".3354 +y_0=86033.0876 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Pepin and Pierce (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "52\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",44.6361488719444],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-92.2277777777778],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1.0000362977],PARAMETER[\"false_easting\",167");
    add_srs_wkt (p, 11,
        "640.3354],PARAMETER[\"false_northing\",86033.0876],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 14,
        "137\"]]");
    p = add_epsg_def_ex (filter, first, last, 8138, "epsg", 8138,
        "NAD83(HARN) / WISCRS Pepin and Pierce (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.6361488719444 +lat_0=44.636148871944");
    add_proj4text (p, 1,
        "4 +lon_0=-92.2277777777778 +k_0=1.0000362977 +x_0=167640");
    add_proj4text (p, 2,
        ".33528067 +y_0=86033.0877317754 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Pepin and Pierce (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",44.6361488719444],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-92.2277777777778],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1.0000362977],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "50000],PARAMETER[\"false_northing\",282260.222],UNIT[\"U");
    add_srs_wkt (p, 12,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"8138\"]]");
    p = add_epsg_def_ex (filter, first, last, 8139, "epsg", 8139,
        "NAD83(HARN) / WISCRS Oneida (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7042237702778 +lat_0=45.704223770277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5444444444444 +k_0=1.0000686968 +x_0=70104.");
    add_proj4text (p, 2,
        "1401 +y_0=57588.0346 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oneida (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45.7042237702778],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-89.5444444444444],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000686968],PARAMETER[\"false_easting\",70104.1401],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",57588.0346],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8139\"]]");
    p = add_epsg_def_ex (filter, first, last, 8140, "epsg", 8140,
        "NAD83(HARN) / WISCRS Oneida (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7042237702778 +lat_0=45.704223770277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5444444444444 +k_0=1.0000686968 +x_0=70104.");
    add_proj4text (p, 2,
        "1402082804 +y_0=57588.0347472695 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oneida (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.7042237702778],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.5444444444444],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000686968],PARAMETER[\"false_easting\",230000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",188936.744],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8140\"]]");
    p = add_epsg_def_ex (filter, first, last, 8141, "epsg", 8141,
        "NAD83(HARN) / WISCRS Oconto (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.3972222222222 +lon_0=-87.908333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000236869 +x_0=182880.3676 +y_0=0.0033 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oconto (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.3972222222222],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-87.9083333333333],PARAMETER[\"scale_factor\",1.0000236");
    add_srs_wkt (p, 10,
        "869],PARAMETER[\"false_easting\",182880.3676],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0033],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8141\"]]");
    p = add_epsg_def_ex (filter, first, last, 8142, "epsg", 8142,
        "NAD83(HARN) / WISCRS Oconto (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.3972222222222 +lon_0=-87.908333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000236869 +x_0=182880.367589535 +y_0=0.003352");
    add_proj4text (p, 2,
        "80670561341 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oconto (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.3972222222222],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-87.9083333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00236869],PARAMETER[\"false_easting\",600000.006],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0.011],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8142\"]]");
    p = add_epsg_def_ex (filter, first, last, 8143, "epsg", 8143,
        "NAD83(HARN) / WISCRS Monroe (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.0000739286111 +lat_0=44.000073928611");
    add_proj4text (p, 1,
        "1 +lon_0=-90.6416666666667 +k_0=1.0000434122 +x_0=204521");
    add_proj4text (p, 2,
        ".209 +y_0=121923.9861 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Monroe (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.0000739286111],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90.6416666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000434122],PARAMETER[\"false_easting\",204521.209],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",121923.9861],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8143\"]]");
    p = add_epsg_def_ex (filter, first, last, 8144, "epsg", 8144,
        "NAD83(HARN) / WISCRS Monroe (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.0000739286111 +lat_0=44.000073928611");
    add_proj4text (p, 1,
        "1 +lon_0=-90.6416666666667 +k_0=1.0000434122 +x_0=204521");
    add_proj4text (p, 2,
        ".209042418 +y_0=121923.986182372 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Monroe (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44.0000739286111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-90.6416666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000434122],PARAMETER[\"false_easting\",671000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",400012.278],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8144\"]]");
    p = add_epsg_def_ex (filter, first, last, 8145, "epsg", 8145,
        "NAD83(HARN) / WISCRS Menominee (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.7166666666667 +lon_0=-88.416666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000362499 +x_0=105461.0121 +y_0=0.0029 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Menominee (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.7166666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-88.4166666666667],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00362499],PARAMETER[\"false_easting\",105461.0121],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.0029],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8145\"]]");
    p = add_epsg_def_ex (filter, first, last, 8146, "epsg", 8146,
        "NAD83(HARN) / WISCRS Menominee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.7166666666667 +lon_0=-88.416666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000362499 +x_0=105461.012141224 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Menominee (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.7166666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-88.4166666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000362499],PARAMETER[\"false_easting\",346000.004],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0.01],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"8146\"]]");
    p = add_epsg_def_ex (filter, first, last, 8147, "epsg", 8147,
        "NAD83(HARN) / WISCRS Marinette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6916666666667 +lon_0=-87.711111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000234982 +x_0=238658.8794 +y_0=0.0032 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marinette (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.6916666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-87.7111111111111],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00234982],PARAMETER[\"false_easting\",238658.8794],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.0032],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8147\"]]");
    p = add_epsg_def_ex (filter, first, last, 8148, "epsg", 8148,
        "NAD83(HARN) / WISCRS Marinette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6916666666667 +lon_0=-87.711111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000234982 +x_0=238658.879451359 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marinette (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",44.6916666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-87.7111111111111],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000234982],PARAMETER[\"false_easting\",783000.007],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0.01],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"8148\"]]");
    p = add_epsg_def_ex (filter, first, last, 8149, "epsg", 8149,
        "NAD83(HARN) / WISCRS Marathon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9009044236111 +lat_0=44.900904423611");
    add_proj4text (p, 1,
        "1 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493 +y_0=55");
    add_proj4text (p, 2,
        "049.2669 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marathon (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",44.9009044236111],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-89.77],PARAMETER[\"scale_factor\",1.0000532");
    add_srs_wkt (p, 10,
        "89],PARAMETER[\"false_easting\",74676.1493],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",55049.2669],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8149\"]]");
    p = add_epsg_def_ex (filter, first, last, 8150, "epsg", 8150,
        "NAD83(HARN) / WISCRS Marathon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9009044236111 +lat_0=44.900904423611");
    add_proj4text (p, 1,
        "1 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493522987 +");
    add_proj4text (p, 2,
        "y_0=55049.2669545339 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marathon (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44.9009044236111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.77],PARAMETER[\"scale_factor\",1.00005");
    add_srs_wkt (p, 10,
        "3289],PARAMETER[\"false_easting\",245000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",180607.47],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 14,
        "150\"]]");
    p = add_epsg_def_ex (filter, first, last, 8151, "epsg", 8151,
        "NAD83(HARN) / WISCRS Lincoln (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.8444444444444 +lon_0=-89.733333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000599003 +x_0=116129.0323 +y_0=0.0058 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Lincoln (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.8444444444444],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-89.7333333333333],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "599003],PARAMETER[\"false_easting\",116129.0323],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0.0058],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8151\"]]");
    p = add_epsg_def_ex (filter, first, last, 8152, "epsg", 8152,
        "NAD83(HARN) / WISCRS Lincoln (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.8444444444444 +lon_0=-89.733333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000599003 +x_0=116129.032258064 +y_0=0.005791");
    add_proj4text (p, 2,
        "21158242316 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Lincoln (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",44.8444444444444],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-89.7333333333333],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000599003],PARAMETER[\"false_easting\",381000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0.019],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8152\"]]");
    p = add_epsg_def_ex (filter, first, last, 8153, "epsg", 8153,
        "NAD83(HARN) / WISCRS Langlade (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1542371052778 +lat_0=45.154237105277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.0333333333333 +k_0=1.0000627024 +x_0=198425");
    add_proj4text (p, 2,
        ".197 +y_0=105279.7829 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Langlade (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.1542371052778],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-89.0333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000627024],PARAMETER[\"false_easting\",198425.197],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",105279.7829],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8153\"]]");
    p = add_epsg_def_ex (filter, first, last, 8154, "epsg", 8154,
        "NAD83(HARN) / WISCRS Langlade (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1542371052778 +lat_0=45.154237105277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.0333333333333 +k_0=1.0000627024 +x_0=198425");
    add_proj4text (p, 2,
        ".196850394 +y_0=105279.782880366 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Langlade (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.1542371052778],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.0333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000627024],PARAMETER[\"false_easting\",651000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",345405.421],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8154\"]]");
    p = add_epsg_def_ex (filter, first, last, 8155, "epsg", 8155,
        "NAD83(HARN) / WISCRS La Crosse (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4511111111111 +lon_0=-91.316666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000319985 +x_0=130454.6598 +y_0=0.0033 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS La Crosse (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.4511111111111],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-91.3166666666667],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00319985],PARAMETER[\"false_easting\",130454.6598],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.0033],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8155\"]]");
    p = add_epsg_def_ex (filter, first, last, 8156, "epsg", 8156,
        "NAD83(HARN) / WISCRS La Crosse (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4511111111111 +lon_0=-91.316666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000319985 +x_0=130454.659690119 +y_0=0.003352");
    add_proj4text (p, 2,
        "80670561341 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS La Crosse (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.4511111111111],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-91.3166666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000319985],PARAMETER[\"false_easting\",427999.996],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0.011],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8156\"]]");
    p = add_epsg_def_ex (filter, first, last, 8157, "epsg", 8157,
        "NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sheboygan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.2666666666667 +lon_0=-87.55 +k=1.0");
    add_proj4text (p, 1,
        "000233704 +x_0=79857.7614 +y_0=0.0012 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_");
    add_srs_wkt (p, 2,
        "Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",43.2666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-87.55],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1.0000233704],PARAMETER[\"false_easting\",79857");
    add_srs_wkt (p, 11,
        ".7614],PARAMETER[\"false_northing\",0.0012],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8157\"]]");
    p = add_epsg_def_ex (filter, first, last, 8158, "epsg", 8158,
        "NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sheboygan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.2666666666667 +lon_0=-87.55 +k=1.0");
    add_proj4text (p, 1,
        "000233704 +x_0=79857.761544323 +y_0=0.00121920243840488 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_Hi");
    add_srs_wkt (p, 2,
        "gh_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 4,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",43.2666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-87.55],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.0000233704],PARAMETER[\"false_easting\",26");
    add_srs_wkt (p, 11,
        "2000.006],PARAMETER[\"false_northing\",0.004],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"8158\"]]");
    p = add_epsg_def_ex (filter, first, last, 8159, "epsg", 8159,
        "NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.2166666666667 +lon_0=-87.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000260649 +x_0=185928.3728 +y_0=0.0009 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_");
    add_srs_wkt (p, 2,
        "High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 4,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[");
    add_srs_wkt (p, 5,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 6,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",42.21666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"central_meridian\",-87.8944444444444],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1.0000260649],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",185928.3728],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "009],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"8159\"]]");
    p = add_epsg_def_ex (filter, first, last, 8160, "epsg", 8160,
        "NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.2166666666667 +lon_0=-87.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000260649 +x_0=185928.372771145 +y_0=0.000914");
    add_proj4text (p, 2,
        "401828803657 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD");
    add_srs_wkt (p, 2,
        "83_High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",42.21666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"central_meridian\",-87.8944444444444]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1.0000260649],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",610000.003],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".003],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8160\"]]");
    p = add_epsg_def_ex (filter, first, last, 8161, "epsg", 8161,
        "NAD83(HARN) / WISCRS Jackson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.2533351277778 +lon_0=-90.844296519");
    add_proj4text (p, 1,
        "4444 +k=1.0000353 +x_0=27000 +y_0=25000 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Jackson (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.2533351277778],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.8442965194444],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "353],PARAMETER[\"false_easting\",27000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",25000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"8161\"]]");
    p = add_epsg_def_ex (filter, first, last, 8162, "epsg", 8162,
        "NAD83(HARN) / WISCRS Jackson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.2533351277778 +lon_0=-90.844296519");
    add_proj4text (p, 1,
        "4444 +k=1.0000353 +x_0=27000 +y_0=24999.9998983998 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Jackson (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",44.2533351277778],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-90.8442965194444],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000353],PARAMETER[\"false_easting\",88582.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",82020.833],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8162\"]]");
    p = add_epsg_def_ex (filter, first, last, 8163, "epsg", 8163,
        "NAD83(HARN) / WISCRS Iron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4333333333333 +lon_0=-90.255555555");
    add_proj4text (p, 1,
        "5556 +k=1.0000677153 +x_0=220980.4419 +y_0=0.0085 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iron (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",45.4333333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.2555555555556],PARAMETER[\"scale_factor\",1.0000677");
    add_srs_wkt (p, 10,
        "153],PARAMETER[\"false_easting\",220980.4419],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0085],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8163\"]]");
    p = add_epsg_def_ex (filter, first, last, 8164, "epsg", 8164,
        "NAD83(HARN) / WISCRS Iron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4333333333333 +lon_0=-90.255555555");
    add_proj4text (p, 1,
        "5556 +k=1.0000677153 +x_0=220980.441960884 +y_0=0.008534");
    add_proj4text (p, 2,
        "41706883413 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iron (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",45.4333333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.2555555555556],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "677153],PARAMETER[\"false_easting\",725000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.028],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"816");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 8165, "epsg", 8165,
        "NAD83(HARN) / WISCRS Iowa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5388888888889 +lon_0=-90.161111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000394961 +x_0=113081.0261 +y_0=0.0045 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iowa (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",42.5388888888889],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.1611111111111],PARAMETER[\"scale_factor\",1.0000394");
    add_srs_wkt (p, 10,
        "961],PARAMETER[\"false_easting\",113081.0261],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0045],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8165\"]]");
    p = add_epsg_def_ex (filter, first, last, 8166, "epsg", 8166,
        "NAD83(HARN) / WISCRS Iowa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5388888888889 +lon_0=-90.161111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000394961 +x_0=113081.026162052 +y_0=0.004572");
    add_proj4text (p, 2,
        "00914401829 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iowa (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",42.5388888888889],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.1611111111111],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "394961],PARAMETER[\"false_easting\",371000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.015],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"816");
    add_srs_wkt (p, 14,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 8167, "epsg", 8167,
        "NAD83(HARN) / WISCRS Green Lake and Marquette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.8070001177778 +lat_0=43.807000117777");
    add_proj4text (p, 1,
        "8 +lon_0=-89.2416666666667 +k_0=1.0000344057 +x_0=150876");
    add_proj4text (p, 2,
        ".3018 +y_0=79170.7795 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",43.8070001177778],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-89.2416666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1.0000344057],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",150876.3018],PARAMETER[\"false_northing\",79170.7795");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8167\"]]");
    p = add_epsg_def_ex (filter, first, last, 8168, "epsg", 8168,
        "NAD83(HARN) / WISCRS Green Lake and Marquette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.8070001177778 +lat_0=43.807000117777");
    add_proj4text (p, 1,
        "8 +lon_0=-89.2416666666667 +k_0=1.0000344057 +x_0=150876");
    add_proj4text (p, 2,
        ".301752603 +y_0=79170.7793751587 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accura");
    add_srs_wkt (p, 2,
        "cy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",43.8070001177778]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-89.2416666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1.0000344057],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",495000],PARAMETER[\"false_northing\",259746.132]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"8168\"]]");
    p = add_epsg_def_ex (filter, first, last, 8169, "epsg", 8169,
        "NAD83(HARN) / WISCRS Green and Lafayette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6375622769444 +lat_0=42.637562276944");
    add_proj4text (p, 1,
        "4 +lon_0=-89.8388888888889 +k_0=1.0000390487 +x_0=170078");
    add_proj4text (p, 2,
        ".7403 +y_0=45830.2947 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green and Lafayette (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",42.6375622769444],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-89.8388888888889],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1.0000390487],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 11,
        "70078.7403],PARAMETER[\"false_northing\",45830.2947],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8169\"]]");
    p = add_epsg_def_ex (filter, first, last, 8170, "epsg", 8170,
        "NAD83(HARN) / WISCRS Green and Lafayette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6375622769444 +lat_0=42.637562276944");
    add_proj4text (p, 1,
        "4 +lon_0=-89.8388888888889 +k_0=1.0000390487 +x_0=170078");
    add_proj4text (p, 2,
        ".74015748 +y_0=45830.2948437897 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green and Lafayette (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Re");
    add_srs_wkt (p, 2,
        "ference_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",42.6375622769444],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-89.8388888888889],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.0000390487],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",558000],PARAMETER[\"false_northing\",150361.559],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"8170\"]]");
    p = add_epsg_def_ex (filter, first, last, 8171, "epsg", 8171,
        "NAD83(HARN) / WISCRS Grant (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4111111111111 +lon_0=-90.8 +k=1.00");
    add_proj4text (p, 1,
        "00349452 +x_0=242316.4841 +y_0=0.01 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Grant (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",41.4111111111111],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.8],PARAMETER[\"scale_factor\",1.0000349452],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",242316.4841],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.01],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8171\"]]");
    p = add_epsg_def_ex (filter, first, last, 8172, "epsg", 8172,
        "NAD83(HARN) / WISCRS Grant (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4111111111111 +lon_0=-90.8 +k=1.00");
    add_proj4text (p, 1,
        "00349452 +x_0=242316.484023368 +y_0=0.0100584201168402 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Grant (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.4111111111111],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.8],PARAMETER[\"scale_factor\",1.0000349452],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",794999.998],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.033],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8172\"]]");
    p = add_epsg_def_ex (filter, first, last, 8173, "epsg", 8173,
        "NAD83(HARN) / WISCRS Forest (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0055555555556 +lon_0=-88.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000673004 +x_0=275844.5533 +y_0=0.0157 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Forest (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.0055555555556],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-88.6333333333333],PARAMETER[\"scale_factor\",1.0000673");
    add_srs_wkt (p, 10,
        "004],PARAMETER[\"false_easting\",275844.5533],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0.0157],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8173\"]]");
    p = add_epsg_def_ex (filter, first, last, 8177, "epsg", 8177,
        "NAD83(HARN) / WISCRS Forest (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0055555555556 +lon_0=-88.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000673004 +x_0=275844.553213106 +y_0=0.015849");
    add_proj4text (p, 2,
        "6316992634 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Forest (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.0055555555556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-88.6333333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00673004],PARAMETER[\"false_easting\",905000.005],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0.052],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8177\"]]");
    p = add_epsg_def_ex (filter, first, last, 8179, "epsg", 8179,
        "NAD83(HARN) / WISCRS Dunn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4083333333333 +lon_0=-91.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000410324 +x_0=51816.104 +y_0=0.003 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dunn (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.4083333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-91.8944444444444],PARAMETER[\"scale_factor\",1.0000410");
    add_srs_wkt (p, 10,
        "324],PARAMETER[\"false_easting\",51816.104],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.003],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"8179\"]]");
    p = add_epsg_def_ex (filter, first, last, 8180, "epsg", 8180,
        "NAD83(HARN) / WISCRS Dunn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4083333333333 +lon_0=-91.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000410324 +x_0=51816.1039370078 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dunn (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.4083333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-91.8944444444444],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "410324],PARAMETER[\"false_easting\",170000.001],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.01],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8180\"]]");
    p = add_epsg_def_ex (filter, first, last, 8181, "epsg", 8181,
        "NAD83(HARN) / WISCRS Douglas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.8833333333333 +lon_0=-91.916666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000385418 +x_0=59131.3183 +y_0=0.0041 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Douglas (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",45.8833333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-91.9166666666667],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "385418],PARAMETER[\"false_easting\",59131.3183],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0.0041],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8181\"]]");
    p = add_epsg_def_ex (filter, first, last, 8182, "epsg", 8182,
        "NAD83(HARN) / WISCRS Douglas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.8833333333333 +lon_0=-91.916666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000385418 +x_0=59131.3182626365 +y_0=0.003962");
    add_proj4text (p, 2,
        "40792481585 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Douglas (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",45.8833333333333],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-91.9166666666667],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000385418],PARAMETER[\"false_easting\",194000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0.013],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8182\"]]");
    p = add_epsg_def_ex (filter, first, last, 8184, "epsg", 8184,
        "NAD83(HARN) / WISCRS Door (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.2722222222222 +k=1.00");
    add_proj4text (p, 1,
        "00187521 +x_0=158801.1176 +y_0=0.0023 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Door (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.4],PARAMETER[\"central_meridian\",-87.2722222");
    add_srs_wkt (p, 9,
        "222222],PARAMETER[\"scale_factor\",1.0000187521],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",158801.1176],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0023],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"8184\"]]");
    p = add_epsg_def_ex (filter, first, last, 8185, "epsg", 8185,
        "NAD83(HARN) / WISCRS Door (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.2722222222222 +k=1.00");
    add_proj4text (p, 1,
        "00187521 +x_0=158801.117602235 +y_0=0.00243840487680975 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Door (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",44.4],PARAMETER[\"central_meridian\",-87.2722");
    add_srs_wkt (p, 9,
        "222222222],PARAMETER[\"scale_factor\",1.0000187521],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",521000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0.008],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8185\"]]");
    p = add_epsg_def_ex (filter, first, last, 8187, "epsg", 8187,
        "NAD83(HARN) / WISCRS Dodge and Jefferson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4722222222222 +lon_0=-88.775 +k=1.");
    add_proj4text (p, 1,
        "0000346418 +x_0=263347.7263 +y_0=0.0076 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dodge and Jefferson (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",41.4722222222222],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-88.775],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "346418],PARAMETER[\"false_easting\",263347.7263],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0.0076],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8187\"]]");
    p = add_epsg_def_ex (filter, first, last, 8189, "epsg", 8189,
        "NAD83(HARN) / WISCRS Dodge and Jefferson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4722222222222 +lon_0=-88.775 +k=1.");
    add_proj4text (p, 1,
        "0000346418 +x_0=263347.726390653 +y_0=0.0076200152400304");
    add_proj4text (p, 2,
        "8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dodge and Jefferson (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Re");
    add_srs_wkt (p, 2,
        "ference_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.4722222222222],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-88.775],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000346418],PARAMETER[\"false_easting\",863999.999],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0.025],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"8189\"]]");
    p = add_epsg_def_ex (filter, first, last, 8191, "epsg", 8191,
        "NAD83(HARN) / WISCRS Dane (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.4222222222222 +k_0=1.0000384786 +x_0=247193.2944 ");
    add_proj4text (p, 2,
        "+y_0=146591.9896 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dane (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.0695160375],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-89.4222222222222],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00384786],PARAMETER[\"false_easting\",247193.2944],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",146591.9896],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8191\"]]");
    p = add_epsg_def_ex (filter, first, last, 8193, "epsg", 8193,
        "NAD83(HARN) / WISCRS Dane (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.4222222222222 +k_0=1.0000384786 +x_0=247193.29438");
    add_proj4text (p, 2,
        "6589 +y_0=146591.989636779 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 3,
        ",0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dane (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.0695160375],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-89.4222222222222],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000384786],PARAMETER[\"false_easting\",811000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",480943.886],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8193\"]]");
    p = add_epsg_def_ex (filter, first, last, 8196, "epsg", 8196,
        "NAD83(HARN) / WISCRS Crawford (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6274 +y");
    add_proj4text (p, 2,
        "_0=53703.1201 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Crawford (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.200055605],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-90.9388888888889],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000349151],PARAMETER[\"false_easting\",113690.6274],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",53703.1201],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8196\"]]");
    p = add_epsg_def_ex (filter, first, last, 8197, "epsg", 8197,
        "NAD83(HARN) / WISCRS Crawford (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6273812");
    add_proj4text (p, 2,
        "55 +y_0=53703.1202438405 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 3,
        ",0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Crawford (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.200055605],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-90.9388888888889],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1.0000349151],PARAMETER[\"false_easting\",373000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",176190.987],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"8197\"]]");
    p = add_epsg_def_ex (filter, first, last, 8198, "epsg", 8198,
        "NAD83(HARN) / WISCRS Columbia (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.4625466458333 +lat_0=43.462546645833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.3944444444444 +k_0=1.00003498 +x_0=169164.3");
    add_proj4text (p, 2,
        "381 +y_0=111569.6134 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Columbia (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.4625466458333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-89.3944444444444],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.00003498],PARAMETER[\"false_easting\",169164.3381],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",111569.6134],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8198\"]]");
    p = add_epsg_def_ex (filter, first, last, 8200, "epsg", 8200,
        "NAD83(HARN) / WISCRS Columbia (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.4625466458333 +lat_0=43.462546645833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.3944444444444 +k_0=1.00003498 +x_0=169164.3");
    add_proj4text (p, 2,
        "38023876 +y_0=111569.613512827 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 3,
        ",0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Columbia (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.4625466458333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.3944444444444],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.00003498],PARAMETER[\"false_easting\",554999.999],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",366041.307],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"8200\"]]");
    p = add_epsg_def_ex (filter, first, last, 8201, "epsg", 8201,
        "NAD83(HARN) / WISCRS Clark (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.7083333333333 +k=1.00");
    add_proj4text (p, 1,
        "00463003 +x_0=199949.1989 +y_0=0.0086 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Clark (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43.6],PARAMETER[\"central_meridian\",-90.7083333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.0000463003],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",199949.1989],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0.0086],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"8201\"]]");
    p = add_epsg_def_ex (filter, first, last, 8202, "epsg", 8202,
        "NAD83(HARN) / WISCRS Clark (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.7083333333333 +k=1.00");
    add_proj4text (p, 1,
        "00463003 +x_0=199949.198983998 +y_0=0.00853441706883413 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Clark (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.6],PARAMETER[\"central_meridian\",-90.7083");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"scale_factor\",1.0000463003],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",655999.997],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0.028],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8202\"]]");
    p = add_epsg_def_ex (filter, first, last, 8203, "epsg", 8203,
        "NAD83(HARN) / WISCRS Chippewa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9778568986111 +lat_0=44.977856898611");
    add_proj4text (p, 1,
        "1 +lon_0=-91.2944444444444 +k_0=1.0000391127 +x_0=60045.");
    add_proj4text (p, 2,
        "72 +y_0=44091.4346 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Chippewa (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",44.9778568986111],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-91.2944444444444],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000391127],PARAMETER[\"false_easting\",60045.72],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",44091.4346],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8203\"]]");
    p = add_epsg_def_ex (filter, first, last, 8204, "epsg", 8204,
        "NAD83(HARN) / WISCRS Chippewa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9778568986111 +lat_0=44.977856898611");
    add_proj4text (p, 1,
        "1 +lon_0=-91.2944444444444 +k_0=1.0000391127 +x_0=60045.");
    add_proj4text (p, 2,
        "7200914401 +y_0=44091.434493269 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Chippewa (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44.9778568986111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-91.2944444444444],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000391127],PARAMETER[\"false_easting\",197000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",144656.648],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"8204\"]]");
    p = add_epsg_def_ex (filter, first, last, 8205, "epsg", 8205,
        "NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.7194444444444 +lon_0=-88.5 +k=1.00");
    add_proj4text (p, 1,
        "00286569 +x_0=244754.8893 +y_0=0.0049 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"");
    add_srs_wkt (p, 2,
        "NAD83_High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 6,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 7,
        "\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",42.71944");
    add_srs_wkt (p, 9,
        "44444444],PARAMETER[\"central_meridian\",-88.5],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",1.0000286569],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",244754.8893],PARAMETER[\"false_northing\",0.0049],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8205\"]]");
    p = add_epsg_def_ex (filter, first, last, 8206, "epsg", 8206,
        "NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.7194444444444 +lon_0=-88.5 +k=1.00");
    add_proj4text (p, 1,
        "00286569 +x_0=244754.889204978 +y_0=0.0048768097536195 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATU");
    add_srs_wkt (p, 2,
        "M[\"NAD83_High_Accuracy_Reference_Network\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.7");
    add_srs_wkt (p, 9,
        "194444444444],PARAMETER[\"central_meridian\",-88.5],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.0000286569],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",802999.999],PARAMETER[\"false_northing\",0.016]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"8206\"]]");
    p = add_epsg_def_ex (filter, first, last, 8207, "epsg", 8207,
        "NAD83(HARN) / WISCRS Burnett (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.8987148658333 +lat_0=45.898714865833");
    add_proj4text (p, 1,
        "3 +lon_0=-92.4577777777778 +k_0=1.0000383841 +x_0=64008.");
    add_proj4text (p, 2,
        "1276 +y_0=59445.9043 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Burnett (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.8987148658333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-92.4577777777778],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000383841],PARAMETER[\"false_easting\",64008.1276],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",59445.9043],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8207\"]]");
    p = add_epsg_def_ex (filter, first, last, 8208, "epsg", 8208,
        "NAD83(HARN) / WISCRS Burnett (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.8987148658333 +lat_0=45.898714865833");
    add_proj4text (p, 1,
        "3 +lon_0=-92.4577777777778 +k_0=1.0000383841 +x_0=64008.");
    add_proj4text (p, 2,
        "1277114554 +y_0=59445.9041910083 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Burnett (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.8987148658333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-92.4577777777778],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000383841],PARAMETER[\"false_easting\",209999.999");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",195032.104],UNIT[\"US sur");
    add_srs_wkt (p, 12,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"8208\"]]");
    p = add_epsg_def_ex (filter, first, last, 8209, "epsg", 8209,
        "NAD83(HARN) / WISCRS Buffalo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4813888888889 +lon_0=-91.797222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000382778 +x_0=175260.3502 +y_0=0.0048 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Buffalo (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43.4813888888889],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-91.7972222222222],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "382778],PARAMETER[\"false_easting\",175260.3502],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0.0048],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8209\"]]");
    p = add_epsg_def_ex (filter, first, last, 8210, "epsg", 8210,
        "NAD83(HARN) / WISCRS Buffalo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4813888888889 +lon_0=-91.797222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000382778 +x_0=175260.3502159 +y_0=0.00487680");
    add_proj4text (p, 2,
        "97536195 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Buffalo (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",43.4813888888889],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-91.7972222222222],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000382778],PARAMETER[\"false_easting\",574999.999],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.016],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8210\"]]");
    p = add_epsg_def_ex (filter, first, last, 8212, "epsg", 8212,
        "NAD83(HARN) / WISCRS Brown (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31600 +");
    add_proj4text (p, 1,
        "y_0=4600 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Brown (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",43],PARAMETER[\"central_meridian\",-88],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.00002],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "31600],PARAMETER[\"false_northing\",4600],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8212\"]]");
    p = add_epsg_def_ex (filter, first, last, 8213, "epsg", 8213,
        "NAD83(HARN) / WISCRS Brown (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31599.9");
    add_proj4text (p, 1,
        "998983998 +y_0=4599.99989839979 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Brown (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",43],PARAMETER[\"central_meridian\",-88],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1.00002],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",103674.333],PARAMETER[\"false_northing\",15091.833],U");
    add_srs_wkt (p, 11,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"8213\"]]");
    p = add_epsg_def_ex (filter, first, last, 8214, "epsg", 8214,
        "NAD83(HARN) / WISCRS Bayfield (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.6696483772222 +lat_0=46.669648377222");
    add_proj4text (p, 1,
        "2 +lon_0=-91.1527777777778 +k_0=1.0000331195 +x_0=228600");
    add_proj4text (p, 2,
        ".4575 +y_0=148551.4837 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Bayfield (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",46.6696483772222],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-91.1527777777778],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000331195],PARAMETER[\"false_easting\",228600.4575],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",148551.4837],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8214\"]]");
    p = add_epsg_def_ex (filter, first, last, 8216, "epsg", 8216,
        "NAD83(HARN) / WISCRS Bayfield (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.6696483772222 +lat_0=46.669648377222");
    add_proj4text (p, 1,
        "2 +lon_0=-91.1527777777778 +k_0=1.0000331195 +x_0=228600");
    add_proj4text (p, 2,
        ".457505715 +y_0=148551.483566167 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Bayfield (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",46.6696483772222],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-91.1527777777778],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000331195],PARAMETER[\"false_easting\",750000.001");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",487372.659],UNIT[\"US sur");
    add_srs_wkt (p, 12,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"8216\"]]");
    p = add_epsg_def_ex (filter, first, last, 8218, "epsg", 8218,
        "NAD83(HARN) / WISCRS Barron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.1333333333333 +lon_0=-91.85 +k=1.0");
    add_proj4text (p, 1,
        "000486665 +x_0=93150 +y_0=0.0029 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Barron (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",45.1333333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-91.85],PARAMETER[\"scale_factor\",1.0000486665],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",93150],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0029],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"8218\"]]");
    p = add_epsg_def_ex (filter, first, last, 8220, "epsg", 8220,
        "NAD83(HARN) / WISCRS Barron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.1333333333333 +lon_0=-91.85 +k=1.0");
    add_proj4text (p, 1,
        "000486665 +x_0=93150 +y_0=0.00304800609601219 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Barron (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",45.1333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-91.85],PARAMETER[\"scale_factor\",1.0000486665],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",305609.625],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0.01],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8220\"]]");
    p = add_epsg_def_ex (filter, first, last, 8222, "epsg", 8222,
        "NAD83(HARN) / WISCRS Ashland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.7061111111111 +lon_0=-90.622222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000495683 +x_0=172821.9461 +y_0=0.0017 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Ashland (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",45.7061111111111],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-90.6222222222222],PARAMETER[\"scale_factor\",1.0000");
    add_srs_wkt (p, 10,
        "495683],PARAMETER[\"false_easting\",172821.9461],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0.0017],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8222\"]]");
    p = add_epsg_def_ex (filter, first, last, 8224, "epsg", 8224,
        "NAD83(HARN) / WISCRS Ashland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.7061111111111 +lon_0=-90.622222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000495683 +x_0=172821.945948692 +y_0=0.001828");
    add_proj4text (p, 2,
        "80365760731 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Ashland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",45.7061111111111],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-90.6222222222222],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "000495683],PARAMETER[\"false_easting\",567000.001],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.006],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"8224\"]]");
    p = add_epsg_def_ex (filter, first, last, 8225, "epsg", 8225,
        "NAD83(HARN) / WISCRS Adams and Juneau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.3666666666667 +lon_0=-90 +k=1.0000");
    add_proj4text (p, 1,
        "365285 +x_0=147218.6942 +y_0=0.0037 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Adams and Juneau (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "52\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",43.3666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-90],PARAMETER[\"scale_factor\",1.000036528");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_easting\",147218.6942],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.0037],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8225\"]]");
    p = add_epsg_def_ex (filter, first, last, 8226, "epsg", 8226,
        "NAD83(HARN) / WISCRS Adams and Juneau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.3666666666667 +lon_0=-90 +k=1.0000");
    add_proj4text (p, 1,
        "365285 +x_0=147218.694132588 +y_0=0.00365760731521463 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Adams and Juneau (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.3666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-90],PARAMETER[\"scale_factor\",1.00003652");
    add_srs_wkt (p, 10,
        "85],PARAMETER[\"false_easting\",482999.999],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0.012],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"822");
    add_srs_wkt (p, 14,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 8231, "epsg", 8231,
        "NAD83(CSRS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS96)\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS96)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]],ID[\"EP");
    add_srs_wkt (p, 10,
        "SG\",8231]]");
    p = add_epsg_def_ex (filter, first, last, 8232, "epsg", 8232,
        "NAD83(CSRS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS96)\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS96\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 3,
        "92\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8232\"]]");
    p = add_epsg_def_ex (filter, first, last, 8235, "epsg", 8235,
        "NAD83(CSRS)v2", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v2\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 2\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8235]]");
}

#endif /* full EPSG initialization enabled/disabled */

