/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_28 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 5536, "epsg", 5536,
        "Corrego Alegre 1961 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1961", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 21S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5536\"]]");
    p = add_epsg_def_ex (filter, first, last, 5537, "epsg", 5537,
        "Corrego Alegre 1961 / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1961", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 22S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-51],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5537\"]]");
    p = add_epsg_def_ex (filter, first, last, 5538, "epsg", 5538,
        "Corrego Alegre 1961 / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1961", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 23S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-45],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5538\"]]");
    p = add_epsg_def_ex (filter, first, last, 5539, "epsg", 5539,
        "Corrego Alegre 1961 / UTM zone 24S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1961", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1961 / UTM zone 24S\",GEOGCS[\"C");
    add_srs_wkt (p, 1,
        "orrego Alegre 1961\",DATUM[\"Corrego_Alegre_1961\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"5524\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-39],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5539\"]]");
    p = add_epsg_def_ex (filter, first, last, 5545, "epsg", 5545,
        "PNG94", 1, 1,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"PNG94\",DATUM[\"Papua New G");
    add_srs_wkt (p, 1,
        "uinea Geodetic Datum 1994\",ELLIPSOID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gree");
    add_srs_wkt (p, 3,
        "nwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[e");
    add_srs_wkt (p, 4,
        "llipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORD");
    add_srs_wkt (p, 5,
        "ER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 7,
        "ee\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 9,
        "own\"],AREA[\"Papua New Guinea\"],BBOX[-14.75,139.2,2.58");
    add_srs_wkt (p, 10,
        ",162.81]],ID[\"EPSG\",5545]]],TARGETCRS[GEOGCRS[\"WGS 84");
    add_srs_wkt (p, 11,
        "\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS ");
    add_srs_wkt (p, 12,
        "84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 13,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 14,
        "433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1]");
    add_srs_wkt (p, 15,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longit");
    add_srs_wkt (p, 16,
        "ude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 17,
        "433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"PNG94");
    add_srs_wkt (p, 18,
        " to WGS 84 (1)\",METHOD[\"Geocentric translations (geog2");
    add_srs_wkt (p, 19,
        "D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis transl");
    add_srs_wkt (p, 20,
        "ation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translat");
    add_srs_wkt (p, 21,
        "ion\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translatio");
    add_srs_wkt (p, 22,
        "n\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 23,
        "Papua New Guinea\"],BBOX[-14.75,139.2,2.58,162.81]],ID[\"");
    add_srs_wkt (p, 24,
        "EPSG\",5553]]]");
    p = add_epsg_def_ex (filter, first, last, 5546, "epsg", 5546,
        "PNG94", 1, 1,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PNG94\",DATUM[\"Papua_New_Guinea_Geodetic_Datum");
    add_srs_wkt (p, 1,
        "_1994\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1076\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5546\"]]");
    p = add_epsg_def_ex (filter, first, last, 5550, "epsg", 5550,
        "PNG94 / PNGMG94 zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 54\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",141],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5550\"]]");
    p = add_epsg_def_ex (filter, first, last, 5551, "epsg", 5551,
        "PNG94 / PNGMG94 zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 55\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",147],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5551\"]]");
    p = add_epsg_def_ex (filter, first, last, 5552, "epsg", 5552,
        "PNG94 / PNGMG94 zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Papua_New_Guinea_Geodetic_Datum_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PNG94 / PNGMG94 zone 56\",GEOGCS[\"PNG94\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1076\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"5546\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",153],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5552\"]]");
    p = add_epsg_def_ex (filter, first, last, 5554, "epsg", 5554,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 31N + DHHN92 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 2,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 8,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",3],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"25831\"]],VERT_CS[\"DHHN92 he");
    add_srs_wkt (p, 14,
        "ight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",200");
    add_srs_wkt (p, 15,
        "5,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 17,
        "P],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 18,
        "54\"]]");
    p = add_epsg_def_ex (filter, first, last, 5555, "epsg", 5555,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32N + DHHN92 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 2,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 8,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",9],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"25832\"]],VERT_CS[\"DHHN92 he");
    add_srs_wkt (p, 14,
        "ight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",200");
    add_srs_wkt (p, 15,
        "5,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 17,
        "P],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 18,
        "55\"]]");
    p = add_epsg_def_ex (filter, first, last, 5556, "epsg", 5556,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33N + DHHN92 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 2,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 6,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 7,
        "122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 8,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",15],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"25833\"]],VERT_CS[\"DHHN92 h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Deutsches Haupthoehennetz 1992\",20");
    add_srs_wkt (p, 15,
        "05,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 16,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",");
    add_srs_wkt (p, 17,
        "UP],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 18,
        "556\"]]");
    p = add_epsg_def_ex (filter, first, last, 5559, "epsg", 5559,
        "Ocotepeque 1935 / Guatemala Norte", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +ellps=clrk66 +towgs84=205,96,-98,0,0,");
    add_proj4text (p, 3,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Norte\",GEOGCS[\"Oc");
    add_srs_wkt (p, 1,
        "otepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",16.8166666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-90.3333333333333],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "99992226],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",292209.579],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"5559\"]]");
    p = add_epsg_def_ex (filter, first, last, 5560, "epsg", 5560,
        "UCS-2000", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=24,-121,-76,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"UCS-2000\",DATUM[\"Ukraine ");
    add_srs_wkt (p, 1,
        "2000\",ELLIPSOID[\"Krassowsky 1940\",6378245,298.3,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Ukraine");
    add_srs_wkt (p, 9,
        "\"],BBOX[43.18,22.15,52.38,40.18]],ID[\"EPSG\",5560]]],T");
    add_srs_wkt (p, 10,
        "ARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic Syste");
    add_srs_wkt (p, 11,
        "m 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENG");
    add_srs_wkt (p, 12,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 13,
        "degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"l");
    add_srs_wkt (p, 14,
        "atitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 15,
        "25199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 16,
        "degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDG");
    add_srs_wkt (p, 17,
        "EDTRANSFORMATION[\"UCS-2000 to WGS 84 (2)\",METHOD[\"Geo");
    add_srs_wkt (p, 18,
        "centric translations (geog2D domain)\",ID[\"EPSG\",9603]");
    add_srs_wkt (p, 19,
        "],PARAMETER[\"X-axis translation\",24,ID[\"EPSG\",8605]]");
    add_srs_wkt (p, 20,
        ",PARAMETER[\"Y-axis translation\",-121,ID[\"EPSG\",8606]");
    add_srs_wkt (p, 21,
        "],PARAMETER[\"Z-axis translation\",-76,ID[\"EPSG\",8607]");
    add_srs_wkt (p, 22,
        "],USAGE[SCOPE[\"unknown\"],AREA[\"Ukraine\"],BBOX[43.18,");
    add_srs_wkt (p, 23,
        "22.15,52.38,40.18]],ID[\"EPSG\",5840]]]");
    p = add_epsg_def_ex (filter, first, last, 5561, "epsg", 5561,
        "UCS-2000", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=25,-141,-78.5,0,0.35");
    add_proj4text (p, 1,
        ",0.736,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"UCS-2000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Kr");
    add_srs_wkt (p, 1,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[24,-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"107");
    add_srs_wkt (p, 3,
        "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"5561\"]]");
    p = add_epsg_def_ex (filter, first, last, 5562, "epsg", 5562,
        "UCS-2000 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 4\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",4500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"5562\"]]");
    p = add_epsg_def_ex (filter, first, last, 5563, "epsg", 5563,
        "UCS-2000 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 5\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"5563\"]]");
    p = add_epsg_def_ex (filter, first, last, 5564, "epsg", 5564,
        "UCS-2000 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 6\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",6500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"5564\"]]");
    p = add_epsg_def_ex (filter, first, last, 5565, "epsg", 5565,
        "UCS-2000 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger zone 7\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"5565\"]]");
    p = add_epsg_def_ex (filter, first, last, 5566, "epsg", 5566,
        "UCS-2000 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 21E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5566\"]]");
    p = add_epsg_def_ex (filter, first, last, 5567, "epsg", 5567,
        "UCS-2000 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 27E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5567\"]]");
    p = add_epsg_def_ex (filter, first, last, 5568, "epsg", 5568,
        "UCS-2000 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 33E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5568\"]]");
    p = add_epsg_def_ex (filter, first, last, 5569, "epsg", 5569,
        "UCS-2000 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Gauss-Kruger CM 39E\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5569\"]]");
    p = add_epsg_def_ex (filter, first, last, 5570, "epsg", 5570,
        "UCS-2000 / Ukraine TM zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 7\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6381\"]]");
    p = add_epsg_def_ex (filter, first, last, 5571, "epsg", 5571,
        "UCS-2000 / Ukraine TM zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 8\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6382\"]]");
    p = add_epsg_def_ex (filter, first, last, 5572, "epsg", 5572,
        "UCS-2000 / Ukraine TM zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 9\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6383\"]]");
    p = add_epsg_def_ex (filter, first, last, 5573, "epsg", 5573,
        "UCS-2000 / Ukraine TM zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 10\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",30],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6384\"]]");
    p = add_epsg_def_ex (filter, first, last, 5574, "epsg", 5574,
        "UCS-2000 / Ukraine TM zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 11\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6385\"]]");
    p = add_epsg_def_ex (filter, first, last, 5575, "epsg", 5575,
        "UCS-2000 / Ukraine TM zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 12\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",36],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6386\"]]");
    p = add_epsg_def_ex (filter, first, last, 5576, "epsg", 5576,
        "UCS-2000 / Ukraine TM zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 13\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6387\"]]");
    p = add_epsg_def_ex (filter, first, last, 5577, "epsg", 5577,
        "UCS-2000 / Ukraine TM zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 7\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6381\"]]");
    p = add_epsg_def_ex (filter, first, last, 5578, "epsg", 5578,
        "UCS-2000 / Ukraine TM zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 8\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6382\"]]");
    p = add_epsg_def_ex (filter, first, last, 5579, "epsg", 5579,
        "UCS-2000 / Ukraine TM zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 9\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,-");
    add_srs_wkt (p, 3,
        "121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6383\"]]");
    p = add_epsg_def_ex (filter, first, last, 5580, "epsg", 5580,
        "UCS-2000 / Ukraine TM zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 10\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",30],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6384\"]]");
    p = add_epsg_def_ex (filter, first, last, 5581, "epsg", 5581,
        "UCS-2000 / Ukraine TM zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 11\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6385\"]]");
    p = add_epsg_def_ex (filter, first, last, 5582, "epsg", 5582,
        "UCS-2000 / Ukraine TM zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 12\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",36],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6386\"]]");
    p = add_epsg_def_ex (filter, first, last, 5583, "epsg", 5583,
        "UCS-2000 / Ukraine TM zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 13\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[24,");
    add_srs_wkt (p, 3,
        "-121,-76,0,0,0,0],AUTHORITY[\"EPSG\",\"1077\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",39],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"6387\"]]");
    p = add_epsg_def_ex (filter, first, last, 5588, "epsg", 5588,
        "NAD27 / New Brunswick Stereographic (NAD27)", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Oblique_Stereographic", "foot",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=3");
    add_proj4text (p, 1,
        "04800 +y_0=304800 +datum=NAD27 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Brunswick Stereographic (NAD27)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7008\"]],TOWGS84[-22,160,190,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",46.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-66.5],PARAMETER[\"scale_factor\",0.999912],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",1000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"5588\"]]");
    p = add_epsg_def_ex (filter, first, last, 5589, "epsg", 5589,
        "Sibun Gorge 1922 / Colony Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Sibun_Gorge_1922", "Transverse_Mercator", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +to_meter=0.3047972");
    add_proj4text (p, 3,
        "654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sibun Gorge 1922 / Colony Grid\",GEOGCS[\"Sibun");
    add_srs_wkt (p, 1,
        " Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1858\",6378293.64520876,294.260676369261,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"1071\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5464\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",17.0612419444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-88.6318575],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",217259.2");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_northing\",445474.83],UNIT[\"Clarke");
    add_srs_wkt (p, 11,
        "'s foot\",0.3047972654,AUTHORITY[\"EPSG\",\"9005\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5589\"]]");
    p = add_epsg_def_ex (filter, first, last, 5592, "epsg", 5592,
        "FEH2010", 1, 1,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"FEH2010\",DATUM[\"Fehmarnbe");
    add_srs_wkt (p, 1,
        "lt Datum 2010\",ELLIPSOID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic long");
    add_srs_wkt (p, 6,
        "itude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - Fehmarnbelt outer\"],BBOX[54.33,10.66,54.83,");
    add_srs_wkt (p, 10,
        "12.01]],ID[\"EPSG\",5592]]],TARGETCRS[GEOGCRS[\"WGS 84\"");
    add_srs_wkt (p, 11,
        ",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84");
    add_srs_wkt (p, 12,
        "\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIME");
    add_srs_wkt (p, 13,
        "M[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 14,
        "3]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],A");
    add_srs_wkt (p, 15,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitud");
    add_srs_wkt (p, 16,
        "e\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 17,
        "3]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"FEH2010");
    add_srs_wkt (p, 18,
        " to WGS 84 (1)\",METHOD[\"Geocentric translations (geog2");
    add_srs_wkt (p, 19,
        "D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis transl");
    add_srs_wkt (p, 20,
        "ation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translat");
    add_srs_wkt (p, 21,
        "ion\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translatio");
    add_srs_wkt (p, 22,
        "n\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 23,
        "Europe - Fehmarnbelt outer\"],BBOX[54.33,10.66,54.83,12.");
    add_srs_wkt (p, 24,
        "01]],ID[\"EPSG\",5599]]]");
    p = add_epsg_def_ex (filter, first, last, 5593, "epsg", 5593,
        "FEH2010", 1, 1,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FEH2010\",DATUM[\"Fehmarnbelt_Datum_2010\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"1078\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"5593\"]]");
    p = add_epsg_def_ex (filter, first, last, 5596, "epsg", 5596,
        "FEH2010 / Fehmarnbelt TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FEH2010 / Fehmarnbelt TM\",GEOGCS[\"FEH2010\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1078\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5593\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",11.3333333333333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",1000000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"5596\"]]");
    p = add_epsg_def_ex (filter, first, last, 5598, "epsg", 5598,
        "FEH2010 / Fehmarnbelt TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Fehmarnbelt_Datum_2010", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"FEH2010 / Fehmarnbelt TM + FCSVR10 height\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"FEH2010 / Fehmarnbelt TM\",GEOGCS[\"FEH2010\",DA");
    add_srs_wkt (p, 2,
        "TUM[\"Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 4,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1078\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"5593\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",11.3333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1],PARAMETER[\"false_easting\",1000000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"5596\"]],VERT_CS[\"FCSVR10 heig");
    add_srs_wkt (p, 14,
        "ht\",VERT_DATUM[\"Fehmarnbelt Vertical Reference 2010\",");
    add_srs_wkt (p, 15,
        "2005,AUTHORITY[\"EPSG\",\"1079\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 16,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 17,
        ",UP],AUTHORITY[\"EPSG\",\"5597\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 18,
        "5598\"]]");
    p = add_epsg_def_ex (filter, first, last, 5623, "epsg", 5623,
        "NAD27 / Michigan East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-83.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999942857],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 11,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5623\"]]");
    p = add_epsg_def_ex (filter, first, last, 5624, "epsg", 5624,
        "NAD27 / Michigan Old Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan Old Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",41.5],PARAMETER[\"central_meridian\",-85.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.999909091],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"5624\"]]");
    p = add_epsg_def_ex (filter, first, last, 5625, "epsg", 5625,
        "NAD27 / Michigan West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-88.75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.999909091],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5625\"]]");
    p = add_epsg_def_ex (filter, first, last, 5627, "epsg", 5627,
        "ED50 / TM 6 NE", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 6 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84,-97,-117,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",6],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5627\"]]");
    p = add_epsg_def_ex (filter, first, last, 5628, "epsg", 5628,
        "SWEREF99", 1, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 + RH2000 height\",GEOGCS[\"SWEREF99\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4619\"]],VERT_CS[\"RH2000 height\",VERT_DATUM[\"Rikets h");
    add_srs_wkt (p, 8,
        "ojdsystem 2000\",2005,AUTHORITY[\"EPSG\",\"5208\"]],UNIT");
    add_srs_wkt (p, 9,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 10,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"5613\"]],AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"5628\"]]");
    p = add_epsg_def_ex (filter, first, last, 5629, "epsg", 5629,
        "Moznet / UTM zone 38S", 0, 0,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moznet / UTM zone 38S\",GEOGCS[\"Moznet\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Moznet_ITRF94\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6130\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4130\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5629\"]]");
    p = add_epsg_def_ex (filter, first, last, 5631, "epsg", 5631,
        "Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",2500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5631\"]]");
    p = add_epsg_def_ex (filter, first, last, 5632, "epsg", 5632,
        "PTRA08 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LCC Europe\",GEOGCS[\"PTRA08\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",52]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",10],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",35],PARAMETER[\"standard_parallel_2\",65],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5632\"]]");
    p = add_epsg_def_ex (filter, first, last, 5633, "epsg", 5633,
        "PTRA08 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Autonomous_Regions_of_Portugal_2008", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PTRA08 / LAEA Europe\",GEOGCS[\"PTRA08\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Autonomous_Regions_of_Portugal_2008\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1041\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"5013\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Azimuthal_Equal_Area\"],PARAMETER[\"latitude_of_center\"");
    add_srs_wkt (p, 8,
        ",52],PARAMETER[\"longitude_of_center\",10],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",4321000],PARAMETER[\"false_northing\",321");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5633\"]]");
    p = add_epsg_def_ex (filter, first, last, 5634, "epsg", 5634,
        "REGCAN95 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LCC Europe\",GEOGCS[\"REGCAN95\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",52]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",10],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",35],PARAMETER[\"standard_parallel_2\",65],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",4000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5634\"]]");
    p = add_epsg_def_ex (filter, first, last, 5635, "epsg", 5635,
        "REGCAN95 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / LAEA Europe\",GEOGCS[\"REGCAN95\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Lambert_Az");
    add_srs_wkt (p, 7,
        "imuthal_Equal_Area\"],PARAMETER[\"latitude_of_center\",5");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"longitude_of_center\",10],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",4321000],PARAMETER[\"false_northing\",32100");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5635\"]]");
    p = add_epsg_def_ex (filter, first, last, 5636, "epsg", 5636,
        "TUREF / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LAEA Europe\",GEOGCS[\"TUREF\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Turkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Azimu");
    add_srs_wkt (p, 7,
        "thal_Equal_Area\"],PARAMETER[\"latitude_of_center\",52],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"longitude_of_center\",10],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",4321000],PARAMETER[\"false_northing\",3210000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5636\"]]");
    p = add_epsg_def_ex (filter, first, last, 5637, "epsg", 5637,
        "TUREF / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Turkish_National_Reference_Frame", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TUREF / LCC Europe\",GEOGCS[\"TUREF\",DATUM[\"T");
    add_srs_wkt (p, 1,
        "urkish_National_Reference_Frame\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1057\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"5252\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",52],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",10],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",35],PARAMETER[\"standard_parallel_2\",65],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",4000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",2800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5637\"]]");
    p = add_epsg_def_ex (filter, first, last, 5638, "epsg", 5638,
        "ISN2004 / LAEA Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "Lambert_Azimuthal_Equal_Area", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LAEA Europe\",GEOGCS[\"ISN2004\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5324\"]],PROJECTION[\"Lambert_Azimuthal_Equal_A");
    add_srs_wkt (p, 7,
        "rea\"],PARAMETER[\"latitude_of_center\",52],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "longitude_of_center\",10],PARAMETER[\"false_easting\",43");
    add_srs_wkt (p, 9,
        "21000],PARAMETER[\"false_northing\",3210000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5638\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5639, "epsg", 5639,
        "ISN2004 / LCC Europe", 0, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4");
    add_proj4text (p, 1,
        "000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / LCC Europe\",GEOGCS[\"ISN2004\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"5324\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",10],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",65],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4000000],PARAMETER[\"false_northing\",280000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5639\"]]");
    p = add_epsg_def_ex (filter, first, last, 5641, "epsg", 5641,
        "SIRGAS 2000 / Brazil Mercator", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Mercator_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=-43 +lat_ts=-2 +x_0=5000000 +y_0=10000");
    add_proj4text (p, 1,
        "000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Mercator\",GEOGCS[\"SIRGAS");
    add_srs_wkt (p, 1,
        " 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_l");
    add_srs_wkt (p, 2,
        "as_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4674\"]],PROJECTION[\"Mercator_2SP\"],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "tandard_parallel_1\",-2],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-43],PARAMETER[\"false_easting\",5000000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"5641\"]]");
    p = add_epsg_def_ex (filter, first, last, 5643, "epsg", 5643,
        "ED50 / SPBA LCC", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=52.66666666666666 +lat_2=54.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=48 +lon_0=10 +x_0=815000 +y_0=0 +ellps=intl +");
    add_proj4text (p, 2,
        "towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / SPBA LCC\",GEOGCS[\"ED50\",DATUM[\"Europ");
    add_srs_wkt (p, 1,
        "ean_Datum_1950\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",48],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",10],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "52.6666666666667],PARAMETER[\"standard_parallel_2\",54.3");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"false_easting\",815000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"5643\"]]");
    p = add_epsg_def_ex (filter, first, last, 5644, "epsg", 5644,
        "RGR92 / UTM zone 39S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGR92 / UTM zone 39S\",GEOGCS[\"RGR92\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_de_la_Reunion_1992\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6627\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4627\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",51],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"5644\"]]");
    p = add_epsg_def_ex (filter, first, last, 5646, "epsg", 5646,
        "NAD83 / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Vermont (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-72.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99964286],PARAMETER[\"false_easting\",1640416.6667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5646\"]]");
    p = add_epsg_def_ex (filter, first, last, 5649, "epsg", 5649,
        "ETRS89 / UTM zone 31N (zE-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5649\"]]");
    p = add_epsg_def_ex (filter, first, last, 5650, "epsg", 5650,
        "ETRS89 / UTM zone 33N (zE-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",335000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5650\"]]");
    p = add_epsg_def_ex (filter, first, last, 5651, "epsg", 5651,
        "ETRS89 / UTM zone 31N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3150000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5651\"]]");
    p = add_epsg_def_ex (filter, first, last, 5652, "epsg", 5652,
        "ETRS89 / UTM zone 32N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3250000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5652\"]]");
    p = add_epsg_def_ex (filter, first, last, 5653, "epsg", 5653,
        "ETRS89 / UTM zone 33N (N-zE)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N (N-zE)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",335000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5653\"]]");
    p = add_epsg_def_ex (filter, first, last, 5654, "epsg", 5654,
        "NAD83(HARN) / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Vermont (ftUS)\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",42.5],PARAMETER[\"central_meridian\",-72.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999964286],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",1640416.6667],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"5654\"]]");
    p = add_epsg_def_ex (filter, first, last, 5655, "epsg", 5655,
        "NAD83(NSRS2007) / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Vermont (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-72.5],PARAMETER[\"scale_factor\",0.999964286],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1640416.6667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5655\"]]");
    p = add_epsg_def_ex (filter, first, last, 5659, "epsg", 5659,
        "Monte Mario / TM Emilia-Romagna", 0, 0,
        "International 1924", "Greenwich",
        "Monte_Mario", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=500053 +y_0");
    add_proj4text (p, 1,
        "=-3999820 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-");
    add_proj4text (p, 2,
        "2.917,0.714,-11.68 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario / TM Emilia-Romagna\",GEOGCS[\"Mont");
    add_srs_wkt (p, 1,
        "e Mario\",DATUM[\"Monte_Mario\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4265\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500053],PARAMETER[\"false_northing\",-3999820],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5659");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 5663, "epsg", 5663,
        "Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",3500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5663\"]]");
    p = add_epsg_def_ex (filter, first, last, 5664, "epsg", 5664,
        "Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 2 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],TOWGS84[24,-123,-94,0.02,-0.25,-0.13,1.1]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4178\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5664\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5665, "epsg", 5665,
        "Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 3 (E-N)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",3500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5665\"]]");
    p = add_epsg_def_ex (filter, first, last, 5666, "epsg", 5666,
        "PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 3 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",3500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5666\"]]");
    p = add_epsg_def_ex (filter, first, last, 5667, "epsg", 5667,
        "PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Potsdam_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4746\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",4500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5667\"]]");
    p = add_epsg_def_ex (filter, first, last, 5668, "epsg", 5668,
        "RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 4 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5668\"]]");
    p = add_epsg_def_ex (filter, first, last, 5669, "epsg", 5669,
        "RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Rauenberg_Datum_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RD/83 / 3-degree Gauss-Kruger zone 5 (E-N)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 2,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4745\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5669\"]]");
    p = add_epsg_def_ex (filter, first, last, 5670, "epsg", 5670,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",9],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5670\"]]");
    p = add_epsg_def_ex (filter, first, last, 5671, "epsg", 5671,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",4500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5671\"]]");
    p = add_epsg_def_ex (filter, first, last, 5672, "epsg", 5672,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_58\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",5500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5672\"]]");
    p = add_epsg_def_ex (filter, first, last, 5673, "epsg", 5673,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[24,-123,-94,0.02,-0.25,-");
    add_srs_wkt (p, 4,
        "0.13,1.1],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",3500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"5673\"]]");
    p = add_epsg_def_ex (filter, first, last, 5674, "epsg", 5674,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",4500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5674\"]]");
    p = add_epsg_def_ex (filter, first, last, 5675, "epsg", 5675,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        " (E-N)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_194");
    add_srs_wkt (p, 2,
        "2_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",5500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5675\"]]");
    p = add_epsg_def_ex (filter, first, last, 5676, "epsg", 5676,
        "DHDN / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",6],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",2500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5676\"]]");
    p = add_epsg_def_ex (filter, first, last, 5677, "epsg", 5677,
        "DHDN / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",3500000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"5677\"]]");
    p = add_epsg_def_ex (filter, first, last, 5678, "epsg", 5678,
        "DHDN / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5678\"]]");
    p = add_epsg_def_ex (filter, first, last, 5679, "epsg", 5679,
        "DHDN / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-");
    add_srs_wkt (p, 4,
        "2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5679\"]]");
    p = add_epsg_def_ex (filter, first, last, 5680, "epsg", 5680,
        "DHDN / 3-degree Gauss-Kruger zone 1 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 1 (E-N)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",3],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",1500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"5680\"]]");
    p = add_epsg_def_ex (filter, first, last, 5681, "epsg", 5681,
        "DB_REF", 1, 1,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"5681\"]]");
    p = add_epsg_def_ex (filter, first, last, 5682, "epsg", 5682,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",6],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",2500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5682\"]]");
    p = add_epsg_def_ex (filter, first, last, 5683, "epsg", 5683,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",9],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"5683\"]]");
    p = add_epsg_def_ex (filter, first, last, 5684, "epsg", 5684,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",4500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5684\"]]");
    p = add_epsg_def_ex (filter, first, last, 5685, "epsg", 5685,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_Reference_System\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"1081\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5681\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",5500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5685\"]]");
    p = add_epsg_def_ex (filter, first, last, 5698, "epsg", 5698,
        "RGF93 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RGF93 / Lambert-93 + NGF-IGN69 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"RGF93 / Lambert-93\",GEOGCS[\"RGF93\",DATUM[\"Reseau");
    add_srs_wkt (p, 2,
        "_Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",46.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_1\",49],PARAMETER[\"standard_parallel_2\",44],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",700000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",6600000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"2154\"]],VERT_CS[\"NGF-IGN69 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Nivellement General de la France - IGN69\",2005");
    add_srs_wkt (p, 16,
        ",AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"569");
    add_srs_wkt (p, 19,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 5699, "epsg", 5699,
        "RGF93 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RGF93 / Lambert-93 + NGF-IGN78 height\",PROJC");
    add_srs_wkt (p, 1,
        "S[\"RGF93 / Lambert-93\",GEOGCS[\"RGF93\",DATUM[\"Reseau");
    add_srs_wkt (p, 2,
        "_Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 8,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",46.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_1\",49],PARAMETER[\"standard_parallel_2\",44],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",700000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",6600000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"2154\"]],VERT_CS[\"NGF-IGN78 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Nivellement General de la France - IGN78\",2005");
    add_srs_wkt (p, 16,
        ",AUTHORITY[\"EPSG\",\"5120\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5721\"]],AUTHORITY[\"EPSG\",\"569");
    add_srs_wkt (p, 19,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 5700, "epsg", 5700,
        "NZGD2000 / UTM zone 1S", 0, 0,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / UTM zone 1S\",GEOGCS[\"NZGD2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-177],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5700\"]]");
    p = add_epsg_def_ex (filter, first, last, 5707, "epsg", 5707,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone I + NGF-IGN69 heig");
    add_srs_wkt (p, 1,
        "ht\",PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NT");
    add_srs_wkt (p, 2,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 3,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 4,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 5,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 6,
        ",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 7,
        "rad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],A");
    add_srs_wkt (p, 8,
        "UTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 9,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 11,
        "\",0.999877341],PARAMETER[\"false_easting\",600000],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"27571\"]],VERT_CS[");
    add_srs_wkt (p, 15,
        "\"NGF-IGN69 height\",VERT_DATUM[\"Nivellement General de");
    add_srs_wkt (p, 16,
        " la France - IGN69\",2005,AUTHORITY[\"EPSG\",\"5119\"]],");
    add_srs_wkt (p, 17,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gr");
    add_srs_wkt (p, 18,
        "avity-related height\",UP],AUTHORITY[\"EPSG\",\"5720\"]]");
    add_srs_wkt (p, 19,
        ",AUTHORITY[\"EPSG\",\"5707\"]]");
    p = add_epsg_def_ex (filter, first, last, 5708, "epsg", 5708,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone IV + NGF-IGN78 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,");
    add_srs_wkt (p, 5,
        "320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Pari");
    add_srs_wkt (p, 6,
        "s\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 7,
        "\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]");
    add_srs_wkt (p, 8,
        "],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 9,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.");
    add_srs_wkt (p, 10,
        "85],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_");
    add_srs_wkt (p, 11,
        "factor\",0.99994471],PARAMETER[\"false_easting\",234.358");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",4185861.369],UNIT[\"metre");
    add_srs_wkt (p, 13,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27574\"]");
    add_srs_wkt (p, 15,
        "],VERT_CS[\"NGF-IGN78 height\",VERT_DATUM[\"Nivellement ");
    add_srs_wkt (p, 16,
        "General de la France - IGN78\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5120\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 18,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "5721\"]],AUTHORITY[\"EPSG\",\"5708\"]]");
    p = add_epsg_def_ex (filter, first, last, 5825, "epsg", 5825,
        "AGD66 / ACT Standard Grid", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-35.31773627777778 +lon_0=149.0092948");
    add_proj4text (p, 1,
        "305555 +k=1.000086 +x_0=200000 +y_0=600000 +ellps=aust_S");
    add_proj4text (p, 2,
        "A +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0");
    add_proj4text (p, 3,
        ".29 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / ACT Standard Grid\",GEOGCS[\"AGD66\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"Austra");
    add_srs_wkt (p, 2,
        "lian National Spheroid\",6378160,298.25,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7003\"]],TOWGS84[-129.193,-41.212,130.73,0.246,0.37");
    add_srs_wkt (p, 4,
        "4,0.329,-2.955],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",-35.3177362777778");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",149.009294830556],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1.000086],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",200000],PARAMETER[\"false_northing\",600000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"582");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 5830, "epsg", 5830,
        "DB_REF", 1, 1,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"DB_REF\",DATUM[\"Deutsche Bahn Reference Syste");
    add_srs_wkt (p, 1,
        "m\",ELLIPSOID[\"Bessel 1841\",6377397.155,299.1528128,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Germ");
    add_srs_wkt (p, 9,
        "any - onshore\"],BBOX[47.27,5.86,55.09,15.04]],ID[\"EPSG");
    add_srs_wkt (p, 10,
        "\",5830]]");
    p = add_epsg_def_ex (filter, first, last, 5832, "epsg", 5832,
        "DB_REF / 3-degree Gauss-Kruger zone 2 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 2 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 2 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5681\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",6],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",2500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"5682\"]],VERT_CS[\"DH");
    add_srs_wkt (p, 14,
        "HN92 height\",VERT_DATUM[\"Deutsches Haupthoehennetz 199");
    add_srs_wkt (p, 15,
        "2\",2005,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 17,
        "ght\",UP],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5832\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

