/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_21 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4301, "epsg", 4301,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 1,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 2,
        "OWGS84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4301\"]]");
    p = add_epsg_def_ex (filter, first, last, 4302, "epsg", 4302,
        "Trinidad 1903", 1, 1,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+towgs84=-61.702,284.488,472.052,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Trinidad 1903\",DATUM[\"Trinidad_1903\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1858\",6378293.64520876,294.260676369261,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7007\"]],TOWGS84[-61.702,284.488,472.05");
    add_srs_wkt (p, 3,
        "2,0,0,0,0],AUTHORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4302\"]]");
    p = add_epsg_def_ex (filter, first, last, 4303, "epsg", 4303,
        "TC(1948)", 1, 1,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TC(1948)\",DATUM[\"Trucial_Coast_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Helmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "20\"]],AUTHORITY[\"EPSG\",\"6303\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4303\"]]");
    p = add_epsg_def_ex (filter, first, last, 4304, "epsg", 4304,
        "Voirol 1875", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4304\"]]");
    p = add_epsg_def_ex (filter, first, last, 4306, "epsg", 4306,
        "Bern 1938", 1, 1,
        "Bessel 1841", "Greenwich",
        "Bern_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1938\",DATUM[\"Bern_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6306\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4306\"]]");
    p = add_epsg_def_ex (filter, first, last, 4307, "epsg", 4307,
        "Nord Sahara 1959", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-209.3622,-87.8162,");
    add_proj4text (p, 1,
        "404.6198,0.0046,3.4784,0.5805,-1.4547 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959\",DATUM[\"Nord_Sahara_1959\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6");
    add_srs_wkt (p, 3,
        "198,0.0046,3.4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "307\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4307\"]]");
    p = add_epsg_def_ex (filter, first, last, 4308, "epsg", 4308,
        "RT38", 1, 1,
        "Bessel 1841", "Greenwich",
        "Stockholm_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38\",DATUM[\"Stockholm_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6308\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4308\"]]");
    p = add_epsg_def_ex (filter, first, last, 4309, "epsg", 4309,
        "Yacare", 1, 1,
        "International 1924", "Greenwich",
        "Yacare", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yacare\",DATUM[\"Yacare\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 1,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[-124.45,183.74,44.64,-0.4384,0.5446,-0.9706,-2.1365");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6309\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"430");
    add_srs_wkt (p, 7,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 4310, "epsg", 4310,
        "Yoff", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Yoff", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-30,190,8");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yoff\",DATUM[\"Yoff\",SPHEROID[\"Clarke 1880 (I");
    add_srs_wkt (p, 1,
        "GN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "11\"]],TOWGS84[-30,190,89,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6310\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4310\"]]");
    p = add_epsg_def_ex (filter, first, last, 4311, "epsg", 4311,
        "Zanderij", 1, 1,
        "International 1924", "Greenwich",
        "Zanderij", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Zanderij\",DATUM[\"Zanderij\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-265,120,-358,0,0,0,0],AUTHORITY[\"EPSG\",\"631");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4311\"]]");
    p = add_epsg_def_ex (filter, first, last, 4312, "epsg", 4312,
        "MGI", 1, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 1,
        "919,5.137,1.474,5.297,2.4232 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI\",DATUM[\"Militar_Geographische_Institut\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5.");
    add_srs_wkt (p, 3,
        "137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6312\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4312\"]]");
    p = add_epsg_def_ex (filter, first, last, 4313, "epsg", 4313,
        "Belge 1972", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-106.8686,52.2978,-10");
    add_proj4text (p, 1,
        "3.7239,0.3366,-0.457,1.8422,-1.2747 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1972\",DATUM[\"Reseau_National_Belge_1972");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[-99.059,53.322,-112.486,0.4");
    add_srs_wkt (p, 3,
        "19,-0.83,1.885,-1],AUTHORITY[\"EPSG\",\"6313\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4313\"]]");
    p = add_epsg_def_ex (filter, first, last, 4314, "epsg", 4314,
        "DHDN", 1, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=598.1,73.7,418.2,0.");
    add_proj4text (p, 1,
        "202,0.045,-2.455,6.7 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.04");
    add_srs_wkt (p, 3,
        "5,-2.455,6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4314\"]]");
    p = add_epsg_def_ex (filter, first, last, 4315, "epsg", 4315,
        "Conakry 1905", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7011\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4315\"]]");
    p = add_epsg_def_ex (filter, first, last, 4316, "epsg", 4316,
        "Dealul Piscului 1930", 1, 1,
        "International 1924", "Greenwich",
        "Dealul_Piscului_1930", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=103.25,-100.4,-307.19");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dealul Piscului 1930\",DATUM[\"Dealul_Piscului_");
    add_srs_wkt (p, 1,
        "1930\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[103.25,-100.4,-307.19,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6316\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4316\"]]");
    p = add_epsg_def_ex (filter, first, last, 4317, "epsg", 4317,
        "Pulkovo 1942(58)", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=28,-121,-77,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4179\"]]");
    p = add_epsg_def_ex (filter, first, last, 4318, "epsg", 4318,
        "NGN", 1, 1,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGN\",DATUM[\"National_Geodetic_Network\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7030\"]],TOWGS84[-3.2,-5.7,2.8,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6318\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4318\"]]");
    p = add_epsg_def_ex (filter, first, last, 4319, "epsg", 4319,
        "KUDAMS", 1, 1,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KUDAMS\",DATUM[\"Kuwait_Utility\",SPHEROID[\"GR");
    add_srs_wkt (p, 1,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[-20.8,11.3,2.4,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6319\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4319\"]]");
    p = add_epsg_def_ex (filter, first, last, 4322, "epsg", 4322,
        "WGS 72", 1, 1,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.");
    add_proj4text (p, 1,
        "2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 72\",DATUM[\"World_Geodetic_System_1972\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4322\"]]");
    p = add_epsg_def_ex (filter, first, last, 4324, "epsg", 4324,
        "WGS 72BE", 1, 1,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0");
    add_proj4text (p, 1,
        ".38 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 72BE\",DATUM[\"WGS_72_Transit_Broadcast_Eph");
    add_srs_wkt (p, 1,
        "emeris\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7043\"]],TOWGS84[0,0,1.9,0,0,0.814,-0.38],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4324\"]]");
    p = add_epsg_def_ex (filter, first, last, 4327, "epsg", 4327,
        "WGS 84 (3D) (deprecated)", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree minute second hemisphere",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (3D)\",DATUM[\"World Geodetic System 19");
    add_srs_wkt (p, 1,
        "84\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree ");
    add_srs_wkt (p, 5,
        "minute second hemisphere\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Long)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree minute second hemisphere\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 8,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 9,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World (by count");
    add_srs_wkt (p, 10,
        "ry)\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4329]]");
    p = add_epsg_def_ex (filter, first, last, 4329, "epsg", 4329,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World (by count");
    add_srs_wkt (p, 9,
        "ry)\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4979]]");
    p = add_epsg_def_ex (filter, first, last, 4339, "epsg", 4339,
        "Australian Antarctic", 1, 1,
        "GRS 1980", "Greenwich",
        "Australian_Antarctic_Datum_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Australian Antarctic\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Australian Antarctic Datum 1998\",ELLIPSOID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"unknown\"],AREA[\"Antarctica - Australian sector\"");
    add_srs_wkt (p, 10,
        "],BBOX[-90,45,-60,160]],ID[\"EPSG\",4931]]],TARGETCRS[GE");
    add_srs_wkt (p, 11,
        "OGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",EL");
    add_srs_wkt (p, 12,
        "LIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 14,
        ".0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",");
    add_srs_wkt (p, 15,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 16,
        ",AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 17,
        ".0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFOR");
    add_srs_wkt (p, 18,
        "MATION[\"Australian Antarctic to WGS 84 (1)\",METHOD[\"G");
    add_srs_wkt (p, 19,
        "eocentric translations (geog2D domain)\",ID[\"EPSG\",960");
    add_srs_wkt (p, 20,
        "3]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]");
    add_srs_wkt (p, 21,
        "],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],");
    add_srs_wkt (p, 22,
        "PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],US");
    add_srs_wkt (p, 23,
        "AGE[SCOPE[\"unknown\"],AREA[\"Antarctica - Australian se");
    add_srs_wkt (p, 24,
        "ctor\"],BBOX[-90,45,-60,160]],ID[\"EPSG\",1890]]]");
    p = add_epsg_def_ex (filter, first, last, 4341, "epsg", 4341,
        "EST97", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"EST97\",DATUM[\"Estonia 199");
    add_srs_wkt (p, 1,
        "7\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Estonia\"]");
    add_srs_wkt (p, 9,
        ",BBOX[57.52,20.37,60,28.2]],ID[\"EPSG\",4935]]],TARGETCR");
    add_srs_wkt (p, 10,
        "S[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 11,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 13,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 14,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 16,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 17,
        "RMATION[\"EST97 to WGS 84 (1)\",METHOD[\"Geocentric tran");
    add_srs_wkt (p, 18,
        "slations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[");
    add_srs_wkt (p, 19,
        "\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"");
    add_srs_wkt (p, 20,
        "Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-");
    add_srs_wkt (p, 21,
        "axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 22,
        "known\"],AREA[\"Estonia\"],BBOX[57.52,20.37,60,28.2]],ID");
    add_srs_wkt (p, 23,
        "[\"EPSG\",1649]]]");
    p = add_epsg_def_ex (filter, first, last, 4343, "epsg", 4343,
        "CHTRF95", 1, 1,
        "GRS 1980", "Greenwich",
        "Swiss_Terrestrial_Reference_Frame_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"CHTRF95\",DATUM[\"Swiss Ter");
    add_srs_wkt (p, 1,
        "restrial Reference Frame 1995\",ELLIPSOID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Europe - Liechtenstein and Switzerland");
    add_srs_wkt (p, 10,
        "\"],BBOX[45.82,5.96,47.81,10.49]],ID[\"EPSG\",4933]]],TA");
    add_srs_wkt (p, 11,
        "RGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System");
    add_srs_wkt (p, 12,
        " 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGT");
    add_srs_wkt (p, 13,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 14,
        "degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"l");
    add_srs_wkt (p, 15,
        "atitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 16,
        "25199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 17,
        "degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDG");
    add_srs_wkt (p, 18,
        "EDTRANSFORMATION[\"CHTRF95 to WGS 84 (1)\",METHOD[\"Geoc");
    add_srs_wkt (p, 19,
        "entric translations (geog2D domain)\",ID[\"EPSG\",9603]]");
    add_srs_wkt (p, 20,
        ",PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],P");
    add_srs_wkt (p, 21,
        "ARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PAR");
    add_srs_wkt (p, 22,
        "AMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE");
    add_srs_wkt (p, 23,
        "[SCOPE[\"unknown\"],AREA[\"Europe - Liechtenstein and Sw");
    add_srs_wkt (p, 24,
        "itzerland\"],BBOX[45.82,5.96,47.81,10.49]],ID[\"EPSG\",1");
    add_srs_wkt (p, 25,
        "511]]]");
    p = add_epsg_def_ex (filter, first, last, 4345, "epsg", 4345,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"ETRS89\",DATUM[\"European T");
    add_srs_wkt (p, 1,
        "errestrial Reference System 1989\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"unknown\"],AREA[\"Europe - ETRS89\"],BBOX[32.88,-16.1");
    add_srs_wkt (p, 10,
        ",84.17,40.18]],ID[\"EPSG\",4937]]],TARGETCRS[GEOGCRS[\"W");
    add_srs_wkt (p, 11,
        "GS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"");
    add_srs_wkt (p, 12,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 13,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 14,
        "5199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDE");
    add_srs_wkt (p, 15,
        "R[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"lo");
    add_srs_wkt (p, 16,
        "ngitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 17,
        "5199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"E");
    add_srs_wkt (p, 18,
        "TRS89 to WGS 84 (1)\",METHOD[\"Geocentric translations (");
    add_srs_wkt (p, 19,
        "geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis t");
    add_srs_wkt (p, 20,
        "ranslation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tra");
    add_srs_wkt (p, 21,
        "nslation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis trans");
    add_srs_wkt (p, 22,
        "lation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],A");
    add_srs_wkt (p, 23,
        "REA[\"Europe - ETRS89\"],BBOX[32.88,-16.1,84.17,40.18]],");
    add_srs_wkt (p, 24,
        "ID[\"EPSG\",1149]]]");
    p = add_epsg_def_ex (filter, first, last, 4347, "epsg", 4347,
        "GDA94", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"GDA94\",DATUM[\"Geocentric ");
    add_srs_wkt (p, 1,
        "Datum of Australia 1994\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Australia - GDA\"],BBOX[-60.56,93.41,-8.47,");
    add_srs_wkt (p, 10,
        "173.35]],ID[\"EPSG\",4939]]],TARGETCRS[GEOGCRS[\"WGS 84\"");
    add_srs_wkt (p, 11,
        ",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84");
    add_srs_wkt (p, 12,
        "\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIME");
    add_srs_wkt (p, 13,
        "M[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 14,
        "3]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],A");
    add_srs_wkt (p, 15,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitud");
    add_srs_wkt (p, 16,
        "e\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 17,
        "3]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"GDA94 t");
    add_srs_wkt (p, 18,
        "o WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D ");
    add_srs_wkt (p, 19,
        "domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translat");
    add_srs_wkt (p, 20,
        "ion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Au");
    add_srs_wkt (p, 23,
        "stralia - GDA\"],BBOX[-60.56,93.41,-8.47,173.35]],ID[\"E");
    add_srs_wkt (p, 24,
        "PSG\",1150]]]");
    p = add_epsg_def_ex (filter, first, last, 4349, "epsg", 4349,
        "Hartebeesthoek94", 1, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Hartebeesthoek94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Hartebeesthoek94\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Africa - South Africa, Lesotho and Eswatini.\"],BBOX");
    add_srs_wkt (p, 10,
        "[-50.32,13.33,-22.13,42.85]],ID[\"EPSG\",4941]]],TARGETC");
    add_srs_wkt (p, 11,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 12,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 13,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 14,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 15,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 16,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 17,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 18,
        "NSFORMATION[\"Hartebeesthoek94 to WGS 84 (1)\",METHOD[\"");
    add_srs_wkt (p, 19,
        "Geocentric translations (geog2D domain)\",ID[\"EPSG\",96");
    add_srs_wkt (p, 20,
        "03]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605");
    add_srs_wkt (p, 21,
        "]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]]");
    add_srs_wkt (p, 22,
        ",PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],U");
    add_srs_wkt (p, 23,
        "SAGE[SCOPE[\"unknown\"],AREA[\"Africa - South Africa, Le");
    add_srs_wkt (p, 24,
        "sotho and Eswatini.\"],BBOX[-50.32,13.33,-22.13,42.85]],");
    add_srs_wkt (p, 25,
        "ID[\"EPSG\",1505]]]");
    p = add_epsg_def_ex (filter, first, last, 4351, "epsg", 4351,
        "IRENET95", 1, 1,
        "GRS 1980", "Greenwich",
        "IRENET95", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"IRENET95\",DATUM[\"IRENET95");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Europe - Ire");
    add_srs_wkt (p, 9,
        "land (Republic and Ulster) - onshore\"],BBOX[51.39,-10.5");
    add_srs_wkt (p, 10,
        "6,55.43,-5.34]],ID[\"EPSG\",4943]]],TARGETCRS[GEOGCRS[\"");
    add_srs_wkt (p, 11,
        "WGS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[");
    add_srs_wkt (p, 12,
        "\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 13,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 14,
        "925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,OR");
    add_srs_wkt (p, 15,
        "DER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 16,
        "longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 17,
        "925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"");
    add_srs_wkt (p, 18,
        "IRENET95 to WGS 84 (1)\",METHOD[\"Geocentric translation");
    add_srs_wkt (p, 19,
        "s (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axi");
    add_srs_wkt (p, 20,
        "s translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis ");
    add_srs_wkt (p, 21,
        "translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis tr");
    add_srs_wkt (p, 22,
        "anslation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 23,
        "],AREA[\"Europe - Ireland (Republic and Ulster) - onshor");
    add_srs_wkt (p, 24,
        "e\"],BBOX[51.39,-10.56,55.43,-5.34]],ID[\"EPSG\",1678]]]");
    p = add_epsg_def_ex (filter, first, last, 4353, "epsg", 4353,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"JGD2000\",DATUM[\"Japanese ");
    add_srs_wkt (p, 1,
        "Geodetic Datum 2000\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"]");
    add_srs_wkt (p, 9,
        ",AREA[\"Japan\"],BBOX[17.09,122.38,46.05,157.65]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",4947]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World");
    add_srs_wkt (p, 11,
        " Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 12,
        ".257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"JGD2000 to WGS 84 (1)\"");
    add_srs_wkt (p, 18,
        ",METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Japan\"],BBOX[17");
    add_srs_wkt (p, 23,
        ".09,122.38,46.05,157.65]],ID[\"EPSG\",1826]]]");
    p = add_epsg_def_ex (filter, first, last, 4355, "epsg", 4355,
        "LKS94", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"LKS94\",DATUM[\"Lithuania 1");
    add_srs_wkt (p, 1,
        "994 (ETRS89)\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[");
    add_srs_wkt (p, 9,
        "\"Lithuania\"],BBOX[53.89,19.02,56.45,26.82]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",4951]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geod");
    add_srs_wkt (p, 11,
        "etic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 12,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 13,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 14,
        "2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 15,
        ",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[2],A");
    add_srs_wkt (p, 16,
        "NGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",432");
    add_srs_wkt (p, 17,
        "6]]],ABRIDGEDTRANSFORMATION[\"LKS94 to WGS 84 (1)\",METH");
    add_srs_wkt (p, 18,
        "OD[\"Geocentric translations (geog2D domain)\",ID[\"EPSG");
    add_srs_wkt (p, 19,
        "\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8");
    add_srs_wkt (p, 21,
        "606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",860");
    add_srs_wkt (p, 22,
        "7]],USAGE[SCOPE[\"unknown\"],AREA[\"Lithuania\"],BBOX[53");
    add_srs_wkt (p, 23,
        ".89,19.02,56.45,26.82]],ID[\"EPSG\",1283]]]");
    p = add_epsg_def_ex (filter, first, last, 4357, "epsg", 4357,
        "Moznet", 1, 1,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Moznet\",DATUM[\"Moznet (IT");
    add_srs_wkt (p, 1,
        "RF94)\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Mozambi");
    add_srs_wkt (p, 9,
        "que\"],BBOX[-27.71,30.21,-10.09,43.03]],ID[\"EPSG\",4953");
    add_srs_wkt (p, 10,
        "]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic ");
    add_srs_wkt (p, 11,
        "System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 12,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 13,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AX");
    add_srs_wkt (p, 14,
        "IS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 15,
        "74532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 16,
        "NIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],");
    add_srs_wkt (p, 17,
        "ABRIDGEDTRANSFORMATION[\"Moznet to WGS 84 (1)\",METHOD[\"");
    add_srs_wkt (p, 18,
        "Coordinate Frame rotation (geog2D domain)\",ID[\"EPSG\",");
    add_srs_wkt (p, 19,
        "9607]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",86");
    add_srs_wkt (p, 20,
        "05]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606");
    add_srs_wkt (p, 21,
        "]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]]");
    add_srs_wkt (p, 22,
        ",PARAMETER[\"X-axis rotation\",0,ID[\"EPSG\",8608]],PARA");
    add_srs_wkt (p, 23,
        "METER[\"Y-axis rotation\",0,ID[\"EPSG\",8609]],PARAMETER");
    add_srs_wkt (p, 24,
        "[\"Z-axis rotation\",0,ID[\"EPSG\",8610]],PARAMETER[\"Sc");
    add_srs_wkt (p, 25,
        "ale difference\",1,ID[\"EPSG\",8611]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 26,
        "own\"],AREA[\"Mozambique\"],BBOX[-27.71,30.21,-10.09,43.");
    add_srs_wkt (p, 27,
        "03]],ID[\"EPSG\",1302]]]");
    p = add_epsg_def_ex (filter, first, last, 4359, "epsg", 4359,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NAD83(CSRS)\",DATUM[\"NAD83");
    add_srs_wkt (p, 1,
        " Canadian Spatial Reference System\",ELLIPSOID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",");
    add_srs_wkt (p, 5,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 7,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal he");
    add_srs_wkt (p, 8,
        "ight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SC");
    add_srs_wkt (p, 9,
        "OPE[\"unknown\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.");
    add_srs_wkt (p, 10,
        "46,-47.74]],ID[\"EPSG\",4955]]],TARGETCRS[GEOGCRS[\"WGS ");
    add_srs_wkt (p, 11,
        "84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WG");
    add_srs_wkt (p, 12,
        "S 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 13,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 14,
        "99433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[");
    add_srs_wkt (p, 15,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"long");
    add_srs_wkt (p, 16,
        "itude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 17,
        "99433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"NAD");
    add_srs_wkt (p, 18,
        "83(CSRS) to WGS 84 (1)\",METHOD[\"Geocentric translation");
    add_srs_wkt (p, 19,
        "s (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axi");
    add_srs_wkt (p, 20,
        "s translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis ");
    add_srs_wkt (p, 21,
        "translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis tr");
    add_srs_wkt (p, 22,
        "anslation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 23,
        "],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]],ID[");
    add_srs_wkt (p, 24,
        "\"EPSG\",1842]]]");
    p = add_epsg_def_ex (filter, first, last, 4361, "epsg", 4361,
        "NAD83(HARN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NAD83(HARN)\",DATUM[\"NAD83");
    add_srs_wkt (p, 1,
        " (High Accuracy Reference Network)\",ELLIPSOID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",");
    add_srs_wkt (p, 5,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 7,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal he");
    add_srs_wkt (p, 8,
        "ight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SC");
    add_srs_wkt (p, 9,
        "OPE[\"unknown\"],AREA[\"USA - HARN\"],BBOX[-14.59,144.58");
    add_srs_wkt (p, 10,
        ",71.4,-64.51]],ID[\"EPSG\",4957]]],TARGETCRS[GEOGCRS[\"W");
    add_srs_wkt (p, 11,
        "GS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"");
    add_srs_wkt (p, 12,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 13,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 14,
        "5199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDE");
    add_srs_wkt (p, 15,
        "R[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"lo");
    add_srs_wkt (p, 16,
        "ngitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 17,
        "5199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"N");
    add_srs_wkt (p, 18,
        "AD83(HARN) to WGS 84 (1)\",METHOD[\"Geocentric translati");
    add_srs_wkt (p, 19,
        "ons (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-a");
    add_srs_wkt (p, 20,
        "xis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axi");
    add_srs_wkt (p, 21,
        "s translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis ");
    add_srs_wkt (p, 22,
        "translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 23,
        "\"],AREA[\"USA - HARN\"],BBOX[-14.59,144.58,71.4,-64.51]");
    add_srs_wkt (p, 24,
        "],ID[\"EPSG\",1580]]]");
    p = add_epsg_def_ex (filter, first, last, 4363, "epsg", 4363,
        "NZGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NZGD2000\",DATUM[\"New Zeal");
    add_srs_wkt (p, 1,
        "and Geodetic Datum 2000\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"New Zealand\"],BBOX[-55.95,160.6,-25.88,-17");
    add_srs_wkt (p, 10,
        "1.2]],ID[\"EPSG\",4959]]],TARGETCRS[GEOGCRS[\"WGS 84\",D");
    add_srs_wkt (p, 11,
        "ATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\"");
    add_srs_wkt (p, 12,
        ",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 13,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 14,
        "],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANG");
    add_srs_wkt (p, 15,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitude\"");
    add_srs_wkt (p, 16,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 17,
        ",ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"NZGD2000 t");
    add_srs_wkt (p, 18,
        "o WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D ");
    add_srs_wkt (p, 19,
        "domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translat");
    add_srs_wkt (p, 20,
        "ion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Ne");
    add_srs_wkt (p, 23,
        "w Zealand\"],BBOX[-55.95,160.6,-25.88,-171.2]],ID[\"EPSG");
    add_srs_wkt (p, 24,
        "\",1565]]]");
    p = add_epsg_def_ex (filter, first, last, 4365, "epsg", 4365,
        "POSGAR 98", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"POSGAR 98\",DATUM[\"Posicio");
    add_srs_wkt (p, 1,
        "nes Geodesicas Argentinas 1998\",ELLIPSOID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78");
    add_srs_wkt (p, 10,
        ",-52.63]],ID[\"EPSG\",4961]]],TARGETCRS[GEOGCRS[\"WGS 84");
    add_srs_wkt (p, 11,
        "\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS ");
    add_srs_wkt (p, 12,
        "84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 13,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 14,
        "433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1]");
    add_srs_wkt (p, 15,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longit");
    add_srs_wkt (p, 16,
        "ude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 17,
        "433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"POSGA");
    add_srs_wkt (p, 18,
        "R 98 to WGS 84 (1)\",METHOD[\"Geocentric translations (g");
    add_srs_wkt (p, 19,
        "eog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis tr");
    add_srs_wkt (p, 20,
        "anslation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tran");
    add_srs_wkt (p, 21,
        "slation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis transl");
    add_srs_wkt (p, 22,
        "ation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 23,
        "EA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78,-52.63]],ID[");
    add_srs_wkt (p, 24,
        "\"EPSG\",1773]]]");
    p = add_epsg_def_ex (filter, first, last, 4367, "epsg", 4367,
        "REGVEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"REGVEN\",DATUM[\"Red Geodes");
    add_srs_wkt (p, 1,
        "ica Venezolana\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Venezuela\"],BBOX[0.64,-73.38,16.75,-58.95]],ID[\"EP");
    add_srs_wkt (p, 10,
        "SG\",4963]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World ");
    add_srs_wkt (p, 11,
        "Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 12,
        "257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"REGVEN to WGS 84 (1)\"");
    add_srs_wkt (p, 18,
        ",METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Venezuela\"],BBO");
    add_srs_wkt (p, 23,
        "X[0.64,-73.38,16.75,-58.95]],ID[\"EPSG\",1768]]]");
    p = add_epsg_def_ex (filter, first, last, 4369, "epsg", 4369,
        "RGF93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGF93\",DATUM[\"Reseau Geod");
    add_srs_wkt (p, 1,
        "esique Francais 1993\",ELLIPSOID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellips");
    add_srs_wkt (p, 4,
        "oidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1]");
    add_srs_wkt (p, 5,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodet");
    add_srs_wkt (p, 6,
        "ic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 7,
        "0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,");
    add_srs_wkt (p, 8,
        "ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 9,
        "],AREA[\"France\"],BBOX[41.15,-9.86,51.56,10.38]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",4965]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World");
    add_srs_wkt (p, 11,
        " Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 12,
        ".257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"RGF93 to WGS 84 (1)\",");
    add_srs_wkt (p, 18,
        "METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"France\"],BBOX[4");
    add_srs_wkt (p, 23,
        "1.15,-9.86,51.56,10.38]],ID[\"EPSG\",1671]]]");
    p = add_epsg_def_ex (filter, first, last, 4371, "epsg", 4371,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGFG95\",DATUM[\"Reseau Geo");
    add_srs_wkt (p, 1,
        "desique Francais Guyane 1995\",ELLIPSOID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],C");
    add_srs_wkt (p, 4,
        "S[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,");
    add_srs_wkt (p, 5,
        "ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[");
    add_srs_wkt (p, 6,
        "\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 7,
        "egree\",0.0174532925199433]],AXIS[\"ellipsoidal height (");
    add_srs_wkt (p, 8,
        "h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"French Guiana\"],BBOX[2.11,-54.6,8.88,");
    add_srs_wkt (p, 10,
        "-49.46]],ID[\"EPSG\",4967]]],TARGETCRS[GEOGCRS[\"WGS 84\"");
    add_srs_wkt (p, 11,
        ",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84");
    add_srs_wkt (p, 12,
        "\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIME");
    add_srs_wkt (p, 13,
        "M[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 14,
        "3]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],A");
    add_srs_wkt (p, 15,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitud");
    add_srs_wkt (p, 16,
        "e\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 17,
        "3]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"RGFG95 ");
    add_srs_wkt (p, 18,
        "to WGS 84 (2)\",METHOD[\"Geocentric translations (geog2D");
    add_srs_wkt (p, 19,
        " domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis transla");
    add_srs_wkt (p, 20,
        "tion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translati");
    add_srs_wkt (p, 21,
        "on\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation");
    add_srs_wkt (p, 22,
        "\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 23,
        "French Guiana\"],BBOX[2.11,-54.6,8.88,-49.46]],ID[\"EPSG");
    add_srs_wkt (p, 24,
        "\",4840]]]");
    p = add_epsg_def_ex (filter, first, last, 4373, "epsg", 4373,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGR92\",DATUM[\"Reseau Geod");
    add_srs_wkt (p, 1,
        "esique de la Reunion 1992\",ELLIPSOID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gree");
    add_srs_wkt (p, 3,
        "nwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[e");
    add_srs_wkt (p, 4,
        "llipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORD");
    add_srs_wkt (p, 5,
        "ER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 7,
        "ee\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 9,
        "own\"],AREA[\"Reunion\"],BBOX[-24.72,51.83,-18.28,58.24]");
    add_srs_wkt (p, 10,
        "],ID[\"EPSG\",4971]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 11,
        "[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",637");
    add_srs_wkt (p, 12,
        "8137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 13,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 14,
        "[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 15,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"longitude\",ea");
    add_srs_wkt (p, 16,
        "st,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID");
    add_srs_wkt (p, 17,
        "[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"RGR92 to WGS ");
    add_srs_wkt (p, 18,
        "84 (1)\",METHOD[\"Geocentric translations (geog2D domain");
    add_srs_wkt (p, 19,
        ")\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\",");
    add_srs_wkt (p, 20,
        "0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0,");
    add_srs_wkt (p, 21,
        "ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,ID");
    add_srs_wkt (p, 22,
        "[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Reunion");
    add_srs_wkt (p, 23,
        "\"],BBOX[-24.72,51.83,-18.28,58.24]],ID[\"EPSG\",1912]]]");
    p = add_epsg_def_ex (filter, first, last, 4375, "epsg", 4375,
        "SIRGAS 1995", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SIRGAS 1995\",DATUM[\"Siste");
    add_srs_wkt (p, 1,
        "ma de Referencia Geocentrico para America del Sur 1995\"");
    add_srs_wkt (p, 2,
        ",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT");
    add_srs_wkt (p, 3,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodet");
    add_srs_wkt (p, 5,
        "ic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",e");
    add_srs_wkt (p, 7,
        "ast,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],A");
    add_srs_wkt (p, 8,
        "XIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"South Americ");
    add_srs_wkt (p, 10,
        "a - SIRGAS 1995 by country\"],BBOX[-59.87,-113.21,16.75,");
    add_srs_wkt (p, 11,
        "-26]],ID[\"EPSG\",4975]]],TARGETCRS[GEOGCRS[\"WGS 84\",D");
    add_srs_wkt (p, 12,
        "ATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\"");
    add_srs_wkt (p, 13,
        ",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 14,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANG");
    add_srs_wkt (p, 16,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitude\"");
    add_srs_wkt (p, 17,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 18,
        ",ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"SIRGAS to ");
    add_srs_wkt (p, 19,
        "WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D do");
    add_srs_wkt (p, 20,
        "main)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0");
    add_srs_wkt (p, 23,
        ",ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Sout");
    add_srs_wkt (p, 24,
        "h America - SIRGAS 1995 by country\"],BBOX[-59.87,-113.2");
    add_srs_wkt (p, 25,
        "1,16.75,-26]],ID[\"EPSG\",1581]]]");
    p = add_epsg_def_ex (filter, first, last, 4377, "epsg", 4377,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SWEREF99\",DATUM[\"SWEREF99");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Sweden\"],BB");
    add_srs_wkt (p, 9,
        "OX[54.96,10.03,69.07,24.17]],ID[\"EPSG\",4977]]],TARGETC");
    add_srs_wkt (p, 10,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 11,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 13,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 14,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 15,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 16,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 17,
        "NSFORMATION[\"SWEREF99 to WGS 84 (1)\",METHOD[\"Geocentr");
    add_srs_wkt (p, 18,
        "ic translations (geog2D domain)\",ID[\"EPSG\",9603]],PAR");
    add_srs_wkt (p, 19,
        "AMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAM");
    add_srs_wkt (p, 20,
        "ETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMET");
    add_srs_wkt (p, 21,
        "ER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCO");
    add_srs_wkt (p, 22,
        "PE[\"unknown\"],AREA[\"Sweden\"],BBOX[54.96,10.03,69.07,");
    add_srs_wkt (p, 23,
        "24.17]],ID[\"EPSG\",1879]]]");
    p = add_epsg_def_ex (filter, first, last, 4379, "epsg", 4379,
        "Yemen NGN96", 1, 1,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Yemen NGN96\",DATUM[\"Yemen");
    add_srs_wkt (p, 1,
        " National Geodetic Network 1996\",ELLIPSOID[\"WGS 84\",6");
    add_srs_wkt (p, 2,
        "378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Yemen\"],BBOX[8.95,41.08,19,57.96]],ID");
    add_srs_wkt (p, 10,
        "[\"EPSG\",4981]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 11,
        "orld Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137");
    add_srs_wkt (p, 12,
        ",298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 13,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 14,
        "ipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 15,
        "degree\",0.0174532925199433]],AXIS[\"longitude\",east,OR");
    add_srs_wkt (p, 16,
        "DER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EP");
    add_srs_wkt (p, 17,
        "SG\",4326]]],ABRIDGEDTRANSFORMATION[\"Yemen NGN96 to WGS");
    add_srs_wkt (p, 18,
        " 84 (1)\",METHOD[\"Geocentric translations (geog2D domai");
    add_srs_wkt (p, 19,
        "n)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\"");
    add_srs_wkt (p, 20,
        ",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0");
    add_srs_wkt (p, 21,
        ",ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,I");
    add_srs_wkt (p, 22,
        "D[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Yemen\"");
    add_srs_wkt (p, 23,
        "],BBOX[8.95,41.08,19,57.96]],ID[\"EPSG\",1540]]]");
    p = add_epsg_def_ex (filter, first, last, 4381, "epsg", 4381,
        "RGNC 1991 (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_Geodesique_Nouvelle_Caledonie_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGNC 1991\",DATUM[\"Reseau Geodesique Nouvelle");
    add_srs_wkt (p, 1,
        " Caledonie 1991\",ELLIPSOID[\"International 1924\",63783");
    add_srs_wkt (p, 2,
        "88,297,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"New Caledonia\"],BBOX[-26.45,156.25,-14.83,174.28]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",4969]]");
    p = add_epsg_def_ex (filter, first, last, 4383, "epsg", 4383,
        "RRAF 1991 (deprecated)", 1, 1,
        "WGS 84", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RRAF 1991\",DATUM[\"Reseau de Reference des An");
    add_srs_wkt (p, 1,
        "tilles Francaises 1991\",ELLIPSOID[\"WGS 84\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellips");
    add_srs_wkt (p, 4,
        "oidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1]");
    add_srs_wkt (p, 5,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodet");
    add_srs_wkt (p, 6,
        "ic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 7,
        "0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,");
    add_srs_wkt (p, 8,
        "ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 9,
        "],AREA[\"Caribbean - French Antilles\"],BBOX[14.08,-63.6");
    add_srs_wkt (p, 10,
        "6,18.54,-57.52]],ID[\"EPSG\",4973]]");
    p = add_epsg_def_ex (filter, first, last, 4386, "epsg", 4386,
        "ISN93", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"ISN93\",DATUM[\"Islands Net");
    add_srs_wkt (p, 1,
        " 1993\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LEN");
    add_srs_wkt (p, 2,
        "GTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[");
    add_srs_wkt (p, 3,
        "\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"");
    add_srs_wkt (p, 4,
        "geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433]],AXIS[\"geodetic longitude (Lo");
    add_srs_wkt (p, 6,
        "n)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 7,
        "33]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHU");
    add_srs_wkt (p, 8,
        "NIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Icelan");
    add_srs_wkt (p, 9,
        "d\"],BBOX[59.96,-30.87,69.59,-5.55]],ID[\"EPSG\",4945]]]");
    add_srs_wkt (p, 10,
        ",TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic Sys");
    add_srs_wkt (p, 11,
        "tem 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LE");
    add_srs_wkt (p, 12,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 13,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[");
    add_srs_wkt (p, 14,
        "\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 15,
        "32925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT");
    add_srs_wkt (p, 16,
        "[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABR");
    add_srs_wkt (p, 17,
        "IDGEDTRANSFORMATION[\"ISN93 to WGS 84 (1)\",METHOD[\"Geo");
    add_srs_wkt (p, 18,
        "centric translations (geog2D domain)\",ID[\"EPSG\",9603]");
    add_srs_wkt (p, 19,
        "],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],");
    add_srs_wkt (p, 20,
        "PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PA");
    add_srs_wkt (p, 21,
        "RAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAG");
    add_srs_wkt (p, 22,
        "E[SCOPE[\"unknown\"],AREA[\"Iceland\"],BBOX[59.96,-30.87");
    add_srs_wkt (p, 23,
        ",69.59,-5.55]],ID[\"EPSG\",1952]]]");
    p = add_epsg_def_ex (filter, first, last, 4388, "epsg", 4388,
        "LKS92", 1, 1,
        "GRS 1980", "Greenwich",
        "Latvia_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"LKS92\",DATUM[\"Latvia 1992");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Latvia\"],BB");
    add_srs_wkt (p, 9,
        "OX[55.67,19.06,58.09,28.24]],ID[\"EPSG\",4949]]],TARGETC");
    add_srs_wkt (p, 10,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 11,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 13,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 14,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 15,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 16,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 17,
        "NSFORMATION[\"LKS92 to WGS 84 (1)\",METHOD[\"Geocentric ");
    add_srs_wkt (p, 18,
        "translations (geog2D domain)\",ID[\"EPSG\",9603]],PARAME");
    add_srs_wkt (p, 19,
        "TER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETE");
    add_srs_wkt (p, 20,
        "R[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[");
    add_srs_wkt (p, 21,
        "\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[");
    add_srs_wkt (p, 22,
        "\"unknown\"],AREA[\"Latvia\"],BBOX[55.67,19.06,58.09,28.");
    add_srs_wkt (p, 23,
        "24]],ID[\"EPSG\",1958]]]");
    p = add_epsg_def_ex (filter, first, last, 4390, "epsg", 4390,
        "Kertau 1968 / Johor Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.042583333333333 +lon_0=103.562758333");
    add_proj4text (p, 1,
        "3333 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Johor Grid\",GEOGCS[\"Kertau 1968");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifie");
    add_srs_wkt (p, 2,
        "d\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cassini");
    add_srs_wkt (p, 7,
        "_Soldner\"],PARAMETER[\"latitude_of_origin\",2.042583333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",103.562758333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"4390\"]]");
    p = add_epsg_def_ex (filter, first, last, 4391, "epsg", 4391,
        "Kertau 1968 / Sembilan and Melaka Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.712283333333334 +lon_0=101.941166666");
    add_proj4text (p, 1,
        "6667 +x_0=-242.005 +y_0=-948.547 +a=6377304.063 +b=63561");
    add_proj4text (p, 2,
        "03.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Sembilan and Melaka Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Cassini_Soldner\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",2.71228333333333],PARAMETER[\"central_meridian\",101.94");
    add_srs_wkt (p, 9,
        "1166666667],PARAMETER[\"false_easting\",-242.005],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",-948.547],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"4391\"]]");
    p = add_epsg_def_ex (filter, first, last, 4392, "epsg", 4392,
        "Kertau 1968 / Pahang Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.710972222222222 +lon_0=102.436177777");
    add_proj4text (p, 1,
        "7778 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Pahang Grid\",GEOGCS[\"Kertau 196");
    add_srs_wkt (p, 1,
        "8\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifi");
    add_srs_wkt (p, 2,
        "ed\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cassin");
    add_srs_wkt (p, 7,
        "i_Soldner\"],PARAMETER[\"latitude_of_origin\",3.71097222");
    add_srs_wkt (p, 8,
        "222222],PARAMETER[\"central_meridian\",102.436177777778]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"4392\"]]");
    p = add_epsg_def_ex (filter, first, last, 4393, "epsg", 4393,
        "Kertau 1968 / Selangor Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.680344444444444 +lon_0=101.508244444");
    add_proj4text (p, 1,
        "4444 +x_0=-21759.438 +y_0=55960.906 +a=6377304.063 +b=63");
    add_proj4text (p, 2,
        "56103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Selangor Grid\",GEOGCS[\"Kertau 1");
    add_srs_wkt (p, 1,
        "968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modi");
    add_srs_wkt (p, 2,
        "fied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cass");
    add_srs_wkt (p, 7,
        "ini_Soldner\"],PARAMETER[\"latitude_of_origin\",3.680344");
    add_srs_wkt (p, 8,
        "44444444],PARAMETER[\"central_meridian\",101.50824444444");
    add_srs_wkt (p, 9,
        "4],PARAMETER[\"false_easting\",-21759.438],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",55960.906],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4393\"]]");
    p = add_epsg_def_ex (filter, first, last, 4394, "epsg", 4394,
        "Kertau 1968 / Terengganu Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.946141666666667 +lon_0=102.895208333");
    add_proj4text (p, 1,
        "3333 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Terengganu Grid\",GEOGCS[\"Kertau");
    add_srs_wkt (p, 1,
        " 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mo");
    add_srs_wkt (p, 2,
        "dified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cass");
    add_srs_wkt (p, 7,
        "ini_Soldner\"],PARAMETER[\"latitude_of_origin\",4.946141");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",102.89520833333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4394\"]]");
    p = add_epsg_def_ex (filter, first, last, 4395, "epsg", 4395,
        "Kertau 1968 / Pinang Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.421325 +lon_0=100.3458694444444 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +towgs84=-");
    add_proj4text (p, 2,
        "11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Pinang Grid\",GEOGCS[\"Kertau 196");
    add_srs_wkt (p, 1,
        "8\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifi");
    add_srs_wkt (p, 2,
        "ed\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cassin");
    add_srs_wkt (p, 7,
        "i_Soldner\"],PARAMETER[\"latitude_of_origin\",5.421325],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",100.345869444444],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4395\"]]");
    p = add_epsg_def_ex (filter, first, last, 4396, "epsg", 4396,
        "Kertau 1968 / Kedah and Perlis Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.965147222222223 +lon_0=100.637594444");
    add_proj4text (p, 1,
        "4444 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Kedah and Perlis Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Cassini_Soldner\"],PARAMETER[\"latitude_of_origin\",5.");
    add_srs_wkt (p, 8,
        "96514722222222],PARAMETER[\"central_meridian\",100.63759");
    add_srs_wkt (p, 9,
        "4444444],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"4396\"]]");
    p = add_epsg_def_ex (filter, first, last, 4397, "epsg", 4397,
        "Kertau 1968 / Perak Revised Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.859380555555555 +lon_0=100.816766666");
    add_proj4text (p, 1,
        "6667 +x_0=0 +y_0=133453.669 +a=6377304.063 +b=6356103.03");
    add_proj4text (p, 2,
        "8993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Perak Revised Grid\",GEOGCS[\"Ker");
    add_srs_wkt (p, 1,
        "tau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "18\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Cassini_Soldner\"],PARAMETER[\"latitude_of_origin\",4.85");
    add_srs_wkt (p, 8,
        "938055555556],PARAMETER[\"central_meridian\",100.8167666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",133453.669],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"4397\"]]");
    p = add_epsg_def_ex (filter, first, last, 4398, "epsg", 4398,
        "Kertau 1968 / Kelantan Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.893922222222222 +lon_0=102.177291666");
    add_proj4text (p, 1,
        "6667 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Kelantan Grid\",GEOGCS[\"Kertau 1");
    add_srs_wkt (p, 1,
        "968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modi");
    add_srs_wkt (p, 2,
        "fied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cass");
    add_srs_wkt (p, 7,
        "ini_Soldner\"],PARAMETER[\"latitude_of_origin\",5.893922");
    add_srs_wkt (p, 8,
        "22222222],PARAMETER[\"central_meridian\",102.17729166666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4398\"]]");
    p = add_epsg_def_ex (filter, first, last, 4399, "epsg", 4399,
        "NAD27 / BLM 59N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 59N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4399\"]]");
    p = add_epsg_def_ex (filter, first, last, 4400, "epsg", 4400,
        "NAD27 / BLM 60N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 60N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4400\"]]");
    p = add_epsg_def_ex (filter, first, last, 4401, "epsg", 4401,
        "NAD27 / BLM 1N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 1N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4401\"]]");
    p = add_epsg_def_ex (filter, first, last, 4402, "epsg", 4402,
        "NAD27 / BLM 2N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 2N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4402\"]]");
    p = add_epsg_def_ex (filter, first, last, 4403, "epsg", 4403,
        "NAD27 / BLM 3N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 3N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4403\"]]");
    p = add_epsg_def_ex (filter, first, last, 4404, "epsg", 4404,
        "NAD27 / BLM 4N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 4N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4404\"]]");
    p = add_epsg_def_ex (filter, first, last, 4405, "epsg", 4405,
        "NAD27 / BLM 5N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 5N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4405\"]]");
    p = add_epsg_def_ex (filter, first, last, 4406, "epsg", 4406,
        "NAD27 / BLM 6N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 6N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4406\"]]");
    p = add_epsg_def_ex (filter, first, last, 4407, "epsg", 4407,
        "NAD27 / BLM 7N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 7N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4407\"]]");
    p = add_epsg_def_ex (filter, first, last, 4408, "epsg", 4408,
        "NAD27 / BLM 8N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 8N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-10,158,187,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-135],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",1640416.67],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4408\"]]");
    p = add_epsg_def_ex (filter, first, last, 4409, "epsg", 4409,
        "NAD27 / BLM 9N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 9N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4409\"]]");
    p = add_epsg_def_ex (filter, first, last, 4410, "epsg", 4410,
        "NAD27 / BLM 10N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 10N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1640416.67],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4410\"]]");
    p = add_epsg_def_ex (filter, first, last, 4411, "epsg", 4411,
        "NAD27 / BLM 11N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 11N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-117],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",1640416.67],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4411\"]]");
    p = add_epsg_def_ex (filter, first, last, 4412, "epsg", 4412,
        "NAD27 / BLM 12N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 12N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-111],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",1640416.67],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4412\"]]");
    p = add_epsg_def_ex (filter, first, last, 4413, "epsg", 4413,
        "NAD27 / BLM 13N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 13N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,159,175,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-105],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",1640416.67],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4413\"]]");
    p = add_epsg_def_ex (filter, first, last, 4414, "epsg", 4414,
        "NAD83(HARN) / Guam Map Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.5 +lon_0=144.75 +k=1 +x_0=100000 +");
    add_proj4text (p, 1,
        "y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Guam Map Grid\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",13.5],PARAMETER[\"central_meridian\",144.75],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",1000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",200000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4414\"]]");
    p = add_epsg_def_ex (filter, first, last, 4415, "epsg", 4415,
        "Katanga 1955 / Katanga Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=-9 +lon_0=26 +");
    add_proj4text (p, 1,
        "x_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-");
    add_proj4text (p, 2,
        "9.614,-255.95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Lambert\",GEOGCS[\"Katan");
    add_srs_wkt (p, 1,
        "ga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4695\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",26],PARAMETER[\"standard_parallel_1\",-6.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",-11.5],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",500000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4415\"]]");
    p = add_epsg_def_ex (filter, first, last, 4417, "epsg", 4417,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4417\"]]");
    p = add_epsg_def_ex (filter, first, last, 4418, "epsg", 4418,
        "NAD27 / BLM 18N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 18N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"6267\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",1640416.67],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 11,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"4418\"]]");
    p = add_epsg_def_ex (filter, first, last, 4419, "epsg", 4419,
        "NAD27 / BLM 19N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 19N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4419\"]]");
    p = add_epsg_def_ex (filter, first, last, 4420, "epsg", 4420,
        "NAD83 / BLM 60N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 60N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",177],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4420\"]]");
    p = add_epsg_def_ex (filter, first, last, 4421, "epsg", 4421,
        "NAD83 / BLM 1N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 1N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4421\"]]");
    p = add_epsg_def_ex (filter, first, last, 4422, "epsg", 4422,
        "NAD83 / BLM 2N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 2N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-171],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4422\"]]");
    p = add_epsg_def_ex (filter, first, last, 4423, "epsg", 4423,
        "NAD83 / BLM 3N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 3N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-165],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4423\"]]");
    p = add_epsg_def_ex (filter, first, last, 4424, "epsg", 4424,
        "NAD83 / BLM 4N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 4N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-159],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4424\"]]");
    p = add_epsg_def_ex (filter, first, last, 4425, "epsg", 4425,
        "NAD83 / BLM 5N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 5N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-153],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4425\"]]");
    p = add_epsg_def_ex (filter, first, last, 4426, "epsg", 4426,
        "NAD83 / BLM 6N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 6N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-147],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4426\"]]");
    p = add_epsg_def_ex (filter, first, last, 4427, "epsg", 4427,
        "NAD83 / BLM 7N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 7N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-141],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4427\"]]");
    p = add_epsg_def_ex (filter, first, last, 4428, "epsg", 4428,
        "NAD83 / BLM 8N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 8N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-135],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4428\"]]");
    p = add_epsg_def_ex (filter, first, last, 4429, "epsg", 4429,
        "NAD83 / BLM 9N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 9N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-129],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4429\"]]");
    p = add_epsg_def_ex (filter, first, last, 4430, "epsg", 4430,
        "NAD83 / BLM 10N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 10N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-123],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4430\"]]");
    p = add_epsg_def_ex (filter, first, last, 4431, "epsg", 4431,
        "NAD83 / BLM 11N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 11N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-117],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4431\"]]");
    p = add_epsg_def_ex (filter, first, last, 4432, "epsg", 4432,
        "NAD83 / BLM 12N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 12N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-111],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4432\"]]");
    p = add_epsg_def_ex (filter, first, last, 4433, "epsg", 4433,
        "NAD83 / BLM 13N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 13N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-105],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4433\"]]");
    p = add_epsg_def_ex (filter, first, last, 4434, "epsg", 4434,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4434\"]]");
    p = add_epsg_def_ex (filter, first, last, 4437, "epsg", 4437,
        "NAD83(NSRS2007) / Puerto Rico and Virgin Is.", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Puerto Rico and Virgin Is.\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"latitude_of_origin\",17.83333333333");
    add_srs_wkt (p, 9,
        "33],PARAMETER[\"central_meridian\",-66.4333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_1\",18.4333333333333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"standard_parallel_2\",18.0333333333333],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_easting\",200000],PARAMETER[\"false_northing\",2");
    add_srs_wkt (p, 13,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"4437\"]]");
    p = add_epsg_def_ex (filter, first, last, 4438, "epsg", 4438,
        "NAD83 / BLM 18N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 18N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4438\"]]");
    p = add_epsg_def_ex (filter, first, last, 4439, "epsg", 4439,
        "NAD83 / BLM 19N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 19N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4439\"]]");
    p = add_epsg_def_ex (filter, first, last, 4455, "epsg", 4455,
        "NAD27 / Pennsylvania South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "67\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",39.3333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-77.75],PARAMETER[\"standard_parallel_1\",40.96666666666");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"standard_parallel_2\",39.9333333333333],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4455\"]]");
    p = add_epsg_def_ex (filter, first, last, 4456, "epsg", 4456,
        "NAD27 / New York Long Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=609601.2192024384 +y_0=3");
    add_proj4text (p, 2,
        "0480.06096012192 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],TOWGS84[-8,160,176,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",40.5],PARAMETER[\"central_meridian\",-74],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",41.0333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",40.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2000000],PARAMETER[\"false_northing\",10");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"4456\"]]");
    p = add_epsg_def_ex (filter, first, last, 4457, "epsg", 4457,
        "NAD83 / South Dakota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.8333333333333],PARAMETER[\"central_meridian\",-100],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",45.6833333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",44.4166666666667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",1968500],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"4457\"]]");
    p = add_epsg_def_ex (filter, first, last, 4462, "epsg", 4462,
        "WGS 84 / Australian Centre for Remote Sensing Lambert", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=-27 +lon_0=132 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Australian Centre for Remote Sensing L");
    add_srs_wkt (p, 1,
        "ambert\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4326\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",-27],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",132],PARAMETER[\"standard_parallel_1\",-1");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"standard_parallel_2\",-36],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"446");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 4463, "epsg", 4463,
        "RGSPM06", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGSPM06\",DATUM[\"Reseau_Geodesique_de_Saint_Pi");
    add_srs_wkt (p, 1,
        "erre_et_Miquelon_2006\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1038\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4463\"]]");
    p = add_epsg_def_ex (filter, first, last, 4466, "epsg", 4466,
        "RGSPM06", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGSPM06\",DATUM[\"Reseau Ge");
    add_srs_wkt (p, 1,
        "odesique de Saint Pierre et Miquelon 2006\",ELLIPSOID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 4,
        "925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (");
    add_srs_wkt (p, 5,
        "Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],");
    add_srs_wkt (p, 7,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipso");
    add_srs_wkt (p, 8,
        "idal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],U");
    add_srs_wkt (p, 9,
        "SAGE[SCOPE[\"unknown\"],AREA[\"St Pierre and Miquelon\"]");
    add_srs_wkt (p, 10,
        ",BBOX[43.41,-57.1,47.37,-55.9]],ID[\"EPSG\",4466]]],TARG");
    add_srs_wkt (p, 11,
        "ETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1");
    add_srs_wkt (p, 12,
        "984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHU");
    add_srs_wkt (p, 13,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 14,
        "gree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"lat");
    add_srs_wkt (p, 15,
        "itude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 16,
        "199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"de");
    add_srs_wkt (p, 17,
        "gree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGED");
    add_srs_wkt (p, 18,
        "TRANSFORMATION[\"RGSPM06 to WGS 84 (1)\",METHOD[\"Geocen");
    add_srs_wkt (p, 19,
        "tric translations (geog2D domain)\",ID[\"EPSG\",9603]],P");
    add_srs_wkt (p, 20,
        "ARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PAR");
    add_srs_wkt (p, 21,
        "AMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAM");
    add_srs_wkt (p, 22,
        "ETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[S");
    add_srs_wkt (p, 23,
        "COPE[\"unknown\"],AREA[\"St Pierre and Miquelon\"],BBOX[");
    add_srs_wkt (p, 24,
        "43.41,-57.1,47.37,-55.9]],ID[\"EPSG\",4477]]]");
    p = add_epsg_def_ex (filter, first, last, 4467, "epsg", 4467,
        "RGSPM06 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGSPM06 / UTM zone 21N\",GEOGCS[\"RGSPM06\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1038\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4463\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",-57],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4467\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

