/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_18 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 3885, "epsg", 3885,
        "ETRS89 / GK31FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK31FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",31],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",31500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"3885\"]]");
    p = add_epsg_def_ex (filter, first, last, 3888, "epsg", 3888,
        "IGRS", 1, 1,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"IGRS\",DATUM[\"Iraqi Geospa");
    add_srs_wkt (p, 1,
        "tial Reference System\",ELLIPSOID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellip");
    add_srs_wkt (p, 4,
        "soidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1");
    add_srs_wkt (p, 5,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geode");
    add_srs_wkt (p, 6,
        "tic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"Iraq\"],BBOX[29.06,38.79,37.39,48.75]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",3888]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World");
    add_srs_wkt (p, 11,
        " Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 12,
        ".257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"IGRS to WGS 84 (1)\",M");
    add_srs_wkt (p, 18,
        "ETHOD[\"Geocentric translations (geog2D domain)\",ID[\"E");
    add_srs_wkt (p, 19,
        "PSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPS");
    add_srs_wkt (p, 20,
        "G\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 21,
        ",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8");
    add_srs_wkt (p, 22,
        "607]],USAGE[SCOPE[\"unknown\"],AREA[\"Iraq\"],BBOX[29.06");
    add_srs_wkt (p, 23,
        ",38.79,37.39,48.75]],ID[\"EPSG\",3894]]]");
    p = add_epsg_def_ex (filter, first, last, 3889, "epsg", 3889,
        "IGRS", 1, 1,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGRS\",DATUM[\"Iraqi_Geospatial_Reference_Syste");
    add_srs_wkt (p, 1,
        "m\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1029\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"3889\"]]");
    p = add_epsg_def_ex (filter, first, last, 3890, "epsg", 3890,
        "IGRS / UTM zone 37N", 0, 0,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 37N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",39],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3890\"]]");
    p = add_epsg_def_ex (filter, first, last, 3891, "epsg", 3891,
        "IGRS / UTM zone 38N", 0, 0,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 38N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",45],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3891\"]]");
    p = add_epsg_def_ex (filter, first, last, 3892, "epsg", 3892,
        "IGRS / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGRS / UTM zone 39N\",GEOGCS[\"IGRS\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "raqi_Geospatial_Reference_System\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1029\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"3889\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",51],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"3892\"]]");
    p = add_epsg_def_ex (filter, first, last, 3893, "epsg", 3893,
        "ED50 / Iraq National Grid", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.02626833333333 +lon_0=46.5 +k=0.99");
    add_proj4text (p, 1,
        "94 +x_0=800000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / Iraq National Grid\",GEOGCS[\"ED50\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"European_Datum_1950\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-10");
    add_srs_wkt (p, 3,
        "3,-106,-141,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",29.026268333");
    add_srs_wkt (p, 8,
        "3333],PARAMETER[\"central_meridian\",46.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9994],PARAMETER[\"false_easting\",800000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"3893\"]]");
    p = add_epsg_def_ex (filter, first, last, 3901, "epsg", 3901,
        "KKJ / Finland Uniform Coordinate System", 0, 0,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"KKJ / Finland Uniform Coordinate System + N60");
    add_srs_wkt (p, 1,
        " height\",PROJCS[\"KKJ / Finland Uniform Coordinate Syst");
    add_srs_wkt (p, 2,
        "em\",GEOGCS[\"KKJ\",DATUM[\"Kartastokoordinaattijarjeste");
    add_srs_wkt (p, 3,
        "lma_1966\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-96.062,-82.428,-12");
    add_srs_wkt (p, 5,
        "1.753,4.801,0.345,-1.376,1.496],AUTHORITY[\"EPSG\",\"612");
    add_srs_wkt (p, 6,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 7,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4123\"]],PROJECTION[\"T");
    add_srs_wkt (p, 9,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale_f");
    add_srs_wkt (p, 11,
        "actor\",1],PARAMETER[\"false_easting\",3500000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AUTHORITY[\"EPSG\",\"2393\"]],VERT_CS[\"N60 heigh");
    add_srs_wkt (p, 15,
        "t\",VERT_DATUM[\"Helsinki 1960\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5116\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 18,
        ",\"5717\"]],AUTHORITY[\"EPSG\",\"3901\"]]");
    p = add_epsg_def_ex (filter, first, last, 3902, "epsg", 3902,
        "ETRS89 / TM35FIN(N,E)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / TM35FIN(N,E) + N60 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / TM35FIN(N,E)\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",27],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5048\"]],VERT_CS[\"N60 height\",VE");
    add_srs_wkt (p, 14,
        "RT_DATUM[\"Helsinki 1960\",2005,AUTHORITY[\"EPSG\",\"511");
    add_srs_wkt (p, 15,
        "6\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 16,
        "S[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"57");
    add_srs_wkt (p, 17,
        "17\"]],AUTHORITY[\"EPSG\",\"3902\"]]");
    p = add_epsg_def_ex (filter, first, last, 3903, "epsg", 3903,
        "ETRS89 / TM35FIN(N,E)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / TM35FIN(N,E) + N2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / TM35FIN(N,E)\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"5048\"]],VERT_CS[\"N2000 height\"");
    add_srs_wkt (p, 14,
        ",VERT_DATUM[\"N2000\",2005,AUTHORITY[\"EPSG\",\"1030\"]]");
    add_srs_wkt (p, 15,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"G");
    add_srs_wkt (p, 16,
        "ravity-related height\",UP],AUTHORITY[\"EPSG\",\"3900\"]");
    add_srs_wkt (p, 17,
        "],AUTHORITY[\"EPSG\",\"3903\"]]");
    p = add_epsg_def_ex (filter, first, last, 3906, "epsg", 3906,
        "MGI 1901", 1, 1,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "4\"]],TOWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"3906\"]]");
    p = add_epsg_def_ex (filter, first, last, 3907, "epsg", 3907,
        "MGI 1901 / Balkans zone 5", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 5\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",5500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"8677\"]]");
    p = add_epsg_def_ex (filter, first, last, 3908, "epsg", 3908,
        "MGI 1901 / Balkans zone 6", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 6\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",18],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",6500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"8678\"]]");
    p = add_epsg_def_ex (filter, first, last, 3909, "epsg", 3909,
        "MGI 1901 / Balkans zone 7", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 7\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",7500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"6316\"]]");
    p = add_epsg_def_ex (filter, first, last, 3910, "epsg", 3910,
        "MGI 1901 / Balkans zone 8", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 8\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[682,-");
    add_srs_wkt (p, 3,
        "203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",8500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"8679\"]]");
    p = add_epsg_def_ex (filter, first, last, 3911, "epsg", 3911,
        "MGI 1901 / Slovenia Grid", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Slovenia Grid\",GEOGCS[\"MGI 1901\",");
    add_srs_wkt (p, 1,
        "DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 2,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[476.08");
    add_srs_wkt (p, 3,
        ",125.947,417.81,4.610862,2.388137,-11.942335,9.896638],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "3906\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"868");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 3912, "epsg", 3912,
        "MGI 1901 / Slovene National Grid", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Slovene National Grid\",GEOGCS[\"MGI");
    add_srs_wkt (p, 1,
        " 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[476.08,125.947,417.81,4.610862,2.388137,-11.942335,9.8");
    add_srs_wkt (p, 4,
        "96638],AUTHORITY[\"EPSG\",\"1031\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"3906\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",15],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",-");
    add_srs_wkt (p, 11,
        "5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"3912\"]]");
    p = add_epsg_def_ex (filter, first, last, 3920, "epsg", 3920,
        "Puerto Rico / UTM zone 20N", 0, 0,
        "Clarke 1866", "Greenwich",
        "Puerto_Rico", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=clrk66 +towgs84=11,72,-101,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico / UTM zone 20N\",GEOGCS[\"Puerto Ri");
    add_srs_wkt (p, 1,
        "co\",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"6139\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-63],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3920\"]]");
    p = add_epsg_def_ex (filter, first, last, 3942, "epsg", 3942,
        "RGF93 / CC42", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.25 +lat_2=42.75 +lat_0=42 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC42\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",42],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",41.25],PARAMETER[\"standard_parallel_2\",42.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3942\"]]");
    p = add_epsg_def_ex (filter, first, last, 3943, "epsg", 3943,
        "RGF93 / CC43", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.25 +lat_2=43.75 +lat_0=43 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC43\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",43],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",42.25],PARAMETER[\"standard_parallel_2\",43.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3943\"]]");
    p = add_epsg_def_ex (filter, first, last, 3944, "epsg", 3944,
        "RGF93 / CC44", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.25 +lat_2=44.75 +lat_0=44 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC44\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",43.25],PARAMETER[\"standard_parallel_2\",44.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3944\"]]");
    p = add_epsg_def_ex (filter, first, last, 3945, "epsg", 3945,
        "RGF93 / CC45", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.75 +lat_0=45 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC45\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",45],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",44.25],PARAMETER[\"standard_parallel_2\",45.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",4200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3945\"]]");
    p = add_epsg_def_ex (filter, first, last, 3946, "epsg", 3946,
        "RGF93 / CC46", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.25 +lat_2=46.75 +lat_0=46 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC46\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",46],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",45.25],PARAMETER[\"standard_parallel_2\",46.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",5200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3946\"]]");
    p = add_epsg_def_ex (filter, first, last, 3947, "epsg", 3947,
        "RGF93 / CC47", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.25 +lat_2=47.75 +lat_0=47 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC47\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",47],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",46.25],PARAMETER[\"standard_parallel_2\",47.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",6200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3947\"]]");
    p = add_epsg_def_ex (filter, first, last, 3948, "epsg", 3948,
        "RGF93 / CC48", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.25 +lat_2=48.75 +lat_0=48 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC48\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",48],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",47.25],PARAMETER[\"standard_parallel_2\",48.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",7200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3948\"]]");
    p = add_epsg_def_ex (filter, first, last, 3949, "epsg", 3949,
        "RGF93 / CC49", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.25 +lat_2=49.75 +lat_0=49 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC49\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",48.25],PARAMETER[\"standard_parallel_2\",49.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",8200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3949\"]]");
    p = add_epsg_def_ex (filter, first, last, 3950, "epsg", 3950,
        "RGF93 / CC50", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.25 +lat_2=50.75 +lat_0=50 +lon_0=3 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 / CC50\",GEOGCS[\"RGF93\",DATUM[\"Reseau_");
    add_srs_wkt (p, 1,
        "Geodesique_Francais_1993\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6171\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4171\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",50],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",3],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",49.25],PARAMETER[\"standard_parallel_2\",50.75],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",1700000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",9200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3950\"]]");
    p = add_epsg_def_ex (filter, first, last, 3968, "epsg", 3968,
        "NAD83 / Virginia Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia Lambert\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-79.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",37],PARAMETER[\"standard_parallel_2\",39.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"3968\"]]");
    p = add_epsg_def_ex (filter, first, last, 3969, "epsg", 3969,
        "NAD83(HARN) / Virginia Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia Lambert\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",36],PARAMETER[\"central_meridian\",-79.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",37],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",39.5],PARAMETER[\"false_easting\",0],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3969\"]]");
    p = add_epsg_def_ex (filter, first, last, 3970, "epsg", 3970,
        "NAD83(NSRS2007) / Virginia Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Virginia Lambert\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"latitude_of_origin\",36],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-79.5],PARAMETER[\"standard_parallel_1\",37],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"standard_parallel_2\",39.5],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3970\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3973, "epsg", 3973,
        "WGS 84 / NSIDC EASE-Grid 2.0 North", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 North\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_center\",90],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 9,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 10,
        "],AXIS[\"Easting\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"6931\"]]");
    p = add_epsg_def_ex (filter, first, last, 3974, "epsg", 3974,
        "WGS 84 / NSIDC EASE-Grid 2.0 South", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Azimuthal_Equal_Area", "metre",
        "Easting", "North", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS8");
    add_proj4text (p, 1,
        "4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 South\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_center\",-90],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 9,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 10,
        "],AXIS[\"Easting\",NORTH],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"6932\"]]");
    p = add_epsg_def_ex (filter, first, last, 3975, "epsg", 3975,
        "WGS 84 / NSIDC EASE-Grid 2.0 Global", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Cylindrical_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +datum=WGS84");
    add_proj4text (p, 1,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC EASE-Grid 2.0 Global\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,");
    add_srs_wkt (p, 2,
        "298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Cylindrical_Equal_Area\"],PARAMETER[\"standar");
    add_srs_wkt (p, 7,
        "d_parallel_1\",30],PARAMETER[\"central_meridian\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 9,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 10,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"6933\"]]");
    p = add_epsg_def_ex (filter, first, last, 3976, "epsg", 3976,
        "WGS 84 / NSIDC Sea Ice Polar Stereographic South", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "North", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / NSIDC Sea Ice Polar Stereographic Sout");
    add_srs_wkt (p, 1,
        "h\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS ");
    add_srs_wkt (p, 2,
        "84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4326\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",-70],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 10,
        "\"]],AXIS[\"Easting\",NORTH],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"3976\"]]");
    p = add_epsg_def_ex (filter, first, last, 3978, "epsg", 3978,
        "NAD83 / Canada Atlas Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Canada Atlas Lambert\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",49]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-95],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",49],PARAMETER[\"standard_parallel_2\",77]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3978\"]]");
    p = add_epsg_def_ex (filter, first, last, 3979, "epsg", 3979,
        "NAD83(CSRS) / Canada Atlas Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Canada Atlas Lambert\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",49],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-95],PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",77],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"3979\"]]");
    p = add_epsg_def_ex (filter, first, last, 3985, "epsg", 3985,
        "Katanga 1955 / Katanga Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=9 +lon_0=26 +x");
    add_proj4text (p, 1,
        "_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9");
    add_proj4text (p, 2,
        ".614,-255.95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Lambert\",GEOGCS[\"Katan");
    add_srs_wkt (p, 1,
        "ga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4695\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",26],PARAMETER[\"standard_parallel_1\",-6.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",-11.5],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",500000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4415\"]]");
    p = add_epsg_def_ex (filter, first, last, 3986, "epsg", 3986,
        "Katanga 1955 / Katanga Gauss zone A", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=30 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone A\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4695\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",30],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",500");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3986\"]]");
    p = add_epsg_def_ex (filter, first, last, 3987, "epsg", 3987,
        "Katanga 1955 / Katanga Gauss zone B", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=28 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone B\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4695\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",28],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",500");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3987\"]]");
    p = add_epsg_def_ex (filter, first, last, 3988, "epsg", 3988,
        "Katanga 1955 / Katanga Gauss zone C", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=26 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone C\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4695\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",26],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",500");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3988\"]]");
    p = add_epsg_def_ex (filter, first, last, 3989, "epsg", 3989,
        "Katanga 1955 / Katanga Gauss zone D", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=24 +k=1 +x_0=200000 +y_0=50");
    add_proj4text (p, 1,
        "0000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Gauss zone D\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4695\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",24],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",500");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3989\"]]");
    p = add_epsg_def_ex (filter, first, last, 3991, "epsg", 3991,
        "Puerto Rico State Plane CS of 1927", 0, 0,
        "Clarke 1866", "Greenwich",
        "Puerto_Rico", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=11,7");
    add_proj4text (p, 3,
        "2,-101,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico State Plane CS of 1927\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "uerto Rico\",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
        "39\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",17.8333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-66.4333333333333],PARAMETER[\"standard_parallel_1\",18.");
    add_srs_wkt (p, 10,
        "4333333333333],PARAMETER[\"standard_parallel_2\",18.0333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 13,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3991");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3992, "epsg", 3992,
        "Puerto Rico / St. Croix", 0, 0,
        "Clarke 1866", "Greenwich",
        "Puerto_Rico", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=152400.3048006096 +y_0=30480.06096012192 +ellps=clrk");
    add_proj4text (p, 3,
        "66 +towgs84=11,72,-101,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Puerto Rico / St. Croix\",GEOGCS[\"Puerto Rico\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Puerto_Rico\",SPHEROID[\"Clarke 1866\",6378206.");
    add_srs_wkt (p, 2,
        "4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[11,72,-101,0,0,0,0],AUTHORITY[\"EPSG\",\"6139\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4139\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",17.8");
    add_srs_wkt (p, 8,
        "333333333333],PARAMETER[\"central_meridian\",-66.4333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_1\",18.43333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_2\",18.0333333333333],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",100000],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3992\"]]");
    p = add_epsg_def_ex (filter, first, last, 3994, "epsg", 3994,
        "WGS 84 / Mercator 41", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +datum=W");
    add_proj4text (p, 1,
        "GS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Mercator 41\",GEOGCS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Merc");
    add_srs_wkt (p, 6,
        "ator_2SP\"],PARAMETER[\"standard_parallel_1\",-41],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",100],PARAMETER[\"false_easting");
    add_srs_wkt (p, 8,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 9,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 10,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3994\"]]");
    p = add_epsg_def_ex (filter, first, last, 3995, "epsg", 3995,
        "WGS 84 / Arctic Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=71 +lon_0=0 +k=1 +x_0=0 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Arctic Polar Stereographic\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,");
    add_srs_wkt (p, 2,
        "298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",71],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 9,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 10,
        "sting\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"3995\"]]");
    p = add_epsg_def_ex (filter, first, last, 3996, "epsg", 3996,
        "WGS 84 / IBCAO Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=75 +lon_0=0 +k=1 +x_0=0 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / IBCAO Polar Stereographic\",GEOGCS[\"W");
    add_srs_wkt (p, 1,
        "GS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",75],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 9,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 10,
        "ting\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"3996\"]]");
    p = add_epsg_def_ex (filter, first, last, 3997, "epsg", 3997,
        "WGS 84 / Dubai Local TM", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=55.33333333333334 +k=1 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Dubai Local TM\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",55.3333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3997\"]]");
    p = add_epsg_def_ex (filter, first, last, 4001, "epsg", 4001,
        "Unknown datum based upon the Airy 1830 ellipsoid", 1, 1,
        "Airy 1830", "Greenwich",
        "Not_specified_based_on_Airy_1830_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Airy 1830 ellipsoi");
    add_srs_wkt (p, 1,
        "d\",DATUM[\"Not_specified_based_on_Airy_1830_ellipsoid\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Airy 1830\",6377563.396,299.3249646,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7001\"]],AUTHORITY[\"EPSG\",\"6001\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4001\"]]");
    p = add_epsg_def_ex (filter, first, last, 4002, "epsg", 4002,
        "Unknown datum based upon the Airy Modified 1849 ellipsoid", 1, 1,
        "Airy Modified 1849", "Greenwich",
        "Not_specified_based_on_Airy_Modified_1849_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=mod_airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Airy Modified 1849");
    add_srs_wkt (p, 1,
        " ellipsoid\",DATUM[\"Not_specified_based_on_Airy_Modifie");
    add_srs_wkt (p, 2,
        "d_1849_ellipsoid\",SPHEROID[\"Airy Modified 1849\",63773");
    add_srs_wkt (p, 3,
        "40.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6002\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4002\"]]");
    p = add_epsg_def_ex (filter, first, last, 4003, "epsg", 4003,
        "Unknown datum based upon the Australian National Spheroid", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Not_specified_based_on_Australian_National_Spheroid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Australian Nationa");
    add_srs_wkt (p, 1,
        "l Spheroid\",DATUM[\"Not_specified_based_on_Australian_N");
    add_srs_wkt (p, 2,
        "ational_Spheroid\",SPHEROID[\"Australian National Sphero");
    add_srs_wkt (p, 3,
        "id\",6378160,298.25,AUTHORITY[\"EPSG\",\"7003\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6003\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4003\"]]");
    p = add_epsg_def_ex (filter, first, last, 4004, "epsg", 4004,
        "Unknown datum based upon the Bessel 1841 ellipsoid", 1, 1,
        "Bessel 1841", "Greenwich",
        "Not_specified_based_on_Bessel_1841_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel 1841 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Bessel_1841_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6004\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4004\"]]");
    p = add_epsg_def_ex (filter, first, last, 4005, "epsg", 4005,
        "Unknown datum based upon the Bessel Modified ellipsoid", 1, 1,
        "Bessel Modified", "Greenwich",
        "Not_specified_based_on_Bessel_Modified_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel Modified el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Bessel_Modified");
    add_srs_wkt (p, 2,
        "_ellipsoid\",SPHEROID[\"Bessel Modified\",6377492.018,29");
    add_srs_wkt (p, 3,
        "9.1528128,AUTHORITY[\"EPSG\",\"7005\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6005\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4005\"]]");
    p = add_epsg_def_ex (filter, first, last, 4006, "epsg", 4006,
        "Unknown datum based upon the Bessel Namibia ellipsoid", 1, 1,
        "Bessel Namibia (GLM)", "Greenwich",
        "Not_specified_based_on_Bessel_Namibia_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bess_nam +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Bessel Namibia ell");
    add_srs_wkt (p, 1,
        "ipsoid\",DATUM[\"Not_specified_based_on_Bessel_Namibia_e");
    add_srs_wkt (p, 2,
        "llipsoid\",SPHEROID[\"Bessel Namibia (GLM)\",6377483.865");
    add_srs_wkt (p, 3,
        "28042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6006\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4006\"]]");
    p = add_epsg_def_ex (filter, first, last, 4007, "epsg", 4007,
        "Unknown datum based upon the Clarke 1858 ellipsoid", 1, 1,
        "Clarke 1858", "Greenwich",
        "Not_specified_based_on_Clarke_1858_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1858 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1858_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1858\",6378293.64520876,294.26067");
    add_srs_wkt (p, 3,
        "6369261,AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6007\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4007\"]]");
    p = add_epsg_def_ex (filter, first, last, 4008, "epsg", 4008,
        "Unknown datum based upon the Clarke 1866 ellipsoid", 1, 1,
        "Clarke 1866", "Greenwich",
        "Not_specified_based_on_Clarke_1866_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1866 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1866_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6008");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4008\"]]");
    p = add_epsg_def_ex (filter, first, last, 4009, "epsg", 4009,
        "Unknown datum based upon the Clarke 1866 Michigan ellipsoid (deprecated)", 1, 1,
        "Clarke 1866 Michigan", "Greenwich",
        "Not_specified_based_on_Clarke_1866_Michigan_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1866 Michig");
    add_srs_wkt (p, 1,
        "an ellipsoid (deprecated)\",DATUM[\"Not_specified_based_");
    add_srs_wkt (p, 2,
        "on_Clarke_1866_Michigan_ellipsoid\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 3,
        "66 Michigan\",6378450.04754889,294.978697164677,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",\"6009\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4009\"]]");
    p = add_epsg_def_ex (filter, first, last, 4010, "epsg", 4010,
        "Unknown datum based upon the Clarke 1880 (Benoit) ellipsoid", 1, 1,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Not_specified_based_on_Clarke_1880_Benoit_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300.789 +b=6356566.435 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (Benoi");
    add_srs_wkt (p, 1,
        "t) ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_188");
    add_srs_wkt (p, 2,
        "0_Benoit_ellipsoid\",SPHEROID[\"Clarke 1880 (Benoit)\",6");
    add_srs_wkt (p, 3,
        "378300.789,293.466315538981,AUTHORITY[\"EPSG\",\"7010\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6010\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"401");
    add_srs_wkt (p, 8,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 4011, "epsg", 4011,
        "Unknown datum based upon the Clarke 1880 (IGN) ellipsoid", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Not_specified_based_on_Clarke_1880_IGN_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (IGN) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_I");
    add_srs_wkt (p, 2,
        "GN_ellipsoid\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,");
    add_srs_wkt (p, 3,
        "293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6011\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4011\"]]");
    p = add_epsg_def_ex (filter, first, last, 4012, "epsg", 4012,
        "Unknown datum based upon the Clarke 1880 (RGS) ellipsoid", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Not_specified_based_on_Clarke_1880_RGS_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (RGS) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_R");
    add_srs_wkt (p, 2,
        "GS_ellipsoid\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6012\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4012\"]]");
    p = add_epsg_def_ex (filter, first, last, 4013, "epsg", 4013,
        "Unknown datum based upon the Clarke 1880 (Arc) ellipsoid", 1, 1,
        "Clarke 1880 (Arc)", "Greenwich",
        "Not_specified_based_on_Clarke_1880_Arc_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (Arc) ");
    add_srs_wkt (p, 1,
        "ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1880_A");
    add_srs_wkt (p, 2,
        "rc_ellipsoid\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6013\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4013\"]]");
    p = add_epsg_def_ex (filter, first, last, 4014, "epsg", 4014,
        "Unknown datum based upon the Clarke 1880 (SGA 1922) ellipsoid", 1, 1,
        "Clarke 1880 (SGA 1922)", "Greenwich",
        "Not_specified_based_on_Clarke_1880_SGA_1922_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356514.996941779 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 (SGA 1");
    add_srs_wkt (p, 1,
        "922) ellipsoid\",DATUM[\"Not_specified_based_on_Clarke_1");
    add_srs_wkt (p, 2,
        "880_SGA_1922_ellipsoid\",SPHEROID[\"Clarke 1880 (SGA 192");
    add_srs_wkt (p, 3,
        "2)\",6378249.2,293.46598,AUTHORITY[\"EPSG\",\"7014\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6014\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4014\"");
    add_srs_wkt (p, 8,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4015, "epsg", 4015,
        "Unknown datum based upon the Everest 1830 (1937 Adjustment) ellipsoid", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Not_specified_based_on_Everest_1830_1937_Adjustment_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1937");
    add_srs_wkt (p, 1,
        " Adjustment) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1937_Adjustment_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6015\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4015\"]]");
    p = add_epsg_def_ex (filter, first, last, 4016, "epsg", 4016,
        "Unknown datum based upon the Everest 1830 (1967 Definition) ellipsoid", 1, 1,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Not_specified_based_on_Everest_1830_1967_Definition_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=evrstSS +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1967");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1967_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1967 Definition)\",6377298.556,300.8017,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7016\"]],AUTHORITY[\"EPSG\",\"6016\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4016\"]]");
    p = add_epsg_def_ex (filter, first, last, 4017, "epsg", 4017,
        "MOLDREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "MOLDREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"MOLDREF99\",DATUM[\"MOLDREF");
    add_srs_wkt (p, 1,
        "99\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Moldova\"");
    add_srs_wkt (p, 9,
        "],BBOX[45.44,26.63,48.47,30.13]],ID[\"EPSG\",4017]]],TAR");
    add_srs_wkt (p, 10,
        "GETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 11,
        "1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTH");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 13,
        "egree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"la");
    add_srs_wkt (p, 14,
        "titude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 15,
        "5199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 16,
        "egree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGE");
    add_srs_wkt (p, 17,
        "DTRANSFORMATION[\"MOLDREF99 to WGS 84 (1)\",METHOD[\"Geo");
    add_srs_wkt (p, 18,
        "centric translations (geog2D domain)\",ID[\"EPSG\",9603]");
    add_srs_wkt (p, 19,
        "],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],");
    add_srs_wkt (p, 20,
        "PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PA");
    add_srs_wkt (p, 21,
        "RAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAG");
    add_srs_wkt (p, 22,
        "E[SCOPE[\"unknown\"],AREA[\"Moldova\"],BBOX[45.44,26.63,");
    add_srs_wkt (p, 23,
        "48.47,30.13]],ID[\"EPSG\",5585]]]");
    p = add_epsg_def_ex (filter, first, last, 4018, "epsg", 4018,
        "Unknown datum based upon the Everest 1830 Modified ellipsoid", 1, 1,
        "Everest 1830 Modified", "Greenwich",
        "Not_specified_based_on_Everest_1830_Modified_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377304.063 +b=6356103.038993155 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 Modif");
    add_srs_wkt (p, 1,
        "ied ellipsoid\",DATUM[\"Not_specified_based_on_Everest_1");
    add_srs_wkt (p, 2,
        "830_Modified_ellipsoid\",SPHEROID[\"Everest 1830 Modifie");
    add_srs_wkt (p, 3,
        "d\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6018\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4018\"");
    add_srs_wkt (p, 8,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4019, "epsg", 4019,
        "Unknown datum based upon the GRS 1980 ellipsoid", 1, 1,
        "GRS 1980", "Greenwich",
        "Not_specified_based_on_GRS_1980_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GRS 1980 ellipsoid");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Not_specified_based_on_GRS_1980_ellipsoid\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6019\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4019\"]]");
    p = add_epsg_def_ex (filter, first, last, 4020, "epsg", 4020,
        "Unknown datum based upon the Helmert 1906 ellipsoid", 1, 1,
        "Helmert 1906", "Greenwich",
        "Not_specified_based_on_Helmert_1906_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Helmert 1906 ellip");
    add_srs_wkt (p, 1,
        "soid\",DATUM[\"Not_specified_based_on_Helmert_1906_ellip");
    add_srs_wkt (p, 2,
        "soid\",SPHEROID[\"Helmert 1906\",6378200,298.3,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"6020\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4020\"]]");
    p = add_epsg_def_ex (filter, first, last, 4021, "epsg", 4021,
        "Unknown datum based upon the Indonesian National Spheroid", 1, 1,
        "Indonesian National Spheroid", "Greenwich",
        "Not_specified_based_on_Indonesian_National_Spheroid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Indonesian Nationa");
    add_srs_wkt (p, 1,
        "l Spheroid\",DATUM[\"Not_specified_based_on_Indonesian_N");
    add_srs_wkt (p, 2,
        "ational_Spheroid\",SPHEROID[\"Indonesian National Sphero");
    add_srs_wkt (p, 3,
        "id\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6021\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4021\"]]");
    p = add_epsg_def_ex (filter, first, last, 4022, "epsg", 4022,
        "Unknown datum based upon the International 1924 ellipsoid", 1, 1,
        "International 1924", "Greenwich",
        "Not_specified_based_on_International_1924_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the International 1924");
    add_srs_wkt (p, 1,
        " ellipsoid\",DATUM[\"Not_specified_based_on_Internationa");
    add_srs_wkt (p, 2,
        "l_1924_ellipsoid\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 3,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6022\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4022\"]]");
    p = add_epsg_def_ex (filter, first, last, 4023, "epsg", 4023,
        "MOLDREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "MOLDREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MOLDREF99\",DATUM[\"MOLDREF99\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1032\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4023\"]]");
    p = add_epsg_def_ex (filter, first, last, 4024, "epsg", 4024,
        "Unknown datum based upon the Krassowsky 1940 ellipsoid", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Not_specified_based_on_Krassowsky_1940_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Krassowsky 1940 el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Krassowsky_1940");
    add_srs_wkt (p, 2,
        "_ellipsoid\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6024\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4024\"]]");
    p = add_epsg_def_ex (filter, first, last, 4025, "epsg", 4025,
        "Unknown datum based upon the NWL 9D ellipsoid", 1, 1,
        "NWL 9D", "Greenwich",
        "Not_specified_based_on_NWL_9D_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the NWL 9D ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_NWL_9D_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"NWL 9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7025\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6025\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"40");
    add_srs_wkt (p, 7,
        "25\"]]");
    p = add_epsg_def_ex (filter, first, last, 4026, "epsg", 4026,
        "MOLDREF99 / Moldova TM", 0, 1,
        "GRS 1980", "Greenwich",
        "MOLDREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.4 +k=0.9999400000000001 +");
    add_proj4text (p, 1,
        "x_0=200000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MOLDREF99 / Moldova TM\",GEOGCS[\"MOLDREF99\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"MOLDREF99\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1032\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4023\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",28.4],PARAMETER[\"scale_factor\",0.99994],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",200000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"4026\"]]");
    p = add_epsg_def_ex (filter, first, last, 4027, "epsg", 4027,
        "Unknown datum based upon the Plessis 1817 ellipsoid", 1, 1,
        "Plessis 1817", "Greenwich",
        "Not_specified_based_on_Plessis_1817_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Plessis 1817 ellip");
    add_srs_wkt (p, 1,
        "soid\",DATUM[\"Not_specified_based_on_Plessis_1817_ellip");
    add_srs_wkt (p, 2,
        "soid\",SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6027\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4027\"]]");
    p = add_epsg_def_ex (filter, first, last, 4028, "epsg", 4028,
        "Unknown datum based upon the Struve 1860 ellipsoid", 1, 1,
        "Struve 1860", "Greenwich",
        "Not_specified_based_on_Struve_1860_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378298.3 +b=6356657.142669561 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Struve 1860 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Struve_1860_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Struve 1860\",6378298.3,294.73,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7028\"]],AUTHORITY[\"EPSG\",\"6028\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4028\"]]");
    p = add_epsg_def_ex (filter, first, last, 4029, "epsg", 4029,
        "Unknown datum based upon the War Office ellipsoid", 1, 1,
        "War Office", "Greenwich",
        "Not_specified_based_on_War_Office_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the War Office ellipso");
    add_srs_wkt (p, 1,
        "id\",DATUM[\"Not_specified_based_on_War_Office_ellipsoid");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7029\"]],AUTHORITY[\"EPSG\",\"6029\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4029\"]]");
    p = add_epsg_def_ex (filter, first, last, 4030, "epsg", 4030,
        "Unknown datum based upon the WGS 84 ellipsoid", 1, 1,
        "WGS 84", "Greenwich",
        "Not_specified_based_on_WGS_84_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the WGS 84 ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_WGS_84_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7030\"]],AUTHORITY[\"EPSG\",\"6030\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4030\"]]");
    p = add_epsg_def_ex (filter, first, last, 4031, "epsg", 4031,
        "Unknown datum based upon the GEM 10C ellipsoid", 1, 1,
        "GEM 10C", "Greenwich",
        "Not_specified_based_on_GEM_10C_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GEM 10C ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_GEM_10C_ellipsoid\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GEM 10C\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7031\"]],AUTHORITY[\"EPSG\",\"6031\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4031\"]]");
    p = add_epsg_def_ex (filter, first, last, 4032, "epsg", 4032,
        "Unknown datum based upon the OSU86F ellipsoid", 1, 1,
        "OSU86F", "Greenwich",
        "Not_specified_based_on_OSU86F_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.2 +b=6356751.516927429 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the OSU86F ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_OSU86F_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"OSU86F\",6378136.2,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7032\"]],AUTHORITY[\"EPSG\",\"6032\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4032\"]]");
    p = add_epsg_def_ex (filter, first, last, 4033, "epsg", 4033,
        "Unknown datum based upon the OSU91A ellipsoid", 1, 1,
        "OSU91A", "Greenwich",
        "Not_specified_based_on_OSU91A_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.3 +b=6356751.616592146 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the OSU91A ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_OSU91A_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"OSU91A\",6378136.3,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7033\"]],AUTHORITY[\"EPSG\",\"6033\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4033\"]]");
    p = add_epsg_def_ex (filter, first, last, 4034, "epsg", 4034,
        "Unknown datum based upon the Clarke 1880 ellipsoid", 1, 1,
        "Clarke 1880", "Greenwich",
        "Not_specified_based_on_Clarke_1880_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Clarke 1880 ellips");
    add_srs_wkt (p, 1,
        "oid\",DATUM[\"Not_specified_based_on_Clarke_1880_ellipso");
    add_srs_wkt (p, 2,
        "id\",SPHEROID[\"Clarke 1880\",6378249.14480801,293.46630");
    add_srs_wkt (p, 3,
        "7655636,AUTHORITY[\"EPSG\",\"7034\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6034\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4034\"]]");
    p = add_epsg_def_ex (filter, first, last, 4035, "epsg", 4035,
        "Unspecified datum based upon the GRS 1980 Authalic Sphere", 1, 1,
        "GRS 1980 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_GRS_1980_Authalic_Sphere", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371000 +b=6371000 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the GRS 1980 Autha");
    add_srs_wkt (p, 1,
        "lic Sphere\",DATUM[\"Not_specified_based_on_GRS_1980_Aut");
    add_srs_wkt (p, 2,
        "halic_Sphere\",SPHEROID[\"GRS 1980 Authalic Sphere\",637");
    add_srs_wkt (p, 3,
        "1007,0,AUTHORITY[\"EPSG\",\"7048\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4047\"]]");
    p = add_epsg_def_ex (filter, first, last, 4036, "epsg", 4036,
        "Unknown datum based upon the GRS 1967 ellipsoid", 1, 1,
        "GRS 1967", "Greenwich",
        "Not_specified_based_on_GRS_1967_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the GRS 1967 ellipsoid");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Not_specified_based_on_GRS_1967_ellipsoid\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1967\",6378160,298.247167427,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7036\"]],AUTHORITY[\"EPSG\",\"6036\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4036\"]]");
    p = add_epsg_def_ex (filter, first, last, 4037, "epsg", 4037,
        "WGS 84 / TMzn35N", 0, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TMzn35N\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AUTHORITY[\"EPSG\",\"4037\"]]");
    p = add_epsg_def_ex (filter, first, last, 4038, "epsg", 4038,
        "WGS 84 / TMzn36N", 0, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TMzn36N\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",33],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AUTHORITY[\"EPSG\",\"4038\"]]");
    p = add_epsg_def_ex (filter, first, last, 4040, "epsg", 4040,
        "RGRDC 2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGRDC 2005\",DATUM[\"Reseau");
    add_srs_wkt (p, 1,
        " Geodesique de la RDC 2005\",ELLIPSOID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gre");
    add_srs_wkt (p, 3,
        "enwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[");
    add_srs_wkt (p, 4,
        "ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,OR");
    add_srs_wkt (p, 5,
        "DER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 6,
        "geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)");
    add_srs_wkt (p, 8,
        "\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 9,
        "known\"],AREA[\"Congo DR (Zaire) - south\"],BBOX[-13.46,");
    add_srs_wkt (p, 10,
        "11.79,-3.41,29.81]],ID[\"EPSG\",4040]]],TARGETCRS[GEOGCR");
    add_srs_wkt (p, 11,
        "S[\"WGS 84\",DATUM[\"World Geodetic System 1984\",ELLIPS");
    add_srs_wkt (p, 12,
        "OID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 14,
        "532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north");
    add_srs_wkt (p, 15,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 16,
        "[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 17,
        "532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATIO");
    add_srs_wkt (p, 18,
        "N[\"RGRDC 2005 to WGS 84 (1)\",METHOD[\"Geocentric trans");
    add_srs_wkt (p, 19,
        "lations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"");
    add_srs_wkt (p, 20,
        "X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-");
    add_srs_wkt (p, 21,
        "axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-ax");
    add_srs_wkt (p, 22,
        "is translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 23,
        "own\"],AREA[\"Congo DR (Zaire) - south\"],BBOX[-13.46,11");
    add_srs_wkt (p, 24,
        ".79,-3.41,29.81]],ID[\"EPSG\",4064]]]");
    p = add_epsg_def_ex (filter, first, last, 4041, "epsg", 4041,
        "Unknown datum based upon the Average Terrestrial System 1977 ellipsoid", 1, 1,
        "Average Terrestrial System 1977", "Greenwich",
        "Not_specified_based_on_Average_Terrestrial_System_1977_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Average Terrestria");
    add_srs_wkt (p, 1,
        "l System 1977 ellipsoid\",DATUM[\"Not_specified_based_on");
    add_srs_wkt (p, 2,
        "_Average_Terrestrial_System_1977_ellipsoid\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6041\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4041\"]]");
    p = add_epsg_def_ex (filter, first, last, 4042, "epsg", 4042,
        "Unknown datum based upon the Everest (1830 Definition) ellipsoid", 1, 1,
        "Everest (1830 Definition)", "Greenwich",
        "Not_specified_based_on_Everest_1830_Definition_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest (1830 Defi");
    add_srs_wkt (p, 1,
        "nition) ellipsoid\",DATUM[\"Not_specified_based_on_Evere");
    add_srs_wkt (p, 2,
        "st_1830_Definition_ellipsoid\",SPHEROID[\"Everest (1830 ");
    add_srs_wkt (p, 3,
        "Definition)\",6377299.36559538,300.801725543368,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6042\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4042\"]]");
    p = add_epsg_def_ex (filter, first, last, 4043, "epsg", 4043,
        "Unknown datum based upon the WGS 72 ellipsoid", 1, 1,
        "WGS 72", "Greenwich",
        "Not_specified_based_on_WGS_72_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the WGS 72 ellipsoid\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Not_specified_based_on_WGS_72_ellipsoid\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6043\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"40");
    add_srs_wkt (p, 7,
        "43\"]]");
    p = add_epsg_def_ex (filter, first, last, 4044, "epsg", 4044,
        "Unknown datum based upon the Everest 1830 (1962 Definition) ellipsoid", 1, 1,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Not_specified_based_on_Everest_1830_1962_Definition_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377301.243 +b=6356100.230165384 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1962");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1962_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1962 Definition)\",6377301.243,300.8017255,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6044\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 8,
        ",AUTHORITY[\"EPSG\",\"4044\"]]");
    p = add_epsg_def_ex (filter, first, last, 4045, "epsg", 4045,
        "Unknown datum based upon the Everest 1830 (1975 Definition) ellipsoid", 1, 1,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Not_specified_based_on_Everest_1830_1975_Definition_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.151 +b=6356098.145120132 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unknown datum based upon the Everest 1830 (1975");
    add_srs_wkt (p, 1,
        " Definition) ellipsoid\",DATUM[\"Not_specified_based_on_");
    add_srs_wkt (p, 2,
        "Everest_1830_1975_Definition_ellipsoid\",SPHEROID[\"Ever");
    add_srs_wkt (p, 3,
        "est 1830 (1975 Definition)\",6377299.151,300.8017255,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6045\"]]");
    add_srs_wkt (p, 5,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 6,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 7,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 8,
        ",AUTHORITY[\"EPSG\",\"4045\"]]");
    p = add_epsg_def_ex (filter, first, last, 4046, "epsg", 4046,
        "RGRDC 2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGRDC 2005\",DATUM[\"Reseau_Geodesique_de_la_RD");
    add_srs_wkt (p, 1,
        "C_2005\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4046\"]]");
    p = add_epsg_def_ex (filter, first, last, 4047, "epsg", 4047,
        "Unspecified datum based upon the GRS 1980 Authalic Sphere", 1, 1,
        "GRS 1980 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_GRS_1980_Authalic_Sphere", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371007 +b=6371007 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the GRS 1980 Autha");
    add_srs_wkt (p, 1,
        "lic Sphere\",DATUM[\"Not_specified_based_on_GRS_1980_Aut");
    add_srs_wkt (p, 2,
        "halic_Sphere\",SPHEROID[\"GRS 1980 Authalic Sphere\",637");
    add_srs_wkt (p, 3,
        "1007,0,AUTHORITY[\"EPSG\",\"7048\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4047\"]]");
    p = add_epsg_def_ex (filter, first, last, 4048, "epsg", 4048,
        "RGRDC 2005 / Congo TM zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 12\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4048\"]]");
    p = add_epsg_def_ex (filter, first, last, 4049, "epsg", 4049,
        "RGRDC 2005 / Congo TM zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 14\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",14],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4049\"]]");
    p = add_epsg_def_ex (filter, first, last, 4050, "epsg", 4050,
        "RGRDC 2005 / Congo TM zone 16", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 16\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",16],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4050\"]]");
    p = add_epsg_def_ex (filter, first, last, 4051, "epsg", 4051,
        "RGRDC 2005 / Congo TM zone 18", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 18\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",18],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4051\"]]");
    p = add_epsg_def_ex (filter, first, last, 4052, "epsg", 4052,
        "Unspecified datum based upon the Clarke 1866 Authalic Sphere", 1, 1,
        "Clarke 1866 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_Clarke_1866_Authalic_Sphere", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6370997 +b=6370997 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the Clarke 1866 Au");
    add_srs_wkt (p, 1,
        "thalic Sphere\",DATUM[\"Not_specified_based_on_Clarke_18");
    add_srs_wkt (p, 2,
        "66_Authalic_Sphere\",SPHEROID[\"Clarke 1866 Authalic Sph");
    add_srs_wkt (p, 3,
        "ere\",6370997,0,AUTHORITY[\"EPSG\",\"7052\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6052\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4052\"]]");
    p = add_epsg_def_ex (filter, first, last, 4053, "epsg", 4053,
        "Unspecified datum based upon the International 1924 Authalic Sphere", 1, 1,
        "International 1924 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_International_1924_Authalic_Sphere", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6371228 +b=6371228 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the International ");
    add_srs_wkt (p, 1,
        "1924 Authalic Sphere\",DATUM[\"Not_specified_based_on_In");
    add_srs_wkt (p, 2,
        "ternational_1924_Authalic_Sphere\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 3,
        "nal 1924 Authalic Sphere\",6371228,0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"7057\"]],AUTHORITY[\"EPSG\",\"6053\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4053\"]]");
    p = add_epsg_def_ex (filter, first, last, 4054, "epsg", 4054,
        "Unspecified datum based upon the Hughes 1980 ellipsoid", 1, 1,
        "Hughes 1980", "Greenwich",
        "Not_specified_based_on_Hughes_1980_ellipsoid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378273 +b=6356889.449 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Unspecified datum based upon the Hughes 1980 el");
    add_srs_wkt (p, 1,
        "lipsoid\",DATUM[\"Not_specified_based_on_Hughes_1980_ell");
    add_srs_wkt (p, 2,
        "ipsoid\",SPHEROID[\"Hughes 1980\",6378273,298.2794111230");
    add_srs_wkt (p, 3,
        "64,AUTHORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"60");
    add_srs_wkt (p, 4,
        "54\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4054\"]]");
    p = add_epsg_def_ex (filter, first, last, 4055, "epsg", 4055,
        "Popular Visualisation CRS (deprecated)", 1, 1,
        "Popular Visualisation Sphere", "Greenwich",
        "Popular_Visualisation_Datum", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Popular Visualisation CRS (deprecated)\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Popular_Visualisation_Datum\",SPHEROID[\"Popular Visua");
    add_srs_wkt (p, 2,
        "lisation Sphere\",6378137,0,AUTHORITY[\"EPSG\",\"7059\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6055\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"405");
    add_srs_wkt (p, 7,
        "5\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

