/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_11 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 3140, "epsg", 3140,
        "Viti Levu 1912 / Viti Levu Grid", 0, 1,
        "Clarke 1880 (international foot)", "Greenwich",
        "Viti_Levu_1912", "Cassini_Soldner", "link",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=-18 +lon_0=178 +x_0=109435.392 +y_0=14");
    add_proj4text (p, 1,
        "1622.272 +a=6378306.3696 +b=6356571.996 +towgs84=98,390,");
    add_proj4text (p, 2,
        "-22,0,0,0,0 +units=link +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Viti Levu 1912 / Viti Levu Grid\",GEOGCS[\"Viti");
    add_srs_wkt (p, 1,
        " Levu 1912\",DATUM[\"Viti_Levu_1912\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (international foot)\",6378306.3696,293.46630765563");
    add_srs_wkt (p, 3,
        "5,AUTHORITY[\"EPSG\",\"7055\"]],TOWGS84[98,390,-22,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6752\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4752\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"latitude_of_origin\",-18],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",178],PARAMETER[\"false_easting\",544000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",704000],UNIT[\"link\",0.201168,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9098\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"3140\"]]");
    p = add_epsg_def_ex (filter, first, last, 3141, "epsg", 3141,
        "Fiji 1956 / UTM zone 60S", 0, 0,
        "International 1924", "Greenwich",
        "Fiji_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=265.025,3");
    add_proj4text (p, 1,
        "84.929,-194.046,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1956 / UTM zone 60S\",GEOGCS[\"Fiji 1956\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Fiji_1956\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[265.025,3");
    add_srs_wkt (p, 3,
        "84.929,-194.046,0,0,0,0],AUTHORITY[\"EPSG\",\"6721\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4721\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",177],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3141\"]]");
    p = add_epsg_def_ex (filter, first, last, 3142, "epsg", 3142,
        "Fiji 1956 / UTM zone 1S", 0, 0,
        "International 1924", "Greenwich",
        "Fiji_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=intl +towgs84=265.025,38");
    add_proj4text (p, 1,
        "4.929,-194.046,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1956 / UTM zone 1S\",GEOGCS[\"Fiji 1956\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Fiji_1956\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[265.025,38");
    add_srs_wkt (p, 3,
        "4.929,-194.046,0,0,0,0],AUTHORITY[\"EPSG\",\"6721\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4721\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-177],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3142\"]]");
    p = add_epsg_def_ex (filter, first, last, 3143, "epsg", 3143,
        "Fiji 1986 / Fiji Map Grid", 0, 0,
        "WGS 72", "Greenwich",
        "Fiji_Geodetic_Datum_1986", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=200");
    add_proj4text (p, 1,
        "0000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 2,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1986 / Fiji Map Grid\",GEOGCS[\"Fiji 1986\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Fiji_Geodetic_Datum_1986\",SPHEROID[\"WGS 72\",");
    add_srs_wkt (p, 2,
        "6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",4.5,0,0,0.554,0.2263],AUTHORITY[\"EPSG\",\"6720\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4720\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",-17],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",178.75],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.99985],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",4000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"3460\"]]");
    p = add_epsg_def_ex (filter, first, last, 3146, "epsg", 3146,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 6 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 6 (de");
    add_srs_wkt (p, 1,
        "precated)\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",18],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",6500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"3146\"]]");
    p = add_epsg_def_ex (filter, first, last, 3147, "epsg", 3147,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 18E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 18E (de");
    add_srs_wkt (p, 1,
        "precated)\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",18],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"3147\"]]");
    p = add_epsg_def_ex (filter, first, last, 3148, "epsg", 3148,
        "Indian 1960 / UTM zone 48N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=198,881,317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "60\",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6131\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4131\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3148\"]]");
    p = add_epsg_def_ex (filter, first, last, 3149, "epsg", 3149,
        "Indian 1960 / UTM zone 49N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=198,881,317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / UTM zone 49N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "60\",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6131\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4131\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3149\"]]");
    p = add_epsg_def_ex (filter, first, last, 3150, "epsg", 3150,
        "Pulkovo 1995 / 3-degree Gauss-Kruger zone 6 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 6 (de");
    add_srs_wkt (p, 1,
        "precated)\",GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.1");
    add_srs_wkt (p, 4,
        "3,-0.22],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",18],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",6500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3150\"]]");
    p = add_epsg_def_ex (filter, first, last, 3151, "epsg", 3151,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 18E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 18E (de");
    add_srs_wkt (p, 1,
        "precated)\",GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.1");
    add_srs_wkt (p, 4,
        "3,-0.22],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4200\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",18],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3151\"]]");
    p = add_epsg_def_ex (filter, first, last, 3152, "epsg", 3152,
        "ST74", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.05779 +k=0.99999425 +x_0=");
    add_proj4text (p, 1,
        "100178.1808 +y_0=-6500614.7836 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ST74\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",18.05779],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.99999425],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",100178.1808],PARAMETER[\"false_northing\",-6500614");
    add_srs_wkt (p, 10,
        ".7836],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"3152\"]]");
    p = add_epsg_def_ex (filter, first, last, 3153, "epsg", 3153,
        "NAD83(CSRS) / BC Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / BC Albers\",GEOGCS[\"NAD83(CSRS)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Albers_Conic_Equal_Area\"],PARAMETER[\"latitude_of_cen");
    add_srs_wkt (p, 8,
        "ter\",45],PARAMETER[\"longitude_of_center\",-126],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_1\",50],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",58.5],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3153\"]]");
    p = add_epsg_def_ex (filter, first, last, 3154, "epsg", 3154,
        "NAD83(CSRS) / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 7N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-141],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3154\"]]");
    p = add_epsg_def_ex (filter, first, last, 3155, "epsg", 3155,
        "NAD83(CSRS) / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 8N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-135],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3155\"]]");
    p = add_epsg_def_ex (filter, first, last, 3156, "epsg", 3156,
        "NAD83(CSRS) / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 9N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-129],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3156\"]]");
    p = add_epsg_def_ex (filter, first, last, 3157, "epsg", 3157,
        "NAD83(CSRS) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 10N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-123],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3157\"]]");
    p = add_epsg_def_ex (filter, first, last, 3158, "epsg", 3158,
        "NAD83(CSRS) / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 14N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-99],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3158\"]]");
    p = add_epsg_def_ex (filter, first, last, 3159, "epsg", 3159,
        "NAD83(CSRS) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 15N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-93],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3159\"]]");
    p = add_epsg_def_ex (filter, first, last, 3160, "epsg", 3160,
        "NAD83(CSRS) / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 16N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-87],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3160\"]]");
    p = add_epsg_def_ex (filter, first, last, 3161, "epsg", 3161,
        "NAD83 / Ontario MNR Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x");
    add_proj4text (p, 1,
        "_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ontario MNR Lambert\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-85],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",44.5],PARAMETER[\"standard_parallel_2\",53.5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",930000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",6430000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"3161\"]]");
    p = add_epsg_def_ex (filter, first, last, 3162, "epsg", 3162,
        "NAD83(CSRS) / Ontario MNR Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x");
    add_proj4text (p, 1,
        "_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Ontario MNR Lambert\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "85],PARAMETER[\"standard_parallel_1\",44.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",53.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "930000],PARAMETER[\"false_northing\",6430000],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3162\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3163, "epsg", 3163,
        "RGNC91-93 / Lambert New Caledonia", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / Lambert New Caledonia\",GEOGCS[\"RG");
    add_srs_wkt (p, 1,
        "NC91-93\",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledoni");
    add_srs_wkt (p, 2,
        "e_91_93\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",-21.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",166],PARAMETER[\"standard_parallel_1\",-20.66666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"standard_parallel_2\",-22.33333333");
    add_srs_wkt (p, 11,
        "33333],PARAMETER[\"false_easting\",400000],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"3163\"]]");
    p = add_epsg_def_ex (filter, first, last, 3164, "epsg", 3164,
        "ST87 Ouvea / UTM zone 58S", 0, 0,
        "WGS 84", "Greenwich",
        "ST87_Ouvea", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,");
    add_proj4text (p, 1,
        "16.136,-22.856,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ST87 Ouvea / UTM zone 58S\",GEOGCS[\"ST87 Ouvea");
    add_srs_wkt (p, 1,
        "\",DATUM[\"ST87_Ouvea\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-56.263,");
    add_srs_wkt (p, 3,
        "16.136,-22.856,0,0,0,0],AUTHORITY[\"EPSG\",\"6750\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4750\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",165],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3164\"]]");
    p = add_epsg_def_ex (filter, first, last, 3165, "epsg", 3165,
        "NEA74 Noumea / Noumea Lambert", 0, 0,
        "International 1924", "Greenwich",
        "NEA74_Noumea", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0");
    add_proj4text (p, 1,
        "=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +e");
    add_proj4text (p, 2,
        "llps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NEA74 Noumea / Noumea Lambert\",GEOGCS[\"NEA74 ");
    add_srs_wkt (p, 1,
        "Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-10.18,-350.43,291.37,0,0,0,0],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 4,
        "44\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4644\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",-22.26969175],PARAMETER[\"central_meridian\",166.");
    add_srs_wkt (p, 9,
        "44242575],PARAMETER[\"standard_parallel_1\",-22.24469175");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",-22.29469175],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",0.66],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",1.02],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"3165\"]]");
    p = add_epsg_def_ex (filter, first, last, 3166, "epsg", 3166,
        "NEA74 Noumea / Noumea Lambert 2", 0, 0,
        "International 1924", "Greenwich",
        "NEA74_Noumea", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.294722222");
    add_proj4text (p, 1,
        "22222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.3");
    add_proj4text (p, 2,
        "13000000000001 +y_0=-2.354 +ellps=intl +towgs84=-10.18,-");
    add_proj4text (p, 3,
        "350.43,291.37,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NEA74 Noumea / Noumea Lambert 2\",GEOGCS[\"NEA7");
    add_srs_wkt (p, 1,
        "4 Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-10.18,-350.43,291.37,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6644\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4644\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",-22.2697222222222],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",166.4425],PARAMETER[\"standard_parallel_1\",-22.2447");
    add_srs_wkt (p, 10,
        "222222222],PARAMETER[\"standard_parallel_2\",-22.2947222");
    add_srs_wkt (p, 11,
        "222222],PARAMETER[\"false_easting\",8.313],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",-2.354],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"3166\"]]");
    p = add_epsg_def_ex (filter, first, last, 3167, "epsg", 3167,
        "Kertau (RSO) / RSO Malaya (ch)", 0, 0,
        "Everest 1830 (RSO 1969)", "Greenwich",
        "Kertau_RSO", "Hotine_Oblique_Mercator", "British chain (Sears 1922 truncated)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=40000 +y_0=0 +no_uoff +gamma=323.1301023611");
    add_proj4text (p, 2,
        "111 +a=6377295.664 +b=6356094.667915204 +to_meter=20.116");
    add_proj4text (p, 3,
        "756 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau (RSO) / RSO Malaya (ch)\",GEOGCS[\"Kerta");
    add_srs_wkt (p, 1,
        "u (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"Everest 1830 (");
    add_srs_wkt (p, 2,
        "RSO 1969)\",6377295.664,300.8017,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "56\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4751\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",102.25],PARAMETER[\"azimuth\",323.0257905]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"rectified_grid_angle\",323.130102361111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",40000],PARAMETER[\"false_northing\",0],UNIT[\"Brit");
    add_srs_wkt (p, 12,
        "ish chain (Sears 1922 truncated)\",20.116756,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9301\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3167\"]]");
    p = add_epsg_def_ex (filter, first, last, 3168, "epsg", 3168,
        "Kertau (RSO) / RSO Malaya (m)", 0, 0,
        "Everest 1830 (RSO 1969)", "Greenwich",
        "Kertau_RSO", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804670.24 +y_0=0 +no_uoff +gamma=323.130102");
    add_proj4text (p, 2,
        "3611111 +a=6377295.664 +b=6356094.667915204 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau (RSO) / RSO Malaya (m)\",GEOGCS[\"Kertau");
    add_srs_wkt (p, 1,
        " (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"Everest 1830 (R");
    add_srs_wkt (p, 2,
        "SO 1969)\",6377295.664,300.8017,AUTHORITY[\"EPSG\",\"705");
    add_srs_wkt (p, 3,
        "6\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4751\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",102.25],PARAMETER[\"azimuth\",323.0257905]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"rectified_grid_angle\",323.130102361111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",804670.24],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"316");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3169, "epsg", 3169,
        "RGNC91-93 / UTM zone 57S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 57S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",159],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3169\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3170, "epsg", 3170,
        "RGNC91-93 / UTM zone 58S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 58S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",165],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3170\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3171, "epsg", 3171,
        "RGNC91-93 / UTM zone 59S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 59S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",171],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3171\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 3172, "epsg", 3172,
        "IGN53 Mare / UTM zone 59S", 0, 0,
        "International 1924", "Greenwich",
        "IGN53_Mare", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=287.58,17");
    add_proj4text (p, 1,
        "7.78,-135.41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN53 Mare / UTM zone 59S\",GEOGCS[\"IGN53 Mare");
    add_srs_wkt (p, 1,
        "\",DATUM[\"IGN53_Mare\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[287.58");
    add_srs_wkt (p, 3,
        ",177.78,-135.41,0,0,0,0],AUTHORITY[\"EPSG\",\"6641\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4641\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",171],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3172\"]]");
    p = add_epsg_def_ex (filter, first, last, 3174, "epsg", 3174,
        "NAD83 / Great Lakes Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568");
    add_proj4text (p, 1,
        "977 +lon_0=-84.455955 +x_0=1000000 +y_0=1000000 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Great Lakes Albers\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_");
    add_srs_wkt (p, 7,
        "Equal_Area\"],PARAMETER[\"latitude_of_center\",45.568977");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"longitude_of_center\",-84.455955],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",42.122774],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",49.01518],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3174\"]]");
    p = add_epsg_def_ex (filter, first, last, 3175, "epsg", 3175,
        "NAD83 / Great Lakes and St Lawrence Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568");
    add_proj4text (p, 1,
        "977 +lon_0=-83.248627 +x_0=1000000 +y_0=1000000 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Great Lakes and St Lawrence Albers\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Albers_Conic_Equal_Area\"],PARAMETER[\"latitude_of_cen");
    add_srs_wkt (p, 8,
        "ter\",45.568977],PARAMETER[\"longitude_of_center\",-83.2");
    add_srs_wkt (p, 9,
        "48627],PARAMETER[\"standard_parallel_1\",42.122774],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",49.01518],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"3175\"]]");
    p = add_epsg_def_ex (filter, first, last, 3176, "epsg", 3176,
        "Indian 1960 / TM 106 NE", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881");
    add_proj4text (p, 2,
        ",317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / TM 106 NE\",GEOGCS[\"Indian 1960\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937 Adj");
    add_srs_wkt (p, 2,
        "ustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6131\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4131\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",106],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"3176\"]]");
    p = add_epsg_def_ex (filter, first, last, 3177, "epsg", 3177,
        "LGD2006 / Libya TM", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9965000000000001 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=0 +ellps=intl +towgs84=-208.4058,-109.877");
    add_proj4text (p, 2,
        "7,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM\",GEOGCS[\"LGD2006\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Libyan_Geodetic_Datum_2006\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",17],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9965],PARAMETER[\"false_easting\",1000000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3177\"]]");
    p = add_epsg_def_ex (filter, first, last, 3178, "epsg", 3178,
        "GR96 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 18N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3178\"]]");
    p = add_epsg_def_ex (filter, first, last, 3179, "epsg", 3179,
        "GR96 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 19N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3179\"]]");
    p = add_epsg_def_ex (filter, first, last, 3180, "epsg", 3180,
        "GR96 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 20N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3180\"]]");
    p = add_epsg_def_ex (filter, first, last, 3181, "epsg", 3181,
        "GR96 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 21N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3181\"]]");
    p = add_epsg_def_ex (filter, first, last, 3182, "epsg", 3182,
        "GR96 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 22N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3182\"]]");
    p = add_epsg_def_ex (filter, first, last, 3183, "epsg", 3183,
        "GR96 / UTM zone 23N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 23N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3183\"]]");
    p = add_epsg_def_ex (filter, first, last, 3184, "epsg", 3184,
        "GR96 / UTM zone 24N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 24N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3184\"]]");
    p = add_epsg_def_ex (filter, first, last, 3185, "epsg", 3185,
        "GR96 / UTM zone 25N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 25N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3185\"]]");
    p = add_epsg_def_ex (filter, first, last, 3186, "epsg", 3186,
        "GR96 / UTM zone 26N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 26N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3186\"]]");
    p = add_epsg_def_ex (filter, first, last, 3187, "epsg", 3187,
        "GR96 / UTM zone 27N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 27N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3187\"]]");
    p = add_epsg_def_ex (filter, first, last, 3188, "epsg", 3188,
        "GR96 / UTM zone 28N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 28N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3188\"]]");
    p = add_epsg_def_ex (filter, first, last, 3189, "epsg", 3189,
        "GR96 / UTM zone 29N", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 29N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3189\"]]");
    p = add_epsg_def_ex (filter, first, last, 3190, "epsg", 3190,
        "LGD2006 / Libya TM zone 5", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99995 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 5\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",9],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3190\"]]");
    p = add_epsg_def_ex (filter, first, last, 3191, "epsg", 3191,
        "LGD2006 / Libya TM zone 6", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 6\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",11],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3191\"]]");
    p = add_epsg_def_ex (filter, first, last, 3192, "epsg", 3192,
        "LGD2006 / Libya TM zone 7", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 7\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",13],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3192\"]]");
    p = add_epsg_def_ex (filter, first, last, 3193, "epsg", 3193,
        "LGD2006 / Libya TM zone 8", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 8\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3193\"]]");
    p = add_epsg_def_ex (filter, first, last, 3194, "epsg", 3194,
        "LGD2006 / Libya TM zone 9", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 9\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",17],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3194\"]]");
    p = add_epsg_def_ex (filter, first, last, 3195, "epsg", 3195,
        "LGD2006 / Libya TM zone 10", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 10\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",19],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3195\"]]");
    p = add_epsg_def_ex (filter, first, last, 3196, "epsg", 3196,
        "LGD2006 / Libya TM zone 11", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 11\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3196\"]]");
    p = add_epsg_def_ex (filter, first, last, 3197, "epsg", 3197,
        "LGD2006 / Libya TM zone 12", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 12\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",23],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3197\"]]");
    p = add_epsg_def_ex (filter, first, last, 3198, "epsg", 3198,
        "LGD2006 / Libya TM zone 13", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.4058,-109.8777,-2.5764,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 13\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",25],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3198\"]]");
    p = add_epsg_def_ex (filter, first, last, 3199, "epsg", 3199,
        "LGD2006 / UTM zone 32N", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-208.4058,-109.8");
    add_proj4text (p, 1,
        "777,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 32N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3199\"]]");
    p = add_epsg_def_ex (filter, first, last, 3200, "epsg", 3200,
        "FD58 / Iraq zone", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Final_Datum_1958", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-241.54,-163.64,396.06,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FD58 / Iraq zone\",GEOGCS[\"FD58\",DATUM[\"Fina");
    add_srs_wkt (p, 1,
        "l_Datum_1958\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6132\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4132\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 7,
        "de_of_origin\",32.5],PARAMETER[\"central_meridian\",45],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9987864078],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1500000],PARAMETER[\"false_northing\",11662");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3200\"]]");
    p = add_epsg_def_ex (filter, first, last, 3201, "epsg", 3201,
        "LGD2006 / UTM zone 33N", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-208.4058,-109.8");
    add_proj4text (p, 1,
        "777,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 33N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3201\"]]");
    p = add_epsg_def_ex (filter, first, last, 3202, "epsg", 3202,
        "LGD2006 / UTM zone 34N", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-208.4058,-109.8");
    add_proj4text (p, 1,
        "777,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 34N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",21],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3202\"]]");
    p = add_epsg_def_ex (filter, first, last, 3203, "epsg", 3203,
        "LGD2006 / UTM zone 35N", 0, 0,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-208.4058,-109.8");
    add_proj4text (p, 1,
        "777,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 35N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.4058,-109.8777,-2.5764,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",27],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3203\"]]");
    p = add_epsg_def_ex (filter, first, last, 3204, "epsg", 3204,
        "WGS 84 / SCAR IMW SP19-20", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-66],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-60.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-63.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 13,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 3205, "epsg", 3205,
        "WGS 84 / SCAR IMW SP21-22", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP21-22\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-54],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-60.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-63.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 3206, "epsg", 3206,
        "WGS 84 / SCAR IMW SP23-24", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-42 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP23-24\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-42],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-60.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-63.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 3207, "epsg", 3207,
        "WGS 84 / SCAR IMW SQ01-02", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-174 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ01-02\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-174],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",-64.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "207\"]]");
    p = add_epsg_def_ex (filter, first, last, 3208, "epsg", 3208,
        "WGS 84 / SCAR IMW SQ19-20", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-66],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 13,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3209, "epsg", 3209,
        "WGS 84 / SCAR IMW SQ21-22", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ21-22\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-54],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 3210, "epsg", 3210,
        "WGS 84 / SCAR IMW SQ37-38", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ37-38\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",42],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-64.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-67.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3210");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3211, "epsg", 3211,
        "WGS 84 / SCAR IMW SQ39-40", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ39-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",54],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-64.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-67.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3211");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3212, "epsg", 3212,
        "WGS 84 / SCAR IMW SQ41-42", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ41-42\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",66],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-64.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-67.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3212");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3213, "epsg", 3213,
        "WGS 84 / SCAR IMW SQ43-44", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ43-44\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",78],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-64.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-67.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3213");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3214, "epsg", 3214,
        "WGS 84 / SCAR IMW SQ45-46", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ45-46\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",90],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-64.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-67.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3214");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3215, "epsg", 3215,
        "WGS 84 / SCAR IMW SQ47-48", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ47-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",102],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 3216, "epsg", 3216,
        "WGS 84 / SCAR IMW SQ49-50", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ49-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",114],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 3217, "epsg", 3217,
        "WGS 84 / SCAR IMW SQ51-52", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ51-52\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",126],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 13,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 3218, "epsg", 3218,
        "WGS 84 / SCAR IMW SQ53-54", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ53-54\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",138],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 13,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3219, "epsg", 3219,
        "WGS 84 / SCAR IMW SQ55-56", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ55-56\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",150],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 3220, "epsg", 3220,
        "WGS 84 / SCAR IMW SQ57-58", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ57-58\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",162],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-64.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-67.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 3221, "epsg", 3221,
        "WGS 84 / SCAR IMW SR13-14", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-102 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR13-14\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-102],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",-68.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "221\"]]");
    p = add_epsg_def_ex (filter, first, last, 3222, "epsg", 3222,
        "WGS 84 / SCAR IMW SR15-16", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-90 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR15-16\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-90],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 3223, "epsg", 3223,
        "WGS 84 / SCAR IMW SR17-18", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-78 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR17-18\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-78],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 3224, "epsg", 3224,
        "WGS 84 / SCAR IMW SR19-20", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-66],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 3225, "epsg", 3225,
        "WGS 84 / SCAR IMW SR27-28", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-18 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR27-28\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-18],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 3226, "epsg", 3226,
        "WGS 84 / SCAR IMW SR29-30", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-6 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR29-30\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-6],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3226");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3227, "epsg", 3227,
        "WGS 84 / SCAR IMW SR31-32", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=6 +x_0=0 +y_0=0 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR31-32\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",6],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3227");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3228, "epsg", 3228,
        "WGS 84 / SCAR IMW SR33-34", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=18 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR33-34\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",18],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3228");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3229, "epsg", 3229,
        "WGS 84 / SCAR IMW SR35-36", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=30 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR35-36\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",30],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3229");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3230, "epsg", 3230,
        "WGS 84 / SCAR IMW SR37-38", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR37-38\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",42],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3230");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3231, "epsg", 3231,
        "WGS 84 / SCAR IMW SR39-40", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR39-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",54],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3231");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3232, "epsg", 3232,
        "WGS 84 / SCAR IMW SR41-42", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR41-42\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",66],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3232");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3233, "epsg", 3233,
        "WGS 84 / SCAR IMW SR43-44", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR43-44\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",78],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3233");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3234, "epsg", 3234,
        "WGS 84 / SCAR IMW SR45-46", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR45-46\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",90],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",-68.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",-71.3333333333333],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3234");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3235, "epsg", 3235,
        "WGS 84 / SCAR IMW SR47-48", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR47-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",102],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"323");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 3236, "epsg", 3236,
        "WGS 84 / SCAR IMW SR49-50", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR49-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",114],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"323");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 3237, "epsg", 3237,
        "WGS 84 / SCAR IMW SR51-52", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR51-52\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",126],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"323");
    add_srs_wkt (p, 13,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 3238, "epsg", 3238,
        "WGS 84 / SCAR IMW SR53-54", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR53-54\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",138],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"323");
    add_srs_wkt (p, 13,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 3239, "epsg", 3239,
        "WGS 84 / SCAR IMW SR55-56", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR55-56\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",150],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"323");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 3240, "epsg", 3240,
        "WGS 84 / SCAR IMW SR57-58", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR57-58\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",162],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 3241, "epsg", 3241,
        "WGS 84 / SCAR IMW SR59-60", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=174 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR59-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",174],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-68.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",-71.3333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 13,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 3242, "epsg", 3242,
        "WGS 84 / SCAR IMW SS04-06", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-153 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS04-06\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-153],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",-72.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",-75.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "242\"]]");
    p = add_epsg_def_ex (filter, first, last, 3243, "epsg", 3243,
        "WGS 84 / SCAR IMW SS07-09", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-135 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS07-09\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-90],PARAMETER[\"central_meridian\",-135],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",-72.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",-75.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "243\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

