/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_08 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2830, "epsg", 2830,
        "NAD83(HARN) / New York West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York West\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40],PARAMETER[\"central_meridian\",-78.583333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",350000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2830\"]]");
    p = add_epsg_def_ex (filter, first, last, 2831, "epsg", 2831,
        "NAD83(HARN) / New York Long Island", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York Long Island\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",40.1666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-74],PARAMETER[\"standard_parallel_1\",41.");
    add_srs_wkt (p, 10,
        "0333333333333],PARAMETER[\"standard_parallel_2\",40.6666");
    add_srs_wkt (p, 11,
        "666666667],PARAMETER[\"false_easting\",300000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"2831\"]]");
    p = add_epsg_def_ex (filter, first, last, 2832, "epsg", 2832,
        "NAD83(HARN) / North Dakota North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Dakota North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",47],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "00.5],PARAMETER[\"standard_parallel_1\",48.7333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",47.4333333333333],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",600000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"2832\"]]");
    p = add_epsg_def_ex (filter, first, last, 2833, "epsg", 2833,
        "NAD83(HARN) / North Dakota South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Dakota South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-100.5],PARAMETER[\"standard_parallel_1\",47");
    add_srs_wkt (p, 10,
        ".4833333333333],PARAMETER[\"standard_parallel_2\",46.183");
    add_srs_wkt (p, 11,
        "3333333333],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"2833\"]]");
    p = add_epsg_def_ex (filter, first, last, 2834, "epsg", 2834,
        "NAD83(HARN) / Ohio North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Ohio North\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",39.6666666666667],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-82.5],PARAMETER[\"standard_parallel_1\",41.7],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",40.4333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",600000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"2834\"]]");
    p = add_epsg_def_ex (filter, first, last, 2835, "epsg", 2835,
        "NAD83(HARN) / Ohio South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Ohio South\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",38],PARAMETER[\"central_meridian\",-82.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",40.0333333333333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",38.7333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",600000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"2835\"]]");
    p = add_epsg_def_ex (filter, first, last, 2836, "epsg", 2836,
        "NAD83(HARN) / Oklahoma North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oklahoma North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",35],PARAMETER[\"central_meridian\",-98],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",36.7666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",35.5666666666667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",600000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"2836\"]]");
    p = add_epsg_def_ex (filter, first, last, 2837, "epsg", 2837,
        "NAD83(HARN) / Oklahoma South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oklahoma South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",33.3333333333333],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-98],PARAMETER[\"standard_parallel_1\",35.233333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"standard_parallel_2\",33.9333333333");
    add_srs_wkt (p, 11,
        "333],PARAMETER[\"false_easting\",600000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"2837\"]]");
    p = add_epsg_def_ex (filter, first, last, 2838, "epsg", 2838,
        "NAD83(HARN) / Oregon North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oregon North\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-120.5],PARAMETER[\"standard_parallel_1\",46],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",44.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",2500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2838\"]]");
    p = add_epsg_def_ex (filter, first, last, 2839, "epsg", 2839,
        "NAD83(HARN) / Oregon South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oregon South\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",41.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-120.5],PARAMETER[\"standard_parallel_1\",44],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",42.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",1500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2839\"]]");
    p = add_epsg_def_ex (filter, first, last, 2840, "epsg", 2840,
        "NAD83(HARN) / Rhode Island", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Rhode Island\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",41.0833333333333],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 9,
        "1.5],PARAMETER[\"scale_factor\",0.99999375],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",100000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"2840\"]]");
    p = add_epsg_def_ex (filter, first, last, 2841, "epsg", 2841,
        "NAD83(HARN) / South Dakota North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Dakota North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",43.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-100],PARAMETER[\"standard_parallel_1\",45.6");
    add_srs_wkt (p, 10,
        "833333333333],PARAMETER[\"standard_parallel_2\",44.41666");
    add_srs_wkt (p, 11,
        "66666667],PARAMETER[\"false_easting\",600000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"2841\"]]");
    p = add_epsg_def_ex (filter, first, last, 2842, "epsg", 2842,
        "NAD83(HARN) / South Dakota South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Dakota South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",42.3333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-100.333333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",44.4],PARAMETER[\"standard_parallel_2\",42.8333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"2842\"]]");
    p = add_epsg_def_ex (filter, first, last, 2843, "epsg", 2843,
        "NAD83(HARN) / Tennessee", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Tennessee\",GEOGCS[\"NAD83(HARN)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",34.3333333333333],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-86],PARAMETER[\"standard_parallel_1\",36.4166666666667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",35.25],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",600000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"2843\"]]");
    p = add_epsg_def_ex (filter, first, last, 2844, "epsg", 2844,
        "NAD83(HARN) / Texas North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas North\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",34],PARAMETER[\"central_meridian\",-101.5],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",36.1833333333333],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",34.65],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",200000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"2844\"]]");
    p = add_epsg_def_ex (filter, first, last, 2845, "epsg", 2845,
        "NAD83(HARN) / Texas North Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas North Central\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",31.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-98.5],PARAMETER[\"standard_parallel_1\",33.");
    add_srs_wkt (p, 10,
        "9666666666667],PARAMETER[\"standard_parallel_2\",32.1333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2845\"]]");
    p = add_epsg_def_ex (filter, first, last, 2846, "epsg", 2846,
        "NAD83(HARN) / Texas Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 3,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas Central\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",29.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-100.333333333333],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 10,
        "\",31.8833333333333],PARAMETER[\"standard_parallel_2\",3");
    add_srs_wkt (p, 11,
        "0.1166666666667],PARAMETER[\"false_easting\",700000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",3000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2846\"]]");
    p = add_epsg_def_ex (filter, first, last, 2847, "epsg", 2847,
        "NAD83(HARN) / Texas South Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas South Central\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",27.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-99],PARAMETER[\"standard_parallel_1\",30.28");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"standard_parallel_2\",28.383333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",4000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2847\"]]");
    p = add_epsg_def_ex (filter, first, last, 2848, "epsg", 2848,
        "NAD83(HARN) / Texas South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y");
    add_proj4text (p, 2,
        "_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas South\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",25.6666666666667],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-98.5],PARAMETER[\"standard_parallel_1\",27.8333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"standard_parallel_2\",26.16666666666");
    add_srs_wkt (p, 11,
        "67],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"2848\"]]");
    p = add_epsg_def_ex (filter, first, last, 2849, "epsg", 2849,
        "NAD83(HARN) / Utah North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah North\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",40.3333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-111.5],PARAMETER[\"standard_parallel_1\",41.78333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"standard_parallel_2\",40.716666666666");
    add_srs_wkt (p, 11,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"2849\"]]");
    p = add_epsg_def_ex (filter, first, last, 2850, "epsg", 2850,
        "NAD83(HARN) / Utah Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah Central\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",38.3333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-111.5],PARAMETER[\"standard_parallel_1\",40.65],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",39.0166666666667],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"2850\"]]");
    p = add_epsg_def_ex (filter, first, last, 2851, "epsg", 2851,
        "NAD83(HARN) / Utah South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah South\",GEOGCS[\"NAD83(HARN)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",36.6666666666667],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-111.5],PARAMETER[\"standard_parallel_1\",38.35],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",37.2166666666667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"2851\"]]");
    p = add_epsg_def_ex (filter, first, last, 2852, "epsg", 2852,
        "NAD83(HARN) / Vermont", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Vermont\",GEOGCS[\"NAD83(HARN)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"615");
    add_srs_wkt (p, 4,
        "2\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "2.5],PARAMETER[\"central_meridian\",-72.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.999964286],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2852\"]]");
    p = add_epsg_def_ex (filter, first, last, 2853, "epsg", 2853,
        "NAD83(HARN) / Virginia North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia North\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",37.6666666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-78.5],PARAMETER[\"standard_parallel_1\",39.2],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",38.0333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",3500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"2853\"]]");
    p = add_epsg_def_ex (filter, first, last, 2854, "epsg", 2854,
        "NAD83(HARN) / Virginia South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia South\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",36.3333333333333],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-78.5],PARAMETER[\"standard_parallel_1\",37.9666");
    add_srs_wkt (p, 10,
        "666666667],PARAMETER[\"standard_parallel_2\",36.76666666");
    add_srs_wkt (p, 11,
        "66667],PARAMETER[\"false_easting\",3500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2854\"]]");
    p = add_epsg_def_ex (filter, first, last, 2855, "epsg", 2855,
        "NAD83(HARN) / Washington North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Washington North\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",47],PARAMETER[\"central_meridian\",-120.");
    add_srs_wkt (p, 9,
        "833333333333],PARAMETER[\"standard_parallel_1\",48.73333");
    add_srs_wkt (p, 10,
        "33333333],PARAMETER[\"standard_parallel_2\",47.5],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"2855\"]]");
    p = add_epsg_def_ex (filter, first, last, 2856, "epsg", 2856,
        "NAD83(HARN) / Washington South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Washington South\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45.3333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-120.5],PARAMETER[\"standard_parallel_1\",47.33");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"standard_parallel_2\",45.833333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2856\"]]");
    p = add_epsg_def_ex (filter, first, last, 2857, "epsg", 2857,
        "NAD83(HARN) / West Virginia North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",38.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-79.5],PARAMETER[\"standard_parallel_1\",40.25],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",39],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",600000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2857\"]]");
    p = add_epsg_def_ex (filter, first, last, 2858, "epsg", 2858,
        "NAD83(HARN) / West Virginia South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",37],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"standard_parallel_1\",38.8833333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",37.4833333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",600000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"2858\"]]");
    p = add_epsg_def_ex (filter, first, last, 2859, "epsg", 2859,
        "NAD83(HARN) / Wisconsin North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin North\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45.1666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90],PARAMETER[\"standard_parallel_1\",46.76666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"standard_parallel_2\",45.566666666");
    add_srs_wkt (p, 11,
        "6667],PARAMETER[\"false_easting\",600000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"2859\"]]");
    p = add_epsg_def_ex (filter, first, last, 2860, "epsg", 2860,
        "NAD83(HARN) / Wisconsin Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.8333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-90],PARAMETER[\"standard_parallel_1\",45.5],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",44.25],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",600000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "860\"]]");
    p = add_epsg_def_ex (filter, first, last, 2861, "epsg", 2861,
        "NAD83(HARN) / Wisconsin South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin South\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",42],PARAMETER[\"central_meridian\",-90],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",44.0666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",42.7333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",600000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2861\"]]");
    p = add_epsg_def_ex (filter, first, last, 2862, "epsg", 2862,
        "NAD83(HARN) / Wyoming East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming East\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40.5],PARAMETER[\"central_meridian\",-105.166666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",200000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"2862\"]]");
    p = add_epsg_def_ex (filter, first, last, 2863, "epsg", 2863,
        "NAD83(HARN) / Wyoming East Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming East Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",40.5],PARAMETER[\"central_meridian\",-107.3");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"scale_factor\",0.9999375],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",400000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2863\"]]");
    p = add_epsg_def_ex (filter, first, last, 2864, "epsg", 2864,
        "NAD83(HARN) / Wyoming West Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming West Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",40.5],PARAMETER[\"central_meridian\",-108.7");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",600000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2864\"]]");
    p = add_epsg_def_ex (filter, first, last, 2865, "epsg", 2865,
        "NAD83(HARN) / Wyoming West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming West\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40.5],PARAMETER[\"central_meridian\",-110.083333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",800000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"2865\"]]");
    p = add_epsg_def_ex (filter, first, last, 2866, "epsg", 2866,
        "NAD83(HARN) / Puerto Rico and Virgin Is.", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Puerto Rico and Virgin Is.\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"415");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",17.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-66.4333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_1\",18.4333333333333],PARAMETER[\"standard_p");
    add_srs_wkt (p, 11,
        "arallel_2\",18.0333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",200000],PARAMETER[\"false_northing\",200000],UNIT[\"met");
    add_srs_wkt (p, 13,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2866\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2867, "epsg", 2867,
        "NAD83(HARN) / Arizona East (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona East (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",31],PARAMETER[\"central_meridian\",-110.16666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",700000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"2867\"]]");
    p = add_epsg_def_ex (filter, first, last, 2868, "epsg", 2868,
        "NAD83(HARN) / Arizona Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona Central (ft)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",31],PARAMETER[\"central_meridian\",-111.916");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",700000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"2868\"]]");
    p = add_epsg_def_ex (filter, first, last, 2869, "epsg", 2869,
        "NAD83(HARN) / Arizona West (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Arizona West (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",31],PARAMETER[\"central_meridian\",-113.75],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.999933333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",700000],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 11,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2869\"]]");
    p = add_epsg_def_ex (filter, first, last, 2870, "epsg", 2870,
        "NAD83(HARN) / California zone 1 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
        "00.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 1 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",39.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-122],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",41.6666666666667],PARAMETER[\"standard_parallel_2\",40]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",6561666.667],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",1640416.667],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 13,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 14,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "2870\"]]");
    p = add_epsg_def_ex (filter, first, last, 2871, "epsg", 2871,
        "NAD83(HARN) / California zone 2 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.00");
    add_proj4text (p, 2,
        "01016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 2 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",37.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-122],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",39.8333333333333],PARAMETER[\"standard_parallel_2\",38.");
    add_srs_wkt (p, 11,
        "3333333333333],PARAMETER[\"false_easting\",6561666.667],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",1640416.667],UNIT[\"US surv");
    add_srs_wkt (p, 13,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 14,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"2871\"]]");
    p = add_epsg_def_ex (filter, first, last, 2872, "epsg", 2872,
        "NAD83(HARN) / California zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=");
    add_proj4text (p, 2,
        "500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 3,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 3 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",36.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-120.5],PARAMETER[\"standard_parallel_1\",38.433333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"standard_parallel_2\",37.0666666666");
    add_srs_wkt (p, 11,
        "667],PARAMETER[\"false_easting\",6561666.667],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",1640416.667],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 14,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"2872\"]]");
    p = add_epsg_def_ex (filter, first, last, 2873, "epsg", 2873,
        "NAD83(HARN) / California zone 4 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.000101600");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 4 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",35.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-119],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",37.25],PARAMETER[\"standard_parallel_2\",36],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",6561666.667],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",1640416.667],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2873\"]]");
    p = add_epsg_def_ex (filter, first, last, 2874, "epsg", 2874,
        "NAD83(HARN) / California zone 5 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
        "0000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 5 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",33.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-118],PARAMETER[\"standard_parallel_1\",35.46666666");
    add_srs_wkt (p, 10,
        "66667],PARAMETER[\"standard_parallel_2\",34.033333333333");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_easting\",6561666.667],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",1640416.667],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 14,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"2874\"]]");
    p = add_epsg_def_ex (filter, first, last, 2875, "epsg", 2875,
        "NAD83(HARN) / California zone 6 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        ".0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California zone 6 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",32.1666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-116.25],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "1\",33.8833333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 11,
        "32.7833333333333],PARAMETER[\"false_easting\",6561666.66");
    add_srs_wkt (p, 12,
        "7],PARAMETER[\"false_northing\",1640416.667],UNIT[\"US s");
    add_srs_wkt (p, 13,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"2875\"]]");
    p = add_epsg_def_ex (filter, first, last, 2876, "epsg", 2876,
        "NAD83(HARN) / Colorado North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",39.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-105.5],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 10,
        "40.7833333333333],PARAMETER[\"standard_parallel_2\",39.7");
    add_srs_wkt (p, 11,
        "166666666667],PARAMETER[\"false_easting\",3000000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",1000000],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"2876\"]]");
    p = add_epsg_def_ex (filter, first, last, 2877, "epsg", 2877,
        "NAD83(HARN) / Colorado Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.60");
    add_proj4text (p, 2,
        "96012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",37.8333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-105.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 10,
        "\",39.75],PARAMETER[\"standard_parallel_2\",38.45],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",3000000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",1000000],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2877\"]]");
    p = add_epsg_def_ex (filter, first, last, 2878, "epsg", 2878,
        "NAD83(HARN) / Colorado South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Colorado South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-105.5],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 10,
        "38.4333333333333],PARAMETER[\"standard_parallel_2\",37.2");
    add_srs_wkt (p, 11,
        "333333333333],PARAMETER[\"false_easting\",3000000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",1000000],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"2878\"]]");
    p = add_epsg_def_ex (filter, first, last, 2879, "epsg", 2879,
        "NAD83(HARN) / Connecticut (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_");
    add_proj4text (p, 2,
        "0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Connecticut (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",40.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-72.75],PARAMETER[\"standard_parallel_1\",41");
    add_srs_wkt (p, 10,
        ".8666666666667],PARAMETER[\"standard_parallel_2\",41.2],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",500000],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2879\"]]");
    p = add_epsg_def_ex (filter, first, last, 2880, "epsg", 2880,
        "NAD83(HARN) / Delaware (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Delaware (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",38],PARAMETER[\"central_meridian\",-75.416666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",0.999995],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",656166.667],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2880\"]]");
    p = add_epsg_def_ex (filter, first, last, 2881, "epsg", 2881,
        "NAD83(HARN) / Florida East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",24.3333333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-81],PARAMETER[\"scale_factor\",0.999941177],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",656166.667],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2881\"]]");
    p = add_epsg_def_ex (filter, first, last, 2882, "epsg", 2882,
        "NAD83(HARN) / Florida West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",24.3333333333333],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-82],PARAMETER[\"scale_factor\",0.999941177],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",656166.667],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2882\"]]");
    p = add_epsg_def_ex (filter, first, last, 2883, "epsg", 2883,
        "NAD83(HARN) / Florida North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Florida North (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",29],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-84.5],PARAMETER[\"standard_parallel_1\",30.75],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",29.5833333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2883\"]]");
    p = add_epsg_def_ex (filter, first, last, 2884, "epsg", 2884,
        "NAD83(HARN) / Georgia East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Georgia East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",30],PARAMETER[\"central_meridian\",-82.166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",656166.667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2884\"]]");
    p = add_epsg_def_ex (filter, first, last, 2885, "epsg", 2885,
        "NAD83(HARN) / Georgia West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Georgia West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",30],PARAMETER[\"central_meridian\",-84.166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",2296583.333],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2885\"]]");
    p = add_epsg_def_ex (filter, first, last, 2886, "epsg", 2886,
        "NAD83(HARN) / Idaho East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",41.6666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-112.166666666667],PARAMETER[\"scale_factor\",0.9999473");
    add_srs_wkt (p, 10,
        "68],PARAMETER[\"false_easting\",656166.667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2886\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2887, "epsg", 2887,
        "NAD83(HARN) / Idaho Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",41.6666666666667],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-114],PARAMETER[\"scale_factor\",0.999947368],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",1640416.667],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2887\"]]");
    p = add_epsg_def_ex (filter, first, last, 2888, "epsg", 2888,
        "NAD83(HARN) / Idaho West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Idaho West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",41.6666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-115.75],PARAMETER[\"scale_factor\",0.999933333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2624666.667],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2888\"]]");
    p = add_epsg_def_ex (filter, first, last, 2889, "epsg", 2889,
        "NAD83(HARN) / Indiana East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Indiana East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",37.5],PARAMETER[\"central_meridian\",-85.6666");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"scale_factor\",0.999966667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",328083.333],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",820208.333],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2967\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2890, "epsg", 2890,
        "NAD83(HARN) / Indiana West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Indiana West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",37.5],PARAMETER[\"central_meridian\",-87.0833");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"scale_factor\",0.999966667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",2952750],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",820208.333],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2968\"]]");
    p = add_epsg_def_ex (filter, first, last, 2891, "epsg", 2891,
        "NAD83(HARN) / Kentucky North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-84.25],PARAMETER[\"standard_parallel_1\",37.9666666666");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"standard_parallel_2\",38.9666666666667]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",1640416.667],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2891\"]]");
    p = add_epsg_def_ex (filter, first, last, 2892, "epsg", 2892,
        "NAD83(HARN) / Kentucky South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Kentucky South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",36.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-85.75],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 10,
        "37.9333333333333],PARAMETER[\"standard_parallel_2\",36.7");
    add_srs_wkt (p, 11,
        "333333333333],PARAMETER[\"false_easting\",1640416.667],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",1640416.667],UNIT[\"US surve");
    add_srs_wkt (p, 13,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"2892\"]]");
    p = add_epsg_def_ex (filter, first, last, 2893, "epsg", 2893,
        "NAD83(HARN) / Maryland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maryland (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",37.6666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-77],PARAMETER[\"standard_parallel_1\",39.45],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",38.3],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1312333.333],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2893\"]]");
    p = add_epsg_def_ex (filter, first, last, 2894, "epsg", 2894,
        "NAD83(HARN) / Massachusetts Mainland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=7");
    add_proj4text (p, 2,
        "50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Massachusetts Mainland (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refere");
    add_srs_wkt (p, 2,
        "nce_Network\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",41],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-71.5],PARAMETER[\"standard_parallel_1\",42.683");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"standard_parallel_2\",41.7166666");
    add_srs_wkt (p, 11,
        "666667],PARAMETER[\"false_easting\",656166.667],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",2460625],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 14,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"2894\"]]");
    p = add_epsg_def_ex (filter, first, last, 2895, "epsg", 2895,
        "NAD83(HARN) / Massachusetts Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Massachusetts Island (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "52\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",41],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-70.5],PARAMETER[\"standard_parallel_1\",41.48333");
    add_srs_wkt (p, 10,
        "33333333],PARAMETER[\"standard_parallel_2\",41.283333333");
    add_srs_wkt (p, 11,
        "3333],PARAMETER[\"false_easting\",1640416.667],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 13,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2895");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2896, "epsg", 2896,
        "NAD83(HARN) / Michigan North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999");
    add_proj4text (p, 2,
        "968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",44.7833333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-87],PARAMETER[\"standard_parallel_1\",47.08");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"standard_parallel_2\",45.483333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"false_easting\",26246719.16],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2896\"]]");
    p = add_epsg_def_ex (filter, first, last, 2897, "epsg", 2897,
        "NAD83(HARN) / Michigan Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.9");
    add_proj4text (p, 2,
        "99976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3,
        "ts=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan Central (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.3166666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-84.3666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_1\",45.7],PARAMETER[\"standard_parallel_2\",44.18");
    add_srs_wkt (p, 11,
        "33333333333],PARAMETER[\"false_easting\",19685039.37],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2897\"]]");
    p = add_epsg_def_ex (filter, first, last, 2898, "epsg", 2898,
        "NAD83(HARN) / Michigan South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Michigan South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",41.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-84.3666666666667],PARAMETER[\"standard_parallel_1\",43.");
    add_srs_wkt (p, 10,
        "6666666666667],PARAMETER[\"standard_parallel_2\",42.1],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",13123359.58],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2898\"]]");
    p = add_epsg_def_ex (filter, first, last, 2899, "epsg", 2899,
        "NAD83(HARN) / Mississippi East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Mississippi East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",29.5],PARAMETER[\"central_meridian\",-88");
    add_srs_wkt (p, 9,
        ".8333333333333],PARAMETER[\"scale_factor\",0.99995],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",984250],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2899\"]]");
    p = add_epsg_def_ex (filter, first, last, 2900, "epsg", 2900,
        "NAD83(HARN) / Mississippi West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Mississippi West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",29.5],PARAMETER[\"central_meridian\",-90");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",0.99995],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",2296583.333],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2900\"]]");
    p = add_epsg_def_ex (filter, first, last, 2901, "epsg", 2901,
        "NAD83(HARN) / Montana (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
        " +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Montana (ft)\",GEOGCS[\"NAD83(HAR");
    add_srs_wkt (p, 1,
        "N)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",44.25],PARAMETER[\"central_meridian\",-109.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",45],PARAMETER[\"false_easting\",19685");
    add_srs_wkt (p, 11,
        "03.937],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.");
    add_srs_wkt (p, 12,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2901\"]]");
    p = add_epsg_def_ex (filter, first, last, 2902, "epsg", 2902,
        "NAD83(HARN) / New Mexico East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",31],PARAMETER[\"central_meridian\",-104.33");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",0.999909091],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",541337.5],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2902\"]]");
    p = add_epsg_def_ex (filter, first, last, 2903, "epsg", 2903,
        "NAD83(HARN) / New Mexico Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico Central (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",31],PARAMETER[\"central_meridian\",-10");
    add_srs_wkt (p, 9,
        "6.25],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",1640416.667],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2903\"]]");
    p = add_epsg_def_ex (filter, first, last, 2904, "epsg", 2904,
        "NAD83(HARN) / New Mexico West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New Mexico West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",31],PARAMETER[\"central_meridian\",-107.83");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",0.999916667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",2723091.667],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2904\"]]");
    p = add_epsg_def_ex (filter, first, last, 2905, "epsg", 2905,
        "NAD83(HARN) / New York East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York East (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",38.8333333333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-74.5],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",492125],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2905\"]]");
    p = add_epsg_def_ex (filter, first, last, 2906, "epsg", 2906,
        "NAD83(HARN) / New York Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",40],PARAMETER[\"central_meridian\",-76.5");
    add_srs_wkt (p, 9,
        "833333333333],PARAMETER[\"scale_factor\",0.9999375],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",820208.333],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2906\"]]");
    p = add_epsg_def_ex (filter, first, last, 2907, "epsg", 2907,
        "NAD83(HARN) / New York West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York West (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",40],PARAMETER[\"central_meridian\",-78.5833");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"scale_factor\",0.9999375],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",1148291.667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2907\"]]");
    p = add_epsg_def_ex (filter, first, last, 2908, "epsg", 2908,
        "NAD83(HARN) / New York Long Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000");
    add_proj4text (p, 2,
        "000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / New York Long Island (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "52\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",40.1666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-74],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "1\",41.0333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 11,
        "40.6666666666667],PARAMETER[\"false_easting\",984250],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 14,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"2908\"]]");
    p = add_epsg_def_ex (filter, first, last, 2909, "epsg", 2909,
        "NAD83(HARN) / North Dakota North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Dakota North (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",47],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-100.5],PARAMETER[\"standard_parallel_1\",48.73333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"standard_parallel_2\",47.433333333333");
    add_srs_wkt (p, 11,
        "3],PARAMETER[\"false_easting\",1968503.937],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"2909\"]]");
    p = add_epsg_def_ex (filter, first, last, 2910, "epsg", 2910,
        "NAD83(HARN) / North Dakota South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9");
    add_proj4text (p, 2,
        "999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / North Dakota South (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",45.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-100.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 10,
        "\",47.4833333333333],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 11,
        "6.1833333333333],PARAMETER[\"false_easting\",1968503.937");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2910\"]]");
    p = add_epsg_def_ex (filter, first, last, 2911, "epsg", 2911,
        "NAD83(HARN) / Oklahoma North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oklahoma North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",35],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-98],PARAMETER[\"standard_parallel_1\",36.7666666666667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"standard_parallel_2\",35.5666666666667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",1968500],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2911\"]]");
    p = add_epsg_def_ex (filter, first, last, 2912, "epsg", 2912,
        "NAD83(HARN) / Oklahoma South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oklahoma South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",33.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-98],PARAMETER[\"standard_parallel_1\",35.");
    add_srs_wkt (p, 10,
        "2333333333333],PARAMETER[\"standard_parallel_2\",33.9333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"291");
    add_srs_wkt (p, 15,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 2913, "epsg", 2913,
        "NAD83(HARN) / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oregon North (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.6666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-120.5],PARAMETER[\"standard_parallel_1\",46],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",44.3333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",8202099.738],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "02\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"2913\"]]");
    p = add_epsg_def_ex (filter, first, last, 2914, "epsg", 2914,
        "NAD83(HARN) / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Oregon South (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",41.6666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-120.5],PARAMETER[\"standard_parallel_1\",44],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",42.3333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",4921259.843],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "02\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"2914\"]]");
    p = add_epsg_def_ex (filter, first, last, 2915, "epsg", 2915,
        "NAD83(HARN) / Tennessee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Tennessee (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",34.3333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-86],PARAMETER[\"standard_parallel_1\",36.41666");
    add_srs_wkt (p, 10,
        "66666667],PARAMETER[\"standard_parallel_2\",35.25],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",1968500],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2915\"]]");
    p = add_epsg_def_ex (filter, first, last, 2916, "epsg", 2916,
        "NAD83(HARN) / Texas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.99989");
    add_proj4text (p, 2,
        "83998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas North (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",34],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "01.5],PARAMETER[\"standard_parallel_1\",36.1833333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",34.65],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",656166.667],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "3280833.333],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2916\"]]");
    p = add_epsg_def_ex (filter, first, last, 2917, "epsg", 2917,
        "NAD83(HARN) / Texas North Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas North Central (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"415");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",31.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-98.5],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "1\",33.9666666666667],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 11,
        "32.1333333333333],PARAMETER[\"false_easting\",1968500],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",6561666.667],UNIT[\"US surve");
    add_srs_wkt (p, 13,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"2917\"]]");
    p = add_epsg_def_ex (filter, first, last, 2918, "epsg", 2918,
        "NAD83(HARN) / Texas Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 3,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",29.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-100.333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_1\",31.8833333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 11,
        "el_2\",30.1166666666667],PARAMETER[\"false_easting\",229");
    add_srs_wkt (p, 12,
        "6583.333],PARAMETER[\"false_northing\",9842500],UNIT[\"U");
    add_srs_wkt (p, 13,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"2918\"]]");
    p = add_epsg_def_ex (filter, first, last, 2919, "epsg", 2919,
        "NAD83(HARN) / Texas South Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas South Central (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"415");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",27.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-99],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",30.2833333333333],PARAMETER[\"standard_parallel_2\",28.");
    add_srs_wkt (p, 11,
        "3833333333333],PARAMETER[\"false_easting\",1968500],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",13123333.333],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"2919\"]]");
    p = add_epsg_def_ex (filter, first, last, 2920, "epsg", 2920,
        "NAD83(HARN) / Texas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.00");
    add_proj4text (p, 2,
        "00000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Texas South (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",25.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-98.5],PARAMETER[\"standard_parallel_1\",27.");
    add_srs_wkt (p, 10,
        "8333333333333],PARAMETER[\"standard_parallel_2\",26.1666");
    add_srs_wkt (p, 11,
        "666666667],PARAMETER[\"false_easting\",984250],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",16404166.667],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"2920\"]]");
    p = add_epsg_def_ex (filter, first, last, 2921, "epsg", 2921,
        "NAD83(HARN) / Utah North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah North (ft)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",40.3333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-111.5],PARAMETER[\"standard_parallel_1\",41.78");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"standard_parallel_2\",40.716666");
    add_srs_wkt (p, 11,
        "6666667],PARAMETER[\"false_easting\",1640419.948],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",3280839.895],UNIT[\"foot\",0.3048");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2921\"]]");
    p = add_epsg_def_ex (filter, first, last, 2922, "epsg", 2922,
        "NAD83(HARN) / Utah Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah Central (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",38.3333333333333],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-111.5],PARAMETER[\"standard_parallel_1\",40.65");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",39.0166666666667],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",1640419.948],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",6561679.79],UNIT[\"foot\",0.3048,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2922\"]]");
    p = add_epsg_def_ex (filter, first, last, 2923, "epsg", 2923,
        "NAD83(HARN) / Utah South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Utah South (ft)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",36.6666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-111.5],PARAMETER[\"standard_parallel_1\",38.35");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"standard_parallel_2\",37.2166666666667],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",1640419.948],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",9842519.685],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2923\"]]");
    p = add_epsg_def_ex (filter, first, last, 2924, "epsg", 2924,
        "NAD83(HARN) / Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2");
    add_proj4text (p, 2,
        "000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",37.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-78.5],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 10,
        "9.2],PARAMETER[\"standard_parallel_2\",38.0333333333333]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",11482916.667],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",6561666.667],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 14,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 15,
        "\"2924\"]]");
    p = add_epsg_def_ex (filter, first, last, 2925, "epsg", 2925,
        "NAD83(HARN) / Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0");
    add_proj4text (p, 2,
        "001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Virginia South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",36.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-78.5],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 10,
        "7.9666666666667],PARAMETER[\"standard_parallel_2\",36.76");
    add_srs_wkt (p, 11,
        "66666666667],PARAMETER[\"false_easting\",11482916.667],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",3280833.333],UNIT[\"US surve");
    add_srs_wkt (p, 13,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"2925\"]]");
    p = add_epsg_def_ex (filter, first, last, 2926, "epsg", 2926,
        "NAD83(HARN) / Washington North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Washington North (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",47],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-120.833333333333],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 10,
        "48.7333333333333],PARAMETER[\"standard_parallel_2\",47.5");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",1640416.667],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2926\"]]");
    p = add_epsg_def_ex (filter, first, last, 2927, "epsg", 2927,
        "NAD83(HARN) / Washington South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Washington South (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",45.3333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-120.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 10,
        "\",47.3333333333333],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 11,
        "5.8333333333333],PARAMETER[\"false_easting\",1640416.667");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"2927\"]]");
    p = add_epsg_def_ex (filter, first, last, 2928, "epsg", 2928,
        "NAD83(HARN) / Wisconsin North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.1666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-90],PARAMETER[\"standard_parallel_1\",46.");
    add_srs_wkt (p, 10,
        "7666666666667],PARAMETER[\"standard_parallel_2\",45.5666");
    add_srs_wkt (p, 11,
        "666666667],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"292");
    add_srs_wkt (p, 15,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 2929, "epsg", 2929,
        "NAD83(HARN) / Wisconsin Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",43.8333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-90],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 10,
        "45.5],PARAMETER[\"standard_parallel_2\",44.25],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",1968500],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2929\"]]");
    p = add_epsg_def_ex (filter, first, last, 2930, "epsg", 2930,
        "NAD83(HARN) / Wisconsin South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wisconsin South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-90],PARAMETER[\"standard_parallel_1\",44.0666666666667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"standard_parallel_2\",42.7333333333333],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",1968500],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2930\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

