/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_05 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2527, "epsg", 2527,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 11\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2527\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2528, "epsg", 2528,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 12\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2528\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2529, "epsg", 2529,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 13\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2529\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2530, "epsg", 2530,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 14\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",42],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",145");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2530\"]]");
    p = add_epsg_def_ex (filter, first, last, 2531, "epsg", 2531,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 15\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",155");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2531\"]]");
    p = add_epsg_def_ex (filter, first, last, 2532, "epsg", 2532,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 16\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",48],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",165");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2532\"]]");
    p = add_epsg_def_ex (filter, first, last, 2533, "epsg", 2533,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 17\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",51],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",175");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2533\"]]");
    p = add_epsg_def_ex (filter, first, last, 2534, "epsg", 2534,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 18\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",54],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",185");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2534\"]]");
    p = add_epsg_def_ex (filter, first, last, 2535, "epsg", 2535,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 19\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",57],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",195");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2535\"]]");
    p = add_epsg_def_ex (filter, first, last, 2536, "epsg", 2536,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 20\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",60],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",205");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2536\"]]");
    p = add_epsg_def_ex (filter, first, last, 2537, "epsg", 2537,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 21\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",63],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",215");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2537\"]]");
    p = add_epsg_def_ex (filter, first, last, 2538, "epsg", 2538,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 22\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",66],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",225");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2538\"]]");
    p = add_epsg_def_ex (filter, first, last, 2539, "epsg", 2539,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 23\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",69],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",235");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2539\"]]");
    p = add_epsg_def_ex (filter, first, last, 2540, "epsg", 2540,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 24\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",72],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",245");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2540\"]]");
    p = add_epsg_def_ex (filter, first, last, 2541, "epsg", 2541,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 25\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",75],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",255");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2541\"]]");
    p = add_epsg_def_ex (filter, first, last, 2542, "epsg", 2542,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 26\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",78],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",265");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2542\"]]");
    p = add_epsg_def_ex (filter, first, last, 2543, "epsg", 2543,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 27\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2543\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2544, "epsg", 2544,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 28\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
        "4],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2544\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2545, "epsg", 2545,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 29\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2545\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2546, "epsg", 2546,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 30\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2546\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2547, "epsg", 2547,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 31\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2547\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2548, "epsg", 2548,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 32\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2548\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2549, "epsg", 2549,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 33", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 33\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",33500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2549\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2550, "epsg", 2550,
        "Segara / UTM zone 50S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Gunung_Segara", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-404.78");
    add_proj4text (p, 1,
        ",685.68,45.47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Segara / UTM zone 50S\",GEOGCS[\"Segara\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Gunung_Segara\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 2,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-404.7");
    add_srs_wkt (p, 3,
        "8,685.68,45.47,0,0,0,0],AUTHORITY[\"EPSG\",\"6613\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4613\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",117],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2933\"]]");
    p = add_epsg_def_ex (filter, first, last, 2551, "epsg", 2551,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 34", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 34\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "02],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",34500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2551");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2552, "epsg", 2552,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 35", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 35\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",35500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2552");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2553, "epsg", 2553,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 36", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 36\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "08],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",36500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2553");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2554, "epsg", 2554,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 37", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 37\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",37500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2554");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2555, "epsg", 2555,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 38", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 38\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "14],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",38500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2555");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2556, "epsg", 2556,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 39", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 39\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",39500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2556");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2557, "epsg", 2557,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 40", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 40\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "20],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",40500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2557");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2558, "epsg", 2558,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 41", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 41\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",41500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2558");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2559, "epsg", 2559,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 42", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 42\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "26],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",42500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2559");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2560, "epsg", 2560,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 43", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 43\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",43500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2560");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2561, "epsg", 2561,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 44", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 44\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "32],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",44500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2561");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2562, "epsg", 2562,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 45", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 45\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",45500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2562");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2563, "epsg", 2563,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 46", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 46\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "38],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",46500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2563");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2564, "epsg", 2564,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 47", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 47\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",47500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2564");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2565, "epsg", 2565,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 48", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 48\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "44],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",48500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2565");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2566, "epsg", 2566,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 49", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 49\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",49500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2566");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2567, "epsg", 2567,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 50", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 50\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "50],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",50500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2567");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2568, "epsg", 2568,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 51", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 51\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",51500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2568");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2569, "epsg", 2569,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 52", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 52\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "56],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",52500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2569");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2570, "epsg", 2570,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 53", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 53\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",53500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2570");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2571, "epsg", 2571,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 54", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 54\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "62],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",54500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2571");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2572, "epsg", 2572,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 55", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 55\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",55500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2572");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2573, "epsg", 2573,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 56", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 56\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "68],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",56500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2573");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2574, "epsg", 2574,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 57", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 57\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",57500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2574");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2575, "epsg", 2575,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 58", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 58\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "74],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",58500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2575");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2576, "epsg", 2576,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 59", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 59\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",59500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2576");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2577, "epsg", 2577,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 60", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 60\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "80],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",60500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3389");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2578, "epsg", 2578,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 61", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 61\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",61500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2578");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2579, "epsg", 2579,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 62", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 62\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "174],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",62500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2579");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2580, "epsg", 2580,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 63", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 63\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",63500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2580");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2581, "epsg", 2581,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 64", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 64\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "168],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",64500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2581");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2582, "epsg", 2582,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 21E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2582\"]]");
    p = add_epsg_def_ex (filter, first, last, 2583, "epsg", 2583,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 24E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2583\"]]");
    p = add_epsg_def_ex (filter, first, last, 2584, "epsg", 2584,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 27E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",27");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2584\"]]");
    p = add_epsg_def_ex (filter, first, last, 2585, "epsg", 2585,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 30E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",30");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2585\"]]");
    p = add_epsg_def_ex (filter, first, last, 2586, "epsg", 2586,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 33E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",33");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2586\"]]");
    p = add_epsg_def_ex (filter, first, last, 2587, "epsg", 2587,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 36E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",36");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2587\"]]");
    p = add_epsg_def_ex (filter, first, last, 2588, "epsg", 2588,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 39E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",39");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2588\"]]");
    p = add_epsg_def_ex (filter, first, last, 2589, "epsg", 2589,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 42E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",42],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2589\"]]");
    p = add_epsg_def_ex (filter, first, last, 2590, "epsg", 2590,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 45E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",45],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2590\"]]");
    p = add_epsg_def_ex (filter, first, last, 2591, "epsg", 2591,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 48E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",48],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2591\"]]");
    p = add_epsg_def_ex (filter, first, last, 2592, "epsg", 2592,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 51E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",51],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2592\"]]");
    p = add_epsg_def_ex (filter, first, last, 2593, "epsg", 2593,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 54E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",54],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2593\"]]");
    p = add_epsg_def_ex (filter, first, last, 2594, "epsg", 2594,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 57E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",57],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2594\"]]");
    p = add_epsg_def_ex (filter, first, last, 2595, "epsg", 2595,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 60E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",60],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2595\"]]");
    p = add_epsg_def_ex (filter, first, last, 2596, "epsg", 2596,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 63E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",63],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2596\"]]");
    p = add_epsg_def_ex (filter, first, last, 2597, "epsg", 2597,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 66E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",66],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2597\"]]");
    p = add_epsg_def_ex (filter, first, last, 2598, "epsg", 2598,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 69E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",69],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2598\"]]");
    p = add_epsg_def_ex (filter, first, last, 2599, "epsg", 2599,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 72E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",72],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2599\"]]");
    p = add_epsg_def_ex (filter, first, last, 2600, "epsg", 2600,
        "LKS94 / Lithuania TM", 0, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"LKS94 / Lithuania TM\",GEOGCS[\"LKS94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Lithuania_1994_ETRS89\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6126\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4669\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",24],PARAMETER[\"scale_factor\",0.9998],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3346\"]]");
    p = add_epsg_def_ex (filter, first, last, 2601, "epsg", 2601,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 75E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2601\"]]");
    p = add_epsg_def_ex (filter, first, last, 2602, "epsg", 2602,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 78E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[25,-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",78],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2602\"]]");
    p = add_epsg_def_ex (filter, first, last, 2603, "epsg", 2603,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 81E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",81");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2603\"]]");
    p = add_epsg_def_ex (filter, first, last, 2604, "epsg", 2604,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 84E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",84");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2604\"]]");
    p = add_epsg_def_ex (filter, first, last, 2605, "epsg", 2605,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 87E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",87");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2605\"]]");
    p = add_epsg_def_ex (filter, first, last, 2606, "epsg", 2606,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 90E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",90");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2606\"]]");
    p = add_epsg_def_ex (filter, first, last, 2607, "epsg", 2607,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 93E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",93");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2607\"]]");
    p = add_epsg_def_ex (filter, first, last, 2608, "epsg", 2608,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 96E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",96");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2608\"]]");
    p = add_epsg_def_ex (filter, first, last, 2609, "epsg", 2609,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 99E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "84\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",99");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2609\"]]");
    p = add_epsg_def_ex (filter, first, last, 2610, "epsg", 2610,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 102E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "02],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2610\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2611, "epsg", 2611,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 105E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2611\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2612, "epsg", 2612,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 108E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "08],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2612\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2613, "epsg", 2613,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 111E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2613\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2614, "epsg", 2614,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 114E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "14],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2614\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2615, "epsg", 2615,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 117E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2615\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2616, "epsg", 2616,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 120E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "20],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2616\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2617, "epsg", 2617,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 123E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2617\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2618, "epsg", 2618,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 126E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "26],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2618\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2619, "epsg", 2619,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 129E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2619\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2620, "epsg", 2620,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 132E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "32],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2620\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2621, "epsg", 2621,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 135E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2621\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2622, "epsg", 2622,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 138E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "38],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2622\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2623, "epsg", 2623,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 141E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2623\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2624, "epsg", 2624,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 144E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "44],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2624\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2625, "epsg", 2625,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 147E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2625\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2626, "epsg", 2626,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 150E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "50],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2626\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2627, "epsg", 2627,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 153E\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2627\"");
    add_srs_wkt (p, 13,
        "]]");
}

#endif /* full EPSG initialization enabled/disabled */

