# -----------------------------------------------------------------------------
# On Windows NT 4 SP 6 Kimmo Paakkonnen reports Sparky crashes after alot
# of scrolling, scrambling the screen and taking down the system.
#
# This program just does endless scrolling to try to produce a crash.
#

import sputil
import tkutil

# -----------------------------------------------------------------------------
#
def initialize_session(session):

  cb = lambda s=session, f=show_auto_scroll: f(s)
  session.add_command('as', 'Auto Scroll', cb)

# -----------------------------------------------------------------------------
#
class Auto_Scroll(tkutil.Dialog):

  def __init__(self, session):

    self.continue_scrolling = 0
    self.axis = 0
    self.pixel_step = 1
    
    tkutil.Dialog.__init__(self, session.tk, 'Auto Scroll')

    self.view_menu = sputil.view_menu(session, self.top, 'View to scroll: ')
    self.view_menu.frame.pack(side = 'top', anchor = 'w')

    br = tkutil.button_row(self.top,
			   ('Start', self.start_cb),
                           ('Stop', self.stop_cb),
                           ('Close', self.close_cb),
			   )
    br.frame.pack(side = 'top', anchor = 'w')

  # ---------------------------------------------------------------------------
  #
  def start_cb(self):

    self.continue_scrolling = 1
    self.set_timer()

  # ---------------------------------------------------------------------------
  #
  def set_timer(self):

    if self.continue_scrolling:
      import random
      msec = random.randrange(0,100)
      self.top.after(msec, self.scroll_view)
  
  # ---------------------------------------------------------------------------
  #
  def stop_cb(self):

    self.continue_scrolling = 0
  
  # ---------------------------------------------------------------------------
  #
  def close_cb(self):

    self.continue_scrolling = 0
    tkutil.Dialog.close_cb(self)

  # ---------------------------------------------------------------------------
  #
  def scroll_view(self):

    view = self.view_menu.view()
    if view == None:
      return

    axis, new_ppm = self.choose_step(view)
    c = list(view.center)
    c[axis] = new_ppm
    view.center = c

    self.set_timer()

  # ---------------------------------------------------------------------------
  #
  def choose_step(self, view):

    s = view.spectrum
    if self.axis >= s.dimension:
      self.randomize_step(view)

    import random
    if random.randrange(30) == 0:
      self.randomize_step(view)
      
    while 1:
      a = self.axis
      ppm_step = view.pixel_size[a] * self.pixel_step
      new_ppm = view.center[a] + ppm_step
      inbounds = (new_ppm >= s.region[0][a] and new_ppm <= s.region[1][a])
      if inbounds:
        break
      self.randomize_step(view)

    return self.axis, new_ppm
  
  # ---------------------------------------------------------------------------
  #
  def randomize_step(self, view):

    import random
    self.axis = random.randrange(view.spectrum.dimension)
    self.pixel_step = random.choice((-1,1)) * random.randrange(5,50)
    while self.pixel_step == 0:
      self.pixel_step = random.randrange(-20,20)

    if random.choice((0,1)):
      import math
      pixel_ppm = math.pow(10.0, random.randrange(-30,-15)/10.0)
      f = pixel_ppm / view.pixel_size[self.axis]
      pixel_size = map(lambda s, f=f: f*s, view.pixel_size)
      view.pixel_size = pixel_size
      
# -----------------------------------------------------------------------------
#
def show_auto_scroll(session):
  sputil.the_dialog(Auto_Scroll,session).show_window(1)

