// ----------------------------------------------------------------------------
//
#include <stdio.h>		// use fileno()

#include <tcl.h>
#include <tk.h>

// ----------------------------------------------------------------------------
// Include window system routines portable across all platforms.
//
#include "winsystem-all.cc"

// ----------------------------------------------------------------------------
//
static XImage *rotated_image(Display *display, Window win, XImage *image,
			     bool counter_clockwise);

// ----------------------------------------------------------------------------
//
static bool x_key(XEvent *event, char *c)
{
  if (event && event->type == KeyPress)
    {
      char string[8];
      int len = XLookupString(&event->xkey, string, sizeof(string), NULL,NULL);

      if (len == 1)
	{
	  *c = string[0];
	  return true;
	}
    }
  return false;
}

// ----------------------------------------------------------------------------
//
static bool x_function_key(XEvent *event, int *f, bool *shifted)
{
  if (event->type == KeyPress)
    {
      KeySym keysym;
      XLookupString(&event->xkey, NULL, 0, &keysym, NULL);

      if (IsFunctionKey(keysym))
	{
	  *f = (int) (keysym - XK_F1 + 1);
	  *shifted = (event->xkey.state & ShiftMask);
	  return true;
	}
    }
  return false;
}

// ----------------------------------------------------------------------------
//
static void set_background_erase(Widget w, GC, unsigned long bg)
{
  Tk_SetWindowBackground(window(w), bg);	// clear_area() uses this
}

// ----------------------------------------------------------------------------
//
static void eventually_redraw(Widget wt, int x, int y, int w, int h)
  { XClearArea(widget_display(wt), x_window(wt), x, y, w, h, True); }
static void draw_background(Display *display, Window win, GC,
			    int x, int y, int w, int h)
  { XClearArea(display, win, x, y, w, h, False); }

// ----------------------------------------------------------------------------
//
static void draw_vertical_text(Widget w, GC gc, Tk_Font font, int x, int y,
			       const Stringy &string, bool up)
{
  if (string.is_empty())
    return;

  int width, ascent, descent;
  text_size(font, string, &width, &ascent, &descent);

  Display *display = widget_display(w);
  Window win = x_window(w);

  int height = ascent + descent;
  int depth = Tk_Depth(window(w));
  Pixmap pixmap = Tk_GetPixmap(display, win, width, height, depth);
  XDrawImageString(display, pixmap, gc, 0, ascent,
		   string.cstring(), string.length());
  XImage *image = XGetImage(display, pixmap,
			    0, 0, width, height, AllPlanes, XYPixmap);
  Tk_FreePixmap(display, pixmap);

  XImage *rot_image = rotated_image(display, win, image, up);
  XDestroyImage(image);

  XPutImage(display, win, gc, rot_image, 0, 0,
	    (up ? x-ascent : x-descent), (up ? y-width : y), height, width);
  XDestroyImage(rot_image);
}

// ----------------------------------------------------------------------------
//
static XImage *rotated_image(Display *display, Window win, XImage *image,
			     bool counter_clockwise)
{
  int w = image->width;
  int h = image->height;
  int d = image->depth;
  Pixmap rotated_pixmap = Tk_GetPixmap(display, win, h, w, d);
  unsigned long planes = (1 << d) - 1;
  XImage *rot_image = XGetImage(display, rotated_pixmap,
				0, 0, h, w, planes, XYPixmap);
  Tk_FreePixmap(display, rotated_pixmap);

  if (counter_clockwise)
    {
      for (int c = 0 ; c < w ; ++c)
	for (int r = 0 ; r < h ; ++r)
	  XPutPixel(rot_image, r, w-c-1, XGetPixel(image, c, r));
    }
  else
    {
      for (int c = 0 ; c < w ; ++c)
	for (int r = 0 ; r < h ; ++r)
	  XPutPixel(rot_image, h-r-1, c, XGetPixel(image, c, r));
    }
  return rot_image;
}

// ----------------------------------------------------------------------------
//
static void translate_window_contents(Widget w, GC gc, int dx, int dy)
{
  Display *display = widget_display(w);
  Window win = x_window(w);

  int width = widget_width(w);
  int height = widget_height(w);
  XCopyArea(display, win, win, gc, 0, 0, width, height, dx, dy);

  if (dx > 0)
    eventually_redraw(w, 0, 0, dx, height);
  else if (dx < 0)
    eventually_redraw(w, width + dx, 0, -dx, height);

  if (dy > 0)
    eventually_redraw(w, 0, 0, width, dy);
  else if (dy < 0)
    eventually_redraw(w, 0, height + dy, width, -dy);
}

// ----------------------------------------------------------------------------
//
static void create_tcl_file_handler(FILE *fp, int mask,
				    Tcl_FileProc *input_cb, ClientData data)
{
  Tcl_CreateFileHandler(fileno(fp), mask, input_cb, data);
}

// ----------------------------------------------------------------------------
//
static void remove_tcl_file_handler(FILE *fp, Tcl_FileProc *, ClientData)
{
  Tcl_DeleteFileHandler(fileno(fp));
}
