// ----------------------------------------------------------------------------
//  Spectrum region choosing dialog.
//

#ifndef UIREGION_HEADER_INCLUDED
#define UIREGION_HEADER_INCLUDED

#include "list.h"		// use List

class Command_Dispatcher;
class Session;
class Stringy;
class View;

// ----------------------------------------------------------------------------
//
void show_region_dialog(Session &, View *);
void update_region_dialog(Session &, View *);

// ----------------------------------------------------------------------------
//
class View_Region
{
public:
  View_Region(const Stringy &name, const Stringy &accel,
	      const SRegion &ppm_region);
  Stringy name;
  Stringy accelerator;
  SRegion ppm_region;
};

// ----------------------------------------------------------------------------
//
class View_Regions
{
public:
  View_Regions(Command_Dispatcher &cd);
  ~View_Regions();
  void add_region(const View_Region &);
  void delete_region(View_Region *);
  void delete_regions();
  bool goto_region(const Stringy &accelerator, View *v);
  const List &region_list();			// list of View_Region
private:
  Command_Dispatcher &command_dispatcher;
  List rlist;
};

#endif
