// ----------------------------------------------------------------------------
//

#include "atom.h"		// use Atom
#include "condition.h"		// Use Condition
#include "group.h"		// Use Group
#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "reporter.h"		// use Reporter
#include "resonance.h"		// Use Resonance
#include "session.h"		// use Session
#include "uicomponents.h"	// Use Condition_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "utility.h"		// Use message()
#include "winsystem.h"		// Use ws.option_menu()

// ----------------------------------------------------------------------------
//
class predefined_resonance_dialog : public Dialog
{
public:
  predefined_resonance_dialog(Session &);
  ~predefined_resonance_dialog();

  static predefined_resonance_dialog *the(Session &);

  void show();
  void update();

private:
  Condition_Menu *from_mc, *to_mc;

  static void copy_cb(Widget, CB_Data, CB_Data);

  void copy();
};

// ----------------------------------------------------------------------------
//
void show_predefined_resonance_dialog(Session &s)
  { predefined_resonance_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
predefined_resonance_dialog::predefined_resonance_dialog(Session &s)
  : Dialog(s, "predefinedResonanceDialog")
{
  from_mc = new Condition_Menu(s, dialog, "fromMolCond");
  to_mc = new Condition_Menu(s, dialog, "toMolCond");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "copy", copy_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, from_mc->option_menu(), to_mc->option_menu(),
		     separator, controls, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
predefined_resonance_dialog::~predefined_resonance_dialog()
{
  session.dialog_table().delete_dialog("predefined_resonance_dialog", this);

  delete from_mc;
  delete to_mc;
}

// ----------------------------------------------------------------------------
// The default predefined_resonance_dialog instance.
//
predefined_resonance_dialog *predefined_resonance_dialog::the(Session &s)
{
  Stringy name = "predefined_resonance_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new predefined_resonance_dialog(s));
  return (predefined_resonance_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void predefined_resonance_dialog::copy_cb(Widget,
					  CB_Data client_data,
					  CB_Data)
{
  predefined_resonance_dialog *prd =
    (predefined_resonance_dialog *) client_data;

  prd->copy();
  prd->ws.unshow_dialog(prd->dialog);
}

// ----------------------------------------------------------------------------
//
void predefined_resonance_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void predefined_resonance_dialog::update()
{
}

// ----------------------------------------------------------------------------
//
void predefined_resonance_dialog::copy()
{
  Condition *from = from_mc->condition_chosen();
  Condition *to = to_mc->condition_chosen();

  if (from != NULL && to != NULL && to != from)
    {
      int count = 0;
      const List &rlist = from->resonance_list();
      for (int ri = 0 ; ri < rlist.size() ; ++ri)
	{
	  Resonance *r = (Resonance *) rlist[ri];
	  Stringy atom = r->atom()->name();
	  Stringy group = r->group()->name();
	  if (!to->find_resonance(group, atom))
	    {
	      Stringy nucleus = r->atom()->nucleus();
	      Resonance *rto = to->define_resonance(group, atom, nucleus);
	      if (rto)
		{
		  rto->set_frequency(r->frequency());
		  count += 1;
		}
	    }
	}
      session.reporter().message("Copied %d resonances from %s to %s\n",
				 count, from->fullname().cstring(),
				 to->fullname().cstring());
    }
}
