// ----------------------------------------------------------------------------
//

#include "crosspeak.h"		// Use CrossPeak
#include "peak.h"		// Use Peak
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "spoint.h"		// Use SPoint
#include "stringc.h"		// Use String
#include "uipkpanel.h"		// Use Peak_Panel
#include "uiview.h"		// Use View
#include "winsystem.h"		// Use ws.set_label_text()

static Stringy peak_text(CrossPeak *xp);
static Stringy max_text(View *view, double x, double y);

// ----------------------------------------------------------------------------
//
Peak_Panel::Peak_Panel(View *view, double a, double b, int screen_length)
  : edge_panel(view->session().window_system(), a, b, screen_length, true,
	       view->frame(), "peakPanel")
	    
{
  this->view = view;
  Widget w = widget();
  text = ws.create_label(w, "text");
  ws.add_event_callback(pointer_pause_event, view->drawing_widget(),
		     pointer_pause_cb, this);
  ws.row_attachments(text, text, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
Peak_Panel::~Peak_Panel()
{
  ws.remove_event_callback(pointer_pause_event, view->drawing_widget(),
			pointer_pause_cb, this);
}

// ----------------------------------------------------------------------------
//
void Peak_Panel::pointer_move(double x, double y)
{
  CrossPeak *xp = view->over_visible_crosspeak(x, y);
  Stringy line = (xp ? peak_text(xp) : max_text(view, x, y));
  if (line != ws.label_text(text))
    ws.set_label_text(text, line);
}

// ----------------------------------------------------------------------------
//
void Peak_Panel::pointer_pause_cb(Widget, CB_Data peakpanel, CB_Data)
{
  Peak_Panel *pp = (Peak_Panel *) peakpanel;
  View *v = pp->view;
  SPoint p;
  if (v->pointer_position(&p))
    {
      Spectrum *sp = v->spectrum();
      double h = sp->height_at_point(p);
      double pos_thresh, neg_thresh;
      v->lowest_contour_levels(&pos_thresh, &neg_thresh);
      if (h < pos_thresh && h > neg_thresh &&
	  !v->over_visible_crosspeak(p[v->axis(X)], p[v->axis(Y)]))
	{
	  Stringy line;
	  line << "Position: "
	       << point_format(p, "%.4g", false)
	       << formatted_string("   ht: %.3g", h);
	  if (line != pp->ws.label_text(pp->text))
	    pp->ws.set_label_text(pp->text, line);
	}
    }
}

// ----------------------------------------------------------------------------
//
static Stringy peak_text(CrossPeak *xp)
{
  Spectrum *sp = xp->spectrum();
  Peak *pk = (xp->type() == peak ? (Peak *) xp : NULL);

  Stringy line = (xp->IsAssigned() ? xp->assignment_name() : Stringy("Peak"));

  line << "  " << point_format(xp->frequency(), "%.4g", false);

  if (pk)
    {
      double h = (pk->IntegrateByFit() ? pk->FitHeight() : pk->DataHeight());
      line << formatted_string("   ht: %.3g", h);
      if (!pk->HasLinewidth())
	pk->estimate_linewidth();
      SPoint lw = sp->scale(pk->linewidth(), PPM, HZ);
      line << "   lw (hz): " << point_format(lw, "%.3g", false);
    }

  return line;
}

// ----------------------------------------------------------------------------
//
static Stringy max_text(View *view, double x, double y)
{
  Spectrum *sp = view->spectrum();
  SPoint p = view->point(x, y);
  double h = sp->height_at_point(p);
  Stringy line;
  double pos_thresh, neg_thresh;
  view->lowest_contour_levels(&pos_thresh, &neg_thresh);
  if (h > pos_thresh || h < neg_thresh)
    {
      double hmax;
      SPoint pmax = local_maximum(sp, p, &hmax);
      SPoint lw = symmetric_half_height_width(sp, pmax);
      line << (h > 0 ? "Max: " : "Min: ")
	   << point_format(pmax, "%.4g", false)
	   << formatted_string("   ht: %.3g", hmax)
	   << "   lw (hz): "
	   << point_format(sp->scale(lw, PPM, HZ), "%.4g", false);
    }

  return line;
}
