// ----------------------------------------------------------------------------
//

#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// Use Spectrum_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// Use View
#include "winsystem.h"		// Use ws.widget_table(), ws.button_row(), ...

// ----------------------------------------------------------------------------
//
class pick_dialog : public Dialog
{
public:
  pick_dialog(Session &);
  ~pick_dialog();

  static pick_dialog *the(Session &);

  void show(Spectrum *sp);
  void update(Spectrum *sp);

private:
  Widget linewidth, drop_factor;
  Spectrum_Menu *spectrum_menu;
  Spectrum *sp;

  static void will_delete_spectrum_cb(void *idialog, void *spectrum);
  static void spectrum_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_pick_dialog(Session &s, Spectrum *sp)
  { pick_dialog::the(s)->show(sp); }

// ----------------------------------------------------------------------------
//
pick_dialog::pick_dialog(Session &s) : Dialog(s, "pickDialog")
{
  this->sp = NULL;

  spectrum_menu = new Spectrum_Menu(s, dialog, "spectrumMenu");
  ws.option_callback(spectrum_menu->option_menu(), spectrum_menu_cb, this);

  Table_Entry label = TABLE_LABEL;
  Table_Entry value = TABLE_TEXT_FIELD;
  Widget lw_label = ws.create_label(dialog, "linewidthtitle");
  linewidth = ws.widget_table(dialog, "linewidth", 4, 2,
			   label, value,
			   label, value,
			   label, value,
			   label, value);

  drop_factor = ws.edit_field(dialog, "dropfactor");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, spectrum_menu->option_menu(),
		     lw_label, linewidth, drop_factor,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);
}

// ----------------------------------------------------------------------------
//
pick_dialog::~pick_dialog()
{
  session.dialog_table().delete_dialog("pick_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);

  delete spectrum_menu;
}

// ----------------------------------------------------------------------------
// The default pick_dialog instance.
//
pick_dialog *pick_dialog::the(Session &s)
{
  Stringy name = "pick_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new pick_dialog(s));
  return (pick_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void pick_dialog::will_delete_spectrum_cb(void *pdialog, void *spectrum)
{
  pick_dialog *pd = (pick_dialog *) pdialog;
  Spectrum *sp = (Spectrum *) spectrum;

  if (pd->sp == sp)
    pd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void pick_dialog::spectrum_menu_cb(Widget, CB_Data client_data, CB_Data)
{
  pick_dialog *pd = (pick_dialog *) client_data;
  Spectrum *spect = pd->spectrum_menu->selected_spectrum();

  if (spect)
    pd->update(spect);
}

// ----------------------------------------------------------------------------
//
void pick_dialog::show(Spectrum *sp)
{
  update(sp);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void pick_dialog::update(Spectrum *sp)
{
  this->sp = sp;

  Stringy dialog_title = (sp == NULL ? Stringy("Pick Parameters") :
			  Stringy("Pick parameters ") + sp->name());
  ws.set_dialog_title(dialog, dialog_title);

  spectrum_menu->set_spectrum_choice(sp);

  int dim = (sp == NULL ? 2 : sp->dimension());
  Peak_Pick_Parameters ppp = (sp == NULL ? Peak_Pick_Parameters(dim) :
			      sp->mPeakPick);

  ws.manage_table_children(linewidth, dim, 2);
  for (int a = 0 ; a < dim ; ++a)
    {
      Stringy label = table_axis_label(sp, a, "");
      ws.set_label_text(ws.table_element(linewidth,a,0), label);
      double lw = (sp == NULL ? 0 :
		   sp->scale(ppp.minimum_linewidth[a], a, PPM, HZ));
      ws.set_numeric_text_field(ws.table_element(linewidth,a,1), "%.1f", lw);
    }

  ws.set_numeric_edit_value(drop_factor, "%.2f", ppp.minimum_drop_factor);
}

// ----------------------------------------------------------------------------
//
void pick_dialog::apply()
{
  if (sp == NULL)
    return;

  for (int a = 0 ; a < sp->dimension() ; ++a)
    {
      double hz_lw = ws.numeric_text_field(ws.table_element(linewidth,a,1));
      sp->mPeakPick.minimum_linewidth[a] = sp->scale(hz_lw, a, HZ, PPM);
    }
  sp->mPeakPick.minimum_drop_factor = ws.numeric_edit_value(drop_factor);
}
