// ----------------------------------------------------------------------------
//
#include <math.h>	       // Use fabs()

#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "ornament.h"		// Use Ornament
#include "project.h"		// Use Project
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// Use Spectrum_Menu
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "winsystem.h"		// Use ws.edit_field(), ...

static void update_ornament_size(WinSys &, Widget size_field,
				 Ornament_Type type, Spectrum *sp);

// ----------------------------------------------------------------------------
//
class ornament_size_dialog : public Dialog
{
public:
  ornament_size_dialog(Session &);
  ~ornament_size_dialog();

  static ornament_size_dialog *the(Session &);

  void show(Spectrum *sp);
  void update(Spectrum *sp);

private:
  Widget label_size, peak_size, peakgroup_size, line_size;
  Spectrum_Menu *spectrum_menu;

  static void spectrum_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_ornament_size_dialog(Session &s, Spectrum *sp)
  { ornament_size_dialog::the(s)->show(sp); }

// ----------------------------------------------------------------------------
//
ornament_size_dialog::ornament_size_dialog(Session &s)
  : Dialog(s, "ornamentSizeDialog")
{
  spectrum_menu = new Spectrum_Menu(s, dialog, "spectrumMenu");
  ws.option_callback(spectrum_menu->option_menu(), spectrum_menu_cb, this);

  Widget sizes_heading = ws.create_label(dialog, "heading");

  label_size = ws.edit_field(dialog, "labelSize");
  peak_size = ws.edit_field(dialog, "peakSize");
  peakgroup_size = ws.edit_field(dialog, "peakGroupSize");
  line_size = ws.edit_field(dialog, "lineSize");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       NULL);

  ws.column_attachments(separator, spectrum_menu->option_menu(), sizes_heading,
			label_size, peak_size, peakgroup_size, line_size,
			separator, controls, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
ornament_size_dialog::~ornament_size_dialog()
{
  session.dialog_table().delete_dialog("ornament_size_dialog", this);

  delete spectrum_menu;
}

// ----------------------------------------------------------------------------
// The default ornament_size_dialog instance.
//
ornament_size_dialog *ornament_size_dialog::the(Session &s)
{
  Stringy name = "ornament_size_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new ornament_size_dialog(s));
  return (ornament_size_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::spectrum_menu_cb(Widget, CB_Data osdialog, CB_Data)
{
  ornament_size_dialog *osd = (ornament_size_dialog *) osdialog;
  Spectrum *sp = osd->spectrum_menu->selected_spectrum();

  if (sp)
    osd->update(sp);
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::show(Spectrum *sp)
{
  update(sp);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::update(Spectrum *sp)
{
  Stringy spectrum_name = (sp ? sp->name() : Stringy(""));
  Stringy title = Stringy("Ornament Sizes ") + spectrum_name;
  ws.set_dialog_title(dialog, title);

  spectrum_menu->set_spectrum_choice(sp);

  if (sp)
    {
      ws.set_numeric_edit_value(label_size, "%.3f", sp->ornament_size(label));
      ws.set_numeric_edit_value(peak_size, "%.3f", sp->ornament_size(peak));
      ws.set_numeric_edit_value(peakgroup_size, "%.3f",
				sp->ornament_size(peakgroup));
      ws.set_numeric_edit_value(line_size, "%.3f", sp->ornament_size(line));
    }
  else
    {
      ws.set_edit_value(label_size, "");
      ws.set_edit_value(peak_size, "");
      ws.set_edit_value(peakgroup_size, "");
      ws.set_edit_value(line_size, "");
    }
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::apply()
{
  Spectrum *sp = spectrum_menu->selected_spectrum();

  if (sp)
    {
      update_ornament_size(ws, label_size, label, sp);
      update_ornament_size(ws, peak_size, peak, sp);
      update_ornament_size(ws, peakgroup_size, peakgroup, sp);
      update_ornament_size(ws, line_size, line, sp);
    }
}

// ----------------------------------------------------------------------------
//
static void update_ornament_size(WinSys &ws, Widget size_field,
				 Ornament_Type type, Spectrum *sp)
{
  double size = sp->ornament_size(type);
  double new_size = ws.numeric_edit_value(size_field);

  if (fabs(new_size - size) >= 1e-6)
    sp->set_ornament_size(type, new_size);
}
