// ----------------------------------------------------------------------------
//

#include "assigncopy.h"		// Use Guess_Assignments
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "num.h"		// Use is_bit_set()
#include "project.h"		// use Project
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// use Spectrum_Menu
#include "uidialogs.h"		// Use update_assignment_dialog_guesses()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// Use update_resonance_panels()
#include "winsystem.h"		// Use WinSys

// ----------------------------------------------------------------------------
//
class guess_dialog : public Dialog
{
public:
  guess_dialog(Session &);
  ~guess_dialog();

  static guess_dialog *the(Session &);

  void show(Spectrum *sp);
  void update(Spectrum *sp);

private:
  Widget table;
  Spectrum_Menu *spectrum_menu;
  Spectrum *sp;

  static void will_delete_spectrum_cb(void *idialog, void *spectrum);
  static void spectrum_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_guess_dialog(Session &s, Spectrum *sp)
  { guess_dialog::the(s)->show(sp); }
void update_guess_dialog(Session &s, Spectrum *sp)
  { if (guess_dialog::the(s)->shown())
      guess_dialog::the(s)->update(sp); }

// ----------------------------------------------------------------------------
//
guess_dialog::guess_dialog(Session &s) : Dialog(s, "guessDialog")
{
  this->sp = NULL;

  spectrum_menu = new Spectrum_Menu(s, dialog, "spectrumMenu");
  ws.option_callback(spectrum_menu->option_menu(), spectrum_menu_cb, this);

  Table_Entry label = TABLE_LABEL;
  Table_Entry menu = TABLE_OPTION_MENU;
  Table_Entry tf = TABLE_TEXT_FIELD;
  table = ws.widget_table(dialog, "settings", 5, 4,
		       label, label, label, label,
		       label, menu, tf, tf,
		       label, menu, tf, tf,
		       label, menu, tf, tf,
		       label, menu, tf, tf);

  for (int row = 1 ; row <= DIM ; ++row)
    ws.add_options(ws.table_element(table, row, 1),
		   Guess_Assignments::constraint_names);

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, spectrum_menu->option_menu(), table,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);
}

// ----------------------------------------------------------------------------
//
guess_dialog::~guess_dialog()
{
  session.dialog_table().delete_dialog("guess_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);

  delete spectrum_menu;
}

// ----------------------------------------------------------------------------
// The default guess_dialog instance.
//
guess_dialog *guess_dialog::the(Session &s)
{
  Stringy name = "guess_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new guess_dialog(s));
  return (guess_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void guess_dialog::will_delete_spectrum_cb(void *gdialog, void *spectrum)
{
  guess_dialog *gd = (guess_dialog *) gdialog;
  Spectrum *sp = (Spectrum *) spectrum;

  if (gd->sp == sp)
    gd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void guess_dialog::spectrum_menu_cb(Widget, CB_Data client_data, CB_Data)
{
  guess_dialog *gd = (guess_dialog *) client_data;
  Spectrum *spect = gd->spectrum_menu->selected_spectrum();

  if (spect)
    gd->update(spect);
}

// ----------------------------------------------------------------------------
//
void guess_dialog::show(Spectrum *sp)
{
  update(sp);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void guess_dialog::update(Spectrum *sp)
{
  this->sp = sp;

  Stringy dialog_title = (sp == NULL ?
			  Stringy("Assignment Guessing Options") :
			  "Assignment Guessing Options " + sp->name());
  ws.set_dialog_title(dialog, dialog_title);

  spectrum_menu->set_spectrum_choice(sp);

  int dim = (sp == NULL ? 2 : sp->dimension());
  Guess_Assignments ga = (sp == NULL ? Guess_Assignments(dim) :
			  sp->GetAssignGuessOptions());

  for (int a = 0 ; a < dim ; ++a)
    {
      ws.set_label_text(ws.table_element(table,a+1,0),
			table_axis_label(sp, a, ""));
      ws.set_option(ws.table_element(table, a+1, 1),
		    ga.sequence_constraint[a]);
      ws.set_text_field(ws.table_element(table, a+1, 2),
			ga.atom_constraint[a]);
      ws.set_numeric_text_field(ws.table_element(table, a+1, 3),
				"%.3f", ga.ppm_range[a]);
    }
  ws.manage_table_children(table, dim + 1, 4);
}

// ----------------------------------------------------------------------------
//
void guess_dialog::apply()
{
  if (sp == NULL)
    return;

  Guess_Assignments ga = sp->GetAssignGuessOptions();

  for (int a = 0 ; a < sp->dimension() ; ++a)
    {
      Stringy gtype = ws.option_selected(ws.table_element(table, a+1, 1));
      ga.sequence_constraint[a] =
	matching_string(Guess_Assignments::constraint_names, gtype);
      ga.atom_constraint[a] =
	ws.text_field_string(ws.table_element(table, a+1, 2));
      ga.ppm_range[a] = ws.numeric_text_field(ws.table_element(table, a+1, 3));
    }

  sp->SetAssignGuessOptions(ga);

  update_assignment_dialog_guesses(session);
  update_resonance_panels(session.project().view_list(sp));
}
