// ----------------------------------------------------------------------------
// Edge panel display
//

#ifndef EDGE_PANEL_HEADER_INCLUDED
#define EDGE_PANEL_HEADER_INCLUDED

#include "stringc.h"		// Use Stringy
#include "winsystem.h"		// Use WinSys, Widget, CB_Data

typedef class edge_panel *Edge_Panel;

class Color;
class WinSys;

// ----------------------------------------------------------------------------
//
class edge_panel
{
 public:
  edge_panel(WinSys &ws, double a, double b, int screen_length, bool is_horz,
	     Widget parent, const Stringy &name, bool scroll = true);
  virtual ~edge_panel();

  void range(double *a, double *b);
  void set_range(double a, double b);
  bool is_horizontal();
  Widget widget();
  void erase();
  virtual void view_region_changed();

  virtual void redraw(double a, double b);

  void set_drawing_color(const Color &color);
  void draw_tick(double x, double xlabel);
  void draw_label(double xlabel, const char *label, bool parallel);
  void draw_line(double x1, double y1, double x2, double y2,
		 bool xor_mode = false);
  void fill_rectangle(double x1, double y1, double x2, double y2);

  double thickness();
  double label_spacing();
  void text_width(const char *text, bool parallel,
		  double *left, double *right);

  virtual void pointer_in(double x, double y);
  virtual void pointer_move(double x, double y);
  virtual void pointer_out(double x, double y);

// ----------------------------------------------------------------------------
//
 protected:

  WinSys &ws;
  int paint_position(double x);
  double draw_position(int p);
  double pixel_size();

// ----------------------------------------------------------------------------
//
 private:

  int len;
  double a, b;
  bool is_horz, erase_queued, scroll;
  Drawing_Window *c;

  static void expose_cb(Widget w, CB_Data client_data, CB_Data call_data);
  static void resize_cb(Widget w, CB_Data client_data, CB_Data call_data);

  void resize(int width, int height);
  void repaint(int x, int y, int w, int h);
  void translate(double delta);
  void new_interval(double a, double b);
  bool is_translation(double a, double b);
  void paint_coordinates(double x, double y, int *px, int *py);
};

bool is_clipped(double c, double d, double a_clip, double b_clip);

#endif
